﻿using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.Repository;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    ///系统公共接口
    public class CommonController : ControllerBase
    {
        private ILogger<CommonController> _logger;
        private UnitOfWork _unitOfWork;
        private IWebHostEnvironment _hostingEnvironment;

        public CommonController(ILogger<CommonController> logger, UnitOfWork unitOfWork, IWebHostEnvironment webHostEnvironment)
        {
            _hostingEnvironment = webHostEnvironment;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 根据装备ID获取供应商
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "equid":"a7a1fa28-1d20-4b19-ae01-afad9f363920"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetSupplierByEquipment")]
        public async Task<HttpResponseMessage> GetSupplierByEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string equid = entity.equid ?? "";
                        if (string.IsNullOrEmpty(equid))
                        {
                            return JsonManager.SimpleCustResponse("equid is require");
                        }
                        string[] paras = new string[] {
                    "SupplierCodeNavigation"
                    };
                        Expression<Func<BaseJpSupplierEquipment, bool>> expression = t => t.Equipment.Id.Equals(equid);
                        var equList = _unitOfWork.SupplierProductRepository.GetList(expression, default, false, paras).ToList();
                        var data = equList.Select(t => new
                        {
                            supplierName = t.SupplierCodeNavigation?.Name,
                            supplierId = t.SupplierCode

                        });
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("model is null");
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据卡号获取警员信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "cardNo":"a7a1fa28-1d20-4b19-ae01-afad9f363920"
        ///         "orgId":"a7a1fa28-1d20-4b19-ae01-afad9f363920"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPoliceByCardNo")]
        public async Task<HttpResponseMessage> GetPoliceByCardNo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string cardNo = entity.cardNo ?? "";
                        string orgId = entity.orgId ?? "";
                        if (string.IsNullOrEmpty(cardNo))
                        {
                            return JsonManager.SimpleCustResponse("cardNo is require");
                        }

                        Expression<Func<BaseJpPoliceman, bool>> expression = t => t.PoliceCode.Equals(cardNo) || (t.CardNo.Equals(cardNo) && t.OrgizationCode.Equals(orgId));
                        var police = _unitOfWork.DbContext.BaseJpPolicemen.FirstOrDefault(expression);
                        var data = new
                        {
                            policeName = police?.Name ?? "",
                            policeId = police?.Id ?? "",
                            orgId = police?.OrgizationCode ?? ""

                        };
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("model is null");
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        ///// <summary>
        ///// 获取物资代码、名称信息
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet("GetEquInfo")]
        //public HttpResponseMessage GetEquInfo()
        //{
        //    try
        //    {
        //        var equList = _unitOfWork.DbContext.BaseJpEquipmentDetails.Select(s => new { s.Id, s.Code, s.Name }).ToList();
        //        return JsonManager.ReturnSuccessResponse(equList);
        //    }
        //    catch (Exception ex)
        //    {

        //        _logger.LogError(ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}
        ///// <summary>
        ///// 获取物资型号、名称信息
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet("GetEquSize")]
        //public HttpResponseMessage GetEquSize()
        //{
        //    try
        //    {
        //        var sizeList = _unitOfWork.DbContext.BaseJpEquipmentSizes.Select(s => new { s.Id, Code = s.SizeCode, Name = s.SizeName }).ToList();
        //        return JsonManager.ReturnSuccessResponse(sizeList);
        //    }
        //    catch (Exception ex)
        //    {

        //        _logger.LogError(ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

        ///// <summary>
        ///// 获取物资型号、名称信息
        ///// </summary>
        ///// <returns></returns>
        //[HttpGet("GetStoreInfo")]
        //public HttpResponseMessage GetStoreInfo()
        //{
        //    try
        //    {
        //        var sizeList = _unitOfWork.DbContext.BaseJpWarehouses.Select(s => new {  s.Id, Name = s.Name }).ToList();
        //        return JsonManager.ReturnSuccessResponse(sizeList);
        //    }
        //    catch (Exception ex)
        //    {

        //        _logger.LogError(ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

        /// <summary>
        /// 获取单警柜日志文件
        /// </summary>
        /// <returns></returns>

        [HttpGet("GetLogFile")]
        public async Task<HttpResponseMessage> GetLogFile()
        {
            return await Task.Run(() =>
            {
                try
                {
                    var root_path = $"{_hostingEnvironment.WebRootPath}\\LogFile\\Cabinet";
                    if (Directory.Exists(root_path))
                    {
                        DirectoryInfo root_info = new DirectoryInfo(root_path);
                        DirectoryInfo[] child_info = root_info.GetDirectories();
                        if (child_info == null || child_info.Length == 0)
                        {
                            return JsonManager.SimpleCustResponse("log file not found");
                        }
                        else
                        {
                            List<string> child_ids = child_info.Select(s => s.Name).ToList();
                            var cab_info = _unitOfWork.DbContext.BaseJpCabinets.Where(t => child_ids.Contains(t.CabinetRealNum)).Select(s => new { s.ShortName, s.CabinetRealNum }).ToList();
                            if (cab_info == null || cab_info.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse("log file not found");
                            }
                            else
                            {
                                List<LogInfo> res_list = new List<LogInfo>();
                                foreach (var cab in cab_info)
                                {
                                    LogInfo tmp_info = new LogInfo()
                                    {
                                        CabinetName = cab.ShortName,
                                        CabinetNum = cab.CabinetRealNum,
                                        DateDirInfos = new List<DateDirInfo>()
                                    };

                                    var date_path = $"{root_path}\\{cab.CabinetRealNum}";
                                    DirectoryInfo[] date_child = (new DirectoryInfo(date_path)).GetDirectories();
                                    foreach (var date in date_child)
                                    {
                                        var date_name = date.Name;
                                        var tmp_files = new List<LogFile>();
                                        var file_list = Directory.GetFiles(date.FullName).ToList();
                                        file_list.ForEach(s =>
                                        {
                                            var file_name = Path.GetFileName(s);
                                            tmp_files.Add(new LogFile()
                                            {
                                                DownloadUrl = $"/LogFile/Cabinet/{cab.CabinetRealNum}/{date_name}/{file_name}",
                                                FileName = file_name
                                            });
                                        });

                                        tmp_info.DateDirInfos.Add(new DateDirInfo()
                                        {
                                            DateName = date_name,
                                            LogFiles = tmp_files
                                        });

                                        res_list.Add(tmp_info);
                                    }
                                }
                                return JsonManager.ReturnSuccessResponse(res_list);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("root path not found");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }

    public class LogInfo
    {
        public string CabinetName { get; set; }
        public string CabinetNum { get; set; }
        public List<DateDirInfo> DateDirInfos { get; set; }
    }
    public class DateDirInfo
    {
        public string DateName { get; set; }
        public List<LogFile> LogFiles { get; set; }

    }
    public class LogFile
    {
        public string FileName { get; set; }
        public string DownloadUrl { get; set; }
    }
}
