﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;
using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.WebUtilities;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Microsoft.Net.Http.Headers;
using Nacos;
using Newtonsoft.Json.Linq;
using static JmpModel.Model.Enumerates.BorrowEnum;
using static JmpModel.Model.Enumerates.EquipmentHistroyEnum;

namespace JunmpPoliceStation.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    ///借用领用模块
    public class BorrowController : ControllerBase
    {
        private IWebHostEnvironment _hostingEnvironment;
        private readonly INacosConfigClient _configClient;
        private ILogger<BorrowController> _logger;
        UnitOfWork _unitOfWork;
        public BorrowController(ILogger<BorrowController> logger, UnitOfWork unitOfWork, INacosConfigClient configClient, IWebHostEnvironment hostingEnvironment)
        {
            _configClient = configClient;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
            _hostingEnvironment = hostingEnvironment;
        }


        /// <summary>
        /// 删除领用单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":""
        ///         
        ///         
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteOrder")]
        public async Task<HttpResponseMessage> DeleteOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;
                        List<CommonJpEquipmentInventory> Epcs = new List<CommonJpEquipmentInventory>();
                        var param = new string[] {



                    };
                        var equipments = _unitOfWork.BorrowReturnApplyRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();
                        if (!equipments.ActionType.Equals(1) || !equipments.ChangeFlag.Equals(0))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.DELETE_ERROR);
                        }
                        else
                        {
                            //var deletePolice= _unitOfWork.CommonJpBorrowReturnPoliceRepository.GetList(p => p.BorrowId.Equals(equipments.Id)).ToList();
                            //_unitOfWork.CommonJpBorrowReturnPoliceRepository.Delete(deletePolice, false);
                            var result = _unitOfWork.BorrowReturnApplyRepository.Delete(equipments, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取所有申请的审批单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "size":10,
        ///         "page":0,
        ///         "applyId":"申请人员",
        ///         "actionType":"",0：借用,1:领用 2:报废
        ///         "approveType"://0待审核,1已完成,2已驳回
        ///         "orderCode":""//订单号
        ///         "orgId":""//组织机构,
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "warehouseId":""
        ///     }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllBorrowOrderList")]
        public async Task<HttpResponseMessage> GetAllBorrowOrderList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<CommonJpBorrowReturnApply, bool>> expression = t => !t.Id.Equals(null);
                        string actionType = entity.actionType;
                        string warehouseId = entity.warehouseId;
                        if (!String.IsNullOrEmpty(entity.actionType))
                        {


                            expression = LambdaExtensions.And(expression, t => t.ActionType.Equals(int.Parse(actionType)));
                        }


                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpBorrowReturnDetailEstimates" ,
                       "CommonJpBorrowReturnDetailEstimates.Equipment" ,
                       "CommonJpBorrowReturnDetailEstimates.Size" ,
                       "CommonJpBorrowReturns" ,
                       "ApprovalPersonNavigation" ,
                       "Warehouse" ,
                       "Apply" ,
                       "ApprovalPersonNavigation" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.EquipmentDetail" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Size" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Supplier" ,
                       "CommonJpBorrowReturnDetailEstimates.Supplier" 
                       //"CommonJpBorrowReturnPolices",
                       //"CommonJpBorrowReturnPolices.Police"
                    };

                        string applyId = entity.applyId;
                        string orgId = entity.orgId;
                        var userInfo = _unitOfWork.CommonJpUserRepository.GetList(p => p.OrganizationId.Equals(orgId)).Select(p => p.Id);
                        expression = LambdaExtensions.And(expression, t => t.ApplyUser == applyId);
                        if (actionType.Equals("0"))//借用
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.ApplyUser == applyId);
                        }
                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.WarehouseId == warehouseId);
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = LambdaExtensions.And(expression, t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }
                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }

                        }
                        if (!string.IsNullOrEmpty(entity.orderCode))
                        {
                            string orderCode = entity.orderCode;
                            expression = LambdaExtensions.And(expression, t => t.OrderCode.Contains(orderCode));
                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);

                        if (actionType.Equals("0"))//借用
                        {
                            var applyList = _unitOfWork.BorrowReturnApplyRepository.GetList(expression, null, false, param).OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                            var applyValue = new
                            {
                                totalElements = applyList.Count(),
                                content = applyList.Skip(page * size).Take(size).ToList()
                            };
                            var data = applyValue.content.Select(t => new
                            {
                                ActionType = t.ActionType,
                                t.ChangeFlag,
                                id = t.Id,
                                warehouseId = t.WarehouseId,
                                applyId = t.ApplyUser,
                                applyName = t.ApplyUserName,
                                applyTime = t.ApplyTime,
                                t.ProcessCurrent.UserInfo,
                                t.ProcessCurrent.UpdateTime,
                                t.ProcessCurrent.OrgId,
                                note = t.Note,
                                actionResult = t.ProcessCurrent.CommonJpProcessHistories.OrderBy(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(applyId) ? "0" : "1",
                                UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo))).FirstOrDefault().Name,
                                t.ProcessCurrent.NextStepId,
                                t.ProcessCurrent.CurrentStepName,
                                t.ProcessCurrent.DataScope,
                                t.ProcessCurrent.UserType,

                                processActionType = t.ProcessCurrent.ActionType,
                                historyList = t.ProcessCurrent.CommonJpProcessHistories.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    x.AuditMind,
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                //police = t.CommonJpBorrowReturnPolices.Select(p => new
                                //{
                                //    p.Police?.Name,
                                //    p.Police?.Id
                                //}),
                                t.PoliceId,
                                t.ProcessCurrent.FlowType,
                                flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                                createTime = t.CreateTime,
                                warehouseName = t.Warehouse?.Name,
                                t.OrderCode,
                                expectedTime = t.ExpectedReturnTime,
                                detailList = t.CommonJpBorrowReturnDetailEstimates?.Select(x => new
                                {
                                    id = x.Id,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.EquipmentCount,
                                    supplierId = x.Supplier?.Id,
                                    supplierName = x.Supplier?.Name,
                                    sizeCount = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.EquipmentCode.Equals(x.EquipmentId) && p.WarehouseCode.Equals(t.Warehouse.Id)).Count()

                                }),
                                applyResult = t.CommonJpBorrowReturns?.Select(p => new
                                {
                                    p.CurrentState,
                                    resultList = p.CommonJpBorrowReturnDetailRealities?.Select(q => new
                                    {
                                        quantity = q.EquipmentCount,
                                        equipmentId = q.EquipmentDetail?.Id,
                                        equipmentName = q.EquipmentDetail?.Name,
                                        equipmentSizeId = q.Size?.Id,
                                        equipmentSizeName = q.Size?.SizeName,
                                        //applyQuantity = t.CommonJpBorrowReturnDetailEstimates?.Where(x => q.SizeId.Equals(x.SizeId) && q.EquipmentDetailId.Equals(x.EquipmentId))?.FirstOrDefault().EquipmentCount,
                                        supplierId = q.Supplier?.Id,
                                        supplierName = q.Supplier?.Name,
                                        q.RealCount,
                                        q.InsideRealCount,
                                    })
                                })

                            });
                            var content = new
                            {
                                applyValue.totalElements,
                                content = data.ToList()
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (actionType.Equals("1"))//领用
                        {
                            var applyList = _unitOfWork.BorrowReturnApplyRepository.GetList(expression, null, false, param).ToList();
                            //var applyValue = new
                            //{
                            //    totalElements = applyList.Count(),
                            //    content = applyList.Skip(page * size).Take(size).ToList()
                            //};
                            var data = applyList.Select(t => new
                            {
                                ActionType = t.ActionType,
                                t.ChangeFlag,
                                id = t.Id,
                                warehouseId = t.WarehouseId,
                                applyId = t.ApplyUser,
                                applyName = t.ApplyUserName,
                                applyTime = t.ApplyTime,
                                createTime = t.CreateTime,
                                warehouseName = t.Warehouse?.Name,
                                t.OrderCode,
                                t.OrgId,
                                note = t.Note,
                                //police = t.CommonJpBorrowReturnPolices.Select(p => new
                                //{
                                //    p.Police?.Name,
                                //    p.Police?.Id
                                //}),
                                t.PoliceId,
                                fileUrl = t.FileUrl,
                                detailList = t.CommonJpBorrowReturns?.FirstOrDefault()
                                        ?.CommonJpBorrowReturnDetailRealities?.Select(x => new
                                        {

                                            estimateId = x.Id,
                                            x.EquipmentDetailId,
                                            equipmentName = x.EquipmentDetail?.Name,
                                            equipmentSizeId = x.Size?.Id,
                                            equipmentSizeName = x.Size?.SizeName,
                                            quantity = x.EquipmentCount,
                                            supplierId = x.Supplier?.Id,
                                            supplierName = x.Supplier?.Name,
                                            sizeCount = _unitOfWork.EquipmentInventoryRepository.GetList(p =>
                                                p.EquipmentCode.Equals(x.EquipmentDetailId) &&
                                                p.WarehouseCode.Equals(t.Warehouse.Id)).Count()
                                        })



                            }).OrderByDescending(p => p.createTime)
                                .ToList();
                            var content = new
                            {
                                totalElements = data.Count(),
                                content = data.Skip(page * size).Take(size).ToList()
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else if (actionType.Equals("2"))//销毁
                        {
                            var applyList = _unitOfWork.BorrowReturnApplyRepository.GetList(expression, null, false, param).OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                            var applyValue = new
                            {
                                totalElements = applyList.Count(),
                                content = applyList.Skip(page * size).Take(size).ToList()
                            };
                            var data = applyValue.content.Select(t => new
                            {
                                ActionType = t.ActionType,
                                t.ChangeFlag,
                                id = t.Id,
                                warehouseId = t.WarehouseId,
                                applyId = t.ApplyUser,
                                applyName = t.ApplyUserName,
                                applyTime = t.ApplyTime,
                                t.ProcessCurrent.UserInfo,
                                t.ProcessCurrent.UpdateTime,
                                t.ProcessCurrent.OrgId,
                                note = t.Note,
                                actionResult = t.ProcessCurrent.CommonJpProcessHistories.OrderBy(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(applyId) ? "0" : "1",
                                UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo))).FirstOrDefault().Name,
                                t.ProcessCurrent.NextStepId,
                                t.ProcessCurrent.CurrentStepName,
                                t.ProcessCurrent.DataScope,
                                t.ProcessCurrent.UserType,

                                processActionType = t.ProcessCurrent.ActionType,
                                historyList = t.ProcessCurrent.CommonJpProcessHistories.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    x.AuditMind,
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                //police = t.CommonJpBorrowReturnPolices.Select(p => new
                                //{
                                //    p.Police?.Name,
                                //    p.Police?.Id
                                //}),
                                t.PoliceId,
                                t.ProcessCurrent.FlowType,
                                flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                                createTime = t.CreateTime,
                                warehouseName = t.Warehouse?.Name,
                                t.OrderCode,
                                expectedTime = t.ExpectedReturnTime,
                                detailList = t.CommonJpBorrowReturnDetailEstimates?.Select(x => new
                                {
                                    id = x.Id,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.EquipmentCount,
                                    supplierId = x.Supplier?.Id,
                                    supplierName = x.Supplier?.Name,
                                    sizeCount = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.EquipmentCode.Equals(x.EquipmentId) && p.WarehouseCode.Equals(t.Warehouse.Id)).Count(),

                                }),
                                applyResult = t.CommonJpBorrowReturns?.Select(p => new
                                {
                                    p.CurrentState,
                                    resultList = p.CommonJpBorrowReturnDetailRealities?.Select(q => new
                                    {
                                        quantity = q.EquipmentCount,
                                        equipmentId = q.EquipmentDetail?.Id,
                                        equipmentName = q.EquipmentDetail?.Name,
                                        equipmentSizeId = q.Size?.Id,
                                        equipmentSizeName = q.Size?.SizeName,
                                        //applyQuantity = t.CommonJpBorrowReturnDetailEstimates?.Where(x => q.SizeId.Equals(x.SizeId) && q.EquipmentDetailId.Equals(x.EquipmentId))?.FirstOrDefault().EquipmentCount,
                                        supplierId = q.Supplier?.Id,
                                        supplierName = q.Supplier?.Name,
                                        q.RealCount,
                                        q.InsideRealCount,
                                    })
                                })

                            });
                            var content = new
                            {
                                applyValue.totalElements,
                                content = data.ToList()
                            };
                            return JsonManager.ReturnSuccessResponse(content);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 借用转领用物资单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "orderNo":""
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BorrowTransfer")]
        //[NoSign]
        public async Task<HttpResponseMessage> BorrowTransfer([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orderNo = entity.orderNo;
                        if (!orderNo.Contains("JY"))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        var param = new string[] {
                       "CommonJpBorrowReturnDetailRealities",
                       "CommonJpBorrowReturnDetailRealities.CommonJpEquipmentStates",
                       "CommonJpBorrowReturnDetailRealities.CommonJpEquipmentStates.Eqiupment",
                       "CommonJpBorrowReturns"

                    };

                        var borrowOrder = _unitOfWork.BorrowReturnApplyRepository.GetList(p => p.OrderCode.Equals(orderNo), null, false, param).FirstOrDefault();//找到需要转换的借用单
                        borrowOrder.CommonJpBorrowReturns.FirstOrDefault().CurrentState = (int)CurrentState.已回来;
                        List<CommonJpBorrowReturn> borrow = new List<CommonJpBorrowReturn>();
                        CommonJpBorrowReturnApply newBorrowOrder = new CommonJpBorrowReturnApply()
                        {
                            Id = Guid.NewGuid().ToString(),
                            ActionType = 1,
                            CreateTime = DateTime.Now,
                            OrderCode = borrowOrder.OrderCode.Replace("JY", "LY"),
                            WarehouseId = borrowOrder.WarehouseId,

                            ChangeFlag = 0,
                            ApplyUser = entity.applyId,
                            ApplyUserName = entity.applyName,
                            ApplyTime = DateTime.Now,
                            OrgId = borrowOrder.OrgId,
                            Note = borrowOrder.Note,
                            PoliceNote = borrowOrder.PoliceNote,
                            PoliceId = borrowOrder.PoliceId,

                        };
                        //CommonJpBorrowReturn newBorrowReturn = new CommonJpBorrowReturn()
                        //{

                        //};
                        newBorrowOrder.CommonJpBorrowReturns.Add(new CommonJpBorrowReturn()
                        {
                            Id = Guid.NewGuid().ToString(),
                            ActionType = 1,
                            CreateTime = DateTime.Now,
                            OrderCode = borrowOrder.OrderCode.Replace("JY", "LY"),
                            WarehouseId = borrowOrder.WarehouseId,
                            OrgId = borrowOrder.OrgId,
                            CurrentState = 1
                        });


                        //newBorrowOrder.CommonJpBorrowReturns = borrow;
                        List<CommonJpBorrowReturnDetailReality> detailList = new List<CommonJpBorrowReturnDetailReality>();
                        List<CommonJpEquipmentState> eqState = new List<CommonJpEquipmentState>();
                        foreach (var item in borrowOrder.CommonJpBorrowReturns.FirstOrDefault().CommonJpBorrowReturnDetailRealities)
                        {
                            string borrowId = Guid.NewGuid().ToString();
                            CommonJpBorrowReturnDetailReality detail = new CommonJpBorrowReturnDetailReality()
                            {
                                Id = borrowId,
                                EquipmentDetailId = item.EquipmentDetailId,
                                SizeId = item.SizeId,
                                EstimateId = item.EstimateId,
                                EquipmentCount = item.EquipmentCount,
                                RealityId = item.RealityId,
                                State = 1,
                                RealCount = item.RealCount
                            };
                            detailList.Add(detail);
                            foreach (var stateItem in item.CommonJpEquipmentStates)
                            {
                                stateItem.BorrowId = borrowId;
                                stateItem.OrderCode = borrowOrder.OrderCode.Replace("JY", "LY");
                                stateItem.ActionState = 3;
                                stateItem.Eqiupment.CurrentState = 8;
                                eqState.Add(stateItem);
                            }

                        }
                        _unitOfWork.EquipmentStateRepository.Update(eqState, false);
                        newBorrowOrder.CommonJpBorrowReturns.FirstOrDefault().CommonJpBorrowReturnDetailRealities = detailList;
                        _unitOfWork.BorrowReturnApplyRepository.Update(borrowOrder, false);
                        bool result = _unitOfWork.BorrowReturnApplyRepository.Insert(newBorrowOrder, true);

                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 领用物资单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "epcList":[
        ///         {
        ///            "epc":"",//新增可不填
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddBorrowOrder")]
        public async Task<HttpResponseMessage> AddBorrowOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        List<CommonJpEquipmentInventory> Epcs = new List<CommonJpEquipmentInventory>();

                        var equipments = _unitOfWork.DbContext.CommonJpEquipmentInventories.Include(p => p.CommonJpEquipmentStates).Where(t => !string.IsNullOrEmpty(t.Epc));

                        List<string> EpcList2 = new List<string>();

                        CommonJpEquipmentInventory editEquipment = new CommonJpEquipmentInventory();
                        EpcList2 = equipments.Select(p => p.Epc).ToList();
                        foreach (var item in entity.epcList)
                        {
                            string rfidItem = item.epc;
                            if (!string.IsNullOrEmpty(rfidItem))
                            {
                                editEquipment = equipments.Include(p => p.CommonJpEquipmentStates).Include(p => p.WarehouseCodeNavigation).Where(p => p.Epc.Contains(rfidItem)).FirstOrDefault();
                                editEquipment.CurrentState = (int)EquipmentInventoryEnum.CurrentState.已领用;
                                editEquipment.EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.外出;
                                editEquipment.CreateTime = DateTime.Now;
                                editEquipment.CommonJpEquipmentStates.Add(new CommonJpEquipmentState
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EqiupmentId = editEquipment.Id,
                                    State = (int)EquipmentState.借用领用,
                                    OutTime = DateTime.Now,
                                    CreateTime = DateTime.Now,
                                    ActionState = 3,
                                    OutInState = 0,
                                    OrgId = editEquipment.WarehouseCodeNavigation.OrgizationId,
                                    WarehouseId = editEquipment.WarehouseCode
                                }
                                );
                                Epcs.Add(editEquipment);
                            }

                        }
                        var result = _unitOfWork.EquipmentInventoryRepository.Update(Epcs);
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增领用单
        /// </summary>
        /// <remarks>
        /// ## 例子
        ///      //借用
        ///     {
        ///         "warehouseId":"请求仓库ID",
        ///         "orgId":"组织机构ID",
        ///         "orgCode":"组织机构短码",
        ///         "note":"",
        ///         "detailList":[
        ///         {
        ///            "id":"",
        ///            "equipmentSizeId":"",
        ///            "equipmentDetailId":"",
        ///            "quantity":"",
        ///            "supplierId":""
        ///         }]
        ///     }
        ///     //领用
        ///     {
        ///         "id": "f8e38b3a-5218-4b8b-bc3c-1d895505cd8e",
        ///         "warehouseId": "9715e5ac-b76f-4dd7-8b9c-56b3c592ce62",
        ///         "orgId": "E05CC28D-C189-4389-8081-DD0D6E483B40",
        ///         "note":"",
        ///         "policeNote":"",
        ///         "policeId":"",
        ///         "applyId":""
        ///         "detailList": [
        ///          {
        ///            "quantity": 1,
        ///            "equipmentId": "b9f83e07-a559-45d9-869f-22fbc777723c",
        ///         }]
        ///       }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddAndApprovalBorrowOrder")]
        public async Task<HttpResponseMessage> AddAndApprovalBorrowOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        bool bExpectedTime = DateTime.TryParse(entity?.expectedTime ?? "", out DateTime expectedTime);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.policeId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"policeId is require");
                        }

                        else if (!string.IsNullOrEmpty(id))
                        {
                            if (entity.detailList == null || entity.detailList.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"detailList is require");
                            }
                            //var order= _unitOfWork.BorrowReturnApplyRepository.GetList(t=>t.Id.Equals(id),null)
                            var order = _unitOfWork.DbContext.CommonJpBorrowReturnApplies.Include(t => t.CommonJpBorrowReturns).Include(t => t.CommonJpBorrowReturnDetailRealities).Include(t => t.CommonJpBorrowReturnDetailEstimates).FirstOrDefault(t => t.Id == id);
                            if (order == null)
                            {
                                return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                            }
                            if (order.ChangeFlag.Equals(1))
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.CHANGE_ERROR);
                            }
                            else
                            {
                                order.CommonJpBorrowReturns.FirstOrDefault().WarehouseId = entity.warehouseId;

                                //order.ApplyTime = DateTime.Now;
                                order.WarehouseId = entity.warehouseId;
                                order.Note = entity.note;
                                order.CreateTime = DateTime.Now;
                                order.PoliceNote = entity.policeNote;
                                order.PoliceId = entity.policeId;
                                order.FileUrl = string.IsNullOrEmpty(entity.fileUrl) ? null : entity.fileUrl;
                                List<string> tmpList = JsonManager.GetDetails(entity.detailList);

                                List<string> tmpList2 = JsonManager.GetDetailIds(entity.detailList);
                                var tmpDetail2 = order.CommonJpBorrowReturnDetailEstimates?.Where(t => !tmpList2.Contains(t.Id));
                                for (int i = tmpDetail2.Count() - 1; i >= 0; i--)
                                {
                                    var tmp_dtl2 = tmpDetail2.ElementAt(i);
                                    order.CommonJpBorrowReturnDetailEstimates.Remove(tmp_dtl2);
                                }

                                foreach (var item in entity.detailList)
                                {
                                    int.TryParse(item.quantity, out int qty);

                                    //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                    //{
                                    //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                    //}
                                    if (qty <= 0)
                                    {
                                        return JsonManager.SimpleCustResponse("quantity field error");
                                    }
                                    else
                                    {
                                        var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                        var bPrice = decimal.TryParse(item.price, out decimal price);
                                        //新增明细
                                        if (string.IsNullOrEmpty(item.id ?? ""))
                                        {
                                            order.CommonJpBorrowReturnDetailEstimates.Add(new CommonJpBorrowReturnDetailEstimate()
                                            {
                                                Id = Guid.NewGuid().ToString(),

                                                EquipmentId = item.equipmentDetailId,
                                                SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                                EstimateId = order.Id,
                                                EquipmentCount = qty,
                                                //SupplierId = item.supplierId
                                                UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                                Price = bPrice ? price : (decimal?)null,

                                            });
                                        }
                                        else
                                        {
                                            var detail = order.CommonJpBorrowReturnDetailEstimates.FirstOrDefault(t => t.Id == item.id);
                                            if (detail == null)
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                            }
                                            else
                                            {

                                                detail.SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId;
                                                detail.EquipmentId = item.equipmentDetailId;
                                                detail.EstimateId = order.Id;
                                                detail.EquipmentCount = qty;
                                                //detail.SupplierId = item.supplierId;
                                                detail.UnitPrice = bUnitPrice ? unitPrice : (decimal?)null;
                                                detail.Price = bPrice ? price : (decimal?)null;

                                            }
                                        }
                                    }
                                }

                                var tmpDetail = order.CommonJpBorrowReturnDetailRealities?.Where(t => !tmpList.Contains(t.Id));
                                for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                {
                                    var tmp_dtl = tmpDetail.ElementAt(i);
                                    order.CommonJpBorrowReturnDetailRealities.Remove(tmp_dtl);
                                }

                                foreach (var item in entity.detailList)
                                {
                                    int.TryParse(item.quantity, out int qty);

                                    //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                    //{
                                    //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                    //}
                                    if (qty <= 0)
                                    {
                                        return JsonManager.SimpleCustResponse("quantity field error");
                                    }
                                    else
                                    {
                                        var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                        var bPrice = decimal.TryParse(item.price, out decimal price);
                                        //新增明细
                                        if (string.IsNullOrEmpty(item.estimateId ?? ""))
                                        {
                                            order.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                                            {
                                                Id = Guid.NewGuid().ToString(),

                                                EquipmentDetailId = item.equipmentDetailId,
                                                SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                                EstimateId = order.Id,
                                                EquipmentCount = qty,
                                                RealityId = order.CommonJpBorrowReturns.FirstOrDefault().Id,
                                            });
                                        }
                                        else
                                        {
                                            var detail = order.CommonJpBorrowReturnDetailRealities.FirstOrDefault(t => t.Id == item.estimateId);
                                            if (detail == null)
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                            }
                                            else
                                            {

                                                detail.SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId;

                                                detail.EquipmentDetailId = item.equipmentDetailId;
                                                detail.EstimateId = order.Id;
                                                detail.EquipmentCount = qty;

                                                //detail.SupplierId = item.supplierId;

                                            }
                                        }
                                    }
                                }

                                bool result = _unitOfWork.BorrowReturnApplyRepository.Update(order);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                        }
                        else
                        {
                            string OrderCode = string.Empty;

                            OrderCode = entity.orgCode + "LY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            var ExistOrder = _unitOfWork.BorrowReturnApplyRepository.Get(p => p.OrderCode == OrderCode);
                            if (ExistOrder != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORDER_IS_EXIST);
                            }
                            string orderID = Guid.NewGuid().ToString();
                            //新增数据
                            CommonJpBorrowReturnApply order = new CommonJpBorrowReturnApply()
                            {
                                ChangeFlag = 0,
                                ActionType = 1,
                                ApplyUser = entity.applyId,
                                ApplyUserName = entity.applyName,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                OrderCode = OrderCode,
                                Note = entity.note,
                                PoliceNote = entity.policeNote,
                                PoliceId = entity.policeId,
                                FileUrl = string.IsNullOrEmpty(entity.fileUrl) ? null : entity.fileUrl
                            };

                            //if (entity.police!=null)
                            //{
                            //    List<string> ids = new List<string>();

                            //        foreach (var item in entity.police)
                            //        {
                            //            if (!string.IsNullOrEmpty(item))
                            //            {

                            //                var rfidLeft = item;
                            //                ids.Add(rfidLeft);
                            //            }


                            //    }
                            //    List<CommonJpBorrowReturnPolice> borrowPolice = new List<CommonJpBorrowReturnPolice>();
                            //    foreach (var item in ids)
                            //    {
                            //        borrowPolice.Add(new CommonJpBorrowReturnPolice
                            //        {
                            //            Id = Guid.NewGuid().ToString(),
                            //            BorrowId = orderID,
                            //            PoliceId = item
                            //        });
                            //    }
                            //    _unitOfWork.CommonJpBorrowReturnPoliceRepository.Insert(borrowPolice, false);
                            //}
                            //else
                            //{
                            //    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            //}

                            List<CommonJpBorrowReturnDetailEstimate> detailsList = new List<CommonJpBorrowReturnDetailEstimate>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);

                                //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                //{
                                //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                //}
                                if (string.IsNullOrEmpty(item.equipmentDetailId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentDetailId is require");
                                }

                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                    var bPrice = decimal.TryParse(item.price, out decimal price);

                                    detailsList.Add(new CommonJpBorrowReturnDetailEstimate()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentDetailId,
                                        SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                        EstimateId = order.Id,
                                        EquipmentCount = qty,
                                        //SupplierId = item.supplierId,
                                        UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                        Price = bPrice ? price : (decimal?)null,
                                    });
                                }
                            }

                            order.CommonJpBorrowReturnDetailEstimates = detailsList;

                            List<CommonJpBorrowReturn> GetdetailsList = new List<CommonJpBorrowReturn>();
                            CommonJpBorrowReturn borrowReturn = new CommonJpBorrowReturn();
                            borrowReturn.Id = Guid.NewGuid().ToString();
                            borrowReturn.ActionType = order.ActionType;
                            borrowReturn.WarehouseId = order.WarehouseId;
                            borrowReturn.OrderCode = order.OrderCode;
                            borrowReturn.CurrentState = (int)CurrentState.未出去;
                            borrowReturn.ApplyId = order.Id;
                            borrowReturn.OrgId = order.OrgId;
                            borrowReturn.CreateTime = DateTime.Now;
                            borrowReturn.CreateUser = order.ApplyUser;

                            foreach (var item in detailsList)
                            {
                                //int.TryParse(item.quantity, out int qty);

                                borrowReturn.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    SizeId = item.SizeId,
                                    EquipmentDetailId = item.EquipmentId,
                                    RealityId = borrowReturn.Id,
                                    State = (int)CurrentState.未出去,
                                    EstimateId = order.Id,
                                    EquipmentCount = item.EquipmentCount,
                                    SupplierId = item.SupplierId

                                });
                                //transferCom.CommonJpTransferDetailRealities = transferDetailsList;


                                GetdetailsList.Add(borrowReturn);
                            }


                            order.CommonJpBorrowReturns = GetdetailsList;

                            bool result = _unitOfWork.BorrowReturnApplyRepository.Insert(order);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增借用单（直接审批通过）
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "actionType":0, //0借用申请，1领用申请
        ///         "warehouseId":"请求仓库ID",
        ///         "orgId":"组织机构ID",
        ///         "orgCode":"组织机构短码",
        ///         "userType":"用户类型"
        ///         "userInfo":"用户或组ID"
        ///         "dataScope":"上级或本级"
        ///         "applyId":"申请人员",
        ///         "applyName":"申请人员名字",
        ///         "note":"请求理由",//可为空
        ///         "expectedTime":"",拟还日期(借用所需)
        ///         "nextStepId":"下一步ID"，
        ///         "currentStepName":"当前步骤"，
        ///         "flowState":"流程是否结束",
        ///         "policeNote":""
        ///         "policeId":""
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填   
        ///            "equipmentDetailId":"",
        ///            "quantity":"",
        ///            "supplierId":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddAndApprovalBorrowJYOrder")]
        public async Task<HttpResponseMessage> AddAndApprovalBorrowJYOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        bool bExpectedTime = DateTime.TryParse(entity?.expectedTime ?? "", out DateTime expectedTime);
                        bool baction = int.TryParse(entity.actionType ?? "0", out int actionType);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (!baction)
                        {
                            return JsonManager.SimpleCustResponse($"action is require");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (actionType == 0 && (!bExpectedTime || expectedTime == default))
                        {
                            return JsonManager.SimpleCustResponse($"expectedTime is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }

                        string OrderCode = string.Empty;
                        if (actionType == 0)//借用
                        {
                            OrderCode = entity.orgCode + "JY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                        }
                        else if (actionType == 1)//领用
                        {
                            OrderCode = entity.orgCode + "LY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                        }
                        string orderID = Guid.NewGuid().ToString();
                        string processCurrentId = Guid.NewGuid().ToString();
                        string flowState = (string)entity.flowState.ToLower();
                        bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                            , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)(string)entity.applyId, (string)entity.applyName, OrderCode);

                        //新增数据
                        CommonJpBorrowReturnApply order = new CommonJpBorrowReturnApply()
                        {
                            ActionType = actionType,
                            ApplyUser = entity.applyId,
                            ApplyUserName = entity.applyName,
                            ApplyTime = DateTime.Now,
                            CreateTime = DateTime.Now,
                            ApprovalResult = (int)ApproveType.已审批,
                            WarehouseId = entity.warehouseId,
                            Id = orderID,
                            OrgId = entity.orgId,
                            OrderCode = OrderCode,
                            Note = entity.note,
                            ProcessCurrentId = processCurrentId,
                            ExpectedReturnTime = expectedTime,
                            PoliceNote = entity.policeNote,
                            PoliceId = entity.policeId
                        };

                        List<CommonJpBorrowReturnDetailEstimate> detailsList = new List<CommonJpBorrowReturnDetailEstimate>();
                        foreach (var item in entity.detailList)
                        {
                            int.TryParse(item.quantity, out int qty);

                            //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                            //{
                            //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                            //}
                            if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                            {
                                return JsonManager.SimpleCustResponse("equipmentId is require");
                            }

                            else if (qty <= 0)
                            {
                                return JsonManager.SimpleCustResponse("quantity field error");
                            }
                            else
                            {
                                var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                var bPrice = decimal.TryParse(item.price, out decimal price);
                                detailsList.Add(new CommonJpBorrowReturnDetailEstimate()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    EquipmentId = item.equipmentId,
                                    SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                    EstimateId = order.Id,
                                    EquipmentCount = qty,
                                    //SupplierId = item.supplierId,
                                    UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                    Price = bPrice ? price : (decimal?)null,
                                });
                            }
                        }

                        order.CommonJpBorrowReturnDetailEstimates = detailsList;

                        List<CommonJpBorrowReturn> borrowReturnList = new List<CommonJpBorrowReturn>();

                        CommonJpBorrowReturn borrowReturn = new CommonJpBorrowReturn
                        {
                            Id = Guid.NewGuid().ToString(),
                            ActionType = order.ActionType,
                            WarehouseId = order.WarehouseId,
                            OrderCode = order.OrderCode,
                            CurrentState = (int)CurrentState.未出去,
                            ApplyId = order.Id,
                            OrgId = order.OrgId,
                            CreateTime = DateTime.Now,
                            CreateUser = entity.auditUser,
                            IsWork = false,
                            PolicemanId = order.PoliceId
                        };

                        foreach (var item in order.CommonJpBorrowReturnDetailEstimates)
                        {
                            //int.TryParse(item.quantity, out int qty);

                            borrowReturn.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                            {
                                Id = Guid.NewGuid().ToString(),
                                SizeId = string.IsNullOrEmpty(item.SizeId) ? null : item.SizeId,
                                EquipmentDetailId = item.EquipmentId,
                                RealityId = borrowReturn.Id,
                                State = (int)CurrentState.未出去,
                                EstimateId = order.Id,
                                EquipmentCount = item.EquipmentCount,

                                SupplierId = item.SupplierId

                            });
                            //transferCom.CommonJpTransferDetailRealities = transferDetailsList;


                            borrowReturnList.Add(borrowReturn);
                        }


                        order.CommonJpBorrowReturns = borrowReturnList;

                        var result = _unitOfWork.BorrowReturnApplyRepository.Insert(order);

                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新借用/领用单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "actionType":0, //0借用申请，1领用申请
        ///         "warehouseId":"请求仓库ID",
        ///         "orgId":"组织机构ID",
        ///         "orgCode":"组织机构短码",
        ///         "userType":"用户类型"
        ///         "userInfo":"用户或组ID"
        ///         "dataScope":"上级或本级"
        ///         "applyId":"申请人员",
        ///         "applyName":"申请人员名字",
        ///         "note":"请求理由",//可为空
        ///         "expectedTime":"",拟还日期(借用所需)
        ///         "nextStepId":"下一步ID"，
        ///         "currentStepName":"当前步骤"，
        ///         "flowState":"流程是否结束",
        ///         "policeNote":""
        ///         "policeId":""
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填   
        ///            "equipmentDetailId":"",
        ///            "quantity":"",
        ///            "supplierId":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateBorrowOrder")]
        public async Task<HttpResponseMessage> AddOrUpdateBorrowOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        bool bExpectedTime = DateTime.TryParse(entity?.expectedTime ?? "", out DateTime expectedTime);
                        bool baction = int.TryParse(entity.actionType ?? "0", out int actionType);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (!baction)
                        {
                            return JsonManager.SimpleCustResponse($"action is require");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (actionType == 0 && (!bExpectedTime || expectedTime == default))
                        {
                            return JsonManager.SimpleCustResponse($"expectedTime is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool proResult = _unitOfWork.CheckProcess(id);
                            if (!proResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpBorrowReturnApplies.Include(t => t.CommonJpBorrowReturnDetailEstimates).FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {

                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, "", "update");
                                    order.ApplyTime = DateTime.Now;
                                    order.WarehouseId = entity.warehouseId;
                                    order.Note = entity.note;
                                    order.ApplyUser = entity.applyId;
                                    order.ApplyUserName = entity.applyName;
                                    order.PoliceNote = entity.policeNote;
                                    order.PoliceId = entity.policeId;


                                    order.ExpectedReturnTime = expectedTime;

                                    //if (entity.police != null)
                                    //{
                                    //    List<string> ids = new List<string>();
                                    //    foreach (var item in entity.police)
                                    //    {
                                    //        if (!string.IsNullOrEmpty(item))
                                    //        {

                                    //            var rfidLeft = item;
                                    //            ids.Add(rfidLeft);
                                    //        }


                                    //    }
                                    //    var tmpPolice = _unitOfWork.CommonJpBorrowReturnPoliceRepository.GetList(p => p.BorrowId.Equals(order.Id)).ToList();
                                    //    _unitOfWork.CommonJpBorrowReturnPoliceRepository.Delete(tmpPolice, false);
                                    //    List<CommonJpBorrowReturnPolice> borrowPolice = new List<CommonJpBorrowReturnPolice>();
                                    //    foreach (var item in ids)
                                    //    {
                                    //        borrowPolice.Add(new CommonJpBorrowReturnPolice
                                    //        {
                                    //            Id = Guid.NewGuid().ToString(),
                                    //            BorrowId = order.Id,
                                    //            PoliceId = item
                                    //        });
                                    //    }
                                    //    _unitOfWork.CommonJpBorrowReturnPoliceRepository.Insert(borrowPolice, false);
                                    //}

                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    var tmpDetail = order.CommonJpBorrowReturnDetailEstimates?.Where(t => !tmpList.Contains(t.Id));
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        order.CommonJpBorrowReturnDetailEstimates.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);

                                        //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                        //{
                                        //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                        //}
                                        if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                            var bPrice = decimal.TryParse(item.price, out decimal price);
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpBorrowReturnDetailEstimates.Add(new CommonJpBorrowReturnDetailEstimate()
                                                {
                                                    Id = Guid.NewGuid().ToString(),

                                                    EquipmentId = item.equipmentId,
                                                    SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                                    EstimateId = order.Id,
                                                    EquipmentCount = qty,
                                                    //SupplierId = item.supplierId
                                                    UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                                    Price = bPrice ? price : (decimal?)null,

                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpBorrowReturnDetailEstimates.FirstOrDefault(t => t.Id == item.id);
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {

                                                    detail.SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId;
                                                    detail.EquipmentId = item.equipmentId;
                                                    detail.EstimateId = order.Id;
                                                    detail.EquipmentCount = qty;
                                                    //detail.SupplierId = item.supplierId;
                                                    detail.UnitPrice = bUnitPrice ? unitPrice : (decimal?)null;
                                                    detail.Price = bPrice ? price : (decimal?)null;

                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.BorrowReturnApplyRepository.Update(order);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }

                            else
                            {
                                return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                            }
                        }
                        else
                        {
                            string OrderCode = string.Empty;
                            if (actionType == 0)//借用
                            {
                                OrderCode = entity.orgCode + "JY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            }
                            else if (actionType == 1)//领用
                            {
                                OrderCode = entity.orgCode + "LY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            }
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)(string)entity.applyId, (string)entity.applyName, OrderCode);
                            
                            //新增数据
                            CommonJpBorrowReturnApply order = new CommonJpBorrowReturnApply()
                            {
                                ActionType = actionType,
                                ApplyUser = entity.applyId,
                                ApplyUserName = entity.applyName,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ApprovalResult = (int)ApproveType.待审批,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                OrderCode = OrderCode,
                                Note = entity.note,
                                ProcessCurrentId = processCurrentId,
                                ExpectedReturnTime = expectedTime,
                                PoliceNote = entity.policeNote,
                                PoliceId = entity.policeId
                            };
                            List<CommonJpBorrowReturnDetailEstimate> detailsList = new List<CommonJpBorrowReturnDetailEstimate>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);
                                if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentId is require");
                                }

                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                    var bPrice = decimal.TryParse(item.price, out decimal price);
                                    detailsList.Add(new CommonJpBorrowReturnDetailEstimate()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentId,
                                        SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                        EstimateId = order.Id,
                                        EquipmentCount = qty,
                                        UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                        Price = bPrice ? price : (decimal?)null,
                                        //SupplierId = item.supplierId
                                    });
                                }
                            }

                            order.CommonJpBorrowReturnDetailEstimates = detailsList;

                            if (flowState == "true")
                            {
                                List<CommonJpBorrowReturn> RealityList = new List<CommonJpBorrowReturn>();
                                CommonJpBorrowReturn borrowReturn = new CommonJpBorrowReturn();
                                borrowReturn.Id = Guid.NewGuid().ToString();
                                borrowReturn.ActionType = order.ActionType;
                                borrowReturn.WarehouseId = order.WarehouseId;
                                borrowReturn.OrderCode = order.OrderCode;
                                borrowReturn.CurrentState = (int)CurrentState.未出去;
                                borrowReturn.ApplyId = order.Id;
                                borrowReturn.OrgId = order.OrgId;
                                borrowReturn.CreateTime = DateTime.Now;
                                borrowReturn.CreateUser = entity.auditUser;
                                borrowReturn.IsWork = false;
                                borrowReturn.PolicemanId = order.PoliceId;  
                                foreach (var item in detailsList)
                                {
                                    //int.TryParse(item.quantity, out int qty);

                                    borrowReturn.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        SizeId = item.SizeId,
                                        EquipmentDetailId = item.EquipmentId,
                                        RealityId = borrowReturn.Id,
                                        State = (int)CurrentState.未出去,
                                        EstimateId = orderID,
                                        EquipmentCount = item.EquipmentCount,
                                        SupplierId = item.SupplierId

                                    });


                                    RealityList.Add(borrowReturn);
                                }


                                order.CommonJpBorrowReturns = RealityList;
                            }

                            bool result = _unitOfWork.BorrowReturnApplyRepository.Insert(order);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新报废单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "warehouseId":"请求仓库ID",
        ///         "orgId":"组织机构ID",
        ///         "orgCode":"组织机构短码",
        ///         "userType":"用户类型"
        ///         "userInfo":"用户或组ID"
        ///         "dataScope":"上级或本级"
        ///         "applyId":"申请人员",
        ///         "applyName":"申请人员名字",
        ///         "note":"请求理由",//可为空
        ///         "nextStepId":"下一步ID"，
        ///         "currentStepName":"当前步骤"，
        ///         "flowState":"流程是否结束",
        ///         "policeNote":""
        ///         "policeId":""
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填   
        ///            "equipmentDetailId":"",
        ///            "quantity":"",
        ///            "supplierId":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateFixedOrder")]
        public async Task<HttpResponseMessage> AddOrUpdateFixedOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool proResult = _unitOfWork.CheckProcess(id);
                            if (!proResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpBorrowReturnApplies.Include(t => t.CommonJpBorrowReturnDetailEstimates).FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {

                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess("2", order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, "", "update");
                                    order.ApplyTime = DateTime.Now;
                                    order.WarehouseId = entity.warehouseId;
                                    order.Note = entity.note;
                                    order.ApplyUser = entity.applyId;
                                    order.ApplyUserName = entity.applyName;

                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    var tmpDetail = order.CommonJpBorrowReturnDetailEstimates?.Where(t => !tmpList.Contains(t.Id));
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        order.CommonJpBorrowReturnDetailEstimates.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);

                                        if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                            var bPrice = decimal.TryParse(item.price, out decimal price);
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpBorrowReturnDetailEstimates.Add(new CommonJpBorrowReturnDetailEstimate()
                                                {
                                                    Id = Guid.NewGuid().ToString(),

                                                    EquipmentId = item.equipmentId,
                                                    SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                                    EstimateId = order.Id,
                                                    EquipmentCount = qty,
                                                    //SupplierId = item.supplierId,
                                                    UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                                    Price = bPrice ? price : (decimal?)null,

                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpBorrowReturnDetailEstimates.FirstOrDefault(t => t.Id == item.id);
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {

                                                    detail.SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId;
                                                    detail.EquipmentId = item.equipmentId;
                                                    detail.EstimateId = order.Id;
                                                    detail.EquipmentCount = qty;
                                                    //detail.SupplierId = item.supplierId;
                                                    detail.UnitPrice = bUnitPrice ? unitPrice : (decimal?)null;
                                                    detail.Price = bPrice ? price : (decimal?)null;
                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.BorrowReturnApplyRepository.Update(order);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }

                            else
                            {
                                return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                            }
                        }
                        else
                        {
                            string OrderCode = string.Empty;
                            OrderCode = entity.orgCode + "BF" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)(string)entity.applyId, (string)entity.applyName, OrderCode);

                            //新增数据
                            CommonJpBorrowReturnApply order = new CommonJpBorrowReturnApply()
                            {
                                ActionType = 2,
                                ApplyUser = entity.applyId,
                                ApplyUserName = entity.applyName,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ApprovalResult = (int)ApproveType.待审批,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                OrderCode = OrderCode,
                                Note = entity.note,
                                ProcessCurrentId = processCurrentId,
                            };

                            List<CommonJpBorrowReturnDetailEstimate> detailsList = new List<CommonJpBorrowReturnDetailEstimate>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);

                                if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentId is require");
                                }
                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                    var bPrice = decimal.TryParse(item.price, out decimal price);
                                    detailsList.Add(new CommonJpBorrowReturnDetailEstimate()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentId,
                                        SizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                        EstimateId = order.Id,
                                        EquipmentCount = qty,
                                        //SupplierId = item.supplierId,
                                        UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                        Price = bPrice ? price : (decimal?)null,
                                    });
                                }
                            }

                            order.CommonJpBorrowReturnDetailEstimates = detailsList;

                            if (flowState == "true")
                            {
                                List<CommonJpBorrowReturn> RealityList = new List<CommonJpBorrowReturn>();
                                CommonJpBorrowReturn borrowReturn = new CommonJpBorrowReturn();
                                borrowReturn.Id = Guid.NewGuid().ToString();
                                borrowReturn.ActionType = order.ActionType;
                                borrowReturn.WarehouseId = order.WarehouseId;
                                borrowReturn.OrderCode = order.OrderCode;
                                borrowReturn.CurrentState = (int)CurrentState.未出去;
                                borrowReturn.ApplyId = order.Id;
                                borrowReturn.OrgId = order.OrgId;
                                borrowReturn.CreateTime = DateTime.Now;
                                borrowReturn.CreateUser = entity.auditUser;
                                borrowReturn.IsWork = false;
                                borrowReturn.PolicemanId = order.PoliceId;
                                foreach (var item in detailsList)
                                {
                                    //int.TryParse(item.quantity, out int qty);

                                    borrowReturn.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        SizeId = item.SizeId,
                                        EquipmentDetailId = item.EquipmentId,
                                        RealityId = borrowReturn.Id,
                                        State = (int)CurrentState.未出去,
                                        EstimateId = orderID,
                                        EquipmentCount = item.EquipmentCount,
                                        SupplierId = item.SupplierId

                                    });


                                    RealityList.Add(borrowReturn);
                                }


                                order.CommonJpBorrowReturns = RealityList;
                            }

                            bool result = _unitOfWork.BorrowReturnApplyRepository.Insert(order);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取借用领用订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetByID")]

        public async Task<HttpResponseMessage> GetByID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = string.Empty;
                        id = entity.id;


                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpBorrowReturnDetailEstimates.Equipment" ,
                       "CommonJpBorrowReturnDetailEstimates.Size" ,
                       "CommonJpBorrowReturnDetailEstimates.Equipment" ,
                       "CommonJpBorrowReturns" ,
                       "Warehouse" ,
                       "Apply" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.EquipmentDetail" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Size" ,
                       "CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Supplier" ,
                       "CommonJpBorrowReturnDetailEstimates.Supplier" ,
                       "Police" ,
                       //"CommonJpBorrowReturnPolices",
                       //"CommonJpBorrowReturnPolices.Police"
                    };
                        Expression<Func<CommonJpBorrowReturnApply, bool>> expression = p => (p.Id.Equals(id) || p.OrderCode.Equals(id));

                        var borrow = _unitOfWork.BorrowReturnApplyRepository.GetList(expression, null, false, param).ToList();
                        if (borrow.Count > 0)
                        {


                            var borrowData = borrow.Select(t => new
                            {
                                type = t.ActionType.Equals(0) ? 2 : 3,//2借用，3领用
                                t.ActionType,
                                t.ChangeFlag,
                                id = t.Id,
                                warehouseId = t.WarehouseId,
                                applyId = t.ApplyUser,
                                applyName = t.ApplyUserName,
                                applyTime = t.ApplyTime,
                                t.ProcessCurrent?.UserInfo,
                                t.ProcessCurrent?.UpdateTime,
                                t.ProcessCurrent?.OrgId,
                                note = t.Note,
                                t.ProcessCurrent?.NextStepId,
                                t.ProcessCurrent?.CurrentStepName,
                                t.ProcessCurrent?.DataScope,
                                t.ProcessCurrent?.UserType,
                                t.PoliceNote,
                                t.PoliceId,
                                policeName = t.Police?.Name,
                                processActionType = t.ProcessCurrent?.ActionType,
                                fileUrl= t.FileUrl,
                                historyList = t.ProcessCurrent?.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    x.AuditMind,
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                t.ProcessCurrent?.FlowType,
                                flowState = Convert.ToBoolean(t.ProcessCurrent?.FlowState),
                                createTime = t.CreateTime,
                                warehouseName = t.Warehouse?.Name,
                                t.OrderCode,
                                expectedTime = t.ExpectedReturnTime,

                                actionResult = t.ProcessCurrent?.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.ApplyUser) == true ? "0" : "1",

                                //police = t.CommonJpBorrowReturnPolices.Select(p => new
                                //{
                                //    p.Police?.Name,
                                //    p.Police?.Id
                                //}),
                                detailList = t.CommonJpBorrowReturnDetailEstimates?.Select(x => new
                                {
                                    id = x.Id,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentUnitType = x.Equipment?.UnitType,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.EquipmentCount,
                                    supplierId = x.Supplier?.Id,
                                    supplierName = x.Supplier?.Name,
                                    sizeCount = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.EquipmentCode.Equals(x.EquipmentId) && p.WarehouseCode.Equals(t.Warehouse.Id)).Count(),

                                    unitPrice = x.UnitPrice,
                                    price = x.Price,
                                }),
                                applyResult = t.CommonJpBorrowReturns?.Select(p => new
                                {
                                    p.CurrentState,
                                    resultList = p.CommonJpBorrowReturnDetailRealities?.Select(q => new
                                    {
                                        realityId = q.Id,
                                        quantity = q.EquipmentCount,
                                        equipmentId = q.EquipmentDetail?.Id,
                                        equipmentName = q.EquipmentDetail?.Name,
                                        equipmentSizeId = q.Size?.Id,
                                        equipmentSizeName = q.Size?.SizeName,
                                        //applyQuantity = t.CommonJpBorrowReturnDetailEstimates?.Where(x => q.SizeId.Equals(x.SizeId) && q.EquipmentDetailId.Equals(x.EquipmentId))?.FirstOrDefault().EquipmentCount,
                                        supplierId = q.Supplier?.Id,
                                        supplierName = q.Supplier?.Name,
                                        q.RealCount,
                                        q.InsideRealCount,
                                        q.State
                                    })
                                }).FirstOrDefault(),
                                resultPriceList = new List<object>()
                            }).FirstOrDefault();

                            if (borrowData?.detailList != null)
                            {
                                foreach (var obj in borrowData.detailList)
                                {
                                    if (obj != null)
                                    {
                                        borrowData.resultPriceList.Add(new
                                        {
                                            equipmentName = obj.equipmentName,
                                            equipmentUnitType = obj.equipmentUnitType,
                                            equipmentSizeName = obj.equipmentSizeName,
                                            price = obj.unitPrice?.ToString("F2"),
                                            count = obj.quantity,
                                            totalPrice = obj.price?.ToString("F2"),
                                        });
                                    }
                                }
                            }

                            return JsonManager.ReturnSuccessResponse(borrowData);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        private static object BorrowSign = new object();
        /// <summary>
        /// 审批借用领用申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6",
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "flowState":
        ///         "approvalMsg":"驳回理由"
        ///         "userType":"",
        ///         "userInfo":"",
        ///         "dataScope":"",
        ///         "nextStepId":"",
        ///         "currentStepName":"",
        ///         "auditUser":""
        ///         "auditUserName":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    lock (BorrowSign)
                    {


                        if (jdata != null)
                        {

                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }
                            else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"orgId is require");
                            }
                            else
                            {

                                var id = (string)(entity.id);
                                var flowState = (string)(entity.flowState).ToLower();
                                var orderInfo = _unitOfWork.DbContext.CommonJpBorrowReturnApplies.Include(p => p.ProcessCurrent).FirstOrDefault(t => t.Id == id);
                                if (orderInfo.ProcessCurrent.FlowState == "ture")
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.ORDER_OPERATE_ERROR);
                                }
                                if (orderInfo == null)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                                else
                                {
                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {

                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                         (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, "", "approve");
                                        orderInfo.ApprovalTime = DateTime.Now;

                                        if (flowState.Equals("false"))
                                        {
                                            orderInfo.ApprovalMsg = entity.approvalMsg;
                                        }
                                        else
                                        {
                                            List<CommonJpBorrowReturn> detailsList = new List<CommonJpBorrowReturn>();
                                            CommonJpBorrowReturn borrowReturn = new CommonJpBorrowReturn();
                                            borrowReturn.Id = Guid.NewGuid().ToString();
                                            borrowReturn.ActionType = orderInfo.ActionType;
                                            borrowReturn.WarehouseId = orderInfo.WarehouseId;
                                            borrowReturn.OrderCode = orderInfo.OrderCode;
                                            borrowReturn.CurrentState = (int)CurrentState.未出去;
                                            borrowReturn.ApplyId = orderInfo.Id;
                                            borrowReturn.OrgId = orderInfo.OrgId;
                                            borrowReturn.CreateTime = DateTime.Now;
                                            borrowReturn.CreateUser = entity.auditUser;
                                            borrowReturn.IsWork = false;
                                            borrowReturn.PolicemanId = orderInfo.PoliceId;
                                            var DetailEstimates = _unitOfWork.BorrowReturnDetailEstimateRepository.GetList(p => p.EstimateId.Equals(id));
                                            foreach (var item in DetailEstimates)
                                            {
                                                //int.TryParse(item.quantity, out int qty);

                                                borrowReturn.CommonJpBorrowReturnDetailRealities.Add(new CommonJpBorrowReturnDetailReality()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    SizeId = item.SizeId,
                                                    EquipmentDetailId = item.EquipmentId,
                                                    RealityId = borrowReturn.Id,
                                                    State = (int)CurrentState.未出去,
                                                    EstimateId = id,
                                                    EquipmentCount = item.EquipmentCount,

                                                    SupplierId = item.SupplierId

                                                });
                                                //transferCom.CommonJpTransferDetailRealities = transferDetailsList;


                                                detailsList.Add(borrowReturn);
                                            }


                                            orderInfo.CommonJpBorrowReturns = detailsList;
                                        }

                                        bool result = _unitOfWork.BorrowReturnApplyRepository.Update(orderInfo);
                                        if (result)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                        }
                                        else
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }

                            }

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 大文件上传，参数“borrowFile”，可自定义
        /// </summary>
        /// <returns></returns>
        [HttpPost("UploadBorrowFile")]
        [RequestSizeLimit(419430400)/*文件大小上限，400M，可自定义*/]
        [NoSign]
        public async Task<HttpResponseMessage> UploadBorrowFile()
        {
            try
            {
                //获取boundary
                var boundary = HeaderUtilities.RemoveQuotes(MediaTypeHeaderValue.Parse(Request.ContentType).Boundary).Value ?? "";
                //得到reader
                var reader = new MultipartReader(boundary, HttpContext.Request.Body);
                var section = await reader.ReadNextSectionAsync();

                var webRoot = _hostingEnvironment.WebRootPath/*IWebHostEnvironment，用于获取网站、API根目录*/;
                bool flag = false;
                long fileLen = 0;
                List<string> extList = new List<string>()
                {
                    ".doc", ".docx", ".xls", ".xlsx", ".pdf",
                    ".jpg", ".png", ".bmp",
                    ".rar", ".zip", ".7z"
                };
                var savePath = string.Empty;
                //读取section
                while (section != null)
                {
                    var hasContentDispositionHeader = ContentDispositionHeaderValue.TryParse(section.ContentDisposition, out var contentDisposition);
                    if (hasContentDispositionHeader)
                    {
                        if (contentDisposition.Name == "borrowFile")
                        {
                            var fileName = contentDisposition.FileName.Value;
                            var fileExt = Path.GetExtension(fileName);
                            if (extList.Contains(fileExt))
                            {
                                flag = true;
                                var filePath = "BorrowFile/" + DateTime.Now.ToString("yyyyMMdd\\/HHmmssfff");
                                var dir = Path.Combine(webRoot, filePath);
                                if (!Directory.Exists(dir))
                                {
                                    Directory.CreateDirectory(dir);
                                }
                                savePath = $"/{filePath}/{fileName}";
                                fileLen = await WriteFileAsync(section.Body, Path.Combine(dir, fileName));
                            }
                            else
                            {
                                return JsonManager.SimpleCustResponse("unsupported media type");
                            }
                        }
                    }
                    section = await reader.ReadNextSectionAsync();
                }
                if (!flag)
                {
                    return JsonManager.SimpleCustResponse("borrowFile is require");
                }
                else
                {
                    if (fileLen > 0)
                    {
                        return JsonManager.ReturnSuccessResponse(savePath);
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("file upload failed");
                    }
                }
            }
            catch (Exception ex)
            {
                _logger.LogError(ex.ToString());
                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);

            }

        }

        #region private

        /// <summary>
        /// 写文件导到磁盘
        /// </summary>
        /// <param name="stream">流</param>
        /// <param name="path">文件保存路径</param>
        /// <returns></returns>
        private async Task<int> WriteFileAsync(Stream stream, string path)
        {
            const int FILE_WRITE_SIZE = 84975;//写出缓冲区大小
            int writeCount = 0;
            using (FileStream fileStream = new FileStream(path, FileMode.Create, FileAccess.Write, FileShare.Write, FILE_WRITE_SIZE, true))
            {
                byte[] byteArr = new byte[FILE_WRITE_SIZE];
                int readCount = 0;
                while ((readCount = await stream.ReadAsync(byteArr, 0, byteArr.Length)) > 0)
                {
                    await fileStream.WriteAsync(byteArr, 0, readCount);
                    writeCount += readCount;
                }
            }
            return writeCount;
        }

        #endregion
    }
}