﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Nacos;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore;
using Rextec.SOA.Infrastructure;

namespace JunmpPoliceStation.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class MissionController : Controller
    {
        private readonly INacosConfigClient _configClient;
        private ILogger<BorrowController> _logger;
        private readonly object _createEpcLockObj = new object();
        UnitOfWork _unitOfWork;
        public MissionController(ILogger<BorrowController> logger, UnitOfWork unitOfWork, INacosConfigClient configClient)
        {
            _configClient = configClient;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }
        #region bag装备包

        /// <summary>
        /// 添加或修改装备包
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "orgId":"组织机构",
        ///        "name":"装备包名称"
        ///        "bagList": [
        ///          {
        ///            "id":"",
        ///            "detailId": "",
        ///            "count": ""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateBag")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            string name = entity.name;
                            BaseJpBag existObject = _unitOfWork.BaseJpBagRepository.Get(p => p.Name.Equals(name) && p.Id != id);
                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            var param = new string[] {
                            "CommonJpBagInventories",
                            "BaseJpBagMaps"
                    };
                            BaseJpBag updateObject = _unitOfWork.BaseJpBagRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();
                            if (updateObject != null)
                            {
                                updateObject.Name = entity.name;
                                updateObject.OrgId = entity.orgId;
                                updateObject.UpdateTime = DateTime.Now;
                                int changeList = entity.bagList.Count;
                                if (updateObject.CommonJpBagInventories.Where(p => p.IsDelete == false).Count() > 0 && changeList > 0)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.BAG_EXIST);
                                }
                                else
                                {
                                    List<string> tmpList = JsonManager.GetDetailIds(entity.bagList);
                                    var tmpDetail = updateObject.BaseJpBagMaps?.Where(t => !tmpList.Contains(t.Id)).ToList();
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        updateObject.BaseJpBagMaps.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.bagList)
                                    {
                                        if (string.IsNullOrEmpty(item.id ?? ""))
                                        {
                                            updateObject.BaseJpBagMaps.Add(new BaseJpBagMap()
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                BagId = updateObject.Id,
                                                Count = int.Parse(item.count),
                                                DetailId = item.detailId,
                                                CreateTime = DateTime.Now,
                                                UpdateTime = DateTime.Now
                                            });

                                        }
                                        else
                                        {
                                            var detail = updateObject.BaseJpBagMaps.FirstOrDefault(t => t.Id == item.id);
                                            if (detail == null)
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                            }
                                            else
                                            {
                                                detail.UpdateTime = DateTime.Now;
                                                detail.Count = int.Parse(item.count);
                                                detail.DetailId = item.detailId;
                                                detail.UpdateTime = DateTime.Now;

                                            }
                                        }

                                    }



                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.BaseJpBagRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            string name = entity.name;
                            BaseJpBag existObject = _unitOfWork.BaseJpBagRepository.Get(p => p.Name.Equals(name));
                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            string bagId = Guid.NewGuid().ToString();
                            //新增数据
                            BaseJpBag addObject = new BaseJpBag()
                            {
                                Id = bagId,
                                Name = entity.name,
                                CreateTime = DateTime.Now,
                                UpdateTime = DateTime.Now,
                                OrgId = entity.orgId,
                                IsDelete = false
                            };
                            foreach (var item in entity.bagList)
                            {
                                addObject.BaseJpBagMaps.Add(new BaseJpBagMap()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    BagId = bagId,
                                    Count = int.Parse(item.count),
                                    DetailId = item.detailId,
                                    CreateTime = DateTime.Now,
                                    UpdateTime = DateTime.Now
                                });
                            }

                            bool result = _unitOfWork.BaseJpBagRepository.Insert(addObject);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备包分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "name": "包名",
        ///         "orgId":"组织机构号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageBag")]
        public async Task<HttpResponseMessage> GetPageBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string Name = entity.name;
                        string orgId = entity.orgId;
                        Expression<Func<BaseJpBag, bool>> expressionBag = t => t.OrgId.Equals(orgId) && t.IsDelete == false;

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            expressionBag = LambdaExtensions.AndAlso(expressionBag, t => t.Name.Contains(Name));
                        }

                        var param = new string[] {
                       "BaseJpBagMaps" ,
                       "BaseJpBagMaps.Detail",
                       "CommonJpBagInventories",
                       "CommonJpBagInventories.CommonJpEquipmentInventories",
                       "CommonJpBagInventories.CommonJpEquipmentInventories.EquipmentCodeNavigation",
                       "CommonJpBagInventories.CommonJpEquipmentInventories.EquipmentSizecodeNavigation",
                       "Org"
                    };

                        PageData<BaseJpBag> pagedata = _unitOfWork.BaseJpBagRepository.GetPage(expressionBag, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.OrgId,
                            orgName = c.Org?.Name,
                            bagList = c.BaseJpBagMaps.Select(p => new
                            {
                                p.Id,
                                p.Count,
                                p.CreateTime,
                                p.UpdateTime,
                                p.DetailId,
                                p.Detail?.Name
                            }),
                            bagInventories = c.CommonJpBagInventories.Where(p => p.IsDelete == false).Select(p => new
                            {
                                p.Id,
                                p.Epc,
                                p.CreateTime,
                                p.PrintState,
                                p.NeedNumber,
                                p.Number,
                                Inventories = p.CommonJpEquipmentInventories.Select(x => new
                                {
                                    x.Id,
                                    x.Epc,
                                    x.CurrentState,
                                    x.EquipmentCodeNavigation?.Name,
                                    x.EquipmentSizecodeNavigation?.SizeName

                                })
                            })

                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备包实例分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "name": "包名",
        ///         "orgId":"组织机构号"
        ///         "warehouseId":"仓库id 选填"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageBagInventory")]
        public async Task<HttpResponseMessage> GetPageBagInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string Name = entity.name;
                        string orgId = entity.orgId;
                        string warehouseId = entity.warehouseId;
                        Expression<Func<CommonJpBagInventory, bool>> expressionBag = t => t.Bag.OrgId.Equals(orgId) && t.IsDelete == false;

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            expressionBag = LambdaExtensions.AndAlso(expressionBag, t => t.Bag.Name.Contains(Name));
                        }
                        if (!String.IsNullOrEmpty(entity.warehouseId))
                        {
                            expressionBag = LambdaExtensions.AndAlso(expressionBag, t => t.WarehouseId.Equals(warehouseId));
                        }

                        var param = new string[]
                        {
                            "Bag",
                            "Bag.Org",
                            "Bag.BaseJpBagMaps",
                            "Bag.BaseJpBagMaps.Detail",
                            "CommonJpEquipmentInventories",
                            "CommonJpEquipmentInventories.EquipmentCodeNavigation",
                            "CommonJpEquipmentInventories.EquipmentSizecodeNavigation",
                        };

                        var pagedata = _unitOfWork.BagInventoryRepository.GetPage(expressionBag, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Bag.Name,
                            c.Bag.OrgId,
                            orgName = c.Bag.Org?.Name,
                            c.PrintState,
                            c.NeedNumber,
                            c.Number,
                            c.Epc,
                            c.State,
                            Map = c.Bag.BaseJpBagMaps.Select(x => new
                            {
                                x.Id,
                                x.Count,
                                x.CreateTime,
                                x.UpdateTime,
                                x.DetailId,
                                x.Detail?.Name,
                                Inventories = c.CommonJpEquipmentInventories
                                    .Where(y => y.EquipmentCode == x.DetailId)
                                    .Select(y => new
                                    {
                                        y.Id,
                                        y.Epc,
                                        y.CurrentState,
                                        y.EquipmentCodeNavigation?.Name,
                                        y.EquipmentSizecodeNavigation?.SizeName

                                    })
                            }),

                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备包内epc信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "epcList": ["epc"],
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetEpcListByBagInvEpc")]
        public async Task<HttpResponseMessage> GetEpcListByBagInvEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (!(entity.epcList is List<string>) || entity.epcList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"epcList is require");
                        }

                        var epcList = jdata["epcList"].Values<string>().ToList();

                        Expression<Func<CommonJpBagInventory, bool>> expressionBag = t => epcList.Contains(t.Epc) && t.IsDelete != true;

                        var param = new string[]
                        {
                            "Bag",
                            "Bag.Org",
                            "Bag.BaseJpBagMaps",
                            "Bag.BaseJpBagMaps.Detail",
                            "CommonJpEquipmentInventories",
                            "CommonJpEquipmentInventories.EquipmentCodeNavigation",
                            "CommonJpEquipmentInventories.EquipmentSizecodeNavigation",
                        };

                        var list = _unitOfWork.BagInventoryRepository.GetList(expressionBag, x => x.Epc, false, param).ToList();

                        var data = list.Select(c => new
                        {
                            c.Id,
                            c.Bag.Name,
                            orgizationId = c.Bag.OrgId,
                            orgName = c.Bag.Org?.Name,
                            c.PrintState,
                            c.NeedNumber,
                            c.Number,
                            c.Epc,
                            epcList = c.CommonJpEquipmentInventories.Select(x => x.Epc)
                        }
                        ).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除装备包
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":""      
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteBag")]
        public async Task<HttpResponseMessage> DeleteBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;

                        var param = new string[] {
                            "CommonJpBagInventories",
                            "BaseJpBagMaps"
                    };
                        var bag = _unitOfWork.BaseJpBagRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();
                        if (bag.CommonJpBagInventories.Count > 0)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.BAG_EXIST);
                        }
                        else
                        {

                            if (bag.BaseJpBagMaps.Count > 0)
                            {
                                var bagMaps = _unitOfWork.BaseJpBagMapRepository.GetList(p => p.BagId == id).ToList();
                                _unitOfWork.BaseJpBagMapRepository.Delete(bagMaps, false);
                            }
                            var result = _unitOfWork.BaseJpBagRepository.Delete(bag, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 绑定物资至装备包
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "warehouseId":"仓库id",
        ///        "bagId":"装备包id",
        ///        "equipmentList": [
        ///          {
        ///            "epc": "物资epc",
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BindBag")]
        //[NoSign]
        public async Task<HttpResponseMessage> BindBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string warehouseId = entity?.warehouseId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        if (string.IsNullOrEmpty(entity.bagId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"bagId is require");
                        }
                        else if (entity.equipmentList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"equipmentList is require");
                        }
                        string bagInvId = Guid.NewGuid().ToString();
                        string BagId = entity.bagId;

                        List<string> invList = new List<string>();
                        foreach (var item in entity.equipmentList)
                        {
                            invList.Add(item.epc);
                        }
                        var BindList = _unitOfWork.EquipmentInventoryRepository.GetList(p => invList.Contains(p.Epc)).ToList();//取出所有准备绑定的epc
                        var param = new string[]
                        {
                            "BaseJpBagMaps"
                        };
                        //检查装备仓库是否对应
                        if (BindList.Any(x => x.WarehouseCode != warehouseId))
                        {
                            return JsonManager.SimpleCustResponse("绑定失败，存在非本仓库EPC");
                        }
                        //检查装备仓库是否已绑定过装备包
                        if (BindList.Any(x => !string.IsNullOrEmpty(x.BagInventoryId)))
                        {
                            return JsonManager.SimpleCustResponse("绑定失败，存在已绑定装备包的装备");
                        }

                        var bagModel = _unitOfWork.BaseJpBagRepository.GetList(p => p.Id.Equals(BagId), null, false, param).FirstOrDefault();
                        int isPrint = 1;//0初始化，1未打印，2已打印
                        foreach (var item in bagModel.BaseJpBagMaps)
                        {
                            var currentBindCount = BindList.Where(p => p.EquipmentCode.Equals(item.DetailId)).Count();
                            if (currentBindCount > item.Count)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.COUNT_ERROR);
                            }
                            if (currentBindCount < item.Count)
                            {
                                isPrint = 0;
                            }
                        }

                        bagModel.Num++;
                        CommonJpBagInventory bagInv = new CommonJpBagInventory()
                        {
                            Id = bagInvId,
                            BagId = BagId,
                            State = 0,
                            CreateTime = DateTime.Now,
                            PrintState = isPrint,
                            UpdateTime = DateTime.Now,
                            Number = bagModel.Num,
                            IsDelete = false,
                            WarehouseId = warehouseId,
                            NeedNumber = bagModel.BaseJpBagMaps.Sum(x => x.Count)
                        };

                        //创建epc
                        //redis读取今日BoxNo;
                        uint date = uint.Parse(bagInv.CreateTime.Value.Date.ToString("yyyyMMdd"));
                        uint epcBoxNo = 0;
                        var msg = "";
                        lock (_createEpcLockObj)
                        {
                            var key = DateTime.Now.ToString("yyyyMMdd") + "BagNo";
                            string value = RedisCacheHelper.GetStringValue(key);
                            epcBoxNo = uint.TryParse(value, out var boxNo) ? boxNo + 1 : 1;
                            if (!RedisCacheHelper.SetStringValue(key, epcBoxNo.ToString(), ref msg))
                            {
                                throw new Exception("RedisCacheHelper Exception:" + msg);
                            }
                        }
                        var epcs = GenerateEpcNum.GenBagEpcs(GlobalContext.ServerNum, date, Convert.ToUInt32(bagInv.NeedNumber), epcBoxNo, out msg, 1);
                        bagInv.Epc = epcs.First().Epc;

                        foreach (var item in BindList)
                        {
                            bagInv.CommonJpEquipmentInventories.Add(item);
                        }
                        _unitOfWork.BaseJpBagRepository.Update(bagModel, false);
                        bool result = _unitOfWork.BagInventoryRepository.Insert(bagInv);
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 解绑装备包
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "bagInvEpc":"待解绑的装备包ID"
        ///        "type":"all/select" 全部解绑(装备包会消失),个别解绑
        ///        "equipmentList": [
        ///          {
        ///            "equipmentEPC": "物资ID",
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ReleaseBag")]
        //[NoSign]
        public async Task<HttpResponseMessage> ReleaseBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string type = entity.type;
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        if (string.IsNullOrEmpty(entity.bagInvEpc ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"bagInvEpc is require");
                        }
                        else if (entity.equipmentList?.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"equipmentList is require");
                        }

                        string bagEPC = entity.bagInvEpc;
                        var bagRelease = _unitOfWork.BagInventoryRepository.Get(p => p.Epc.Equals(bagEPC));
                        if (bagRelease == null || bagRelease.IsDelete == true)
                        {
                            return JsonManager.SimpleCustResponse($"bagInvEpc is require");
                        }
                        if (type.Equals("all"))//全部解绑
                        {
                            List<CommonJpEquipmentInventory> invDeleteList = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.BagInventoryId.Equals(bagRelease.Id)).ToList();
                            foreach (var item in invDeleteList)
                            {
                                item.BagInventoryId = null;
                            }
                            bagRelease.IsDelete = true;
                            _unitOfWork.BagInventoryRepository.Update(bagRelease, false);
                            bool result = _unitOfWork.EquipmentInventoryRepository.Update(invDeleteList, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else if (type.Equals("select"))//选择性解绑
                        {
                            //装备包实例为维护状态
                            bagRelease.State = 2;
                            _unitOfWork.BagInventoryRepository.Update(bagRelease, false);
                            List<string> invs = new List<string>();
                            foreach (var item in entity.equipmentList)
                            {
                                invs.Add(item.equipmentEPC);
                            }
                            var BindList = _unitOfWork.EquipmentInventoryRepository.GetList(p => invs.Contains(p.Epc)).ToList();
                            foreach (var item in BindList)
                            {
                                item.BagInventoryId = null;
                            }
                            bool result = _unitOfWork.EquipmentInventoryRepository.Update(BindList, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 换绑装备包
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "bagInvEpc":"装备包EPC"
        ///        "equipmentEPC": "物资EPC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ReBindBag")]
        //[NoSign]
        public async Task<HttpResponseMessage> ReBindBag([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        string bagEPC = entity.bagInvEpc ?? "";
                        string equipmentEPC = entity.equipmentEPC;

                        if (string.IsNullOrEmpty(entity.bagInvEpc ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"bagInvEpc is require");
                        }
                        else if (string.IsNullOrEmpty(entity.equipmentEPC ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"equipmentEPC is require");
                        }

                        var bagRelease = _unitOfWork.DbContext.CommonJpBagInventories
                            .Include(x => x.Bag)
                            .Include(x => x.CommonJpEquipmentInventories)
                            .Include(x => x.Bag.BaseJpBagMaps)
                            .FirstOrDefault(p => p.Epc.Equals(bagEPC));
                        if (bagRelease == null || bagRelease.IsDelete == true)
                        {
                            return JsonManager.SimpleCustResponse($"bagInvEpc is require");
                        }
                        if (bagRelease.State != 2)
                        {
                            return JsonManager.SimpleCustResponse($"装备包不在维护状态");
                        }

                        var inv = _unitOfWork.DbContext.CommonJpEquipmentInventories
                            .FirstOrDefault(x => x.Epc == equipmentEPC);
                        if (inv == null)
                        {
                            return JsonManager.SimpleCustResponse($"equipmentEPC is require");
                        }
                        if (!string.IsNullOrEmpty(inv.BagInventoryId))
                        {
                            return JsonManager.SimpleCustResponse($"装备已绑定装备包");
                        }

                        var map = bagRelease.Bag.BaseJpBagMaps.FirstOrDefault(x => x.DetailId == inv.EquipmentCode);
                        if (map == null)
                        {
                            return JsonManager.SimpleCustResponse($"装备包无此装备需求");
                        }
                        if (map.Count <= bagRelease.CommonJpEquipmentInventories.Count(x => x.EquipmentCode == inv.EquipmentCode))
                        {
                            return JsonManager.SimpleCustResponse($"装备包当前类型装备超出需求数量");
                        }

                        inv.BagInventoryId = bagRelease.Id;
                        if (bagRelease.NeedNumber == bagRelease.CommonJpEquipmentInventories.Count + 1)
                        {
                            //绑定齐全，恢复入库状态
                            bagRelease.State = 0;
                        }

                        _unitOfWork.BagInventoryRepository.Update(bagRelease, false);
                        var res = _unitOfWork.EquipmentInventoryRepository.Update(inv, true);

                        if (res)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        #endregion
        #region Model预案
        /// <summary>
        /// 添加或修改模块/预案
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "orgId":"组织机构",
        ///        "isDefault":"是否默认"/默认的模块只能由特殊权限的人进行操作
        ///        "name":"预案名称"
        ///        "modelList": [
        ///          {
        ///            "type": "",bag/equipment 物资类型 /装备包-装备
        ///            "typeId":"",物资ID
        ///            "count": ""数量
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateModel")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateModel([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"name is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            string name = entity.name;
                            BaseJpModel existObject = _unitOfWork.BaseJpModelRepository.Get(p => p.Name.Equals(name) && p.Id != id);

                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            var param = new string[] {
                            "CommonJpModelBags"

                    };
                            BaseJpModel updateObject = _unitOfWork.BaseJpModelRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();
                            if (updateObject != null)
                            {
                                updateObject.Name = entity.name;
                                updateObject.OrgId = entity.orgId;
                                updateObject.UpdateTime = DateTime.Now;
                                int changeList = entity.modelList.Count;
                                //if (updateObject.CommonJpBagInventories.Count > 0 && changeList > 0)
                                //{
                                //    return JsonManager.SimpleStatusResponse(ResultCode.BAG_EXIST);
                                //}
                                //else
                                //{
                                List<string> tmpList = JsonManager.GetDetailIds(entity.modelList);
                                var tmpDetail = updateObject.CommonJpModelBags?.Where(t => !tmpList.Contains(t.Id)).ToList();
                                for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                {
                                    var tmp_dtl = tmpDetail.ElementAt(i);
                                    updateObject.CommonJpModelBags.Remove(tmp_dtl);
                                }

                                foreach (var item in entity.modelList)
                                {
                                    if (string.IsNullOrEmpty(item.id ?? ""))
                                    {
                                        if (item.type == "bag")
                                        {
                                            updateObject.CommonJpModelBags.Add(new CommonJpModelBag()
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                ModelId = updateObject.Id,
                                                Count = int.Parse(item.count),
                                                BagId = item.typeId,
                                                CreateTime = DateTime.Now
                                            });
                                        }
                                        else
                                        {
                                            updateObject.CommonJpModelBags.Add(new CommonJpModelBag()
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                ModelId = updateObject.Id,
                                                Count = int.Parse(item.count),
                                                EquipmentId = item.typeId,
                                                CreateTime = DateTime.Now
                                            });
                                        }

                                    }
                                    else
                                    {
                                        var detail = updateObject.CommonJpModelBags.FirstOrDefault(t => t.Id == item.id);
                                        if (detail == null)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                        }
                                        else
                                        {
                                            detail.Count = int.Parse(item.count);
                                            if (item.type == "bag")
                                            {
                                                detail.BagId = item.typeId;
                                            }
                                            else
                                            {
                                                detail.EquipmentId = item.typeId;
                                            }
                                        }
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.BaseJpModelRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            string name = entity.name;
                            BaseJpModel existObject = _unitOfWork.BaseJpModelRepository.Get(p => p.Name.Equals(name));
                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            string modelId = Guid.NewGuid().ToString();
                            //新增数据
                            BaseJpModel addObject = new BaseJpModel()
                            {
                                Id = modelId,
                                Name = entity.name,
                                CreateTime = DateTime.Now,
                                UpdateTime = DateTime.Now,
                                OrgId = entity.orgId,
                                Isdefault = Convert.ToBoolean(entity.isDefault)
                            };
                            foreach (var item in entity.modelList)
                            {
                                string type = item.type;
                                string typeId = item.typeId;
                                if (type.Equals("bag"))
                                {
                                    addObject.CommonJpModelBags.Add(new CommonJpModelBag()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        BagId = typeId,
                                        Count = int.Parse(item.count),

                                        CreateTime = DateTime.Now,
                                        ModelId = modelId

                                    });
                                }
                                else if (type.Equals("equipment"))
                                {
                                    addObject.CommonJpModelBags.Add(new CommonJpModelBag()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = typeId,
                                        Count = int.Parse(item.count),
                                        CreateTime = DateTime.Now,
                                        ModelId = modelId

                                    });
                                }

                            }

                            bool result = _unitOfWork.BaseJpModelRepository.Insert(addObject);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取模块分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "name": "包名",
        ///         "orgId":"组织机构号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageModel")]
        public async Task<HttpResponseMessage> GetPageModel([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string Name = entity.name;
                        string orgId = entity.orgId;
                        Expression<Func<BaseJpModel, bool>> expressionModel = t => t.OrgId.Equals(orgId);


                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            expressionModel = LambdaExtensions.AndAlso(expressionModel, t => t.Name.Contains(Name));
                        }

                        var param = new string[] {
                       "CommonJpModelBags" ,
                       "CommonJpModelBags.Bag",
                       "CommonJpModelBags.Bag.BaseJpBagMaps",
                       "CommonJpModelBags.Bag.BaseJpBagMaps.Detail",
                       "CommonJpModelBags.Equipment",
                       "Org"
                    };

                        PageData<BaseJpModel> pagedata = _unitOfWork.BaseJpModelRepository.GetPage(expressionModel, "Isdefault", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.OrgId,
                            IsDefault = c.Isdefault,
                            c.UpdateTime,
                            orgName = c.Org?.Name,
                            modelList = c.CommonJpModelBags.Select(p => new
                            {
                                type = string.IsNullOrEmpty(p.BagId) ? "equipment" : "bag",
                                typeId = string.IsNullOrEmpty(p.BagId) ? p.EquipmentId : p.BagId,
                                p.Count,
                                p.CreateTime,
                                Name = string.IsNullOrEmpty(p.BagId) ? p.Equipment?.Name : p.Bag?.Name,
                                bagList = p.Bag?.BaseJpBagMaps.Select(t => new
                                {
                                    t.Id,
                                    t.Count,
                                    t.Detail?.Name,
                                    t.DetailId,
                                    t.UpdateTime
                                })
                            }),
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除预案/模块
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":""      
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteModel")]
        public async Task<HttpResponseMessage> DeleteModel([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;

                        var param = new string[] {
                            "CommonJpModelBags"

                    };
                        var model = _unitOfWork.BaseJpModelRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();


                        if (model.CommonJpModelBags.Count > 0)
                        {
                            var modelMaps = _unitOfWork.ModelBagRepository.GetList(p => p.ModelId == id).ToList();
                            _unitOfWork.ModelBagRepository.Delete(modelMaps, false);
                        }
                        var result = _unitOfWork.BaseJpModelRepository.Delete(model, true);
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        #endregion
        #region 任务

        /// <summary>
        /// 添加或修改任务
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "warehouseId":"仓库"
        ///        "workState":"工作状态"
        ///        "missionId":"任务编号",
        ///        "state":"单据状态"0未开始状态， 2已完成
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("changeWorkState")]
        //[NoSign]
        public async Task<HttpResponseMessage> changeWorkState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string missionId = entity?.missionId ?? "";
                        string workState = entity?.workState ?? "";
                        string state = entity?.state ?? "";
                        string warehouseId= entity?.warehouseId ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        if (string.IsNullOrEmpty(entity.missionId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"missionId is require");
                        }


                        CommonJpMission existObject = _unitOfWork.MissionRepository.Get(p => p.Id.Equals(missionId));
                        if (existObject == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.ORDER_NOT_EXIST);
                        }
                        if (bool.TryParse(workState, out bool bworkState))
                        {
                            if (bworkState)
                            {
                                var existMission = _unitOfWork.MissionRepository.GetList(p => p.IsWork == true&&p.State==0&&p.WarehouseId==warehouseId).ToList();
                                if (existMission.Count > 0|| _unitOfWork.VOrderInfoRepository.Any(t => t.IsWork == true && t.WarehouseId == warehouseId))
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.MISSION_EXIST);
                                }
                                else
                                {
                                    existObject.IsWork = true;
                                }
                            }
                            else
                            {
                                existObject.IsWork = false;
                            }


                        }
                        if (!string.IsNullOrEmpty(state))
                        {
                            existObject.State = int.Parse(state);
                        }


                        bool result = _unitOfWork.MissionRepository.Update(existObject);
                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }

                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 添加或修改任务
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "orgId":"组织机构",
        ///        "name":"预案名称"
        ///        "warehouseId":"仓库号"
        ///        "modelList": [
        ///          {
        ///            "modelId": "",模块ID
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateMission")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateMission([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }

                        if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"name is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            string name = entity.name;
                            CommonJpMission existObject = _unitOfWork.MissionRepository.Get(p => p.Name.Equals(name) && p.Id != id);

                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            var param = new string[] {
                             "CommonJpMisssionChildren",
                             "CommonJpEquipmentStates",
                             };
                            CommonJpMission updateObject = _unitOfWork.MissionRepository.GetList(p => p.Id.Equals(id), null, false, param).FirstOrDefault();

                            if (updateObject != null)
                            {
                                if (updateObject.CommonJpEquipmentStates.Count() > 0)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.MISSION_ERROR);
                                }
                                if (updateObject.IsWork == true)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.MISSION_ERROR);
                                }

                                updateObject.Name = entity.name;
                                updateObject.OrgId = entity.orgId;

                                int changeList = entity.modelList.Count;

                                List<string> tmpList = JsonManager.GetDetailIds(entity.modelList);
                                var tmpDetail = updateObject.CommonJpMisssionChildren?.Where(t => !tmpList.Contains(t.Id)).ToList();
                                for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                {
                                    var tmp_dtl = tmpDetail.ElementAt(i);
                                    updateObject.CommonJpMisssionChildren.Remove(tmp_dtl);
                                }

                                foreach (var item in entity.modelList)
                                {
                                    if (string.IsNullOrEmpty(item.id ?? ""))
                                    {
                                        updateObject.CommonJpMisssionChildren.Add(new CommonJpMisssionChild()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            ModelId = item.modelId,
                                            MissionId = updateObject.Id
                                        });

                                    }
                                    else
                                    {
                                        string MissionId = item.id;
                                        var detail = updateObject.CommonJpMisssionChildren.FirstOrDefault(t => t.Id == MissionId);
                                        if (detail == null)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                        }
                                        else
                                        {
                                            detail.ModelId = item.modelId;
                                        }
                                    }

                                    //}



                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.MissionRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            string name = entity.name;
                            CommonJpMission existObject = _unitOfWork.MissionRepository.Get(p => p.Name.Equals(name));
                            if (existObject != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.NAME_ERROR);
                            }
                            string missionId = Guid.NewGuid().ToString();
                            //新增数据
                            CommonJpMission addObject = new CommonJpMission()
                            {
                                Id = missionId,
                                Name = entity.name,
                                CreateTime = DateTime.Now,
                                State = 0,
                                WarehouseId = entity.warehouseId,
                                OrgId = entity.orgId,
                                IsWork = false
                            };
                            foreach (var item in entity.modelList)
                            {

                                addObject.CommonJpMisssionChildren.Add(new CommonJpMisssionChild()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    MissionId = missionId,
                                    State = "0",
                                    ModelId = item.modelId

                                });
                            }

                            bool result = _unitOfWork.MissionRepository.Insert(addObject);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取任务分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "name": "任务名",
        ///         "orgId":"组织机构号"
        ///         "warehouseId":"仓库ID"
        ///         "state":"0:未开始，1进行中（已出库），2已完成（全部回库)"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageMission")]
        public async Task<HttpResponseMessage> GetPageMission([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string Name = entity.name;
                        string orgId = entity.orgId;
                        string warehouseId = entity.warehouseId;
                        string state = entity.state;
                        Expression<Func<CommonJpMission, bool>> expressionMission = t => t.OrgId.Equals(orgId) && t.WarehouseId.Equals(warehouseId);


                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            expressionMission = LambdaExtensions.AndAlso(expressionMission, t => t.Name.Contains(Name));
                        }
                        if (!String.IsNullOrEmpty(entity.state))
                        {
                            expressionMission = LambdaExtensions.AndAlso(expressionMission, t => t.State.Equals(state));
                        }

                        var param = new string[] {
                       "Warehouse" ,
                       "CommonJpMisssionChildren",
                       "CommonJpMisssionChildren.Model",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Equipment",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag.BaseJpBagMaps",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag.BaseJpBagMaps.Detail",
                       "Org",
                    };

                        PageData<CommonJpMission> pagedata = _unitOfWork.MissionRepository.GetPage(expressionMission, "-CreateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.OrgId,
                            c.IsWork,
                            c.State,
                            orgName = c.Org?.Name,
                            warehouseId = c.WarehouseId,
                            warehouseName = c.Warehouse?.Name,
                            c.CreateTime,
                            missionChild = c.CommonJpMisssionChildren.Select(p => new
                            {
                                p.Id,
                                p.State,
                                p.ModelId,
                                p.Model?.Name,
                                modelList = p.Model?.CommonJpModelBags.Select(x => new
                                {
                                    type = string.IsNullOrEmpty(x.BagId) ? "equipment" : "bag",
                                    typeId = string.IsNullOrEmpty(x.BagId) ? x.EquipmentId : x.BagId,
                                    x.Count,
                                    x.CreateTime,
                                    Name = string.IsNullOrEmpty(x.BagId) ? x.Equipment?.Name : x.Bag?.Name,
                                    bagList = x.Bag?.BaseJpBagMaps.Select(t => new
                                    {
                                        t.Id,
                                        t.Count,
                                        t.Detail?.Name,
                                        t.DetailId,
                                        t.UpdateTime
                                    })
                                }),
                            }),
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过id获取任务
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id": "任务id",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMissionById")]
        public async Task<HttpResponseMessage> GetMissionById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        string id = entity.id;
                        var param = new string[] {
                       "Warehouse" ,
                       "CommonJpMisssionChildren",
                       "CommonJpMisssionChildren.Model",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Equipment",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag.BaseJpBagMaps",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag.BaseJpBagMaps.Detail",
                       "Org",
                    };

                        var list = _unitOfWork.MissionRepository
                            .GetList(x => x.Id == id, null, false, param)
                            .ToList();

                        var data = list.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.OrgId,
                            c.IsWork,
                            c.State,
                            orgName = c.Org?.Name,
                            warehouseId = c.WarehouseId,
                            warehouseName = c.Warehouse?.Name,
                            c.CreateTime,
                            missionChild = c.CommonJpMisssionChildren.Select(p => new
                            {
                                p.Id,
                                p.State,
                                p.ModelId,
                                p.Model?.Name,
                                modelList = p.Model?.CommonJpModelBags.Select(x => new
                                {
                                    type = string.IsNullOrEmpty(x.BagId) ? "equipment" : "bag",
                                    typeId = string.IsNullOrEmpty(x.BagId) ? x.EquipmentId : x.BagId,
                                    x.Count,
                                    x.CreateTime,
                                    Name = string.IsNullOrEmpty(x.BagId) ? x.Equipment?.Name : x.Bag?.Name,
                                    bagList = x.Bag?.BaseJpBagMaps.Select(t => new
                                    {
                                        t.Id,
                                        t.Count,
                                        t.Detail?.Name,
                                        t.DetailId,
                                        t.UpdateTime
                                    })
                                }),
                            }),
                        }
                        ).FirstOrDefault();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取任务出入库信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id": "任务id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMissionInOutInfo")]
        public async Task<HttpResponseMessage> GetMissionInOutInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string id = entity.id;
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }

                        var param = new string[] {
                       "Warehouse" ,
                       "CommonJpMisssionChildren",
                       "CommonJpMisssionChildren.Model",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Equipment",
                       "Org",
                    };

                        var mission = _unitOfWork.MissionRepository.GetList(x => x.Id == id, includes: param).FirstOrDefault();

                        if (mission == null)
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }

                        var data = mission.CommonJpMisssionChildren.Select(x => new
                        {
                            x.Model.Name,
                            x.Model.Id,
                            ModelBagList = x.Model.CommonJpModelBags.Select(y => new
                            {
                                Name = string.IsNullOrEmpty(y.BagId) ? y.Equipment?.Name : y.Bag?.Name,
                                type = string.IsNullOrEmpty(y.BagId) ? "equipment" : "bag",
                                typeId = string.IsNullOrEmpty(y.BagId) ? y.EquipmentId : y.BagId,
                                y.Count,
                                realInCount = _unitOfWork.DbContext.CommonJpEquipmentStates
                                    .Include(z => z.BagInventory)
                                    .Include(z => z.Eqiupment)
                                    .Count(z =>
                                                ((z.BagInventory != null && z.BagInventory.BagId == y.BagId)
                                                || (z.Eqiupment != null && z.Eqiupment.EquipmentCode == y.EquipmentId))
                                                && z.MissionModelId == mission.Id
                                                && z.ActionState == 21
                                                && string.IsNullOrEmpty(z.ParentId)
                                                ),
                                realOutCount = _unitOfWork.DbContext.CommonJpEquipmentStates
                                    .Include(z => z.BagInventory)
                                    .Include(z => z.Eqiupment)
                                    .Count(z =>
                                                ((z.BagInventory != null && z.BagInventory.BagId == y.BagId)
                                                 || (z.Eqiupment != null && z.Eqiupment.EquipmentCode == y.EquipmentId))
                                                && z.MissionModelId == mission.Id
                                                && z.ActionState == 20
                                                && string.IsNullOrEmpty(z.ParentId)
                                    ),
                            })
                        });

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取任务单据信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": ""
        ///         "size": ""
        ///         "warehouseId": "仓库id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMissionOrderInfo")]
        public async Task<HttpResponseMessage> GetMissionOrderInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string warehouseId = entity.warehouseId;
                        if (string.IsNullOrEmpty(warehouseId))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 3;
                        }

                        var param = new string[] {
                       "Warehouse" ,
                       "CommonJpMisssionChildren",
                       "CommonJpMisssionChildren.Model",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Bag",
                       "CommonJpMisssionChildren.Model.CommonJpModelBags.Equipment",
                       "Org",
                    };

                        var pageData = _unitOfWork.MissionRepository.GetPage(x => (x.State == 0 || x.State == 1) && x.IsWork == true && x.WarehouseId == warehouseId, "-CreateTime", page, size, false, param);

                        var data = pageData.content.Select(x => new
                        {
                            id = x.Id,
                            createTime = x.CreateTime,
                            isWork = x.IsWork,
                            orderType = "任务",
                            orgId = x.OrgId,
                            warehouseId = x.WarehouseId,
                            equNames = string.Join(",", x.CommonJpMisssionChildren
                                .Select(y => string.Join(",", y.Model.CommonJpModelBags.Select(z => z.Bag?.Name + z.Equipment?.Name))))
                        }).ToList();

                        return JsonManager.ReturnSuccessResponse(new
                        {
                            totalElements = pageData.totalElements,
                            content = data
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        #endregion
    }
}
