﻿using JmpModel.Model;
using JmpModel.Model.DataContext;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata.Internal;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Models.Repository
{
    public class BaseRepository<T> where T : class, new()
    {
        private readonly DbSet<T> _dbSet;
        public JunmppolicesqlContext DbContext { get; } = null;
        public BaseRepository(JunmppolicesqlContext context)
        {
            DbContext = context;
            _dbSet = DbContext.Set<T>();
        }
        public DatabaseFacade Database => DbContext.Database;
        public IQueryable<T> Entities => _dbSet.AsQueryable().AsNoTracking();

        public List<CAreaList> Exec_Pro(String findCode)
        {
            List<CAreaList> returnList = DbContext.Set<CAreaList>().FromSqlRaw(" EXEC  c_area_count @p_findCode ='" + findCode + "'").ToList();
            return returnList;
        }

        public List<CSyP> Exec_ProP(String proName)
        {
            List<CSyP> returnList = DbContext.Set<CSyP>().FromSqlRaw(proName).ToList();
            return returnList;
        }
        public List<useCountResult> Exec_UseCount(String proName)
        {
            List<useCountResult> returnList = DbContext.Set<useCountResult>().FromSqlRaw(proName).ToList();
            return returnList;
        }

        public int SaveChanges()
        {
            return DbContext.SaveChanges();
        }
        public async Task<int> SaveChangesAsync()
        {
            return await DbContext.SaveChangesAsync();
        }
        public bool Any(Expression<Func<T, bool>> whereLambd)
        {
            return _dbSet.Where(whereLambd).Any();
        }
        public void Disposed()
        {
            throw new Exception("不允许在这里释放上下文，请在UnitOfWork中操作");
            //DbContext.Dispose();
        }

        #region 插入数据
        public bool Insert(T entity, bool isSaveChange = true)
        {
            _dbSet.Add(entity);
            if (isSaveChange)
            {
                return SaveChanges() > 0;
            }
            return false;
        }
        public async Task<bool> InsertAsync(T entity, bool isSaveChange = true)
        {
            _dbSet.Add(entity);
            if (isSaveChange)
            {
                return await SaveChangesAsync() > 0;
            }
            return false;
        }
        public bool Insert(List<T> entitys, bool isSaveChange = true)
        {
            _dbSet.AddRange(entitys);
            if (isSaveChange)
            {
                return SaveChanges() > 0;
            }
            return false;
        }

        public async Task<bool> InsertAsync(List<T> entitys, bool isSaveChange = true)
        {
            _dbSet.AddRange(entitys);
            if (isSaveChange)
            {
                return await SaveChangesAsync() > 0;
            }
            return false;
        }
        public bool InsertList(List<T> entitys,out int resNum, bool isSaveChange = true)
        {
            _dbSet.AddRange(entitys);
            var res = SaveChanges();
            resNum = res;
            if (res>0)
            {
                return true;
            }
            else
            {
                return false;
            }
        
          
        }
        #endregion

        #region 删除
        public bool Delete(T entity, bool isSaveChange = true)
        {
            _dbSet.Attach(entity);
            _dbSet.Remove(entity);
            return isSaveChange ? SaveChanges() > 0 : false;
        }
        public bool Delete(List<T> entitys, bool isSaveChange = true)
        {
            entitys.ForEach(entity =>
            {
                _dbSet.Attach(entity);
                _dbSet.Remove(entity);
            });
            return isSaveChange ? SaveChanges() > 0 : false;
        }
        public virtual async Task<bool> DeleteAsync(T entity, bool isSaveChange = true)
        {

            _dbSet.Attach(entity);
            _dbSet.Remove(entity);
            return isSaveChange ? await SaveChangesAsync() > 0 : false;
        }
        public virtual async Task<bool> DeleteAsync(List<T> entitys, bool isSaveChange = true)
        {
            entitys.ForEach(entity =>
            {
                _dbSet.Attach(entity);
                _dbSet.Remove(entity);
            });
            return isSaveChange ? await SaveChangesAsync() > 0 : false;
        }
        #endregion

        #region 更新数据

        public bool Update(T entity, bool isSaveChange = true, List<string> updatePropertyList = null, bool modified = true)
        {

            if (entity == null)
            {
                return false;
            }
            _dbSet.Attach(entity);
            var entry = DbContext.Entry(entity);
            if (updatePropertyList == null)
            {
                entry.State = EntityState.Modified;//全字段更新
            }
            else
            {
                if (modified)
                {
                    updatePropertyList.ForEach(c =>
                    {
                        entry.Property(c).IsModified = true; //部分字段更新的写法
                    });
                }
                else
                {
                    entry.State = EntityState.Modified;//全字段更新
                    updatePropertyList.ForEach(c =>
                    {
                        entry.Property(c).IsModified = false; //部分字段不更新的写法
                    });
                }
            }
            if (isSaveChange)
            {
                return SaveChanges() > 0;
            }
            return false;
        }
        public bool Update(List<T> entitys, bool isSaveChange = true)
        {
            if (entitys == null || entitys.Count == 0)
            {
                return false;
            }
            entitys.ForEach(c =>
            {
                Update(c, false);
            });
            if (isSaveChange)
            {
                return SaveChanges() > 0;
            }
            return false;
        }
        public async Task<bool> UpdateAsync(T entity, bool isSaveChange = true, List<string> updatePropertyList = null, bool modified = true)
        {
            if (entity == null)
            {
                return false;
            }
            _dbSet.Attach(entity);
            var entry = DbContext.Entry<T>(entity);
            if (updatePropertyList == null)
            {
                entry.State = EntityState.Modified;//全字段更新
            }
            else
            {
                if (modified)
                {
                    updatePropertyList.ForEach(c =>
                    {
                        entry.Property(c).IsModified = true; //部分字段更新的写法
                    });
                }
                else
                {
                    entry.State = EntityState.Modified;//全字段更新
                    updatePropertyList.ForEach(c =>
                    {
                        entry.Property(c).IsModified = false; //部分字段不更新的写法
                    });
                }
            }
            if (isSaveChange)
            {
                return await SaveChangesAsync() > 0;
            }
            return false;
        }
        public async Task<bool> UpdateAsync(List<T> entitys, bool isSaveChange = true)
        {
            if (entitys == null || entitys.Count == 0)
            {
                return false;
            }
            entitys.ForEach(c =>
            {
                _dbSet.Attach(c);
                DbContext.Entry<T>(c).State = EntityState.Modified;
            });
            if (isSaveChange)
            {
                return await SaveChangesAsync() > 0;
            }
            return false;
        }
        #endregion

        #region 查找



        public long Count(Expression<Func<T, bool>> predicate = null)
        {
            if (predicate == null)
            {
                predicate = c => true;
            }
            return _dbSet.LongCount(predicate);
        }
        public async Task<long> CountAsync(Expression<Func<T, bool>> predicate = null)
        {
            if (predicate == null)
            {
                predicate = c => true;
            }
            return await _dbSet.LongCountAsync(predicate);
        }
        public T Get(object id)
        {
            if (id == null)
            {
                return default(T);
            }
            return _dbSet.Find(id);
        }
        public T Get(Expression<Func<T, bool>> predicate = null, bool isNoTracking = false)
        {
            var data = isNoTracking ? _dbSet.Where(predicate).AsNoTracking() : _dbSet.Where(predicate);
            return data.FirstOrDefault();
        }
        public async Task<T> GetAsync(object id)
        {
            if (id == null)
            {
                return default(T);
            }
            return await _dbSet.FindAsync(id);
        }
        public async Task<T> GetAsync(Expression<Func<T, bool>> predicate = null, bool isNoTracking = true)
        {
            var data = isNoTracking ? _dbSet.Where(predicate).AsNoTracking() : _dbSet.Where(predicate);
            return await data.FirstOrDefaultAsync();
        }
        public async Task<List<T>> GetListAsync(Expression<Func<T, bool>> predicate = null, string ordering = "", bool isNoTracking = false, params string[] includes)
        {
            
            var data = isNoTracking ? _dbSet.AsNoTracking() : _dbSet;
            foreach (var include in includes)
            {
                data = data.Include(include);
            }
            data = data.Where(predicate);
            if (!string.IsNullOrEmpty(ordering))
            {
                data = data.OrderByDescending(ordering);
            }
            return await data.ToListAsync();
        }
        public IQueryable<T> GetList(Expression<Func<T, bool>> whereBy, Expression<Func<T, dynamic>> orderBy = null, bool isNoTracking = false, params string[] includes)
        {
            IQueryable<T> data = _dbSet;
            foreach (var include in includes)
            {
                data = data.Include(include);
            }
            data = data.Where(whereBy);
            if (orderBy != null)
            {
                data = data.OrderByDescending(orderBy);
            }



            return data;
        }

        public IQueryable<T> GetArray(Expression<Func<T, bool>> whereBy, Expression<Func<T, dynamic>> orderBy = null, bool orderType = false, params string[] includes)
        {
            IQueryable<T> data = _dbSet;
            foreach (var include in includes)
            {
                data = data.Include(include);
            }

            data =  data.Where(whereBy);
            if (orderBy != null)
            {
                if (orderType)
                {
                    data = data.OrderBy(orderBy);
                }
                else
                {
                    data = data.OrderByDescending(orderBy);
                }
               
            }

            return data;
        }

        public IQueryable<dynamic> GetGroupList<TSource, TKey>(Expression<Func<T, bool>> whereBy, Expression<Func<T, dynamic>> orderBy = null, Expression<Func<T, dynamic>> groupBy = null, bool isNoTracking = false, params string[] includes)
        {
            IQueryable<T> data = _dbSet;
            foreach (var include in includes)
            {
                data = data.Include(include);
            }

            data = isNoTracking ? data.Where(whereBy).AsNoTracking() : data.Where(whereBy);

            if (orderBy != null)
            {
                data = data.OrderByDescending(orderBy);
            }
            IQueryable<dynamic> ss = null;
            if (groupBy != null)
            {
                ss = data.GroupBy(groupBy).Select(p => p.Key);
            }
            return ss;
        }
        public List<T> GetListDe(Expression<Func<T, bool>> whereBy, Expression<Func<T, dynamic>> orderBy = null, bool isNoTracking = false, params string[] includes)
        {
            IQueryable<T> data = _dbSet;
            foreach (var include in includes)
            {
                data = data.Include(include);
            }

            data = isNoTracking ? data.Where(whereBy).AsNoTracking() : data.Where(whereBy);
            if (orderBy != null)
            {
                data = data.OrderBy(orderBy);
            }
            return data.ToList();
        }
        public async Task<IQueryable<T>> LoadAsync(Expression<Func<T, bool>> predicate = null, bool isNoTracking = true)
        {
            if (predicate == null)
            {
                predicate = c => true;
            }
            return await Task.Run(() => isNoTracking ? _dbSet.Where(predicate).AsNoTracking() : _dbSet.Where(predicate));
        }
        public IQueryable<T> Load(Expression<Func<T, bool>> predicate = null, bool isNoTracking = true)
        {
            if (predicate == null)
            {
                predicate = c => true;
            }
            return isNoTracking ? _dbSet.Where(predicate).AsNoTracking() : _dbSet.Where(predicate);
        }
        #region 分页查找

        /// <summary>
        /// 获取数据列表
        /// </summary>
        /// <param name = "orderExp" > 排序条件 </ param >
        /// < param name="expression">查询条件</param>
        /// <param name = "orderBy" > 排序方式 </ param >
        /// < param name="includes">关联表</param>
        /// <returns></returns>
        //public List<T> GetList(Expression<Func<T, dynamic>> orderExp, Expression<Func<T, bool>> expression = null, string orderBy = "desc", string[] includes = null)
        //{
        //    try
        //    {
        //        IQueryable<T> quary = _dbSet.AsQueryable().AsNoTracking();
        //        if (includes != null && includes.Any())
        //        {
        //            foreach (var include in includes)
        //            {
        //                quary = quary.Include(include);
        //            }
        //        }
        //        if (expression != null)
        //        {
        //            quary = quary.Where(expression);
        //        }
        //        return orderBy == "desc" ? quary.OrderByDescending(orderExp).ToList() : quary.OrderBy(orderExp).ToList();
        //    }
        //    catch (Exception ex)
        //    {

        //        return null;
        //    }
        //}

        /// <summary>
        /// 分页查询异步
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有）</param>
        /// <param name="page">当前页码</param>
        /// <param name="size">每页大小</param>
        /// <param name="isOrder">排序正反</param>
        /// <returns></returns>
        public async Task<PageData<T>> GetPageAsync<TKey>(Expression<Func<T, bool>> whereLambda, Expression<Func<T, TKey>> orderBy, int page, int size, bool isOrder = true, bool isNoTracking = true)
        {
            IQueryable<T> data = isOrder ?
                _dbSet.OrderBy(orderBy) :
                _dbSet.OrderByDescending(orderBy);

            if (whereLambda != null)
            {
                data = isNoTracking ? data.Where(whereLambda).AsNoTracking() : data.Where(whereLambda);
            }
            PageData<T> pageData = new PageData<T>
            {
                totalElements = await data.CountAsync(),
                content = await data.Skip(page * size).Take(page).ToListAsync()
            };
            return pageData;
        }

        /// <summary>
        /// 分页查询异步
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有，多个用逗号隔开，倒序开头用-号）</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页大小</param>
        /// <returns></returns>
        public async Task<PageData<T>> GetPageAsync(Expression<Func<T, bool>> whereLambda, string ordering, int pageIndex, int pageSize, bool isNoTracking = false, params string[] include)
        {
            // 分页 一定注意： Skip 之前一定要 OrderBy
            if (string.IsNullOrEmpty(ordering))
            {
                ordering = nameof(T) + "Id";//默认以Id排序
            }
            var data = _dbSet.OrderByBatch(ordering);
            foreach (var item in include)
            {
                data = (data == null ? _dbSet : data).Include(item);
            }
            if (whereLambda != null)
            {
                data = (data ?? _dbSet).Where(whereLambda).Take(100000);
            }

            //查看生成的sql，找到大数据下分页巨慢原因为order by 耗时
            //var sql = data.Skip((pageIndex - 1) * pageSize).Take(pageSize).ToSql();
            //File.WriteAllText(@"D:\sql.txt",sql);
            PageData<T> pageData = new PageData<T>
            {
                totalElements = await data.CountAsync(),
                content = await data.Skip((pageIndex) * pageSize).Take(pageSize).ToListAsync()
            };
            return pageData;
        }


        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有，多个用逗号隔开，倒序开头用-号）</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页大小</param>
        /// <returns></returns>
        public PageData<T> GetPage(Expression<Func<T, bool>> whereLambda, string ordering, int pageIndex, int pageSize, bool isNoTracking = true, params string[] include)
        {
            // 分页 一定注意： Skip 之前一定要 OrderBy
            if (string.IsNullOrEmpty(ordering))
            {
                ordering = nameof(T) + "Id";//默认以Id排序
            }

            IQueryable<T> data = default;
            if (whereLambda != null)
            {
                foreach (var item in include)
                {
                    data = (data == null ? _dbSet : data).Include(item);
                }

                data = (data ?? _dbSet).Where(whereLambda).Take(100000).OrderByBatch(ordering).Skip(pageIndex * pageSize).Take(pageSize);
            }
            var sql = data.ToString();
            //查看生成的sql，找到大数据下分页巨慢原因为order by 耗时
            //var sql = data.Skip((pageIndex - 1) * pageSize).Take(pageSize).ToSql();
            //File.WriteAllText(@"D:\sql.txt",sql);
            PageData<T> pageData = new PageData<T>
            {
                totalElements = _dbSet.Where(whereLambda).Take(100000).Count(),
                content = data.ToList()
            };
            return pageData;
        }

        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有，多个用逗号隔开，倒序开头用-号）</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页大小</param>
        /// <returns></returns>
        public PageData<T> GetPage(Expression<Func<T, bool>> whereLambda, Expression<Func<T, dynamic>> ordering, int pageIndex, int pageSize, bool isNoTracking = true, params string[] include)
        {

            IQueryable<T> data = default;
            if (whereLambda != null)
            {
                foreach (var item in include)
                {
                    data = (data == null ? _dbSet : data).Include(item);
                }

                if (ordering != null)
                {
                    data = (data ?? _dbSet).Where(whereLambda).OrderBy(ordering).Skip(pageIndex * pageSize).Take(pageSize);
                }
                else
                {
                    data = (data ?? _dbSet).Where(whereLambda).Skip(pageIndex * pageSize).Take(pageSize);
                }
            }
            //查看生成的sql，找到大数据下分页巨慢原因为order by 耗时
            //var sql = data.Skip((pageIndex - 1) * pageSize).Take(pageSize).ToSql();
            //File.WriteAllText(@"D:\sql.txt",sql);
            PageData<T> pageData = new PageData<T>
            {
                totalElements = whereLambda == null ? _dbSet.Count() : _dbSet.Where(whereLambda).Count(),
                content = data.ToList()
            };
            return pageData;
        }


        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有，多个用逗号隔开，倒序开头用-号）</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页大小</param>
        /// <returns></returns>
        public PageData<T> GetPageInside(Expression<Func<T, bool>> whereLambda, int pageIndex, int pageSize, bool isNoTracking = true, Expression<Func<T, dynamic>> orderBy = null, Expression<Func<T, dynamic>> orderBy2 = null, params string[] include)
        {


            IQueryable<T> data = default;
            if (whereLambda != null)
            {
                foreach (var item in include)
                {
                    data = (data == null ? _dbSet : data).Include(item);
                }

                data = (data ?? _dbSet).Where(whereLambda).OrderByDescending(orderBy).OrderByDescending(orderBy2).Skip(pageIndex * pageSize).Take(pageSize);
            }
            //查看生成的sql，找到大数据下分页巨慢原因为order by 耗时
            //var sql = data.Skip((pageIndex - 1) * pageSize).Take(pageSize).ToSql();
            //File.WriteAllText(@"D:\sql.txt",sql);
            PageData<T> pageData = new PageData<T>
            {
                totalElements = _dbSet.Where(whereLambda).Count(),
                content = data.ToList()
            };
            return pageData;
        }
        /// <summary>
        /// 分页查询
        /// </summary>
        /// <param name="whereLambda">查询添加（可有，可无）</param>
        /// <param name="ordering">排序条件（一定要有，多个用逗号隔开，倒序开头用-号）</param>
        /// <param name="pageIndex">当前页码</param>
        /// <param name="pageSize">每页大小</param>
        /// <returns></returns>
        public PageGroupData<dynamic> GetGroupPage(Expression<Func<T, bool>> whereLambda, Expression<Func<T, dynamic>> grouping, string ordering, int pageIndex, int pageSize, bool isNoTracking = true, params string[] include)
        {
            // 分页 一定注意： Skip 之前一定要 OrderBy
            if (string.IsNullOrEmpty(ordering))
            {
                ordering = nameof(T) + "Id";//默认以Id排序
            }

            IQueryable<T> data = default;
            if (whereLambda != null)
            {
                foreach (var item in include)
                {
                    data = (data == null ? _dbSet : data).Include(item);
                }

                data = (data ?? _dbSet).Where(whereLambda).AsNoTracking();
            }
            var newValue = data.GroupBy(grouping).Select(p => p.Key);
            //查看生成的sql，找到大数据下分页巨慢原因为order by 耗时
            //var sql = data.Skip((pageIndex - 1) * pageSize).Take(pageSize).ToSql();
            //File.WriteAllText(@"D:\sql.txt",sql);
            PageGroupData<dynamic> pageData = new PageGroupData<dynamic>
            {
                totalElements = newValue.Count(),
                content = newValue.Skip(pageIndex * pageSize).Take(pageSize).ToList()
            };
            return pageData;
        }
        #endregion
        #endregion
    }
}
