using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using JmpCommon;
using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Hosting.WindowsServices;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using NLog.Web;

namespace JunmpPoliceStation
{
    public class Program
    {
        public static void Main(string[] args)
        {
            var process = Process.GetProcessesByName("JunmpPoliceStation");
            if (process.Length > 1)
            {
                Console.WriteLine($"[{DateTime.Now.ToString("yyyy-MM-dd HH:mm")}] - һ...");
                Console.ReadKey();
            }
            else
            {
                var logger = NLog.Web.NLogBuilder.ConfigureNLog(AppContext.BaseDirectory + "nlog.config.xml").GetCurrentClassLogger();
                try
                {
#if DEBUG
                    CreateWebHostBuilder(args).Build().Run();
#else
                    CreateWebHostBuilder(args).Build().Run();
#endif
                }
                catch (Exception ex)
                {
                    logger.Error(ex);
                }
            }

        }
        public static IWebHostBuilder CreateWebHostBuilder(string[] args)
        {
            var configuration = new ConfigurationBuilder().SetBasePath(AppContext.BaseDirectory)
                .AddJsonFile(AppContext.BaseDirectory + "appsettings.json").Build();
            return WebHost.CreateDefaultBuilder(args)
              .ConfigureAppConfiguration((hostContext, services) =>
              {
                  services.SetBasePath(AppContext.BaseDirectory);
                  services.AddJsonFile(AppContext.BaseDirectory + "appsettings.json");
              })
              .UseUrls(configuration["Launch"]).UseStartup<Startup>()
              .ConfigureLogging(logging =>
                       {
                           logging.ClearProviders();
                           logging.SetMinimumLevel(LogLevel.Information);
                       }).UseNLog();
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>
            Host.CreateDefaultBuilder(args)
                .ConfigureWebHostDefaults(webBuilder =>
                {
                    webBuilder.UseStartup<Startup>();
                });
    }
}
