﻿using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;
using JmpCommon.Tools;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class OrganizationController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<OrganizationController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        public OrganizationController(ILogger<OrganizationController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取全部组织结构
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllOrgList")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllOrgList()
        {
            return await Task.Run(() =>
            {
                try
                {

                    ListEq = _unitOfWork.OrganizationRepository.GetList(x => true, t => t.Code).ToList();

                    var returndata = ListEq.Select(c => new
                    {
                        c.Id,
                        c.Name,
                        c.Code,
                        c.NameJc,
                        c.DName,
                        c.FindCode,
                        c.AreaName,
                        c.ParentId,
                        c.State,
                        c.CreateTime,
                        hasChildren = true
                    }).OrderByDescending(f => f.FindCode.Length).ThenBy(c => c.FindCode);

                    return JsonManager.ReturnSuccessResponse(returndata, true);
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 通过code返回组织机构
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "code":"code"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrgByCode")]
        [NoSign]
        public async Task<HttpResponseMessage> GetOrgByCode([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (string.IsNullOrEmpty(entity.code))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string code = entity.code;

                        var res = _unitOfWork.OrganizationRepository.Get(t => t.Code == code);

                        var returndata = new
                        {
                            res.Id,
                            res.Name,
                            res.Code,
                            res.NameJc,
                            res.DName,
                            res.FindCode,
                            res.AreaName,
                            res.ParentId,
                            res.State,
                            res.CreateTime,
                            hasChildren = true
                        };

                        return JsonManager.ReturnSuccessResponse(returndata);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 通过id返回组织机构
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrgById")]
        [NoSign]
        public async Task<HttpResponseMessage> GetOrgById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (string.IsNullOrEmpty(entity.id))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string id = entity.id;

                        var res = _unitOfWork.OrganizationRepository.Get(t => t.Id == id);

                        var returndata = new
                        {
                            res.Id,
                            res.Name,
                            res.Code,
                            res.NameJc,
                            res.DName,
                            res.FindCode,
                            res.AreaName,
                            res.ParentId,
                            res.State,
                            res.CreateTime,
                            hasChildren = true
                        };

                        return JsonManager.ReturnSuccessResponse(returndata, true);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 组织结构停启用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///         "state":0停用,1启用
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("SetOrgState")]
        public async Task<HttpResponseMessage> SetOrgState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;
                        string state = entity.state;

                        var OrgInfo = _unitOfWork.OrganizationRepository.Get(p => p.Id.Equals(id));
                        if (OrgInfo != null)
                        {
                            OrgInfo.State = short.Parse(state);
                            bool result = _unitOfWork.OrganizationRepository.Update(OrgInfo, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 组织结构地图显示停启用
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///         "state":0停用,1启用
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("SetOrgMapState")]
        public async Task<HttpResponseMessage> SetOrgMapState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;
                        string state = entity.state;

                        var OrgInfo = _unitOfWork.OrganizationRepository.Get(p => p.Id.Equals(id));
                        if (OrgInfo != null)
                        {
                            OrgInfo.IsMap = short.Parse(state);
                            bool result = _unitOfWork.OrganizationRepository.Update(OrgInfo, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取组织结构列表带状态
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListOrgState")]
        public async Task<HttpResponseMessage> GetListOrgState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.id))
                        {
                            id = entity.id;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.ParentId.Equals(id);

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        var returndata = ListEq.Select(c => new
                        {
                            c.Id,
                            c.Name,
                            c.Code,
                            c.NameJc,
                            c.DName,
                            c.FindCode,
                            c.AreaName,
                            c.ParentId,
                            c.State,
                            hasChildren = true
                        }).OrderByDescending(f => f.FindCode.Length).ThenBy(c => c.FindCode);

                        return JsonManager.ReturnSuccessResponse(returndata, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        ///
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "page":
        ///         "size":
        ///         "name":
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrgState")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> GetOrgState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string name = entity.name;
                        if (size == 0)
                        {
                            size = 10;
                        }
                        var param = new string[] {

                    };

                        PageData<BaseJpOrganization> equipmentStates = _unitOfWork.OrganizationRepository.GetPage(p => p.Code.Substring(6, 2) != "00" && p.State == 1 && p.Name.Contains(name), "-AreaName", page, size, false, param);
                        var resultContent = equipmentStates.content.Select(p => new
                        {
                            p.Id,
                            p.Name,
                            p.Code,
                            p.CreateTime,
                            p.UpdateTime,
                            p.FindCode,
                            p.AreaName,
                            p.State,
                            p.ParentId,
                            p.NameJc,
                            p.DName,
                            p.Show

                        }).ToList();
                        var content = new
                        {
                            equipmentStates.totalElements,
                            content = resultContent
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取组织结构列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListOrg")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GetListOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.id?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();
                        List<BaseJpOrganization> dataList = null;
                        List<Node> reDataList = null;
                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.id))
                        {
                            id = entity.id;
                        }

                        dataList = GetClassID(id);
                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(id))).ToList();

                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.Code,
                            c.ParentId,
                            c.Name,
                            c.FindCode,
                            c.NameJc,
                            c.DName
                        }
                       ).OrderByDescending(c => c.FindCode.Length).ThenBy(c => c.FindCode).ToList();

                        List<Node> nodes = new List<Node>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            Node node = new Node();
                            node.code = data[i].Code;
                            node.id = data[i].Id;
                            node.Name = data[i].Name;
                            node.ParentId = data[i].ParentId;
                            node.FindCode = data[i].FindCode;
                            node.NameJc = data[i].NameJc;
                            node.Level = 1;
                            node.DName = data[i].DName == null ? "" : data[i].DName;
                            nodes.Add(node);
                        }

                        reDataList = CreateTreeNodes(nodes, id);

                        return JsonManager.ReturnSuccessResponse(reDataList, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取组织结构列表(包括未启用）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllListOrg")]
        public async Task<HttpResponseMessage> GetAllListOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpOrganization, bool>> expression = t => true;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();
                        List<BaseJpOrganization> dataList = null;
                        List<Node> reDataList = null;
                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.id))
                        {
                            id = entity.id;
                        }

                        dataList = GetClassID(id);
                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(id))).ToList();

                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.Code,
                            c.ParentId,
                            c.Name,
                            c.FindCode,
                            c.NameJc,
                            c.DName,
                            c.State
                        }
                       ).OrderByDescending(c => c.FindCode.Length).ThenBy(c => c.FindCode).ToList();

                        List<Node> nodes = new List<Node>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            Node node = new Node();
                            node.code = data[i].Code;
                            node.id = data[i].Id;
                            node.Name = data[i].Name;
                            node.ParentId = data[i].ParentId;
                            node.FindCode = data[i].FindCode;
                            node.NameJc = data[i].NameJc;
                            node.Level = 1;
                            node.DName = data[i].DName == null ? "" : data[i].DName;
                            node.State = data[i].State;
                            nodes.Add(node);
                        }

                        reDataList = CreateTreeNodes(nodes, id);

                        return JsonManager.ReturnSuccessResponse(reDataList, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }


        /// <summary>
        /// 获取上层组织结构列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListUpOrg")]
        public async Task<HttpResponseMessage> GetListUpOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();
                        List<BaseJpOrganization> dataList = null;
                        List<Node> reDataList = null;
                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.id))
                        {
                            id = entity.id;
                            id = ListEq.Where(c => c.Id.Equals(id)).FirstOrDefault().ParentId;
                        }

                        dataList = GetClassID(id);
                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(id))).ToList();

                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.ParentId,
                            c.Name,
                            c.FindCode,
                            c.NameJc,
                            c.DName
                        }
                       ).OrderBy(c => c.FindCode).ToList();

                        List<Node> nodes = new List<Node>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            Node node = new Node();
                            node.id = data[i].Id;
                            node.Name = data[i].Name;
                            node.ParentId = data[i].ParentId;
                            node.FindCode = data[i].FindCode;
                            node.NameJc = data[i].NameJc;
                            node.Level = 1;
                            node.DName = data[i].DName;
                            nodes.Add(node);
                        }

                        reDataList = CreateTreeNodes(nodes, id);

                        return JsonManager.ReturnSuccessResponse(reDataList, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        // 生成树
        private List<Node> CreateTreeNodes(List<Node> nodes, string id)
        {
            List<Node> root = nodes.FindAll(node => node.id.Equals(id));
            return SortNodes(nodes, root);
        }

        // 递归分组
        private List<Node> SortNodes(List<Node> nodes, List<Node> root)
        {

            for (int i = 0; i < root.Count; i++)
            {
                List<Node> children = nodes.FindAll(node => node.ParentId == root[i].id);
                for (var j = 0; j < children.Count; j++)
                {
                    children[j].Level = root[i].Level + 1;
                }
                SortNodes(nodes, children);
                if (children.Count == 0)
                {
                    root[i].Children = null;
                }
                else
                {
                    root[i].Children = children;
                }
            }
            return root;
        }

        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }




        /// <summary>
        /// 添加或修改组织机构信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "dName":"简称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpdateOrg")]
        public async Task<HttpResponseMessage> UpdateOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            Expression<Func<BaseJpOrganization, bool>> expression = t => t.Id.Equals(id);
                            BaseJpOrganization updateObject = _unitOfWork.OrganizationRepository.Get(expression);
                            if (updateObject != null)
                            {
                                updateObject.DName = entity.dName;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.OrganizationRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 修改组织机构经纬度信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "longitude":"经度"
        ///        "latitude":"纬度"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpdateOrgJWD")]
        public async Task<HttpResponseMessage> UpdateOrgJWD([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string longitude = entity?.longitude ?? "";
                        string latitude = entity?.latitude ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        if (string.IsNullOrEmpty(entity.longitude ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"longitude is require");
                        }
                        if (string.IsNullOrEmpty(entity.latitude ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"latitude is require");
                        }


                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.Id.Equals(id);
                        BaseJpOrganization updateObject = _unitOfWork.OrganizationRepository.Get(expression);
                        if (updateObject != null)
                        {
                            updateObject.Longitude = longitude;
                            updateObject.Latitude = latitude;
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        bool result = _unitOfWork.OrganizationRepository.Update(updateObject);

                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过代码（6位）获取组织机构经纬度信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "code" : "代码"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrgJWDByCode")]
        [NoSign]
        public async Task<HttpResponseMessage> GetOrgJWDByCode([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string code = entity?.code ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        if (string.IsNullOrEmpty(entity.code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t =>
                            t.Code.Substring(0, 6) == code
                            && t.Code.Substring(8, 4) == "0000"
                            && !string.IsNullOrEmpty(t.Longitude)
                            && !string.IsNullOrEmpty(t.Latitude)
                            && t.State == 1;

                        var res = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code)
                        .Select(x => new
                        {
                            Name = string.IsNullOrEmpty(x.DName) ? x.Name : x.DName,
                            x.Code,
                            x.Longitude,
                            x.Latitude,
                        }).ToList();
                        return JsonManager.ReturnSuccessResponse(res);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过orgId返回当前组织机构生成单据序号（并累加1）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"id",
        ///         "orderCode":"单号",
        ///         "orderType":"单据类型 采购 调拨"
        /// 
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrderCountByOrgId")]
        public async Task<HttpResponseMessage> GetOrderCountByOrgId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (string.IsNullOrEmpty(entity.orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        if (string.IsNullOrEmpty(entity.orderCode))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        if (string.IsNullOrEmpty(entity.orderType))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string orgId = entity.orgId;
                        string orderCode = entity.orderCode;
                        string orderType = entity.orderType;

                        var org = _unitOfWork.OrganizationRepository.Get(t => t.Id == orgId);
                        if (org == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                        var printOrderCode = "";
                        var printOrderTime = "";
                        switch (orderType)
                        {
                            case "采购":
                                {
                                    var order = _unitOfWork.PurchaseOrderyRepository.Get(x => x.OrderCode == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        //创建新单号
                                        if (org.OrderCount == null || org.OrderCount == 0)
                                        {
                                            org.OrderCount = 1;
                                        }
                                        else
                                        {
                                            org.OrderCount++;
                                        }

                                        order.PrintOrderCode = "类-" + DateTime.Now.Year + "-" +
                                                               org.OrderCount.Value.ToString("D5");
                                        order.PrintOrderTime = DateTime.Now;
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");

                                        _unitOfWork.OrganizationRepository.Update(org, false);
                                        _unitOfWork.PurchaseOrderyRepository.Update(order, false);
                                    }
                                    else
                                    {
                                        //获取旧数据
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");
                                    }

                                    break;
                                }
                            case "借用":
                                {
                                    var order = _unitOfWork.BorrowReturnApplyRepository.Get(x => x.OrderCode == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        //创建新单号
                                        if (org.OrderCount == null || org.OrderCount == 0)
                                        {
                                            org.OrderCount = 1;
                                        }
                                        else
                                        {
                                            org.OrderCount++;
                                        }

                                        order.PrintOrderCode = "类-" + DateTime.Now.Year + "-" +
                                                               org.OrderCount.Value.ToString("D5");
                                        order.PrintOrderTime = DateTime.Now;
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");

                                        _unitOfWork.OrganizationRepository.Update(org, false);
                                        _unitOfWork.BorrowReturnApplyRepository.Update(order, false);
                                    }
                                    else
                                    {
                                        //获取旧数据
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");
                                    }

                                    break;
                                }
                            case "调拨":
                                {
                                    var order = _unitOfWork.TransferApplyRepository.Get(x => x.Order == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        //创建新单号
                                        if (org.OrderCount == null || org.OrderCount == 0)
                                        {
                                            org.OrderCount = 1;
                                        }
                                        else
                                        {
                                            org.OrderCount++;
                                        }

                                        order.PrintOrderCode = "类-" + DateTime.Now.Year + "-" +
                                                               org.OrderCount.Value.ToString("D5");
                                        order.PrintOrderTime = DateTime.Now;
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");

                                        _unitOfWork.OrganizationRepository.Update(org, false);
                                        _unitOfWork.TransferApplyRepository.Update(order, false);
                                    }
                                    else
                                    {
                                        //获取旧数据
                                        printOrderCode = order.PrintOrderCode;
                                        printOrderTime = order.PrintOrderTime.Value.ToString("yyyy年MM月dd日");
                                    }

                                    break;
                                }
                            default:
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                        }

                        _unitOfWork.SaveChanges();

                        return JsonManager.ReturnSuccessResponse(new
                        {
                            no = org.OrderCount,
                            printOrderCode,
                            printOrderTime
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过orgId返回当前组织机构生成单据序号（返回加一后的数据）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"id",
        ///         "orderCode":"单号",
        ///         "orderType":"单据类型 借:借用 领:领用 支:调拨 价:调拨 废:报废 销：销毁 入：采购"
        /// 
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetOrderCountByOrgIdV2")]
        public async Task<HttpResponseMessage> GetOrderCountByOrgIdV2([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (string.IsNullOrEmpty(entity.orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        if (string.IsNullOrEmpty(entity.orderCode))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        if (string.IsNullOrEmpty(entity.orderType))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string orgId = entity.orgId;
                        string orderCode = entity.orderCode;
                        string orderType = entity.orderType;

                        var org = _unitOfWork.OrganizationRepository.Get(t => t.Id == orgId);
                        if (org == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        dynamic order;

                        switch (orderType)
                        {
                            case "借":
                            case "领":
                            case "销":
                                {
                                    order = _unitOfWork.BorrowReturnApplyRepository.Get(x => x.OrderCode == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        CreateNewOrderCount(ref order, org, orderType, out string printOrderCode);
                                        order.PrintOrderCode = printOrderCode;
                                        order.PrintOrderTime = DateTime.Now;
                                        _unitOfWork.BorrowReturnApplyRepository.Update(order);
                                    }
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        printOrderCode = order.PrintOrderCode,
                                        printOrderTime = order.PrintOrderTime?.ToString("yyyy年MM月dd日"),
                                    });
                                }
                            case "支":
                                {
                                    order = _unitOfWork.TransferApplyRepository.Get(x => x.Order == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        CreateNewOrderCount(ref order, org, orderType, out string printOrderCode);
                                        order.PrintOrderCode = printOrderCode;
                                        order.PrintOrderTime = DateTime.Now;
                                        _unitOfWork.TransferApplyRepository.Update(order);
                                    }
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        printOrderCode = order.PrintOrderCode,
                                        printOrderTime = order.PrintOrderTime?.ToString("yyyy年MM月dd日"),
                                    });
                                }
                            case "价":
                                {
                                    order = _unitOfWork.TransferApplyRepository.Get(x => x.Order == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode2))
                                    {
                                        CreateNewOrderCount(ref order, org, orderType, out string printOrderCode);
                                        order.PrintOrderCode2 = printOrderCode;
                                        order.PrintOrderTime2 = DateTime.Now;
                                        _unitOfWork.TransferApplyRepository.Update(order);
                                    }
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        printOrderCode = order.PrintOrderCode2,
                                        printOrderTime = order.PrintOrderTime2?.ToString("yyyy年MM月dd日"),
                                    });
                                }
                            case "废":
                                {
                                    order = _unitOfWork.FixReceiveApplyRepository.Get(x => x.OrderCode == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        CreateNewOrderCount(ref order, org, orderType, out string printOrderCode);
                                        order.PrintOrderCode = printOrderCode;
                                        order.PrintOrderTime = DateTime.Now;
                                        _unitOfWork.FixReceiveApplyRepository.Update(order);
                                    }
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        printOrderCode = order.PrintOrderCode,
                                        printOrderTime = order.PrintOrderTime?.ToString("yyyy年MM月dd日"),
                                    });
                                }
                            case "入":
                                {
                                    order = _unitOfWork.PurchaseOrderyRepository.Get(x => x.OrderCode == orderCode);
                                    if (order == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (string.IsNullOrEmpty(order.PrintOrderCode))
                                    {
                                        CreateNewOrderCount(ref order, org, orderType, out string printOrderCode);
                                        order.PrintOrderCode = printOrderCode;
                                        order.PrintOrderTime = DateTime.Now;
                                        _unitOfWork.PurchaseOrderyRepository.Update(order);
                                    }
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        printOrderCode = order.PrintOrderCode,
                                        printOrderTime = order.PrintOrderTime?.ToString("yyyy年MM月dd日"),
                                    });
                                }
                            default:
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        #region private

        private void CreateNewOrderCount(ref dynamic order, BaseJpOrganization org, string orderType, out string printOrderCode)
        {
            //创建新单号
            var orderCountData = _unitOfWork.DbContext
                .BaseJpOrganizationOrderCounts
                .FirstOrDefault(x => x.OrgId == org.Id && x.OrderType == orderType && x.OrderYear == DateTime.Now.Year);

            if (orderCountData == null)
            {
                orderCountData = new BaseJpOrganizationOrderCount()
                {
                    Id = Guid.NewGuid().ToString(),
                    CreateTime = DateTime.Now,
                    OrderType = orderType,
                    OrderCount = 1,
                    OrderYear = DateTime.Now.Year,
                    OrgId = org.Id,
                };
                _unitOfWork.DbContext.BaseJpOrganizationOrderCounts.Add(orderCountData);
            }
            else
            {
                orderCountData.OrderCount++;
                _unitOfWork.DbContext.BaseJpOrganizationOrderCounts.Update(orderCountData);
            }
            printOrderCode = orderType + "-" + DateTime.Now.Year + "-" + orderCountData.OrderCount?.ToString("D5");

        }

        #endregion
    }


}
