﻿using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class EquipmentInfoController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<EquipmentInfoController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpEquipmentInfo> ListEq = new List<BaseJpEquipmentInfo>();

        public EquipmentInfoController(ILogger<EquipmentInfoController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取装备类型列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListEquipment")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GetListEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => !t.Id.Equals(Guid.Empty.ToString());

                        ListEq = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.Code).OrderBy(p => p.Code).ToList();
                        List<BaseJpEquipmentInfo> dataList = null;
                        List<Node> reDataList = null;
                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity?.id ?? ""))
                        {
                            id = entity.id;
                        }

                        dataList = GetClassID(id);
                        var data = dataList.Select(c => new
                        {
                            id = c.Id,
                            c.Name,
                            c.ParentId,
                            c.Code
                        }
                       ).ToList();

                        List<Node> nodes = new List<Node>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            Node node = new Node();
                            node.id = data[i].id;
                            node.Name = data[i].Name;
                            node.ParentId = data[i].ParentId;
                            node.Level = 1;
                            node.FindCode = data[i].Code;
                            nodes.Add(node);
                        }

                        reDataList = CreateTreeNodes(nodes, id);

                        return JsonManager.ReturnSuccessResponse(reDataList, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        // 生成树
        private List<Node> CreateTreeNodes(List<Node> nodes, string id)
        {
            List<Node> root = nodes.FindAll(node => node.ParentId == id);
            return SortNodes(nodes, root);
        }

        // 递归分组
        private List<Node> SortNodes(List<Node> nodes, List<Node> root)
        {

            for (int i = 0; i < root.Count; i++)
            {
                List<Node> children = nodes.FindAll(node => node.ParentId == root[i].id);
                for (var j = 0; j < children.Count; j++)
                {
                    children[j].Level = root[i].Level + 1;
                }
                SortNodes(nodes, children);
                if (children.Count == 0)
                {
                    root[i].Children = null;
                }
                else
                {
                    root[i].Children = children;
                }
            }
            return root;
        }

        //递归取数据
        private List<BaseJpEquipmentInfo> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }


        /// <summary>
        /// 添加或修改装备类型信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "name":"姓名",
        ///        "parentId" : "父ID",
        ///        "code" : "编码",
        ///        "updateUser":"操作用户ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateEquipmentInfo")]
        public async Task<HttpResponseMessage> AddOrUpdateEquipmentInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => t.Id.Equals(id);
                            BaseJpEquipmentInfo updateObject = _unitOfWork.EquipmentInfoRepository.Get(expression);
                            if (updateObject != null)
                            {
                                if (string.IsNullOrEmpty(entity.parentId ?? ""))
                                {
                                    entity.parentId = Guid.Empty.ToString();
                                }
                                updateObject.Name = entity.name;
                                updateObject.ParentId = entity.parentId;
                                updateObject.Code = entity.code;
                                updateObject.UpdateTime = System.DateTime.Now;
                                updateObject.UpdateUser = entity.updateUser;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.EquipmentInfoRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            if (string.IsNullOrEmpty(entity.parentId ?? ""))
                            {
                                entity.parentId = Guid.Empty.ToString();
                            }
                            //新增数据
                            BaseJpEquipmentInfo addObject = new BaseJpEquipmentInfo()
                            {
                                Id = Guid.NewGuid().ToString(),
                                Sort = null,
                                Name = entity.name,
                                ParentId = entity.parentId,
                                Code = entity.code,
                                CreateTime = System.DateTime.Now,
                                UpdateTime = System.DateTime.Now,
                                UpdateUser = entity.updateUser
                            };

                            bool result = _unitOfWork.EquipmentInfoRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 删除装备类型信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteEquipmentInfo")]
        public async Task<HttpResponseMessage> DeleteEquipmentInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => t.Id.Equals(id);
                            BaseJpEquipmentInfo deleteObject = _unitOfWork.EquipmentInfoRepository.Get(expression);
                            if (deleteObject != null)
                            {
                                bool result = _unitOfWork.EquipmentInfoRepository.Delete(deleteObject);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取全部装备基础信息（info detail size 同步专用）
        /// </summary>
        /// <returns></returns>
        [HttpPost("SyncEquipmentData")]
        [NoSign]
        public async Task<HttpResponseMessage> SyncEquipmentData()
        {
            return await Task.Run(() =>
            {
                try
                {
                    var res = new
                    {
                        info = _unitOfWork.DbContext.BaseJpEquipmentInfos.Select(x => new
                        {
                            x.Id,
                            x.Sort,
                            x.Name,
                            x.ParentId,
                            x.Code,
                            x.CreateTime,
                            x.UpdateTime,
                            x.UpdateUser,

                        }).ToList(),
                        detail = _unitOfWork.DbContext.BaseJpEquipmentDetails.Select(x => new
                        {
                            x.Id,
                            x.Sort,
                            x.EquipmentId,
                            x.Name,
                            x.Type,
                            x.Unit,
                            x.Note,
                            x.State,
                            x.CreateTime,
                            x.UpdateTime,
                            x.UpdateUser,
                            x.Code,
                            x.UnitType,
                        }).ToList(),
                        size = _unitOfWork.DbContext.BaseJpEquipmentSizes.Select(x => new
                        {
                            x.Id,
                            x.SizeCode,
                            x.SizeName,
                            x.CreateTime,
                            x.UpdateUser,
                            x.DetailId,
                            x.Note,
                            x.UpdateTime,
                            x.EpcType,
                        }).ToList(),
                        supplier = _unitOfWork.DbContext.BaseJpSuppliers.Select(x => new
                        {
                            x.Id,
                            x.Sort,
                            x.Name,
                            x.SupplierCode,
                            x.ShortName,
                            x.CreateTime,
                            x.UpdateTime,
                            x.UpdateUser,
                            x.Contacts,
                            x.Phone,
                        }).ToList(),
                        supplierEquipment = _unitOfWork.DbContext.BaseJpSupplierEquipments.Select(x => new
                        {
                            x.Id,
                            x.Sort,
                            x.SupplierCode,
                            x.EquipmentId,
                            x.State,
                            x.UselessUint,
                            x.UselessTime,
                            x.CreateTime,
                            x.UpdateTime,
                            x.UpdateUser,
                            x.Num,
                        }).ToList(),
                    };
                    return JsonManager.ReturnSuccessResponse(res);
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }


    public class Node
    {
        public string code { get; set; }
        /// <summary>
        /// 编号
        /// </summary>
        public string id { get; set; }

        /// <summary>
        /// 上一级编号
        /// </summary>
        public string ParentId { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }


        /// <summary>
        /// 层次
        /// </summary>
        public int Level { get; set; }

        /// <summary>
        /// 简称
        /// </summary>
        public String NameJc { get; set; }

        /// <summary>
        /// 简称
        /// </summary>
        public String DName { get; set; }


        public String FindCode { get; set; }
        public short? State { get; set; }

        /// <summary>
        /// 子节点
        /// </summary>
        public List<Node> Children;
    }
}
