﻿using JmpDehumidifierLib;
using LitJson;
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Linq;
using System.Management;
using System.Net;
using System.ServiceProcess;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace JmpDevService
{
    public partial class DevService : ServiceBase
    {
        public DevService()
        {
            InitializeComponent();
        }

        Dictionary<string, Dehumidifier> devList = new Dictionary<string, Dehumidifier>();
        private string URL = "";
        private string devCode = "";

        private Thread ThreadSend = null;

        protected override void OnStart(string[] args)
        {
            //服务开启执行代码
            //服务开启执行代码

            try
            {
                //获取接口地址
                URL = Properties.Settings.Default.URL;
                devCode = GetMacAddress().ToUpper();

                #region 开启一个线程
                ThreadSend = new Thread(new ThreadStart(ContorlDev));
                ThreadSend.IsBackground = true;
                ThreadSend.Start();
                #endregion


                if (!"unknow".Equals(devCode))
                {
                    //先根据用户请求的uri构造请求地址
                    string serviceUrl = string.Format("{0}/{1}", URL, "api/WarehouseDev/GetListDev");
                    string data = "{'devCode':'" + devCode + "'}";
                    string retrundata = GetHttpRqst(serviceUrl, data);

                    JsonData json = JsonMapper.ToObject(retrundata);
                    if (getKey(json, "code").Equals("10000"))
                    {
                        if (JsonDataContainsKey(json, "data"))
                        {
                            JsonData dataList = json["data"];
                            for (var i = 0; i < dataList.Count; i++)
                            {
                                var devIp = getKey(dataList[i], "devIp");
                                var devPort = getKey(dataList[i], "devPort");
                                //ipList.Add(devIp + ":" + devPort);
                                Dehumidifier dev = new Dehumidifier(devIp, int.Parse(devPort));

                                devList.Add(devIp, dev);
                            }
                        }
                        else
                        {
                            //数据格式有误
                        }

                        foreach (var item in devList)
                        {
                            if (item.Value.Open())
                            {
                                item.Value.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                            }
                        }
                    }
                    else
                    {
                        //调用接口失败
                    }

                }
                else
                {
                    //mac地址获取失败
                }
            }
            catch (Exception ex)
            {
                //异常处理
            }

        }


        //public void OnStart()
        //{
        //    try
        //    {
        //        //获取接口地址
        //        URL = Properties.Settings.Default.URL;
        //        devCode = GetMacAddress().ToUpper();

        //        #region 开启一个线程
        //        ThreadSend = new Thread(new ThreadStart(ContorlDev));
        //        ThreadSend.IsBackground = true;
        //        ThreadSend.Start();
        //        #endregion


        //        if (!"unknow".Equals(devCode))
        //        {
        //            //先根据用户请求的uri构造请求地址
        //            string serviceUrl = string.Format("{0}/{1}", URL, "api/WarehouseDev/GetListDev");
        //            string data = "{'devCode':'" + devCode + "'}";
        //            string retrundata = GetHttpRqst(serviceUrl, data);

        //            JsonData json = JsonMapper.ToObject(retrundata);
        //            if (getKey(json, "code").Equals("10000"))
        //            {
        //                if (JsonDataContainsKey(json, "data"))
        //                {
        //                    JsonData dataList = json["data"];
        //                    for (var i = 0; i < dataList.Count; i++)
        //                    {
        //                        var devIp = getKey(dataList[i], "devIp");
        //                        var devPort = getKey(dataList[i], "devPort");
        //                        //ipList.Add(devIp + ":" + devPort);
        //                        Dehumidifier dev = new Dehumidifier(devIp, int.Parse(devPort));

        //                        devList.Add(devIp, dev);
        //                    }
        //                }
        //                else
        //                {
        //                    //数据格式有误
        //                }

        //                foreach (var item in devList)
        //                {
        //                    if (item.Value.Open())
        //                    {
        //                        item.Value.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
        //                    }
        //                    else
        //                    {
        //                        Console.Write("打开设备失败！");
        //                    }
        //                }
        //            }
        //            else
        //            {
        //                //调用接口失败
        //            }

        //        }
        //        else
        //        {
        //            //mac地址获取失败
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        //异常处理
        //    }
        //}

        //控制设备
        private void ContorlDev()
        {
            while (true)
            {
                try
                {
                    string serviceUrl = string.Format("{0}/{1}", URL, "api/WarehouseDev/GetDevControlInfo");
                    string data = "{'devCode':'" + devCode + "'}";
                    string retrundata = GetHttpRqst(serviceUrl, data);

                    JsonData json = JsonMapper.ToObject(retrundata);
                    if (getKey(json, "code").Equals("10000"))
                    {
                        if (JsonDataContainsKey(json, "msg"))
                        {
                            JsonData devInfo = JsonMapper.ToObject(json["msg"].ToString());

                            var devIp = getKey(devInfo, "DevIp");
                            var Humid = getKey(devInfo, "Humid");
                            var OpenState = getKey(devInfo, "OpenState");

                            foreach (var item in devList)
                            {
                                if (item.Key.Equals(devIp))
                                {
                                    if (!string.IsNullOrEmpty(Humid))
                                    {
                                        item.Value.SetHumid((byte)int.Parse(Humid));
                                    }

                                    if (!string.IsNullOrEmpty(OpenState) && OpenState.Equals("1"))
                                    {
                                        item.Value.OpenMachine(true);
                                    }

                                    if (!string.IsNullOrEmpty(OpenState) && OpenState.Equals("0"))
                                    {
                                        item.Value.OpenMachine(false);
                                    }
                                }
                            }
                        }
                    }
                }
                catch
                {

                }
                Thread.Sleep(5000);
            }
        }
        

        private void OnStatusChanged(MachineStatus args)
        {
            if (args.ErrorCode == 0)
            {
                var devIp = args.ip;
                var warehouseWd = args.Temp.ToString();  // 室内温度
                var warehouseSd = args.Humid.ToString(); // 室内湿度
                var devState = args.IsWorking ? 1 : 0;

                string serviceUrl = string.Format("{0}/{1}", URL, "api/WarehouseDev/UpDev");
                string data = "{'devCode':'" + devCode + "','devIp':'" + devIp + "','warehouseWd':'" + warehouseWd + "','warehouseSd':'" + warehouseSd + "','devState':'" + devState + "'}";
                string retrundata = GetHttpRqst(serviceUrl, data);
            }
            else
            {
                foreach (var item in devList)
                {   
                    if (item.Key.Equals(args.ip))
                    {
                        Dehumidifier dev = new Dehumidifier(args.ip, args.port);
                        devList.Remove(item.Key);
                        devList.Add(args.ip, dev);
                        if (dev.Open())
                        {
                            dev.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
                        }
                    }
                }
            }

        }

        protected override void OnStop()
        {
            //服务结束执行代码
        }

        protected override void OnShutdown()
        {
            //系统即将关闭执行代码
        }

        public static string GetMacAddress()
        {
            try
            {
                string mac = "";
                ManagementClass mc = new ManagementClass("Win32_NetworkAdapterConfiguration");
                ManagementObjectCollection moc = mc.GetInstances();
                foreach (ManagementObject mo in moc)
                {
                    if ((bool)mo["IPEnabled"] == true)
                    {
                        mac = mo["MacAddress"].ToString();
                        break;
                    }
                }
                return mac;
            }
            catch
            {
                return "unknow";
            }
        }


        public static string GetHttpRqst(string strUrl, string json = "")
        {
            try
            {

                HttpWebRequest request = (HttpWebRequest)WebRequest.Create(strUrl);
                request.Method = "POST";

                if (!string.IsNullOrEmpty(json))
                {
                    request.ContentType = "application/json";
                    byte[] data = Encoding.UTF8.GetBytes(json);
                    request.ContentLength = data.Length;
                    using (Stream reqStream = request.GetRequestStream())
                    {
                        reqStream.Write(data, 0, data.Length);
                        reqStream.Close();
                    }
                }

                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                Stream responseStream = response.GetResponseStream();
                StreamReader streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string retString = streamReader.ReadToEnd();
                streamReader.Close();
                responseStream.Close();
                response.Close();
                return retString;

            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }

        public static string getKey(JsonData data, string key)
        {
            if (JsonDataContainsKey(data, key))
            {
                if (data[key] == null)
                {
                    return "";
                }
                else
                {
                    return data[key].ToString();
                }
            }
            else
            {
                return "";
            }
        }

        public static bool JsonDataContainsKey(JsonData data, string key)
        {
            bool result = false;
            if (data == null)
                return result;
            if (!data.IsObject)
            {
                return result;
            }
            IDictionary tdictionary = data as IDictionary;
            if (tdictionary == null)
                return result;
            if (tdictionary.Contains(key))
            {
                result = true;
            }
            return result;
        }
    }
}
