﻿using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Security.Cryptography;
using System.Text;
using System.Threading.Tasks;
using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using JunmpPoliceStation.Controllers;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Org.BouncyCastle.Asn1.Ocsp;
using NLog.Fluent;
using Z.EntityFramework.Plus;

namespace JunmpPoliceStation.Extensions
{
    public class CronJob
    {
        JunmppolicesqlContext _dbContext;
        private IConfiguration Configuration;
        private ILogger<CronJob> _logger;
        public CronJob(JunmppolicesqlContext dbContext, IConfiguration configuration, ILogger<CronJob> logger)
        {
            _dbContext = dbContext;
            Configuration = configuration;
            _logger = logger;
        }

        public Tuple<string, string> UpdateMessageReminderData()
        {
            try
            {
                var configList = _dbContext.BaseJpMessageReminderConfigs
                    .Include(x => x.Org)
                    .ToList();

                foreach (var config in configList)
                {
                    if (string.IsNullOrEmpty(config.EquipmentJson) || config.Enable == false)
                    {
                        //清除老的记录（如果有）
                        var oldLogs = _dbContext.BaseJpMessageReminderLogs
                            .Include(x => x.BaseJpMessageReminderLogDetails)
                            .Where(x => x.OrgId == config.OrgId)
                            .ToList();
                        foreach (var log in oldLogs)
                        {
                            log.BaseJpMessageReminderLogDetails.Clear();
                            log.EquCount = 0;
                        }
                        _dbContext.BaseJpMessageReminderLogs.UpdateRange(oldLogs);
                        _dbContext.SaveChanges();
                        continue;
                    }
                    var equConfig = JsonConvert.DeserializeObject<List<MessageReminderConfigEquipment>>(config.EquipmentJson) ?? new List<MessageReminderConfigEquipment>();

                    //已超期未报废
                    var chaoqiLog = _dbContext.BaseJpMessageReminderLogs
                        .Include(x => x.BaseJpMessageReminderLogDetails)
                        .FirstOrDefault(x => x.OrgId == config.OrgId && x.Type == 0);
                    if (chaoqiLog == null)
                    {
                        chaoqiLog = new BaseJpMessageReminderLog
                        {
                            Id = Guid.NewGuid().ToString(),
                            CreateTime = DateTime.Now,
                            Type = 0,
                            OrgId = config.OrgId,
                            OrgName = config.Org.Name,
                            IsNeedPushParent = config.IsPushParentWithFixed,
                            ParentOrgId = config.IsPushParentWithFixed ? config.Org.ParentId : null,
                            ConfigId = config.Id,
                            EquCount = 0,
                        };
                        _dbContext.BaseJpMessageReminderLogs.Add(chaoqiLog);
                        _dbContext.SaveChanges();
                    }
                    var chaoqiEqu = _dbContext.CommonJpEquipmentInventories
                        .Include(x => x.EquipmentCodeNavigation)
                        .Include(x => x.EquipmentSizecodeNavigation)
                        .Include(x => x.WarehouseCodeNavigation)
                        .Where(x => x.OrgId == config.OrgId && x.SafeLevel == 2 && x.CurrentState != 6 &&
                                    x.InventoryState != "loss")
                        .ToList();
                    chaoqiEqu = chaoqiEqu
                        .Where(x => equConfig.Where(y => y.IsNeedRemind)
                            .Select(y => y.EquipmentDetailId)
                            .Contains(x.EquipmentCode))
                        .ToList();

                    chaoqiLog.BaseJpMessageReminderLogDetails.Clear();
                    if (chaoqiEqu.Count > 0)
                    {
                        foreach (var item in chaoqiEqu)
                        {
                            chaoqiLog.BaseJpMessageReminderLogDetails.Add(new BaseJpMessageReminderLogDetail()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                LogId = config.Id,
                                InventoryId = item.Id,
                                Epc = item.Epc,
                                EquipmentDetailId = item.EquipmentCode,
                                EquipmentDetailName = item.EquipmentCodeNavigation.Name,
                                EquipmentSizeId = item.EquipmentSizecode,
                                EquipmentSizeName = item.EquipmentSizecodeNavigation.SizeName,
                                WarehouseId = item.WarehouseCode,
                                WarehouseName = item.WarehouseCodeNavigation.Name,

                            });
                        }
                        chaoqiLog.EquCount = chaoqiLog.BaseJpMessageReminderLogDetails.Count;
                    }
                    else
                    {
                        chaoqiLog.EquCount = 0;
                    }
                    _dbContext.BaseJpMessageReminderLogs.Update(chaoqiLog);

                    //超期未还
                    var borrowLog = _dbContext.BaseJpMessageReminderLogs
                        .Include(x => x.BaseJpMessageReminderLogDetails)
                        .FirstOrDefault(x => x.OrgId == config.OrgId && x.Type == 1);
                    if (borrowLog == null)
                    {
                        borrowLog = new BaseJpMessageReminderLog
                        {
                            Id = Guid.NewGuid().ToString(),
                            CreateTime = DateTime.Now,
                            Type = 1,
                            OrgId = config.OrgId,
                            OrgName = config.Org.Name,
                            IsNeedPushParent = config.IsPushParentWithBorrow,
                            ParentOrgId = config.IsPushParentWithBorrow ? config.Org.ParentId : null,
                            ConfigId = config.Id,
                            EquCount = 0,
                        };
                        _dbContext.BaseJpMessageReminderLogs.Add(borrowLog);
                        _dbContext.SaveChanges();
                    }

                    borrowLog.EquCount = 0;
                    var borrowView = _dbContext.VBorrowViews
                        .Where(x => x.OrgId == config.OrgId && x.ExpectedTime < DateTime.Now).ToList();
                    foreach (var view in borrowView)
                    {
                        var borrow = _dbContext.CommonJpBorrowReturnApplies
                            .Include(x => x.CommonJpBorrowReturnDetailRealities)
                            .FirstOrDefault(x => x.Id == view.Id);

                        foreach (var reality in borrow.CommonJpBorrowReturnDetailRealities.Where(x => x.State != 2))
                        {
                            var equConfigSingle = equConfig.FirstOrDefault(x => x.EquipmentDetailId == reality.EquipmentDetailId);
                            if (equConfigSingle != null && equConfigSingle.OverdueBorrowDay != -1)
                            {
                                //计算是否超期未还
                                if (view.ExpectedTime < DateTime.Now.AddDays(-equConfigSingle.OverdueBorrowDay))
                                {
                                    //超期
                                    borrowLog.EquCount += Convert.ToInt32(reality.RealCount) - Convert.ToInt32(reality.InsideRealCount);
                                }
                            }
                        }
                    }
                    _dbContext.BaseJpMessageReminderLogs.Update(borrowLog);


                    //非本仓库物资
                    var failWarehouseLog = _dbContext.BaseJpMessageReminderLogs
                        .Include(x => x.BaseJpMessageReminderLogDetails)
                        .FirstOrDefault(x => x.OrgId == config.OrgId && x.Type == 2);
                    if (failWarehouseLog == null)
                    {
                        failWarehouseLog = new BaseJpMessageReminderLog
                        {
                            Id = Guid.NewGuid().ToString(),
                            CreateTime = DateTime.Now,
                            Type = 2,
                            OrgId = config.OrgId,
                            OrgName = config.Org.Name,
                            IsNeedPushParent = config.IsPushParentWithFailWarehouse,
                            ParentOrgId = config.IsPushParentWithFailWarehouse ? config.Org.ParentId : null,
                            ConfigId = config.Id,
                            EquCount = 0,
                        };
                        _dbContext.BaseJpMessageReminderLogs.Add(failWarehouseLog);
                        _dbContext.SaveChanges();
                    }
                    var failWarehouse = _dbContext.CommonJpEquipmentFailWarehouseStates
                        .Where(x => x.FailOrgId == config.OrgId && x.IsCompleted == false)
                        .ToList();
                    failWarehouseLog.BaseJpMessageReminderLogDetails.Clear();
                    if (failWarehouse.Count > 0)
                    {
                        foreach (var state in failWarehouse)
                        {
                            failWarehouseLog.BaseJpMessageReminderLogDetails.Add(new BaseJpMessageReminderLogDetail
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                LogId = config.Id,
                                InventoryId = state.InventoryId,
                                Epc = state.Epc,
                                EquipmentDetailId = state.EquipmentDetailId,
                                EquipmentDetailName = state.EquipmentDetailName,
                                EquipmentSizeId = state.EquipmentSizeId,
                                EquipmentSizeName = state.EquipmentSizeName,
                                WarehouseId = state.FailWarehouseId,
                                WarehouseName = state.FailWarehouseName,
                                OriginalWarehouseId = state.TrueWarehouseId,
                                OriginalWarehouseName = state.TrueWarehouseName
                            });
                        }
                        failWarehouseLog.EquCount = failWarehouseLog.BaseJpMessageReminderLogDetails.Count;
                    }
                    else
                    {
                        failWarehouseLog.EquCount = 0;
                    }
                    _dbContext.BaseJpMessageReminderLogs.Update(failWarehouseLog);

                    //每次循环保存一次
                    _dbContext.SaveChanges();
                }

                return new Tuple<string, string>("10000", "操作成功");
            }
            catch (Exception e)
            {
                _logger.LogError(e, "定时任务工作异常");
                return new Tuple<string, string>("19999", "操作失败");
            }
        }

    }

    public class respone<T>
    {
        public int code { get; set; }
        public string msg { get; set; }
        public T data { get; set; }
    }


    public class MessageReminderConfigEquipment
    {
        /// <summary>
        /// 装备类型id
        /// </summary>
        public string EquipmentDetailId { get; set; }
        /// <summary>
        /// 是否需要提醒（超期未报废）
        /// </summary>
        public bool IsNeedRemind { get; set; }
        /// <summary>
        /// 超期未还x天后提醒(-1不提醒)
        /// </summary>
        public int OverdueBorrowDay { get; set; }
    }
}