﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;
using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JmpModel.Model.Repository.CommonRepository;
using JmpModel.Print;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Rextec.SOA.Infrastructure;

namespace JunmpPoliceStation.Controllers
{
    /// <summary>
    /// 打印模块
    /// </summary>
    [ApiController]
    [Route("api/[controller]")]
    public class PrintController : ControllerBase
    {
        private ILogger<PrintController> _logger;
        private InventoryController _inventoryController;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        private readonly object pushLockObj = new object();
        private readonly object _createEpcLockObj = new object();
        private readonly object _insertLockObj = new object();

        public PrintController(ILogger<PrintController> logger, UnitOfWork unitOfWork, InventoryController inventoryController)
        {
            _logger = logger;
            _inventoryController = inventoryController;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取全部的装备信息
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///       
        ///        } 
        /// </remarks>  
        ///       
        ///         
        ///        
        ///    
        [HttpPost("GetAllEquipments")]
        public async Task<HttpResponseMessage> GetAllEquipments([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {



                    var EquipmentList = _unitOfWork.DbContext.BaseJpEquipmentDetails.Include(p => p.BaseJpEquipmentSizes).Include(p => p.BaseJpSupplierEquipments).ToList();

                    var SupplierList = _unitOfWork.DbContext.BaseJpSuppliers.ToList();
                    var SizeList = _unitOfWork.DbContext.BaseJpEquipmentSizes.ToList();
                    if (EquipmentList.Count > 0)
                    {
                        var data = EquipmentList?.Select(x => new
                        {
                            equipmentDetailID = x.Id,
                            equipmentDetailName = x.Name,
                            supplierList = x.BaseJpSupplierEquipments?.Select(g =>
                           new
                           {

                               supplierid = g.SupplierCode,
                               supplierName = SupplierList.FirstOrDefault(s => s.Id == g.SupplierCode)?.Name
                           }),
                            equipmentSizeList = x.BaseJpEquipmentSizes?.Select(e => new
                            {


                                sizeName = e.SizeName,
                                sizeId = e.Id,
                                sizeCode = e.SizeCode

                            })
                        });


                        return JsonManager.ReturnSuccessResponse(data);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);

                    }





                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增装备
        /// </summary>
        /// <remarks>
        ///         /// 
        ///         ## 例子
        /// 
        ///         {
        ///         "warehouseid": "123",
        ///         "orgid": "123"
        ///         "userid": "111",
        ///         "equipments": [{
        ///         "supplierid": "222",
        ///	        "equipmentid": "123",
        ///         "epc": "123",
        ///	        "equipmentsizeid": "123"
        ///
        ///          }]
        ///          }
        ///</remarks>
        /// 
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddEquipment")]
        public async Task<HttpResponseMessage> AddEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        Dictionary<string, dynamic> Equipments = JsonManager.GetAddEquipmentInfo(jdata);
                        List<CommonJpEquipmentInventory> EquipmentList = new List<CommonJpEquipmentInventory>();
                        List<CommonJpEquipmentState> StateDetailsList = new List<CommonJpEquipmentState>();
                        foreach (var item in Equipments["equipments"])
                        {
                            string EqId = Guid.NewGuid().ToString();
                            EquipmentList.Add(new CommonJpEquipmentInventory
                            {
                                WarehouseCode = Equipments["warehouseid"],
                                Id = EqId,

                                CreateUser = Equipments["userid"],
                                UpdateUser = Equipments["userid"],
                                SupplierCode = item["supplierid"],
                                Epc = item["epc"],
                                EquipmentCode = item["equipmentid"],
                                EquipmentSizecode = item["equipmentsizeid"],
                                EquipmentLocation = (int)EquipmentInventoryEnum.EquipmentLocation.仓库,
                                CurrentState = (int)EquipmentInventoryEnum.CurrentState.库存内,

                                FixCount = 0,
                                CreateTime = DateTime.Now,



                            });
                            StateDetailsList.Add(new CommonJpEquipmentState
                            {
                                Id = Guid.NewGuid().ToString(),
                                EqiupmentId = EqId,
                                OutInState = 1,
                                ActionState = 1,
                                CreateTime = DateTime.Now,
                                IntoTime = DateTime.Now,
                                WarehouseId = Equipments["warehouseid"],
                                OrgId = Equipments["orgID"]

                            });
                            //EquipmentList.
                        }
                        bool result = _unitOfWork.EquipmentInventoryRepository.Insert(EquipmentList);
                        bool stateResult = _unitOfWork.EquipmentStateRepository.Insert(StateDetailsList);


                        if (result)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部打印列表
        /// </summary>
        /// <remarks>
        ///          
        ///         ## 例子
        /// 
        ///         {
        ///           "orgId": "",
        ///           "labelType": ""
        ///           "labelType": ""
        ///           "vendorName": ""
        ///           "productName": ""
        ///           "epcType": "epc类型 0：全部 1：件标 2：箱标"
        ///         }
        ///</remarks>
        ///
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPrintList")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GetPrintList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        var bState = int.TryParse(entity?.printState ?? "", out int printState);
                        string orgid = entity?.orgId ?? "";
                        string labelType = entity?.labelType ?? "-1";
                        string vendorName = entity?.vendorName ?? "";
                        string productName = entity?.productName ?? "";

                        int.TryParse(entity?.page, out int page);
                        int.TryParse(entity?.size, out int size);

                        if (!int.TryParse(entity?.epcType, out int epcType))
                        {
                            //默认件标
                            epcType = 1;
                        }

                        if (size == 0)
                        {
                            size = 50;
                        }
                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        //箱标任务（拆箱后未打印）
                        var xbInvQuery = _unitOfWork.DbContext.CommonJpEquipmentInventories
                            .Include(x => x.WarehouseCodeNavigation)
                            .Include(x => x.EquipmentSizecodeNavigation)
                            .Include(x => x.SupplierCodeNavigation)
                            .Include(x => x.EquipmentCodeNavigation)
                            .Where(x =>
                              x.IsInBox != true
                              && string.IsNullOrEmpty(x.BoxMarkId)
                              && x.InstantiationState == 1
                              && x.WarehouseCodeNavigation.OrgizationId == orgid
                            );
                        if (int.TryParse(labelType, out int tmpType) && tmpType >= 0)
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.EquipmentSizecodeNavigation.EpcType == tmpType);
                        }
                        if (!string.IsNullOrEmpty(vendorName))
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.SupplierCodeNavigation.Name.Contains(vendorName));
                        }
                        if (!string.IsNullOrEmpty(productName))
                        {
                            xbInvQuery = xbInvQuery.Where(x => x.EquipmentCodeNavigation.Name.Contains(productName));
                        }
                        var xbInvList = xbInvQuery.ToList();

                        //件标任务
                        Expression<Func<CommonJpPurchaseEpc, bool>> expression = t =>
                            (string.IsNullOrEmpty(t.Detail.Order.ProcessCurrentId) || t.Detail.Order.ProcessCurrent.FlowState == "true")
                            && t.Detail.Order.OrgId.Equals(orgid);

                        if (int.TryParse(labelType, out int tmpType2) && tmpType2 >= 0)
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Size.EpcType == tmpType2);
                        }
                        if (!string.IsNullOrEmpty(vendorName))
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Supplier.Name.Contains(vendorName));
                        }
                        if (!string.IsNullOrEmpty(productName))
                        {
                            expression = LambdaExtensions.And(expression, t => t.Detail.Equipment.Name.Contains(productName));
                        }
                        if (bState)
                        {
                            if (printState == 0)
                            {
                                expression = LambdaExtensions.And(expression, t => t.CurrentState == printState);
                            }
                            else
                            {
                                expression = LambdaExtensions.And(expression, t => t.CurrentState != 0);
                            }
                        }

                        string[] parame = new string[]
                        {
                                "Detail",
                                "Supplier",
                                "Detail.Order",
                                "Detail.Supplier",
                                "Detail.Size",
                                "Detail.Equipment",
                                "Detail.Order.Warehouse"
                        };

                        var printList = _unitOfWork.PurchaseEpcsRepository.GetList(expression, x => x.CreateTime, false, parame).ToList();

                        var dataJB = printList.Select(x => new
                        {
                            createTime = x.CreateTime,
                            orderCode = x.Detail.Order.OrderCode,
                            id = x.Id,
                            epc = x.Epc,
                            productName = x.Detail?.Equipment?.Name ?? "",
                            productId = x.Detail?.Equipment?.Id ?? "",
                            productNo = x.Detail?.Equipment?.Code,
                            quantity = x.Detail?.Quantity,
                            sizeName = x.Detail?.Size?.SizeName,
                            sizeId = x.Detail?.Size?.Id,
                            sizeCode = x.Detail?.Size?.SizeCode,
                            supplierName = x.SupplierName,
                            supplierId = x.SupplierId,
                            supplierCode = x.Supplier?.SupplierCode,
                            printType = x.Detail?.Size?.EpcType ?? 0,
                            price = x.Price?.ToString() ?? "",
                            productTime = x.ProductTime?.ToString("yyyy-MM-dd"),
                            repairCycle = x.RepairCycle.ToString() ?? "",
                            useTime = x.UseTime?.ToString("yyyy-MM-dd"),
                            warrantyCycle = x.WarrantyCycle?.ToString() ?? "",
                            pieceNo = x.Num,
                            warehouseName = x.Detail?.Order?.Warehouse?.Name ?? "",
                            warehouseId = x.Detail?.Order?.WarehouseId ?? ""
                        })
                                        .OrderBy(t => t.epc)
                                        .ToList();
                        var dataXB = xbInvList.Select(x => new
                        {
                            isUnboxingLabel = true,
                            orderCode = "",
                            id = x.Id,
                            epc = x.Epc,
                            productName = x.EquipmentCodeNavigation?.Name ?? "",
                            productId = x.EquipmentCodeNavigation?.Id ?? "",
                            productNo = x.EquipmentCodeNavigation?.Code,
                            quantity = 1,
                            sizeName = x.EquipmentSizecodeNavigation?.SizeName,
                            sizeId = x.EquipmentSizecodeNavigation?.Id,
                            sizeCode = x.EquipmentSizecodeNavigation?.SizeCode,
                            supplierName = x.SupplierCodeNavigation?.Name,
                            supplierId = x.SupplierCodeNavigation?.Id,
                            supplierCode = x.SupplierCodeNavigation?.SupplierCode,
                            printType = x.EquipmentSizecodeNavigation?.EpcType ?? 0,
                            price = x.Price?.ToString() ?? "",
                            productTime = x.ProductTime?.ToString("yyyy-MM-dd"),
                            repairCycle = x.RepairCycle.ToString() ?? "",
                            useTime = x.UseTime?.ToString("yyyy-MM-dd"),
                            warrantyCycle = x.WarrantyCycle?.ToString() ?? "",
                            pieceNo = 1,
                            warehouseName = x.WarehouseCodeNavigation?.Name ?? "",
                            warehouseId = x.WarehouseCodeNavigation?.Id ?? ""
                        })
                            .OrderBy(t => t.epc)
                            .ToList();

                        switch (epcType)
                        {
                            case 0:
                                {
                                    //全部

                                    var resList = new List<object>();
                                    //先显示箱标再显示件标
                                    resList.AddRange(dataXB);
                                    resList.AddRange(dataJB);
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = resList.Count,
                                        record = resList.Skip(page * size).Take(size)
                                    });
                                }
                            case 1:
                                {
                                    //件标

                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = printList.Count,
                                        record = dataJB.Skip(page * size).Take(size)
                                    });
                                }
                            case 2:
                                {
                                    //箱标
                                    return JsonManager.ReturnSuccessResponse(new
                                    {
                                        total = xbInvList.Count,
                                        record = dataXB.Skip(page * size).Take(size)
                                    });
                                }
                            default: return JsonManager.SimpleCustResponse($"epcType is require");
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备包打印列表
        /// </summary>
        /// <remarks>
        ///          
        ///         ## 例子
        /// 
        ///         {
        ///           "orgId": "",
        ///           "bagName": ""
        ///         }
        ///</remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPrintBagList")]
        public async Task<HttpResponseMessage> GetPrintBagList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        string orgid = entity?.orgId ?? "";
                        string bagName = entity?.bagName ?? "";


                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        //件标任务
                        Expression<Func<CommonJpBagInventory, bool>> expression = x =>
                             x.Bag.OrgId.Equals(orgid)
                             && x.PrintState == 1
                             && x.IsDelete != true;

                        if (!string.IsNullOrEmpty(bagName))
                        {
                            expression = expression.And(x => x.Bag.Name.Contains(bagName));
                        }

                        string[] parame = new string[]
                        {
                            "Bag",
                            "CommonJpEquipmentInventories",
                            "CommonJpEquipmentInventories.EquipmentCodeNavigation",
                            "Warehouse",

                        };

                        var printList = _unitOfWork.BagInventoryRepository
                            .GetList(expression, x => x.CreateTime, false, parame).ToList();

                        var resList = printList.Select(x => new
                        {
                            id = x.Id,
                            epc = x.Epc,
                            createTime = x.CreateTime,
                            bagId = x.BagId,
                            number = x.Number,
                            oneBoxNum = x.NeedNumber,
                            warehouseId = x.WarehouseId,
                            warehouseName = x.Warehouse.Name,
                            organizationId = x.Bag.OrgId,
                            bagName = x.Bag.Name,
                            invInfo = string.Join(",", x.CommonJpEquipmentInventories.Select(y => y.EquipmentCodeNavigation.Name).Distinct())

                        })
                            .OrderBy(t => t.epc)
                            .ToList();
                        return JsonManager.ReturnSuccessResponse(resList);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 更新装备包打印状态
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx",   
        ///        } 
        /// </remarks>
        [HttpPost("UpdateBagState")]
        //[NoSign]
        public async Task<HttpResponseMessage> UpdateBagState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var epcs = _unitOfWork.DbContext.CommonJpBagInventories
                                .FirstOrDefault(
                                    t => t.Id == id && (t.PrintState == 1 || t.PrintState == 2) //允许重复执行打印绑定操作
                                );

                            if (epcs != null)
                            {
                                epcs.PrintState = 2;
                                bool result = _unitOfWork.BagInventoryRepository.Update(epcs);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            else
                            {
                                //将未查询到epcs记录的数据返回错误
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 更新EPC打印状态
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx",
        ///          "isDirectEntryStock":"false"     //是否需要直接采购入库
        ///        } 
        /// </remarks>
        [HttpPost("UpdateEpcState")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        //[NoSign]
        public async Task<HttpResponseMessage> UpdateEpcState([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string tid = entity?.tid ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var epcs = _unitOfWork.DbContext.CommonJpPurchaseEpcs
                                .Include(x => x.Detail)
                                .Include(x => x.Detail.Order)
                                .Include(x => x.Detail.Order.Org)
                                .Include(x => x.Detail.Size)
                                .Include(x => x.Detail.Order.Warehouse)
                                .FirstOrDefault(t => t.Id == id
                                                     && (t.CurrentState == 0 || t.CurrentState == 1)    //允许重复执行打印绑定操作
                                );

                            if (epcs != null)
                            {
                                //if (epcs.Detail.Order.Warehouse.IsLocked == true)
                                //{
                                //    return JsonManager.SimpleCustResponse("写入入库记录失败，锁库中");
                                //}

                                epcs.CurrentState = 1;
                                epcs.Tid = tid;
                                bool result = _unitOfWork.PurchaseEpcsRepository.Update(epcs);
                                if (result)
                                {
                                    if (bool.TryParse(entity?.isDirectEntryStock, out bool isDirectEntryStock) && isDirectEntryStock)
                                    {
                                        var userData =
                                            _unitOfWork.DbContext.CommonJpUsers
                                                .Include(x => x.Police)
                                                .FirstOrDefault(x => x.Id == epcs.Detail.Order.ApplyId);
                                        var res = _inventoryController.UploadRFIDNew(JObject.Parse($@"
                                            {{
                                            	""orgId"": ""{epcs.Detail.Order.OrgId}"",
                                            	""warehouseId"": ""{epcs.Detail.Order.WarehouseId}"",
                                            	""policeId"": ""{userData?.PoliceId}"",
                                            	""currentState"": 1,
                                            	""picUrl"": """",
                                            	""RFIDList"": [{{
                                            		""RFID"": ""{epcs.Epc}""
                                            	}}]
                                            }}
                                        ")).Result;
                                        var resBody = res.Content.ReadAsStringAsync().Result;

                                        var obj = JObject.Parse(resBody);
                                        if (obj["code"]?.Value<int>() != 10000)
                                        {
                                            var type = epcs.Detail.Size.EpcType == 0 ? "打印" : "绑定";
                                            return JsonManager.SimpleCustResponse(type + "成功,入库失败,请手动入库");
                                        }
                                    }
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            else
                            {
                                //将未查询到epcs记录的数据返回错误
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备号型、供应商
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "id":"xxxx"
        ///        } 
        /// </remarks>    
        [HttpPost("GetEquInfoById")]
        public async Task<HttpResponseMessage> GetEquInfoById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            var info = _unitOfWork.DbContext.BaseJpEquipmentDetails
                                .Include("BaseJpEquipmentSizes")
                                .Include("BaseJpSupplierEquipments")
                                .Include("BaseJpSupplierEquipments.SupplierCodeNavigation")
                                .FirstOrDefault(t => t.Id == id);
                            if (info == null)
                            {
                                return JsonManager.ReturnSuccessResponse(new { });
                            }
                            else
                            {
                                var data = new
                                {
                                    suppliers = info.BaseJpSupplierEquipments.Select(s => new
                                    {
                                        name = s.SupplierCodeNavigation.Name,
                                        code = s.SupplierCodeNavigation.SupplierCode,
                                        id = s.SupplierCode
                                    }).ToList(),
                                    sizes = info.BaseJpEquipmentSizes.Select(s => new
                                    {
                                        id = s.Id,
                                        name = s.SizeName,
                                        code = s.SizeCode,
                                        price = s.Price
                                    }).ToList()
                                };
                                return JsonManager.ReturnSuccessResponse(data);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备信息，打印程序用
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>  
        [HttpPost("GetAllEqu")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllEqu()
        {
            return await Task.Run(() =>
             {
                 try
                 {
                     var info = _unitOfWork.DbContext.BaseJpEquipmentDetails;

                     if (info == null)
                     {
                         return JsonManager.ReturnSuccessResponse(new { });
                     }
                     else
                     {
                         var data = (from v in info
                                     select new
                                     {
                                         id = v.Id,
                                         name = v.Name,
                                         code = v.Code
                                     }).ToList();
                         return JsonManager.ReturnSuccessResponse(data);
                     }


                 }
                 catch (Exception ex)
                 {

                     _logger.LogError(ex.ToString());
                     return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                 }
             });
        }

        /// <summary>
        /// 订单列表获取
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        ///        /// ## 例子
        /// 
        ///        {
        ///          "orgId":"E05CC28D-C189-4389-8081-DD0D6E483B40"
        ///        } 
        /// </remarks>   
        [HttpPost("GetPrintOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetPrintOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orgId = entity?.orgId ?? "";

                        DateTime.TryParse(entity?.createTime, out DateTime createTime);
                        string equName = entity?.equName ?? "";
                        string orderCode = entity?.orderCode ?? "";

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 50;
                        }

                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        else
                        {
                            Expression<Func<CommonJpPurchaseDetail, bool>> where = t => t.Order.OrgId.Contains(orgId) && t.State != 2 && t.Quantity > t.CommonJpPurchaseEpcs.Count && t.Order.ProcessCurrent.FlowState == "true";
                            if (createTime != null && createTime != default)
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Order.CreateTime.Value.Date == createTime.Date);
                            }

                            if (!string.IsNullOrEmpty(equName))
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Equipment.Name.Contains(equName));
                            }
                            if (!string.IsNullOrEmpty(orderCode))
                            {
                                where = LambdaExtensions.AndAlso(where, t => t.Order.OrderCode.Contains(orderCode));
                            }

                            string[] parame = new string[]
                            {
                        "Order",
                        "Order.Warehouse",
                        "Size",
                        "Equipment",
                        "CommonJpPurchaseEpcs",
                        "Equipment.BaseJpSupplierEquipments",
                        "Equipment.BaseJpSupplierEquipments.SupplierCodeNavigation"
                            };

                            var details = _unitOfWork.PurchaseDetailRepository.GetPage(where, "-CreateTime", page, size, false, parame);
                            var data = from v in details.content
                                       select new
                                       {
                                           suppilers = v.Equipment.BaseJpSupplierEquipments.Select(s => new
                                           {
                                               id = s.SupplierCode,
                                               name = s.SupplierCodeNavigation?.Name,
                                               code = s.SupplierCodeNavigation?.SupplierCode
                                           }),
                                           orderId = v.Order.Id,
                                           detailId = v.Id,
                                           createTime = v.Order.CreateTime,
                                           equCode = v.Equipment.Code,
                                           equName = v.Equipment.Name,
                                           equId = v.Equipment.Id,
                                           sizeId = v.Size.Id,
                                           sizeCode = v.Size.SizeCode,
                                           sizeName = v.Size.SizeName,
                                           orderCode = v.Order.OrderCode,
                                           genedNum = v.CommonJpPurchaseEpcs.Count,
                                           totalNum = v.Quantity,
                                           reNum = v.Quantity - v.CommonJpPurchaseEpcs.Count,
                                           warehouseId = v.Order.WarehouseId,
                                           warehouseName = v.Order.Warehouse.Name,
                                       };

                            return JsonManager.ReturnSuccessResponse(new
                            {
                                total = details.totalElements,
                                record = data.ToList()
                            });

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取所有供应商，打印程序用
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllSupplier")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllSupplier()
        {
            return await Task.Run(() =>
            {
                try
                {
                    var suppliers = _unitOfWork.SupplierRepository.GetList(t => !string.IsNullOrEmpty(t.SupplierCode)).Select(s => new
                    {
                        id = s.Id,
                        code = s.SupplierCode,
                        name = s.Name
                    }).ToList();

                    return JsonManager.ReturnSuccessResponse(new
                    {
                        total = suppliers.Count,
                        record = suppliers.ToList()
                    });
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 根据采购单信息生成EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>

        [HttpPost("GenerateExtTagEpc")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GenerateExtTagEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string supplierId = entity?.supplierId ?? "";
                            string detailId = entity?.detailId ?? "";
                            string sizeCode = entity?.sizeCode ?? "";
                            string equCode = entity?.equCode ?? "";
                            string supplierCode = entity?.supplierCode ?? "";
                            string supplierName = entity?.supplierName ?? "";

                            bool bQuantity = int.TryParse(entity?.quantity ?? "0", out int quantity);

                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);

                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            if (string.IsNullOrEmpty(detailId))
                            {
                                return JsonManager.SimpleCustResponse($"无效的明细代码");
                            }
                            else if (string.IsNullOrEmpty(supplierName))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商名称");
                            }
                            else if (!ulong.TryParse(sizeCode, out ulong lSizeCode) || !_unitOfWork.EquipmentSizeRepository.Any(t => t.SizeCode == (int)lSizeCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的号型代码");
                            }
                            else if (!ulong.TryParse(equCode, out ulong lEquCode) || !_unitOfWork.EquipmentDetailRepository.Any(t => t.Code == equCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的物资代码");

                            }
                            else if (!bQuantity || quantity <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装备数量");

                            }
                            else if (quantity > 4095)
                            {
                                return JsonManager.SimpleCustResponse($"数量不正确，应小于4095");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的维保周期");

                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");

                            }
                            else if (!bWarranty || warrantyCycle < 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (string.IsNullOrEmpty(supplierCode) || supplierCode.Length != 9 || !_unitOfWork.SupplierRepository.Any(t => t.SupplierCode == supplierCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商代码");
                            }
                            else if (string.IsNullOrEmpty(supplierId) || !_unitOfWork.SupplierRepository.Any(t => t.Id == supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商ID");
                            }
                            else
                            {
                                List<EpcInfo> epcList = new List<EpcInfo>();
                                uint date = uint.Parse(productTime.Date.ToString("yyyyMMdd"));
                                var epcs = GenerateEpcNum.GenEpcs(GlobalContext.ServerNum, lEquCode, supplierCode, lSizeCode, date, out string msg, quantity);
                                if (epcs.Count == quantity)
                                {
                                    epcs.ForEach(s =>
                                    {
                                        epcList.Add(new EpcInfo()
                                        {
                                            detailId = detailId,
                                            supplierId = supplierId,
                                            epc = s.Epc,
                                            price = price,
                                            productTime = productTime,
                                            repairCycle = repairCycle,
                                            useTime = useTime,
                                            warrantyCycle = warrantyCycle,
                                            num = s.Num,
                                            supplierName = supplierName,
                                        });

                                        CommonJpPurchaseEpc insert = new CommonJpPurchaseEpc()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            Num = s.Num,
                                            CreateTime = DateTime.Now,
                                            CurrentState = 0,
                                            DetailId = detailId,
                                            Epc = s.Epc,
                                            Price = price,
                                            ProductTime = productTime,
                                            RepairCycle = repairCycle,
                                            SupplierId = supplierId,
                                            UseDirection = 0,
                                            UseTime = useTime,
                                            WarrantyCycle = warrantyCycle,
                                            SupplierName = supplierName
                                        };
                                        if (!string.IsNullOrEmpty(shelfId))
                                        {
                                            insert.ShelfId = shelfId;
                                            insert.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                            insert.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                            insert.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                        }
                                        _unitOfWork.PurchaseEpcsRepository.Insert(insert, false);
                                    });

                                    var res = _unitOfWork.PurchaseEpcsRepository.SaveChanges() > 0;
                                    if (res)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        //GenerateEpcNum.RollBackNum(equCode, supplierCode, sizeCode, date, quantity);
                                        return JsonManager.SimpleCustResponse("数据保存失败");
                                    }
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse(msg);
                                }
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 直接生成EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateIntTagEpc")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GenerateIntTagEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string sizeCode = entity?.sizeCode ?? "";
                            string equCode = entity?.equCode ?? "";
                            string supplierCode = entity?.supplierCode ?? "";
                            bool bQuantity = int.TryParse(entity?.quantity ?? "0", out int quantity);
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);

                            string labelType = entity.labelType ?? "件标";
                            bool bOneBoxNum = uint.TryParse(entity.oneBoxNum, out uint oneBoxNum);

                            if (!ulong.TryParse(sizeCode, out ulong lSizeCode) || !_unitOfWork.EquipmentSizeRepository.Any(t => t.SizeCode == (int)lSizeCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的号型代码");
                            }
                            else if (!ulong.TryParse(equCode, out ulong lEquCode) || !_unitOfWork.EquipmentDetailRepository.Any(t => t.Code == equCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的物资代码");
                            }
                            else if (!bQuantity || quantity <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装备数量");

                            }
                            else if (quantity > 4095)
                            {
                                return JsonManager.SimpleCustResponse($"数量不正确，应小于4095");
                            }
                            else if (!bWarranty || warrantyCycle < 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (string.IsNullOrEmpty(supplierCode) || supplierCode.Length != 9 || !_unitOfWork.SupplierRepository.Any(t => t.SupplierCode == supplierCode))
                            {
                                return JsonManager.SimpleCustResponse($"无效的供应商代码");
                            }
                            else
                            {
                                uint date = uint.Parse(productTime.Date.ToString("yyyyMMdd"));
                                var epcs = new List<GenerateEpcNum.GenEpcInfo>();
                                var msg = "";
                                switch (labelType)
                                {
                                    case "件标":
                                        {
                                            epcs = GenerateEpcNum.GenEpcs(GlobalContext.ServerNum, lEquCode, supplierCode, lSizeCode, date, out msg, quantity);
                                            break;
                                        }
                                    case "箱标":
                                        {
                                            if (!bOneBoxNum || oneBoxNum <= 0)
                                            {
                                                return JsonManager.SimpleCustResponse($"无效的箱内装备数量");
                                            }

                                            //redis读取今日BoxNo;
                                            uint epcBoxNo = 0;
                                            lock (_createEpcLockObj)
                                            {
                                                var key = DateTime.Now.ToString("yyyyMMdd") + "BoxNo";
                                                string value = RedisCacheHelper.GetStringValue(key);
                                                epcBoxNo = uint.TryParse(value, out var boxNo) ? boxNo + 1 : 1;
                                                if (!RedisCacheHelper.SetStringValue(key, epcBoxNo.ToString(), ref msg))
                                                {
                                                    throw new Exception("RedisCacheHelper Exception:" + msg);
                                                }
                                            }
                                            epcs = GenerateEpcNum.GenBoxMarkEpcs(GlobalContext.ServerNum, lEquCode, supplierCode, lSizeCode, date, oneBoxNum, epcBoxNo, out msg, quantity);
                                            break;
                                        }
                                    default:
                                        {
                                            //其他作为件标
                                            epcs = GenerateEpcNum.GenEpcs(GlobalContext.ServerNum, lEquCode, supplierCode, lSizeCode, date, out msg, quantity);
                                            break;
                                        }
                                }
                                if (epcs.Count == quantity)
                                {
                                    var data = (from v in epcs
                                                select new
                                                {
                                                    epc = v.Epc,
                                                    num = v.Num
                                                });
                                    return JsonManager.ReturnSuccessResponse(data);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse(msg);
                                }
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateInventory")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GenerateInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                lock (_insertLockObj)
                {
                    try
                    {
                        if (jdata != null)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效参数");
                            }

                            //todo 第三方调用接口验证orgId正确性 将来打印程序接口切换后取消注释
                            //if (!string.IsNullOrEmpty(entity._PUSHORG))
                            //{
                            //    if (string.IsNullOrEmpty(entity.warehouseId)
                            //        || _unitOfWork.WarehouseRepository.Get(entity.warehouseId)?.OrgizationId != entity._PUSHORG.ToString()
                            //    )
                            //    {
                            //        return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            //    }
                            //}

                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epc = entity?.epc ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";

                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            bool.TryParse(entity.isUnboxingLabel, out bool isUnboxingLabel);

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }
                            else if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            else if (!CheckEpc(epc, equId))
                            {
                                return JsonManager.SimpleCustResponse($"EPC与装备不匹配");
                            }
                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (warrantyCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                            }
                            else if (repairCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (isUnboxingLabel == false && _unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                            {
                                return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                            }
                            else
                            {
                                bool res = false;
                                if (isUnboxingLabel)
                                {
                                    var inv = _unitOfWork.EquipmentInventoryRepository.Get(t =>
                                        t.Epc.ToUpper() == epc.ToUpper());
                                    if (inv == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"物资异常");
                                    }

                                    inv.InstantiationState = 2;
                                    res = _unitOfWork.EquipmentInventoryRepository.Update(inv);
                                }
                                else
                                {
                                    var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                    var ent = new CommonJpEquipmentInventory
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        Epc = epc,
                                        SupplierCode = supplierId,
                                        EquipmentCode = equId,
                                        WarehouseCode = warehouseId,
                                        EquipmentLocation = 0,
                                        CurrentState = 0,
                                        CreateTime = DateTime.Now,
                                        CreateUser = "internal",
                                        EquipmentSizecode = sizeId,
                                        UpdateUser = "internal",
                                        Price = price,
                                        ProductTime = productTime,
                                        UseTime = useTime,
                                        UseDirection = 0,
                                        WarrantyCycle = warrantyCycle,
                                        RepairCycle = repairCycle,
                                        IsBorrowed = false,
                                        InstantiationState = 2,
                                        OrgId = warehouse?.OrgizationId
                                    };
                                    res = _unitOfWork.EquipmentInventoryRepository.Insert(ent);
                                }
                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }

                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                    }
                    catch (Exception ex)
                    {
                        _logger.LogError(ex.ToString());
                        if (ex.Message == "CRC校验失败")
                        {
                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息(打印程序内部使用）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateInventoryWithProgram")]
        public async Task<HttpResponseMessage> GenerateInventoryWithProgram([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                lock (_insertLockObj)
                {
                    try
                    {
                        if (jdata != null)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效参数");
                            }

                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epc = entity?.epc ?? "";
                            string tid = entity?.tid ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";

                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            bool.TryParse(entity.isUnboxingLabel, out bool isUnboxingLabel);

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }
                            else if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            else if (!CheckEpc(epc, equId))
                            {
                                return JsonManager.SimpleCustResponse($"EPC与装备不匹配");
                            }
                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (warrantyCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                            }
                            else if (repairCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else if (isUnboxingLabel == false && _unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                            {
                                return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                            }
                            else
                            {
                                bool res = false;
                                if (isUnboxingLabel)
                                {
                                    var inv = _unitOfWork.EquipmentInventoryRepository.Get(t =>
                                        t.Epc.ToUpper() == epc.ToUpper());
                                    if (inv == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"物资异常");
                                    }

                                    inv.InstantiationState = 2;
                                    res = _unitOfWork.EquipmentInventoryRepository.Update(inv);
                                }
                                else
                                {
                                    var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                    var ent = new CommonJpEquipmentInventory
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        Epc = epc,
                                        Tid = tid,
                                        SupplierCode = supplierId,
                                        EquipmentCode = equId,
                                        WarehouseCode = warehouseId,
                                        EquipmentLocation = 0,
                                        CurrentState = 0,
                                        CreateTime = DateTime.Now,
                                        CreateUser = "internal",
                                        EquipmentSizecode = sizeId,
                                        UpdateUser = "internal",
                                        Price = price,
                                        ProductTime = productTime,
                                        UseTime = useTime,
                                        UseDirection = 0,
                                        WarrantyCycle = warrantyCycle,
                                        RepairCycle = repairCycle,
                                        IsBorrowed = false,
                                        InstantiationState = 2,
                                        OrgId = warehouse?.OrgizationId
                                    };

                                    if (!string.IsNullOrEmpty(shelfId))
                                    {
                                        ent.ShelfId = shelfId;
                                        ent.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                        ent.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                        ent.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                    }
                                    res = _unitOfWork.EquipmentInventoryRepository.Insert(ent);
                                }
                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }

                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                    }
                    catch (Exception ex)
                    {
                        _logger.LogError(ex.ToString());
                        if (ex.Message == "CRC校验失败")
                        {
                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息(多个epc，第三方使用）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "epcList":[{
        ///             "epc": "",
        ///             "equId": "",     
        ///             "sizeId": "", 
        ///             "supplierId": "",
        ///             "warehouseId": "", 
        ///             "productTime": "",
        ///             "warrantyCycle": "",
        ///             "price": "",
        ///             "useTime": "",
        ///             "repairCycle": ""
        ///         }]
        ///     }
        /// </remarks>
        [HttpPost("GenerateRangeInventoryDevelop")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GenerateRangeInventoryDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                lock (_insertLockObj)
                {
                    try
                    {
                        if (jdata != null)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效参数");
                            }
                            else
                            {
                                var list = new List<dynamic>(entity.epcList);
                                if (list.Count == 0)
                                {
                                    return JsonManager.SimpleCustResponse($"epcList is require");
                                }

                                var warehouseIdList = list.GroupBy(x => x.warehouseId);
                                foreach (var warehouseIdData in warehouseIdList)
                                {
                                    if (!string.IsNullOrEmpty(warehouseIdData.Key))
                                    {
                                        //第三方调用接口验证orgId正确性
                                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                                        {
                                            if (string.IsNullOrEmpty(warehouseIdData.Key)
                                                || _unitOfWork.WarehouseRepository.Get(warehouseIdData.Key)?.OrgizationId != entity._PUSHORG.ToString()
                                            )
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                                            }
                                        }
                                    }
                                }
                                //检查epc是否重复
                                var distinct = list.Select(x => (string)x.epc ?? "").Distinct();
                                if (distinct.Count() != list.Count)
                                {
                                    return JsonManager.SimpleCustResponse("上报数据存在重复EPC");
                                }

                                foreach (dynamic obj in list)
                                {
                                    string sizeId = obj?.sizeId ?? "";
                                    string equId = obj?.equId ?? "";
                                    string epc = obj?.epc ?? "";
                                    string supplierId = obj?.supplierId ?? "";
                                    string warehouseId = obj?.warehouseId ?? "";

                                    bool bProduct = DateTime.TryParse(obj?.productTime ?? "", out DateTime productTime);
                                    bool bWarranty = int.TryParse(obj?.warrantyCycle ?? "0", out int warrantyCycle);
                                    bool bPrice = decimal.TryParse(obj?.price ?? "0", out decimal price);
                                    bool bUse = DateTime.TryParse(obj?.useTime ?? "", out DateTime useTime);
                                    bool bRepair = int.TryParse(obj?.repairCycle ?? "0", out int repairCycle);

                                    bool.TryParse(obj.isUnboxingLabel, out bool isUnboxingLabel);

                                    if (string.IsNullOrEmpty(sizeId))
                                    {
                                        return JsonManager.SimpleCustResponse($"无效号型 epc:" + epc);
                                    }
                                    else if (string.IsNullOrEmpty(equId))
                                    {
                                        return JsonManager.SimpleCustResponse($"无效装备 epc:" + epc);
                                    }
                                    else if (string.IsNullOrEmpty(epc))
                                    {
                                        return JsonManager.SimpleCustResponse($"无效EPC epc:" + epc);
                                    }

                                    try
                                    {
                                        if (!CheckEpc(epc, equId))
                                        {
                                            return JsonManager.SimpleCustResponse($"EPC与装备不匹配 epc:" + epc);
                                        }
                                    }
                                    catch (Exception e)
                                    {
                                        if (e.Message == "CRC校验失败")
                                        {
                                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败 epc:" + epc);
                                        }
                                        throw;
                                    }


                                    if (string.IsNullOrEmpty(supplierId))
                                    {
                                        return JsonManager.SimpleCustResponse($"无效供应商 epc:" + epc);
                                    }
                                    else if (string.IsNullOrEmpty(warehouseId))
                                    {
                                        return JsonManager.SimpleCustResponse($"无效仓库 epc:" + epc);
                                    }
                                    else if (!bRepair || repairCycle <= 0)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效的装维保周期 epc:" + epc);
                                    }
                                    else if (!bPrice || price <= 0)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效的购入单价 epc:" + epc);
                                    }
                                    else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                                    {
                                        return JsonManager.SimpleCustResponse($"无效的质保周期 epc:" + epc);

                                    }
                                    else if (warrantyCycle > 999)
                                    {
                                        return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                                    }
                                    else if (repairCycle > 999)
                                    {
                                        return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                                    }
                                    else if (!bUse || useTime == default)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效使用日期 epc:" + epc);
                                    }
                                    else if (!bProduct || productTime == default)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效生产日期 epc:" + epc);
                                    }
                                    else if (isUnboxingLabel == false && _unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                                    {
                                        return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC epc:" + epc);
                                    }
                                    else
                                    {
                                        if (isUnboxingLabel)
                                        {
                                            var inv = _unitOfWork.EquipmentInventoryRepository.Get(t =>
                                                t.Epc.ToUpper() == epc.ToUpper());
                                            if (inv == null)
                                            {
                                                return JsonManager.SimpleCustResponse($"物资异常");
                                            }

                                            inv.InstantiationState = 2;
                                            _unitOfWork.EquipmentInventoryRepository.Update(inv, false);
                                        }
                                        else
                                        {
                                            var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                            var ent = new CommonJpEquipmentInventory
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                Epc = epc,
                                                SupplierCode = supplierId,
                                                EquipmentCode = equId,
                                                WarehouseCode = warehouseId,
                                                EquipmentLocation = 0,
                                                CurrentState = 0,
                                                CreateTime = DateTime.Now,
                                                CreateUser = "internal",
                                                EquipmentSizecode = sizeId,
                                                UpdateUser = "internal",
                                                Price = price,
                                                ProductTime = productTime,
                                                UseTime = useTime,
                                                UseDirection = 0,
                                                WarrantyCycle = warrantyCycle,
                                                RepairCycle = repairCycle,
                                                IsBorrowed = false,
                                                InstantiationState = 2,
                                                OrgId = warehouse?.OrgizationId
                                            };
                                            _unitOfWork.EquipmentInventoryRepository.Insert(ent, false);
                                        }

                                    }
                                }
                                var res = _unitOfWork.SaveChanges() > 0;
                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                    }
                    catch (Exception ex)
                    {
                        _logger.LogError(ex.ToString());
                        if (ex.Message == "CRC校验失败")
                        {
                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
            });
        }

        /// <summary>
        /// 生成打印入库信息(多个epc,箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GenerateRangeInventory")]
        public async Task<HttpResponseMessage> GenerateRangeInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epcListJson = entity?.epcListJson ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";
                            string boxMarkEpc = entity?.epc ?? "";


                            bool.TryParse(entity.isReloadBoxing, out bool isReloadBoxing);


                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            string shelfId = entity?.shelfId ?? "";
                            bool bShelfRange = int.TryParse(entity?.shelfRange ?? "0", out int shelfRange);
                            bool bShelfRow = int.TryParse(entity?.shelfRow ?? "0", out int shelfRow);
                            bool bShelfColumn = int.TryParse(entity?.shelfColumn ?? "0", out int shelfColumn);

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标epc");
                            }

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }
                            else if (string.IsNullOrEmpty(epcListJson))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPCList");
                            }
                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (warrantyCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                            }
                            else if (repairCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }

                            var epcList = JsonConvert.DeserializeObject<List<string>>(epcListJson).Select(x => x.ToUpper()).ToList();

                            //重装箱物资不做新增处理
                            if (isReloadBoxing)
                            {
                                var boxMark = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                                if (boxMark == null)
                                {
                                    return JsonManager.SimpleCustResponse($"无效箱标");
                                }
                                else if (boxMark.ReloadBoxingState != 1)
                                {
                                    //检查是否重复打印
                                    var oldEpcList =
                                        _unitOfWork.EquipmentInventoryRepository.GetList(x =>
                                            x.BoxMarkId == boxMark.Id).Select(x => x.Epc).ToList();

                                    if (oldEpcList.Except(epcList).Any() || epcList.Except(oldEpcList).Any())
                                    {
                                        //有异常数据，提示
                                        return JsonManager.SimpleCustResponse($"箱标已打印，但物资不匹配");
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleCustResponse($"箱标重复打印,清除任务", "10000");
                                    }
                                }

                                boxMark.ReloadBoxingState = 2;
                                _unitOfWork.EquipmentBoxMarkRepository.Update(boxMark);
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }


                            if (_unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Select(x => x.Epc.ToUpper())
                                .Any(x => epcList.Any(y => y == x))
                                )
                            {
                                return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                            }
                            else
                            {
                                var boxMark = new CommonJpEquipmentBoxMark()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    CreateTime = DateTime.Now,
                                    Epc = boxMarkEpc,
                                    OneBoxNum = epcList.Count,
                                    EquipmentDetailId = equId,
                                    SizeId = sizeId,
                                    SupplierId = supplierId,
                                    CurrentState = 0,
                                    WarehouseId = warehouseId,

                                };
                                _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);

                                var inventoryList = new List<CommonJpEquipmentInventory>();
                                foreach (var epc in epcList)
                                {
                                    var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                    var inv = new CommonJpEquipmentInventory
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        Epc = epc,
                                        SupplierCode = supplierId,
                                        EquipmentCode = equId,
                                        WarehouseCode = warehouseId,
                                        EquipmentLocation = 0,
                                        CurrentState = 0,
                                        CreateTime = DateTime.Now,
                                        CreateUser = "internal",
                                        EquipmentSizecode = sizeId,
                                        UpdateUser = "internal",
                                        Price = price,
                                        ProductTime = productTime,
                                        UseTime = useTime,
                                        UseDirection = 0,
                                        WarrantyCycle = warrantyCycle,
                                        RepairCycle = repairCycle,
                                        IsBorrowed = false,
                                        IsInBox = true,
                                        BoxMarkId = boxMark.Id,
                                        InstantiationState = 1,
                                        OrgId = warehouse?.OrgizationId
                                    };
                                    if (!string.IsNullOrEmpty(shelfId))
                                    {
                                        inv.ShelfId = shelfId;
                                        inv.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                        inv.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                        inv.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                    }
                                    inventoryList.Add(inv);
                                }
                                var res = _unitOfWork.EquipmentInventoryRepository.Insert(inventoryList, true);

                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 装箱操作(内部版，箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BoxingInventory")]
        public async Task<HttpResponseMessage> BoxingInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string boxMarkEpc = entity.boxMarkEpc ?? "";

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标");
                            }
                            var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                            if (old != null)
                            {
                                return JsonManager.SimpleCustResponse($"箱标EPC已存在");
                            }

                            var list = new List<dynamic>(entity.invList);
                            int oneBoxNum = list.Count;
                            if (oneBoxNum == 0)
                            {
                                return JsonManager.SimpleCustResponse($"invList is require");
                            }

                            var obj = list.FirstOrDefault();
                            string boxSizeId = obj?.sizeId ?? "";
                            string boxEquId = obj?.equId ?? "";
                            string boxSupplierId = obj?.supplierId ?? "";
                            string boxWarehouseId = obj?.warehouseId ?? "";


                            var boxMark = new CommonJpEquipmentBoxMark()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                Epc = boxMarkEpc,
                                OneBoxNum = oneBoxNum,
                                EquipmentDetailId = boxEquId,
                                SizeId = boxSizeId,
                                SupplierId = boxSupplierId,
                                CurrentState = 0,
                                WarehouseId = boxWarehouseId,
                                ReloadBoxingState = 1
                            };
                            _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);


                            foreach (var invInfo in entity.invList)
                            {
                                if (bool.TryParse(invInfo.isUnboxingLabel, out bool isUnboxingLabel) && isUnboxingLabel)
                                {
                                    //拆箱生成标签
                                    string epc = invInfo.epc;
                                    var inventory = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == epc);
                                    if (inventory == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效拆箱标签");
                                    }
                                    inventory.BoxMarkId = boxMark.Id;
                                    _unitOfWork.EquipmentInventoryRepository.Update(inventory, false);
                                }
                                else
                                {
                                    #region 创建新物资
                                    try
                                    {
                                        string sizeId = invInfo.sizeId ?? "";
                                        string equId = invInfo.equId ?? "";
                                        string epc = invInfo.epc ?? "";
                                        string supplierId = invInfo.supplierId ?? "";
                                        string warehouseId = invInfo.warehouseId ?? "";

                                        bool bProduct = DateTime.TryParse(invInfo.productTime ?? "", out DateTime productTime);
                                        bool bWarranty = int.TryParse(invInfo.warrantyCycle ?? "0", out int warrantyCycle);
                                        bool bPrice = decimal.TryParse(invInfo.price ?? "0", out decimal price);
                                        bool bUse = DateTime.TryParse(invInfo.useTime ?? "", out DateTime useTime);
                                        bool bRepair = int.TryParse(invInfo.repairCycle ?? "0", out int repairCycle);

                                        string shelfId = invInfo?.shelfId ?? "";
                                        bool bShelfRange = int.TryParse(invInfo.shelfRange ?? "0", out int shelfRange);
                                        bool bShelfRow = int.TryParse(invInfo?.shelfRow ?? "0", out int shelfRow);
                                        bool bShelfColumn = int.TryParse(invInfo?.shelfColumn ?? "0", out int shelfColumn);

                                        if (string.IsNullOrEmpty(sizeId))
                                        {
                                            return JsonManager.SimpleCustResponse($"无效号型");
                                        }
                                        else if (string.IsNullOrEmpty(equId))
                                        {
                                            return JsonManager.SimpleCustResponse($"无效装备");
                                        }
                                        else if (string.IsNullOrEmpty(epc))
                                        {
                                            return JsonManager.SimpleCustResponse($"无效EPC");
                                        }
                                        else if (!CheckEpc(epc, equId))
                                        {
                                            return JsonManager.SimpleCustResponse($"EPC与装备不匹配");
                                        }
                                        else if (string.IsNullOrEmpty(supplierId))
                                        {
                                            return JsonManager.SimpleCustResponse($"无效供应商");
                                        }
                                        else if (string.IsNullOrEmpty(warehouseId))
                                        {
                                            return JsonManager.SimpleCustResponse($"无效仓库");
                                        }
                                        else if (!bRepair || repairCycle <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse($"无效的装维保周期");
                                        }
                                        else if (!bPrice || price <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse($"无效的购入单价");
                                        }
                                        else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                                        {
                                            return JsonManager.SimpleCustResponse($"无效的质保周期");

                                        }
                                        else if (warrantyCycle > 999)
                                        {
                                            return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                                        }
                                        else if (repairCycle > 999)
                                        {
                                            return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                                        }
                                        else if (!bUse || useTime == default)
                                        {
                                            return JsonManager.SimpleCustResponse($"无效使用日期");
                                        }
                                        else if (!bProduct || productTime == default)
                                        {
                                            return JsonManager.SimpleCustResponse($"无效生产日期");
                                        }
                                        else if (_unitOfWork.EquipmentInventoryRepository.Any(t => t.Epc.ToUpper() == epc.ToUpper()))
                                        {
                                            return JsonManager.SimpleCustResponse($"生成库存失败，库存内已存在此EPC");
                                        }
                                        else
                                        {
                                            var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                            var ent = new CommonJpEquipmentInventory
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                Epc = epc,
                                                SupplierCode = supplierId,
                                                EquipmentCode = equId,
                                                WarehouseCode = warehouseId,
                                                EquipmentLocation = 0,
                                                CurrentState = 0,
                                                CreateTime = DateTime.Now,
                                                CreateUser = "internal",
                                                EquipmentSizecode = sizeId,
                                                UpdateUser = "internal",
                                                Price = price,
                                                ProductTime = productTime,
                                                UseTime = useTime,
                                                UseDirection = 0,
                                                WarrantyCycle = warrantyCycle,
                                                RepairCycle = repairCycle,
                                                IsBorrowed = false,
                                                InstantiationState = 1,
                                                BoxMarkId = boxMark.Id,
                                                IsInBox = true,
                                                OrgId = warehouse?.OrgizationId
                                            };
                                            if (!string.IsNullOrEmpty(shelfId))
                                            {
                                                ent.ShelfId = shelfId;
                                                ent.ShelfRange = shelfRange == 0 ? (int?)null : shelfRange;
                                                ent.ShelfRow = shelfRow == 0 ? (int?)null : shelfRow;
                                                ent.ShelfColumn = shelfColumn == 0 ? (int?)null : shelfColumn;
                                            }
                                            _unitOfWork.EquipmentInventoryRepository.Insert(ent, false);
                                        }
                                    }
                                    catch (Exception ex)
                                    {
                                        _logger.LogError(ex.ToString());
                                        if (ex.Message == "CRC校验失败")
                                        {
                                            return JsonManager.SimpleCustResponse($"EPC CRC校验失败");
                                        }
                                        return JsonManager.SimpleCustResponse("物资创建异常");
                                    }

                                    #endregion
                                }
                            }

                            var newInvList = _unitOfWork.DbContext.ChangeTracker.Entries()
                                .Where(x => x.Entity is CommonJpEquipmentInventory)
                                .Select(x => x.Entity as CommonJpEquipmentInventory)
                                .ToList();

                            if (newInvList.Any(x => !string.IsNullOrEmpty(x.ShelfId)))
                            {
                                //全体覆盖货架位置
                                var inv = newInvList.OrderBy(x => x.CreateTime).First(x => !string.IsNullOrEmpty(x.ShelfId));
                                foreach (var inventory in newInvList)
                                {
                                    inventory.ShelfId = inv.ShelfId;
                                    inventory.ShelfRange = inv.ShelfRange;
                                    inventory.ShelfRow = inv.ShelfRow;
                                    inventory.ShelfColumn = inv.ShelfColumn;
                                }
                            }
                            return _unitOfWork.SaveChanges() > 0
                                ? JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS)
                                : JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 装箱操作(用户版，箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BoxingInventoryNormalVersion")]
        public async Task<HttpResponseMessage> BoxingInventoryNormalVersion([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string boxMarkEpc = entity.boxMarkEpc ?? "";

                            if (string.IsNullOrEmpty(boxMarkEpc))
                            {
                                return JsonManager.SimpleCustResponse($"无效箱标");
                            }
                            var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == boxMarkEpc);
                            if (old != null)
                            {
                                return JsonManager.SimpleCustResponse($"箱标EPC已存在");
                            }

                            string policeId = entity.policeId ?? "";
                            if (string.IsNullOrEmpty(policeId))
                            {
                                return JsonManager.SimpleCustResponse($"policeId is require");
                            }

                            var list = new List<dynamic>(entity.invList);
                            int oneBoxNum = list.Count;
                            if (oneBoxNum == 0)
                            {
                                return JsonManager.SimpleCustResponse($"invList is require");
                            }

                            var obj = list.FirstOrDefault();
                            string boxSizeId = obj?.sizeId ?? "";
                            string boxEquId = obj?.equId ?? "";
                            string boxSupplierId = obj?.supplierId ?? "";
                            string boxWarehouseId = obj?.warehouseId ?? "";


                            var boxMark = new CommonJpEquipmentBoxMark()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                Epc = boxMarkEpc,
                                OneBoxNum = oneBoxNum,
                                EquipmentDetailId = boxEquId,
                                SizeId = boxSizeId,
                                SupplierId = boxSupplierId,
                                CurrentState = 0,
                                WarehouseId = boxWarehouseId,
                                ReloadBoxingState = 1
                            };
                            _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);

                            var purchaseEpcList = new List<CommonJpPurchaseEpc>();
                            foreach (var invInfo in entity.invList)
                            {
                                if (bool.TryParse(invInfo.isUnboxingLabel, out bool isUnboxingLabel) && isUnboxingLabel)
                                {
                                    //拆箱生成标签
                                    string epc = invInfo.epc;
                                    var inventory = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == epc);
                                    if (inventory == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效拆箱标签");
                                    }
                                    inventory.IsInBox = true;
                                    inventory.BoxMarkId = boxMark.Id;
                                    _unitOfWork.EquipmentInventoryRepository.Update(inventory, false);
                                }
                                else
                                {

                                    string epc = invInfo.epc ?? "";
                                    var epcData = _unitOfWork.DbContext.CommonJpPurchaseEpcs
                                        .Include(x => x.Detail)
                                        .Include(x => x.Detail.Order)
                                        .Include(x => x.Detail.Order.Org)
                                        .Include(x => x.Detail.Size)
                                        .Include(x => x.Detail.Order.Warehouse)
                                        .FirstOrDefault(t => t.Epc == epc && t.CurrentState == 0);

                                    if (epcData == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"无效打印标签");
                                    }
                                    purchaseEpcList.Add(epcData);
                                }
                            }

                            //统一处理采购epc
                            if (purchaseEpcList.Count > 0)
                            {
                                foreach (var group in purchaseEpcList.GroupBy(x => x.DetailId))
                                {

                                    var detailObj = _unitOfWork.DbContext.CommonJpPurchaseDetails
                                        .Include(x => x.Order)
                                        .Include(x => x.CommonJpPurchaseEpcs)
                                        .FirstOrDefault(x => x.Id == group.Key);
                                    int purchaseCount = detailObj.RealCount ?? 0;
                                    foreach (var epcObj in group)
                                    {
                                        //创建物资
                                        List<CommonJpEquipmentState> state = new List<CommonJpEquipmentState>();
                                        state.Add(new CommonJpEquipmentState
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            PicUrl = "",
                                            PurchaseId = epcObj.DetailId,
                                            EqiupmentId = epcObj.Detail?.EquipmentId,
                                            OutInState = 1,
                                            State = 5,
                                            OrderCode = epcObj.Detail?.Order?.OrderCode,
                                            IntoTime = DateTime.Now,
                                            PoliceId = policeId,
                                            CreateTime = DateTime.Now,
                                            ActionState = 1,
                                            WarehouseId = epcObj.Detail?.Order?.WarehouseId,
                                            OrgId = epcObj.Detail?.Order?.OrgId,
                                        });
                                        _unitOfWork.EquipmentInventoryRepository.Insert(new CommonJpEquipmentInventory
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            Epc = epcObj.Epc,
                                            SupplierCode = epcObj.SupplierId,
                                            EquipmentCode = epcObj.Detail?.EquipmentId,
                                            WarehouseCode = epcObj.Detail?.Order?.WarehouseId,
                                            EquipmentLocation = 0,
                                            CurrentState = 0,
                                            CreateTime = DateTime.Now,
                                            CreateUser = policeId,
                                            EquipmentSizecode = epcObj.Detail?.SizeId,
                                            UpdateUser = policeId,
                                            CommonJpEquipmentStates = state,
                                            Price = epcObj.Price,
                                            ProductTime = epcObj.ProductTime,
                                            UseTime = epcObj.UseTime,
                                            UseDirection = epcObj.UseDirection,
                                            WarrantyCycle = epcObj.WarrantyCycle,
                                            RepairCycle = epcObj.RepairCycle,
                                            BoxMarkId = boxMark.Id,
                                            IsInBox = true,
                                            InstantiationState = 1,
                                            ShelfId = epcObj.ShelfId,
                                            ShelfRange = epcObj.ShelfRange,
                                            ShelfRow = epcObj.ShelfRow,
                                            ShelfColumn = epcObj.ShelfColumn,
                                            OrgId = epcObj.Detail?.Order?.OrgId,
                                        }, false);
                                        epcObj.CurrentState = 2;
                                        purchaseCount++;
                                    }
                                    detailObj.RealCount = purchaseCount;
                                    if (detailObj.CommonJpPurchaseEpcs.All(p => p.CurrentState == 2) && detailObj.State != 1)
                                    {
                                        //子单据完成
                                        detailObj.State = 1;
                                        if (detailObj.Order.CommonJpPurchaseDetails.Count(p => p.State.Equals(0) || p.State == null) <= 0)
                                        {
                                            //总单据完成
                                            detailObj.Order.CurrentState = 1;
                                        }
                                    }
                                    _unitOfWork.PurchaseDetailRepository.Update(detailObj, false);
                                }
                            }

                            var newInvList = _unitOfWork.DbContext.ChangeTracker.Entries()
                                .Where(x => x.Entity is CommonJpEquipmentInventory)
                                .Select(x => x.Entity as CommonJpEquipmentInventory)
                                .ToList();

                            if (newInvList.Any(x => !string.IsNullOrEmpty(x.ShelfId)))
                            {
                                //全体覆盖货架位置
                                var inv = newInvList.OrderBy(x => x.CreateTime).First(x => !string.IsNullOrEmpty(x.ShelfId));
                                foreach (var inventory in newInvList)
                                {
                                    inventory.ShelfId = inv.ShelfId;
                                    inventory.ShelfRange = inv.ShelfRange;
                                    inventory.ShelfRow = inv.ShelfRow;
                                    inventory.ShelfColumn = inv.ShelfColumn;
                                }
                            }

                            return _unitOfWork.SaveChanges() > 0
                                ? JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS)
                                : JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 拆箱还原epc inbox状态(多个epc,箱标限定）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UnpackRangeInventory")]
        public async Task<HttpResponseMessage> UnpackRangeInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity?.epc ?? "";

                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            var boxMark = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Epc == epc);
                            if (boxMark == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            var dataList =
                                _unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Include(x => x.BoxMark)
                                    .Where(x => x.BoxMark.Epc == epc)
                                    .ToList();

                            if (dataList.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"无对应物资，更新失败");
                            }
                            else
                            {
                                if (dataList.Count(x => x.CurrentState != 0) > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"物资状态不是在库，更新失败");
                                }

                                foreach (var inventory in dataList)
                                {
                                    inventory.IsInBox = false;
                                    inventory.BoxMarkId = null;
                                }

                                _unitOfWork.EquipmentInventoryRepository.Update(dataList, false);

                                var res = _unitOfWork.EquipmentBoxMarkRepository.Delete(boxMark, true);
                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 导入旧箱标数据（旧时间戳epc）
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ImportOldBoxMark")]
        public async Task<HttpResponseMessage> ImportOldBoxMark([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            var list = new List<dynamic>(entity.dataList);
                            if (list.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"dataList is require");
                            }

                            var successList = new List<dynamic>();
                            var failList = new List<dynamic>();

                            foreach (var data in list)
                            {
                                string boxMarkEpc = data.boxMarkEpc ?? "";
                                string epcListJson = data.epcListJson ?? "[]";
                                var epcList = JsonConvert.DeserializeObject<List<string>>(epcListJson);

                                if (string.IsNullOrEmpty(boxMarkEpc))
                                {
                                    return JsonManager.SimpleCustResponse($"boxMarkEpc is require");
                                }

                                if (_unitOfWork.EquipmentBoxMarkRepository.Any(x => x.OldEpc == boxMarkEpc))
                                {
                                    failList.Add(new
                                    {
                                        epc = boxMarkEpc,
                                        message = "该箱标已录入"
                                    });
                                    continue;
                                }

                                var invList = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Include(x => x.EquipmentSizecodeNavigation)
                                    .Include(x => x.EquipmentCodeNavigation)
                                    .Include(x => x.SupplierCodeNavigation)
                                    .Where(x => epcList.Contains(x.Epc))
                                    .ToList();
                                if (invList.Count == 0 || invList.Count != epcList.Count)
                                {
                                    failList.Add(new
                                    {
                                        epc = boxMarkEpc,
                                        message = "箱内物资数量错误"
                                    });
                                    continue;
                                }

                                foreach (var inventory in invList)
                                {
                                    if (inventory.IsInBox == false || !string.IsNullOrEmpty(inventory.BoxMarkId))
                                    {
                                        failList.Add(new
                                        {
                                            epc = boxMarkEpc,
                                            message = "箱内物资状态异常"
                                        });
                                        continue;
                                    }
                                }

                                var inv = invList.First();

                                var res = GenerateIntTagEpc(JObject.Parse($@"
                                            {{
                                            	""sizeCode"": ""{inv.EquipmentSizecodeNavigation.SizeCode}"",
                                            	""equCode"": ""{inv.EquipmentCodeNavigation.Code}"",
                                            	""supplierCode"": ""{inv.SupplierCodeNavigation.SupplierCode}"",
                                            	""quantity"": ""1"",
                                            	""productTime"": ""{inv.ProductTime.Value.ToString("yyyy-MM-dd")}"",
                                            	""warrantyCycle"": ""{inv.WarrantyCycle}"",
                                            	""labelType"": ""箱标"",
                                            	""oneBoxNum"": ""{invList.Count}""
                                            }}
                                        ")).Result;
                                var resBody = res.Content.ReadAsStringAsync().Result;

                                var obj = JObject.Parse(resBody);
                                if (obj["code"]?.Value<int>() != 10000)
                                {
                                    failList.Add(new
                                    {
                                        epc = boxMarkEpc,
                                        message = "箱标创建失败"
                                    });
                                    continue;
                                }

                                var xbEpc = obj["data"]?[0]?["epc"]?.Value<string>();

                                var boxMark = new CommonJpEquipmentBoxMark()
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    CreateTime = DateTime.Now,
                                    Epc = xbEpc,
                                    OneBoxNum = invList.Count,
                                    EquipmentDetailId = inv.EquipmentCode,
                                    SizeId = inv.EquipmentSizecode,
                                    SupplierId = inv.SupplierCode,
                                    CurrentState = 0,
                                    WarehouseId = inv.WarehouseCode,
                                    ReloadBoxingState = 2,
                                    OldEpc = boxMarkEpc
                                };

                                foreach (var inventory in invList)
                                {
                                    inventory.IsInBox = true;
                                    inventory.BoxMarkId = boxMark.Id;
                                }
                                _unitOfWork.EquipmentBoxMarkRepository.Insert(boxMark, false);
                                _unitOfWork.EquipmentInventoryRepository.Update(invList, false);

                                successList.Add(new
                                {
                                    epc = boxMarkEpc,
                                    message = ""
                                });
                            }

                            if (successList.Count > 0)
                            {
                                if (_unitOfWork.SaveChanges() == 0)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                }
                            }
                            return JsonManager.ReturnSuccessResponse(new
                            {
                                successList,
                                failList
                            });
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 通过EXCEL导入库存
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///   { "RFIDList": [{
        ///   "数量":"",
        ///   "保质期": "",
        ///   "装备名称": "",
        ///   "装备号型": "",
        ///   "生产厂家": "",
        ///   "组织机构名称": "",
        ///   "生产日期": "",
        ///   "仓库名称"：""
        ///   }]
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("InsertInventoryExcel")]
        [NoSign]
        public async Task<HttpResponseMessage> InsertInventoryExcel([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            var param = new string[] {
                          "BaseJpEquipmentSizes" ,
                          "BaseJpSupplierEquipments"
                         };
                            var paramOrg = new string[] {
                          "Orgization"
                         };
                            var paramsup = new string[] {

                         };
                            var paramwarehouse = new string[] {
                                "BaseJpWarehouses"
                         };

                            var EqdetailAll = _unitOfWork.EquipmentDetailRepository.GetList(p => p.Id != null, null, false, param);
                            var warehouseAll = _unitOfWork.WarehouseRepository.GetList(p => p.Id != null, null, false, paramOrg);
                            var orgAll = _unitOfWork.OrganizationRepository.GetList(p => p.Id != null, null, false, paramwarehouse);
                            List<Dictionary<string, string>> Rfids = new List<Dictionary<string, string>>();
                            List<CommonJpEquipmentInventory> inv = new List<CommonJpEquipmentInventory>();
                            List<string> invName = new List<string>();
                            foreach (var item in entity.RFIDList)
                            {
                                string name = item.装备名称;
                                string warehouse = item.仓库名称;
                                string orgName = item.组织机构名称;
                                var equipDetailName = EqdetailAll.Where(p => p.Name == name).FirstOrDefault();
                                if (equipDetailName == null)
                                {

                                    return JsonManager.SimpleCustResponse($"装备不存在:" + name);
                                }
                                string warehouseId = "";
                                var warehouseName = warehouseAll.Where(p => p.Name == warehouse).FirstOrDefault();
                                if (warehouseName == null)
                                {
                                    var org = orgAll.Where(p => p.Name == orgName).FirstOrDefault();
                                    if (org == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"组织机构不存在:" + orgName);
                                    }
                                    else
                                    {
                                        var exwarehouse = org.BaseJpWarehouses.FirstOrDefault();
                                        if (exwarehouse != null)
                                        {
                                            warehouseId = exwarehouse.Id;
                                        }
                                        else
                                        {
                                            BaseJpWarehouse ware = new BaseJpWarehouse()
                                            {
                                                Id = Guid.NewGuid().ToString(),

                                                Name = org.Name + "仓库",
                                                CreateTime = DateTime.Now,
                                                OrgizationId = org.Id,
                                                UpdateUser = "internal",
                                                UpdateTime = DateTime.Now
                                            };
                                            warehouseId = ware.Id;
                                            _unitOfWork.WarehouseRepository.Insert(ware, false);
                                        }
                                    }

                                }
                                else
                                {
                                    warehouseId = warehouseName.Id;
                                }
                                var size = equipDetailName.BaseJpEquipmentSizes.Where(p => p.SizeName == "无号配号").FirstOrDefault();
                                if (size == null)
                                {
                                    size = equipDetailName.BaseJpEquipmentSizes.FirstOrDefault();
                                    if (size == null)
                                    {
                                        return JsonManager.SimpleCustResponse($"该装备没有任何号型:" + equipDetailName.Name);
                                    }
                                }

                                for (int i = 0; i < int.Parse(item.数量); i++)
                                {

                                    CommonJpEquipmentInventory invNew = new CommonJpEquipmentInventory();
                                    invNew.Id = Guid.NewGuid().ToString();
                                    invNew.WarehouseCode = warehouseId;
                                    invNew.RepairCycle = int.Parse(item.保质期);
                                    invNew.Epc = Guid.NewGuid().ToString().ToUpper();
                                    invNew.Price = 100;
                                    invNew.UseDirection = 0;
                                    invNew.UpdateUser = "internal";
                                    invNew.CreateTime = DateTime.Now;
                                    invNew.CreateUser = "internal";
                                    invNew.IsBorrowed = false;
                                    invNew.WarrantyCycle = int.Parse(item.保质期);
                                    invNew.EquipmentSizecode = size.Id;
                                    invNew.EquipmentCode = equipDetailName.Id;
                                    invNew.UseTime = DateTime.Now;
                                    invNew.ProductTime = DateTime.Parse(item.生产日期);
                                    invNew.OrgId = warehouseName?.OrgizationId;
                                    //var ent = new CommonJpEquipmentInventory
                                    //{
                                    //    Id = Guid.NewGuid().ToString(),

                                    //    SupplierCode = item.,
                                    //    EquipmentCode = equId,
                                    //    WarehouseCode = warehouseId,
                                    //    EquipmentLocation = 0,
                                    //    CurrentState = 0,
                                    //    CreateTime = DateTime.Now,
                                    //    CreateUser = "internal",
                                    //    EquipmentSizecode = sizeId,
                                    //    UpdateUser = "internal",
                                    //    Price = price,
                                    //    ProductTime = productTime,
                                    //    UseTime = useTime,
                                    //    UseDirection = 0,
                                    //    WarrantyCycle = warrantyCycle,
                                    //    RepairCycle = repairCycle,
                                    //    IsBorrowed = false
                                    //};
                                    inv.Add(invNew);
                                }
                            }
                            int insertNum = 0;
                            var res = _unitOfWork.EquipmentInventoryRepository.InsertList(inv, out insertNum, true);

                            _logger.LogDebug("InsertInventoryExcel:" + "插入成功:" + insertNum.ToString());
                            if (res)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleCustResponse("数据写入失败");
                            }






                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 设置库存盘盈盘亏状态
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///    {
        ///    count:"",
        ///  "epc": "",
        ///"equId": "",
        ///"sizeId": "",
        ///"supplierId": "",
        ///"warehouseId": "",
        ///	"productTime": "",
        ///"warrantyCycle": "",
        ///"price": "",
        ///"useTime": "",
        ///"repairCycle": "",	
        ///}
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("InsertInventory")]
        [NoSign]
        public async Task<HttpResponseMessage> InsertInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string count = entity?.count ?? "";
                            string sizeId = entity?.sizeId ?? "";
                            string equId = entity?.equId ?? "";
                            string epc = entity?.epc ?? "";
                            string supplierId = entity?.supplierId ?? "";
                            string warehouseId = entity?.warehouseId ?? "";

                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            if (string.IsNullOrEmpty(sizeId))
                            {
                                return JsonManager.SimpleCustResponse($"无效号型");
                            }
                            else if (string.IsNullOrEmpty(equId))
                            {
                                return JsonManager.SimpleCustResponse($"无效装备");
                            }

                            else if (string.IsNullOrEmpty(supplierId))
                            {
                                return JsonManager.SimpleCustResponse($"无效供应商");
                            }
                            else if (string.IsNullOrEmpty(warehouseId))
                            {
                                return JsonManager.SimpleCustResponse($"无效仓库");
                            }
                            else if (!bRepair || repairCycle <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的装维保周期");
                            }
                            else if (!bPrice || price <= 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效的购入单价");
                            }
                            else if (!bWarranty || warrantyCycle < 0)   //质保周期可以为0
                            {
                                return JsonManager.SimpleCustResponse($"无效的质保周期");

                            }
                            else if (warrantyCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"质保周期不能超过999个月");
                            }
                            else if (repairCycle > 999)
                            {
                                return JsonManager.SimpleCustResponse($"维保周期不能超过999个月");
                            }
                            else if (!bUse || useTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效使用日期");
                            }
                            else if (!bProduct || productTime == default)
                            {
                                return JsonManager.SimpleCustResponse($"无效生产日期");
                            }
                            else
                            {
                                var warehouse = _unitOfWork.WarehouseRepository.Get(warehouseId);
                                List<CommonJpEquipmentInventory> inv = new List<CommonJpEquipmentInventory>();
                                for (int i = 0; i < int.Parse(count); i++)
                                {
                                    var ent = new CommonJpEquipmentInventory
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        Epc = epc,
                                        SupplierCode = supplierId,
                                        EquipmentCode = equId,
                                        WarehouseCode = warehouseId,
                                        EquipmentLocation = 0,
                                        CurrentState = 0,
                                        CreateTime = DateTime.Now,
                                        CreateUser = "internal",
                                        EquipmentSizecode = sizeId,
                                        UpdateUser = "internal",
                                        Price = price,
                                        ProductTime = productTime,
                                        UseTime = useTime,
                                        UseDirection = 0,
                                        WarrantyCycle = warrantyCycle,
                                        RepairCycle = repairCycle,
                                        IsBorrowed = false,
                                        OrgId = warehouse?.OrgizationId
                                    };
                                    inv.Add(ent);
                                }
                                int num = 0;
                                var res = _unitOfWork.EquipmentInventoryRepository.InsertList(inv, out num);
                                if (res)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("数据写入失败");
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 直接报废EPC
        /// </summary>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteInventory")]
        public async Task<HttpResponseMessage> DeleteInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity?.epc ?? "";
                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }
                            else
                            {
                                var _epc_info = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                    .Include(t => t.CommonJpEquipmentStates)
                                    .FirstOrDefault(t => t.Epc == epc);
                                if (_epc_info == null)
                                {
                                    return JsonManager.SimpleCustResponse($"无效EPC");
                                }
                                else if (_epc_info.CommonJpEquipmentStates.Count > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"存在出入库记录，无法删除");
                                }
                                else
                                {
                                    var res = _unitOfWork.EquipmentInventoryRepository.Delete(_epc_info);
                                    if (res)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleCustResponse("数据更新失败");
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 直接报废箱标EPC（包括箱内物资）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// {
        ///     "epc":"箱标epc"
        /// }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteInventoryByEpcList")]
        public async Task<HttpResponseMessage> DeleteInventoryByEpcList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else
                        {
                            string epc = entity.boxMarkEpc;
                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"EPC is require");
                            }

                            var boxMark = _unitOfWork.DbContext.CommonJpEquipmentBoxMarks
                                .Include(x => x.CommonJpEquipmentInventories)
                                .FirstOrDefault(x => x.Epc == epc);
                            if (boxMark == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            var epcInfoList = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Include(t => t.CommonJpEquipmentStates)
                                .Where(t => boxMark.CommonJpEquipmentInventories.Select(x => x.Epc).Contains(t.Epc))
                                .ToList();
                            if (epcInfoList.Count == 0)
                            {
                                return JsonManager.SimpleCustResponse($"无效EPC");
                            }

                            foreach (var inventory in epcInfoList)
                            {
                                if (inventory.CommonJpEquipmentStates.Count > 0)
                                {
                                    return JsonManager.SimpleCustResponse($"epc:{inventory.Epc}存在出入库记录，无法删除");
                                }
                            }
                            _unitOfWork.EquipmentInventoryRepository.Delete(epcInfoList, false);
                            //删除对应箱标
                            var res = _unitOfWork.EquipmentBoxMarkRepository.Delete(boxMark, true);
                            if (res)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleCustResponse("数据更新失败");
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 更新资产基础信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "资产ID",
        ///        "repairCycle":"维保周期-数字型",
        ///        "price":"购入单价-数字型",
        ///        "warrantyCycle" : "质保周期-数字型",
        ///        "useTime":"使用日期-时间类型",
        ///        "productTime": "生产日期-时间类型",
        ///         "shelfId":"货架id",
        ///         "range":"货架排位置",
        ///         "row":"货架行位置",
        ///         "column":"货架列位置",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("updateInventory")]
        public async Task<HttpResponseMessage> updateInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else
                        {
                            bool bProduct = DateTime.TryParse(entity?.productTime ?? "", out DateTime productTime);
                            bool bWarranty = int.TryParse(entity?.warrantyCycle ?? "0", out int warrantyCycle);
                            bool bPrice = decimal.TryParse(entity?.price ?? "0", out decimal price);
                            bool bUse = DateTime.TryParse(entity?.useTime ?? "", out DateTime useTime);
                            bool bRepair = int.TryParse(entity?.repairCycle ?? "0", out int repairCycle);

                            Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Id.Equals(id);
                            CommonJpEquipmentInventory updateObject = _unitOfWork.EquipmentInventoryRepository.Get(expression);
                            if (updateObject != null)
                            {

                                if (!(!bRepair || repairCycle <= 0))
                                {
                                    if (repairCycle > 999)
                                    {
                                        return JsonManager.SimpleCustResponse($"维保周期不能大于999");
                                    }
                                    updateObject.RepairCycle = repairCycle;//装维保周期
                                }
                                if (!(!bPrice || price <= 0))
                                {
                                    updateObject.Price = price;             //购入单价
                                }
                                if (!(!bWarranty || warrantyCycle < 0))
                                {
                                    if (warrantyCycle > 999)
                                    {
                                        return JsonManager.SimpleCustResponse($"质保周期不能大于999");
                                    }
                                    updateObject.WarrantyCycle = warrantyCycle; //质保周期
                                }
                                if (!(!bUse || useTime == default))
                                {
                                    updateObject.UseTime = useTime;           //使用日期
                                }
                                if (!(!bProduct || productTime == default))
                                {
                                    updateObject.ProductTime = productTime;   //生产日期
                                }

                                //updateObject.Address = entity.address;        //位置
                                //只有在库的能编辑位置信息
                                if (!string.IsNullOrEmpty(entity.shelfId) && updateObject.CurrentState == 0)
                                {
                                    string shelfId = entity.shelfId;
                                    var shelf = _unitOfWork.BaseJpShelfInfoRepository.Get(shelfId);
                                    if (shelf == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }

                                    if (int.TryParse(entity.range, out int range))
                                    {
                                        if (range > shelf.Range)
                                        {
                                            return JsonManager.SimpleCustResponse("排超过货架限制");
                                        }
                                        updateObject.ShelfRange = range;
                                    }
                                    else
                                    {
                                        updateObject.ShelfRange = null;
                                    }
                                    if (int.TryParse(entity.row, out int row))
                                    {
                                        if (row > shelf.Row)
                                        {
                                            return JsonManager.SimpleCustResponse("行超过货架限制");
                                        }
                                        updateObject.ShelfRow = row;
                                    }
                                    else
                                    {
                                        updateObject.ShelfRow = null;
                                    }
                                    if (int.TryParse(entity.column, out int column))
                                    {
                                        if (column > shelf.Column)
                                        {
                                            return JsonManager.SimpleCustResponse("列超过货架限制");
                                        }
                                        updateObject.ShelfColumn = column;
                                    }
                                    else
                                    {
                                        updateObject.ShelfColumn = null;
                                    }
                                    updateObject.ShelfId = shelf.Id;
                                }
                                else
                                {
                                    updateObject.ShelfId = null;
                                    updateObject.ShelfRange = null;
                                    updateObject.ShelfColumn = null;
                                    updateObject.ShelfRow = null;
                                }
                                //updateObject.CreateTime = System.DateTime.Now;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            bool result = _unitOfWork.EquipmentInventoryRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 批量通过epc更新物资位置信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///          "list": 
        ///          [
        ///              {
        ///                  "epc": "epc",
        ///                  "shelfId": "货架id",
        ///                  "address": "位置-字符"
        ///              }
        ///          ]
        ///      }
        ///      
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("BatchUpdateInventoryAddressByEpc")]
        //[NoSign]
        public async Task<HttpResponseMessage> BatchUpdateInventoryAddressByEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        var dataList = entity?.list;

                        var successList = new List<string>();
                        var errorList = new List<string>();

                        if (dataList == null || dataList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }

                        foreach (var item in dataList)
                        {
                            string epc = item?.epc;
                            string shelfId = item?.shelfId ?? "";
                            string address = item?.address ?? "";

                            if (string.IsNullOrEmpty(epc))
                            {
                                return JsonManager.SimpleCustResponse($"无效参数");
                            }



                            Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.Epc.Equals(epc);
                            CommonJpEquipmentInventory updateObject = _unitOfWork.EquipmentInventoryRepository.Get(expression);

                            if (updateObject == null)
                            {
                                return JsonManager.SimpleCustResponse($"无效epc");
                            }

                            updateObject.Address = address;
                            var shelf = _unitOfWork.BaseJpShelfInfoRepository.Get(x => x.Id.Equals(shelfId));
                            if (shelf != null)
                            {
                                //有效货架id，更新信息
                                updateObject.ShelfId = shelfId;
                            }
                            else
                            {
                                //无效货架，备注
                                updateObject.Address += " 未指定货架";
                            }
                            bool result = _unitOfWork.EquipmentInventoryRepository.Update(updateObject);

                            if (result)
                            {
                                successList.Add(epc);
                            }
                            else
                            {
                                errorList.Add(epc);
                            }
                        }
                        return JsonManager.ReturnSuccessResponse(new
                        {
                            successList,
                            errorList
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 检查epc是否已被实例化过
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "epc": "epc"
        ///     }
        ///     
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("CheckEpcIsInstantiation")]
        public async Task<HttpResponseMessage> CheckEpcIsInstantiation([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string epc = entity?.epc;
                        if (string.IsNullOrEmpty(epc))
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }

                        var inv = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == epc);
                        var purchaseEpc = _unitOfWork.PurchaseEpcsRepository.Get(x => x.Epc == epc && x.CurrentState != 0);
                        if (inv != null || purchaseEpc != null)
                        {
                            return JsonManager.SimpleCustResponse($"标签已绑定过装备");
                        }
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 创建epc（内部使用）
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        [HttpPost("GenEpcs")]
        [NoSign]
        [SwaggerIgnore]
        public async Task<HttpResponseMessage> GenEpcs([FromBody] GenEpcsModel model)
        {
            return await Task.Run(() =>
            {
                try
                {
                    var epcList = new List<GenerateEpcNum.GenEpcInfo>();
                    string msg = "";
                    switch (model.type)
                    {
                        case "JB":
                            {
                                epcList = GenerateEpcNum.GenEpcs(model.serverNum, model.equCode, model.supplierCode, model.sizeCode, model.productTime, out msg, model.wzsl);
                                break;
                            }
                        case "XB":
                            {
                                //redis读取今日BoxNo;
                                uint epcBoxNo = 0;
                                lock (_createEpcLockObj)
                                {
                                    var key = DateTime.Now.ToString("yyyyMMdd") + "BoxNo";
                                    string value = RedisCacheHelper.GetStringValue(key);
                                    epcBoxNo = uint.TryParse(value, out var boxNo) ? boxNo + 1 : 1;
                                    if (!RedisCacheHelper.SetStringValue(key, epcBoxNo.ToString(), ref msg))
                                    {
                                        throw new Exception("RedisCacheHelper Exception:" + msg);
                                    }
                                }
                                epcList = GenerateEpcNum.GenBoxMarkEpcs(model.serverNum, model.equCode, model.supplierCode, model.sizeCode, model.productTime, model.oneBoxNum, epcBoxNo, out msg, model.wzsl);
                                break;
                            }
                        default: return JsonManager.SimpleCustResponse("无效标签类型");
                    }

                    if (epcList.Count == model.wzsl)
                    {
                        return JsonManager.ReturnSuccessResponse(epcList);
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse(msg);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 直接操作物资信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///          "data":[
        ///                     {
        ///                      "editType":"ADD 新增 UPDATE 更新 DELETE 删除",
        ///                      "id":"", 
        ///                      "supplierCode":"", 
        ///                      "epc":"", 
        ///                      "policeCode":"", 
        ///                      "equipmentCode":"", 
        ///                      "warehouseCode":"", 
        ///                      "cabinetId":"目前忽略单警柜", 
        ///                      "equipmentSizecode":"", 
        ///                      "equipmentLocation":"", 
        ///                      "currentState":"", 
        ///                      "createTime":"", 
        ///                      "warrantyCycle":"", 
        ///                      "repairCycle":"",
        ///                      "productTime":"",
        ///                      "useTime":"",
        ///                      "price":"",
        ///                      "isBorrowed":"",
        ///                      "lostFlag":"",
        ///                      "inventoryState":"",
        ///                      "isInBox":"",
        ///                      "boxMarkId":"",
        ///                      "instantiationState":""
        ///                     }
        ///                 ],
        ///          "xbdata":[
        ///                     {
        ///                      "editType":"ADD 新增 UPDATE 更新 DELETE 删除",
        ///                      "id":"", 
        ///                      "createTime":"", 
        ///                      "epc":"", 
        ///                      "oneBoxNum":"", 
        ///                      "equipmentDetailId":"", 
        ///                      "sizeId":"", 
        ///                      "supplierId":"", 
        ///                      "currentState":"", 
        ///                      "warehouseId":""
        ///                     }
        ///                 ]
        ///      }
        ///      
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("EditInventory")]
        [SwaggerIgnore]
        public async Task<HttpResponseMessage> EditInventory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity.data == null && entity.xbdata == null)
                        {
                            return JsonManager.SimpleCustResponse($"无效参数");
                        }

                        var addList = new List<CommonJpEquipmentInventory>();
                        var updateList = new List<CommonJpEquipmentInventory>();
                        var deleteList = new List<CommonJpEquipmentInventory>();
                        if (entity.data is IEnumerable)
                        {
                            foreach (var item in entity.data)
                            {
                                string editType = item.editType ?? "";
                                string id = item.id ?? "";
                                string supplierCode = item.supplierCode ?? "";
                                string epc = item.epc ?? "";
                                string policeCode = string.IsNullOrEmpty(item.policeCode) ? null : item.policeCode;
                                string equipmentCode = item.equipmentCode ?? "";
                                string warehouseCode = item.warehouseCode ?? "";
                                string cabinetId = null;// item.cabinetId ?? "";
                                string equipmentSizecode = item.equipmentSizecode ?? "";
                                bool bEquipmentLocation = int.TryParse(item.equipmentLocation ?? "", out int equipmentLocation);
                                bool bCurrentState = int.TryParse(item.currentState ?? "", out int currentState);
                                bool bCreateTime = DateTime.TryParse(item.createTime ?? "", out DateTime createTime);
                                bool bWarrantyCycle = int.TryParse(item.warrantyCycle ?? "", out int warrantyCycle);
                                bool bRepairCycle = int.TryParse(item.repairCycle ?? "", out int repairCycle);
                                bool bProductTime = DateTime.TryParse(item.productTime ?? "", out DateTime productTime);
                                bool bUseTime = DateTime.TryParse(item.useTime ?? "", out DateTime useTime);
                                bool bPrice = decimal.TryParse(item.price ?? "", out decimal price);
                                bool bIsBorrowed = bool.TryParse(item.isBorrowed ?? "", out bool isBorrowed);
                                bool bLostFlag = bool.TryParse(item.lostFlag ?? "", out bool lostFlag);
                                string inventoryState = item.inventoryState ?? "";
                                bool bIsInBox = bool.TryParse(item.isInBox ?? "", out bool isInBox);
                                string boxMarkId = string.IsNullOrEmpty(item.boxMarkId) ? null : item.boxMarkId;
                                bool bInstantiationState = int.TryParse(item.instantiationState ?? "", out int instantiationState);

                                if (editType == "UPDATE")
                                {
                                    //更新
                                    var old = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Id == id);
                                    var warehouse = _unitOfWork.WarehouseRepository.Get(x => x.Id == warehouseCode);
                                    old.PoliceCode = policeCode;
                                    old.WarehouseCode = warehouseCode;
                                    old.CabinetId = cabinetId;
                                    old.EquipmentLocation = equipmentLocation;
                                    old.CurrentState = currentState;
                                    old.WarrantyCycle = warrantyCycle;
                                    old.RepairCycle = repairCycle;
                                    old.ProductTime = productTime;
                                    old.UseTime = useTime;
                                    old.Price = price;
                                    old.IsBorrowed = isBorrowed;
                                    old.LostFlag = lostFlag;
                                    old.InventoryState = inventoryState;
                                    old.IsInBox = isInBox;
                                    old.BoxMarkId = boxMarkId;
                                    old.InstantiationState = instantiationState;
                                    old.OrgId = warehouse?.OrgizationId;
                                    updateList.Add(old);
                                }
                                if (editType == "ADD")
                                {
                                    //新增
                                    var warehouse = _unitOfWork.WarehouseRepository.Get(x => x.Id == warehouseCode);
                                    addList.Add(new CommonJpEquipmentInventory
                                    {
                                        Id = id,
                                        SupplierCode = supplierCode,
                                        Epc = epc,
                                        PoliceCode = policeCode,
                                        EquipmentCode = equipmentCode,
                                        WarehouseCode = warehouseCode,
                                        OrgId = warehouse?.OrgizationId,
                                        CabinetId = cabinetId,
                                        EquipmentSizecode = equipmentSizecode,

                                        CreateUser = "internal",
                                        UpdateUser = "internal",

                                        EquipmentLocation = equipmentLocation,
                                        CurrentState = currentState,
                                        CreateTime = createTime,
                                        WarrantyCycle = warrantyCycle,
                                        RepairCycle = repairCycle,
                                        ProductTime = productTime,
                                        UseTime = useTime,
                                        Price = price,
                                        IsBorrowed = isBorrowed,
                                        LostFlag = lostFlag,
                                        InventoryState = inventoryState,
                                        IsInBox = isInBox,
                                        BoxMarkId = boxMarkId,
                                        InstantiationState = instantiationState,
                                    });
                                }
                                if (editType == "DELETE")
                                {
                                    //删除
                                    var old = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Id == id);
                                    if (old != null)
                                    {
                                        deleteList.Add(old);
                                    }
                                }
                            }

                            _unitOfWork.EquipmentInventoryRepository.Insert(addList, false);
                            _unitOfWork.EquipmentInventoryRepository.Update(updateList, false);
                            _unitOfWork.EquipmentInventoryRepository.Delete(deleteList, false);
                        }

                        var xbAddList = new List<CommonJpEquipmentBoxMark>();
                        var xbUpdateList = new List<CommonJpEquipmentBoxMark>();
                        var xbDeleteList = new List<CommonJpEquipmentBoxMark>();
                        if (entity.xbdata is IEnumerable)
                        {
                            foreach (var item in entity.xbdata)
                            {
                                string editType = item.editType ?? "";
                                string id = item.id ?? "";
                                string bCreateTime = DateTime.TryParse(item.createTime ?? "", out DateTime createTime);
                                string epc = item.epc ?? "";
                                string bOneBoxNum = int.TryParse(item.oneBoxNum ?? "", out int oneBoxNum);
                                string equipmentDetailId = item.equipmentDetailId ?? "";
                                string sizeId = item.sizeId ?? "";
                                string supplierId = item.supplierId ?? "";
                                bool bCurrentState = int.TryParse(item.currentState ?? "", out int currentState);
                                string warehouseId = item.warehouseId ?? "";
                                bool bReloadBoxingState = int.TryParse(item.reloadBoxingState ?? "", out int reloadBoxingState);

                                if (editType == "UPDATE")
                                {
                                    //更新
                                    var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Id == id);
                                    old.ReloadBoxingState = reloadBoxingState;
                                    xbUpdateList.Add(old);
                                }
                                if (editType == "ADD")
                                {
                                    //新增
                                    xbAddList.Add(new CommonJpEquipmentBoxMark()
                                    {
                                        Id = id,
                                        CreateTime = createTime,
                                        Epc = epc,
                                        OneBoxNum = oneBoxNum,
                                        EquipmentDetailId = equipmentDetailId,
                                        SizeId = sizeId,
                                        SupplierId = supplierId,
                                        CurrentState = currentState,
                                        WarehouseId = warehouseId,
                                        ReloadBoxingState = reloadBoxingState,
                                    });
                                }
                                if (editType == "DELETE")
                                {
                                    //删除
                                    var old = _unitOfWork.EquipmentBoxMarkRepository.Get(x => x.Id == id);
                                    if (old != null)
                                    {
                                        xbDeleteList.Add(old);
                                    }
                                }
                            }

                            _unitOfWork.EquipmentBoxMarkRepository.Insert(xbAddList, false);
                            _unitOfWork.EquipmentBoxMarkRepository.Update(xbUpdateList, false);
                            _unitOfWork.EquipmentBoxMarkRepository.Delete(xbDeleteList, false);
                        }

                        _unitOfWork.SaveChanges();
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"无效参数");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }
        /// <summary>
        /// 检查epc是否符合epc生成规则
        /// </summary>
        /// <param name="epc"></param>
        /// <param name="equId"></param>
        /// <returns></returns>
        private bool CheckEpc(string epc, string equId)
        {
            var param = new string[] {
                "Equipment",
                "BaseJpSupplierEquipments"
            };

            var equInfos = _unitOfWork.EquipmentDetailRepository.GetList(x => true, t => t.UpdateTime, false, param).ToList();

            if (epc.Length == 64)
            {
                var buffer = EpcConvert.ToHexByte(epc);
                var epc_info = EpcConvert.EpcAnlysing(buffer);
                if (epc_info != null)
                {
                    var equ_info = equInfos.FirstOrDefault(t => t.Code == epc_info.Wzdm.ToString("X"));
                    if (equ_info != null && equ_info.Id == equId)
                    {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    public class EpcInfo
    {
        public string supplierName { get; set; }
        public DateTime useTime { get; set; }
        public DateTime productTime { get; set; }
        public int warrantyCycle { get; set; }
        public int repairCycle { get; set; }
        public decimal price { get; set; }
        public int num { get; set; }
        public string detailId { get; set; }
        public string supplierId { get; set; }
        public string epc { get; set; }
    }

    public class EpcRecordInfo
    {
        public string equCode { get; set; }
        public string sizeCode { get; set; }
        public string suppilerCode { get; set; }
        public string suppilerName { get; set; }
        public DateTime? productTime { get; set; }
        public DateTime? useTime { get; set; }
        public int warrantyCycle { get; set; }
        public int repairCycle { get; set; }
        public decimal price { get; set; }
        public string epc { get; set; }
    }

    public class CtBaseResponse
    {
        public int code { get; set; }
        public string message { get; set; }
    }
    public class CtBaseResponse<T> : CtBaseResponse where T : new()
    {
        public CtBaseResponse()
        {
            data = new T();
        }
        public T data { get; set; }
    }
    public class CtEqpInfo
    {
        public string equipmentCode { get; set; }
        public DateTime tUpdateTime { get; set; }
        public string orderId { get; set; }
        public string typeName { get; set; }
        public string supplierCode { get; set; }
        public DateTime productTime { get; set; }
        public string orgizationId { get; set; }
        public string warehouseName { get; set; }
        public string warehouseCode { get; set; }
        public string sizeName { get; set; }
        public string orgCode { get; set; }
        public decimal price { get; set; }
        public string epc { get; set; }
        public DateTime useTime { get; set; }
        public string equipmentName { get; set; }
        public int useCount { get; set; }
        public string supplierName { get; set; }
        public int warrantyCycle { get; set; }
        public string address { get; set; }
        public string gs1Code { get; set; }
        public int fixCount { get; set; }
        public int repairCycle { get; set; }
        public string cabinetChildNum { get; set; }
        public DateTime tCreateTime { get; set; }
        public string name { get; set; }
        public string typeId { get; set; }
        public string sizeCode { get; set; }
        public string currentState { get; set; }
        public string cabinetNum { get; set; }
    }

    public class GenEpcsModel
    {
        /// <summary>
        /// JB  件标
        /// XB  箱标
        /// </summary>
        public string type { get; set; }
        public byte serverNum { get; set; }
        public ulong equCode { get; set; }
        public string supplierCode { get; set; }
        public ulong sizeCode { get; set; }
        public uint productTime { get; set; }
        public int wzsl { get; set; }
        /// <summary>
        /// 单箱箱内物资数量 箱标必传
        /// </summary>
        public uint oneBoxNum { get; set; }
    }
}