﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.SqlServer;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using System;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class BaseChargeController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<EquipmentDetailController> _logger;
        UnitOfWork _unitOfWork;

        public BaseChargeController(ILogger<EquipmentDetailController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }


        /// <summary>
        /// 上报充电信息第三方
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "orgId":"组织机构代码",
        ///        "equName" : "装备名称",
        ///        "equCode" : "装备代码",
        ///        "epc" : "EPC",
        ///        "startTime":"充电开始时间"，
        ///        "endTime":"充电结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddChargeDevelop")]
        [ServiceFilter(typeof(ActionLimitAttribute))]

        public async Task<HttpResponseMessage> AddChargeDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    //if (jdata != null)
                    //{
                    //    var entity = JsonManager.GetJsonEntity(jdata);

                    //    if (entity == null)
                    //    {
                    //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    //    }

                    //    //第三方调用接口验证orgId正确性
                    //    if (!string.IsNullOrEmpty(entity._PUSHORG))
                    //    {
                    //        if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                    //        {
                    //            return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                    //        }
                    //    }

                    //    if (string.IsNullOrEmpty(entity.orgId ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"orgId is require");
                    //    }
                    //    else if (string.IsNullOrEmpty(entity.equName ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"equName is require");
                    //    }
                    //    else if (string.IsNullOrEmpty(entity.equCode ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"equCode is require");
                    //    }
                    //    else if (string.IsNullOrEmpty(entity.epc ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"epc is require");
                    //    }
                    //    else if (string.IsNullOrEmpty(entity.startTime ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"startTime is require");
                    //    }
                    //    else if (string.IsNullOrEmpty(entity.endTime ?? ""))
                    //    {
                    //        return JsonManager.SimpleCustResponse($"endTime is require");
                    //    }
                    //    else
                    //    {
                    //        string startTime = entity.startTime;
                    //        //新增数据
                    //        BaseCharge addObject = new BaseCharge()
                    //        {
                    //            Id = Guid.NewGuid(),
                    //            OrgId = entity.orgId,
                    //            EquName = entity.equName,
                    //            EquCode = entity.equCode,
                    //            Epc = entity.epc,
                    //            StartTime = Convert.ToDateTime(startTime),
                    //            EndTime = System.DateTime.Now
                    //        };

                    //        bool result = _unitOfWork.BaseChargeRepository.Insert(addObject);

                    //        if (result)
                    //        {
                    //            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                    //        }
                    //        else
                    //        {
                    //            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    //        }
                    //    }
                    //}
                    //else
                    //{
                    //    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    //}

                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 上报充电信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "orgId":"组织机构代码",
        ///        "equName" : "装备名称",
        ///        "equCode" : "装备代码",
        ///        "epc" : "EPC",
        ///        "startTime":"充电开始时间"，
        ///        "endTime":"充电结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddCharge")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> AddCharge([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.equName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"equName is require");
                        }
                        else if (string.IsNullOrEmpty(entity.equCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"equCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.epc ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"epc is require");
                        }
                        else if (string.IsNullOrEmpty(entity.startTime ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"startTime is require");
                        }
                        else if (string.IsNullOrEmpty(entity.endTime ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"endTime is require");
                        }
                        else
                        {
                            string startTime = entity.startTime;
                            //新增数据
                            BaseCharge addObject = new BaseCharge()
                            {
                                Id = Guid.NewGuid(),
                                OrgId = entity.orgId,
                                EquName = entity.equName,
                                EquCode = entity.equCode,
                                Epc = entity.epc,
                                StartTime = Convert.ToDateTime(startTime),
                                EndTime = System.DateTime.Now
                            };

                            bool result = _unitOfWork.BaseChargeRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取充电台统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构ID",
        ///         "equName":"资产名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetChargeList")]
        public async Task<HttpResponseMessage> GetChargeList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseCharge, bool>> expression = t => !t.Id.Equals("");

                        if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            string orgId = entity.orgId.ToString();
                            expression = LambdaExtensions.AndAlso(expression, t => t.OrgId.Equals(orgId));
                        }

                        if (!String.IsNullOrEmpty(entity.equName))
                        {
                            string equName = entity.equName.ToString();
                            expression = LambdaExtensions.AndAlso(expression, t => t.EquName.Contains(equName));
                        }


                        var chargeList = _unitOfWork.BaseChargeRepository.GetList(expression, t => t.EquCode).ToList();

                        var data = chargeList.GroupBy(c => c.EquCode).Select(c => new
                        {
                            c.Key,
                            c.FirstOrDefault().EquName,
                            scCount = c.Sum(t => EF.Functions.DateDiffHour(t.StartTime, t.EndTime)),
                            csCount = c.Count()
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}
