﻿using JmpModel.Model;
using JmpModel.Model.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using JmpModel.Model.DataContext;
using JunmpPoliceStation.Controllers;
using Newtonsoft.Json;
using System.Net;
using JmpCommon;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Rextec.SOA.Infrastructure;
using System.Linq.Expressions;
using Microsoft.Extensions.DependencyInjection;
using Newtonsoft.Json.Linq;
using JmpCommon.Tools;
using MQTTnet.Server;
using Hangfire.MemoryStorage.Database;

namespace JunmpPoliceStation.Extensions
{
    public class ChannelExtension
    {
        private static readonly object pushLockObj = new object();
        /// <summary>
        /// 跨库归还出库
        /// </summary>
        /// <param name="returnBoReality"></param>
        /// <param name="trreOutRealDetailEpcList"></param>
        /// <param name="reOutBoEpcList"></param>
        /// <param name="UpdateReTrReal"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> ReturnTransferOut(List<CommonJpTransferDetailReality> returnBoReality, List<CommonJpTransferDetailReality> trreOutRealDetailEpcList, List<CommonJpEquipmentInventory> reOutBoEpcList, ref List<CommonJpTransferDetailReality> UpdateReTrReal, ref List<CommonJpEquipmentInventory> OuterInvens, ref List<CommonJpEquipmentInventory> UpdateEpc, string picUrl, string policeId, string warehouseId, string orgId)
        {
            bool removeResult = false;//是否已移除
            int brCount = trreOutRealDetailEpcList.Count > 0 ? trreOutRealDetailEpcList.First().RealCount : 0;
            foreach (var realityItem in trreOutRealDetailEpcList)
            {
                var currentEpcList = reOutBoEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                if (currentEpcList.Count > 0)
                {
                    brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                    List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                    foreach (var invenItem in currentEpcList)
                    {

                        brCount++;

                        invenItem.CurrentState = 17;
                        invenItem.EquipmentLocation = 3;//外出
                        invenItem.UpdateUser = policeId;
                        if (trreOutRealDetailEpcList.Count.Equals(0))
                        {
                            OuterInvens.Add(invenItem);

                        }
                        else
                        {
                            invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                            {
                                Id = Guid.NewGuid().ToString(),
                                PicUrl = picUrl,
                                TransferId = realityItem.Id,
                                OrderCode = realityItem.Reality?.Order,
                                OutTime = DateTime.Now,
                                OrgId = orgId,
                                WarehouseId = warehouseId,
                                State = 1,
                                PoliceId = policeId,
                                EqiupmentId = invenItem.Id,
                                CreateTime = DateTime.Now,
                                ActionState = 17,
                                OutInState = 0,
                                HistorySafeLevel = invenItem.SafeLevel
                            });
                            UpdateEpc.Add(invenItem);
                            OuterInvens.Remove(invenItem);
                            tempInv.Add(invenItem);
                            if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                            {
                                realityItem.RealCount = brCount;
                                realityItem.State = 1;

                                brCount = 0;

                                removeResult = true;

                                if (realityItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                {
                                    realityItem.Reality.CurrentState = 1;
                                }
                                UpdateReTrReal.Add(realityItem);
                                returnBoReality.Add(realityItem);
                                break;
                            }


                        }

                    }
                    if (trreOutRealDetailEpcList.Count > 0 && removeResult.Equals(false))
                    {

                        realityItem.RealCount = brCount;
                        UpdateReTrReal.Add(realityItem);
                        returnBoReality.Add(realityItem);

                    }

                    removeResult = false;
                    brCount = 0;//完成后重置计数状态

                    foreach (var item in tempInv)//记录过的库存全部清除
                    {
                        reOutBoEpcList.Remove(item);
                    }
                    //delay.Add(new DelayClose { id = trreOutRealDetailEpcList.FirstOrDefault().RealityId, type = 1, warehouse = warehouseId });
                }

            }


            return returnBoReality;


        }


        /// <summary>
        /// 归还入库
        /// </summary>
        /// <param name="UpdateReTrReal"></param>
        /// <param name="ReturnIntoRealDetailEpcList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> ReturnTransferIn(List<CommonJpTransferDetailReality> UpdateReTrReal, List<CommonJpTransferDetailReality> ReturnIntoRealDetailEpcList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> InsideInvens, string picUrl, string policeId, string warehouseId, string orgId)
        {
            foreach (var InsideItem in InsideInvens)//找出本批物资中归还入库的物资
            {
                var trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();
                if ((InsideItem.CurrentState.Equals(17)) && InsideItem.CommonJpEquipmentStates.Count > 0)
                {
                    var transferId = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.TransferId;
                    if (trIntoRealDetailEpcItem.Id == null || trIntoRealDetailEpcItem.Id != transferId)
                    {
                        trIntoRealDetailEpcItem = ReturnIntoRealDetailEpcList.Where(p => p.State.Equals(1) && p.Id.Equals(transferId)).FirstOrDefault();//找出本批物资中对应的归还单

                    }
                    if (trIntoRealDetailEpcItem == null)
                    {
                        continue;
                    }
                    if (trIntoRealDetailEpcItem.ReceivedWarehouseId.Equals(warehouseId))
                    {

                        InsideItem.IsBorrowed = false;
                        InsideItem.CurrentState = 0;
                        InsideItem.EquipmentLocation = 0;
                        InsideItem.UpdateUser = policeId;
                        InsideItem.WarehouseCode = warehouseId;
                        if (trIntoRealDetailEpcItem.InsideRealCount == null)
                        {
                            trIntoRealDetailEpcItem.InsideRealCount = 0;
                        }
                        trIntoRealDetailEpcItem.InsideRealCount++;
                        if (trIntoRealDetailEpcItem.InsideRealCount.Equals(trIntoRealDetailEpcItem.RealCount))
                        {


                            trIntoRealDetailEpcItem.State = 2;
                            if (trIntoRealDetailEpcItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(1) || p.State.Equals(0)).ToList().Count() <= 0)
                            {
                                trIntoRealDetailEpcItem.Reality.CurrentState = 2;
                            }
                            UpdateReTrReal.Add(trIntoRealDetailEpcItem);//更新归还入库的表单状态
                            trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();

                            ReturnIntoRealDetailEpcList.ToList().Remove(ReturnIntoRealDetailEpcList.Where(p => p.Id.Equals(transferId)).FirstOrDefault());
                        }
                        if (ReturnIntoRealDetailEpcList.Count() > 0 && trIntoRealDetailEpcItem.Id != null)
                        {
                            UpdateReTrReal.Add(trIntoRealDetailEpcItem);//更新归还入库的表单状态
                        }

                        InsideItem.CommonJpEquipmentStates?.Add(new CommonJpEquipmentState//新增一条记录表
                        {

                            Id = Guid.NewGuid().ToString(),
                            PicUrl = picUrl,
                            TransferId = transferId,
                            OrderCode = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Transfer?.Reality?.Order,
                            IntoTime = DateTime.Now,
                            OrgId = orgId,
                            WarehouseId = warehouseId,
                            State = 0,
                            EqiupmentId = InsideItem.Id,
                            CreateTime = DateTime.Now,
                            ActionState = 18,
                            OutInState = 1,
                            PoliceId = policeId,
                            HistorySafeLevel = InsideItem.SafeLevel
                        });
                        UpdateEpc.Add(InsideItem);
                    }
                }
            }
            foreach (var item in UpdateEpc)
            {
                InsideInvens.Remove(item);
            }
            return UpdateReTrReal;
        }
        /// <summary>
        /// 跨库借用出库
        /// </summary>
        /// <param name="tempboReality"></param>
        /// <param name="trboOutRealDetailEpcList"></param>
        /// <param name="trOutBoEpcList"></param>
        /// <param name="UpdateboTrReal"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> BorrowTransferOut(List<CommonJpTransferDetailReality> tempboReality, List<CommonJpTransferDetailReality> trboOutRealDetailEpcList, List<CommonJpEquipmentInventory> trOutBoEpcList, ref List<CommonJpTransferDetailReality> UpdateboTrReal, ref List<CommonJpEquipmentInventory> OuterInvens, ref List<CommonJpEquipmentInventory> UpdateEpc, string picUrl, string policeId, string warehouseId, string orgId)
        {

            bool removeResult = false;//是否已移除
            int brCount = trboOutRealDetailEpcList.Count > 0 ? trboOutRealDetailEpcList.First().RealCount : 0;
            foreach (var realityItem in trboOutRealDetailEpcList)
            {
                brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                var currentEpcList = trOutBoEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                if (currentEpcList.Count > 0)
                {
                    List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                    foreach (var invenItem in currentEpcList)
                    {

                        brCount++;
                        invenItem.IsBorrowed = true;
                        invenItem.CurrentState = 15;
                        invenItem.EquipmentLocation = 3;//外出
                        invenItem.UpdateUser = policeId;
                        if (trboOutRealDetailEpcList.Count.Equals(0))
                        {
                            OuterInvens.Add(invenItem);

                        }
                        else
                        {
                            invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                            {
                                Id = Guid.NewGuid().ToString(),
                                PicUrl = picUrl,
                                TransferId = realityItem.Id,
                                OrderCode = realityItem?.Reality?.Order,
                                OutTime = DateTime.Now,
                                OrgId = orgId,
                                WarehouseId = warehouseId,
                                State = 1,
                                PoliceId = policeId,
                                EqiupmentId = invenItem.Id,
                                CreateTime = DateTime.Now,
                                ActionState = 15,
                                OutInState = 0,
                                HistorySafeLevel = invenItem.SafeLevel
                            });

                            UpdateEpc.Add(invenItem);
                            OuterInvens.Remove(invenItem);
                            tempInv.Add(invenItem);
                            if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                            {
                                realityItem.RealCount = brCount;
                                realityItem.State = 1;

                                brCount = 0;

                                removeResult = true;

                                if (realityItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                {
                                    realityItem.Reality.CurrentState = 1;
                                }
                                UpdateboTrReal.Add(realityItem);
                                tempboReality.Add(realityItem);
                                break;
                            }


                        }

                    }
                    if (trboOutRealDetailEpcList.Count > 0 && removeResult.Equals(false))
                    {

                        realityItem.RealCount = brCount;
                        UpdateboTrReal.Add(realityItem);
                        tempboReality.Add(realityItem);

                    }

                    removeResult = false;
                    brCount = 0;//完成后重置计数状态

                    foreach (var item in tempInv)//记录过的库存全部清除
                    {
                        trOutBoEpcList.Remove(item);
                    }



                }

            }

            return tempboReality;




        }
        /// <summary>
        /// 跨库借用入库
        /// </summary>
        /// <param name="UpdateTrReal"></param>
        /// <param name="UpdateboTrReal"></param>
        /// <param name="trIntoRealDetailEpcList"></param>
        /// <param name="boOutIntoRealDetailEpcList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> BorrowTransferIn(List<CommonJpTransferDetailReality> UpdateboTrReal, List<CommonJpTransferDetailReality> boOutIntoRealDetailEpcList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> InsideInvens, string picUrl, string policeId, string warehouseId, string orgId)
        {
            foreach (var InsideItem in InsideInvens)//找出本批物资中跨库借用入库的物资
            {
                var trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();
                var lastState = InsideItem.CommonJpEquipmentStates.Where(p => p.ActionState != 5).OrderByDescending(p => p.CreateTime).FirstOrDefault();
                if ((InsideItem.CurrentState.Equals(15) || lastState.ActionState.Equals(15)) && InsideItem.CommonJpEquipmentStates.Count > 0)
                {
                    var transferId = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.TransferId;
                    if (trIntoRealDetailEpcItem.Id == null || trIntoRealDetailEpcItem.Id != transferId)
                    {
                        trIntoRealDetailEpcItem = boOutIntoRealDetailEpcList.Where(p => p.State.Equals(1) && p.Id.Equals(transferId)).FirstOrDefault();//找出本批物资中对应的调拨单

                    }
                    if (trIntoRealDetailEpcItem == null)
                    {
                        continue;
                    }
                    if (trIntoRealDetailEpcItem.Reality.ReceiveWarehouseId.Equals(warehouseId))
                    {


                        InsideItem.CurrentState = 0;
                        InsideItem.EquipmentLocation = 0;
                        InsideItem.UpdateUser = policeId;
                        InsideItem.WarehouseCode = warehouseId;
                        if (trIntoRealDetailEpcItem.InsideRealCount == null)
                        {
                            trIntoRealDetailEpcItem.InsideRealCount = 0;
                        }
                        trIntoRealDetailEpcItem.InsideRealCount++;
                        if (trIntoRealDetailEpcItem.InsideRealCount.Equals(trIntoRealDetailEpcItem.RealCount))
                        {


                            trIntoRealDetailEpcItem.State = 2;
                            if (trIntoRealDetailEpcItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(1) || p.State.Equals(0)).ToList().Count() <= 0)
                            {
                                trIntoRealDetailEpcItem.Reality.CurrentState = 2;
                            }
                            UpdateboTrReal.Add(trIntoRealDetailEpcItem);//更新调拨入库的表单状态
                            trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();

                            boOutIntoRealDetailEpcList.Remove(boOutIntoRealDetailEpcList.Where(p => p.Id.Equals(transferId)).FirstOrDefault());
                        }
                        if (boOutIntoRealDetailEpcList.Count > 0 && trIntoRealDetailEpcItem.Id != null)
                        {
                            UpdateboTrReal.Add(trIntoRealDetailEpcItem);//更新调拨入库的表单状态
                        }

                        InsideItem.CommonJpEquipmentStates?.Add(new CommonJpEquipmentState//新增一条记录表
                        {

                            Id = Guid.NewGuid().ToString(),
                            PicUrl = picUrl,
                            TransferId = transferId,
                            IntoTime = DateTime.Now,
                            OrgId = orgId,
                            WarehouseId = warehouseId,
                            State = 0,
                            PoliceId = policeId,
                            EqiupmentId = InsideItem.Id,
                            CreateTime = DateTime.Now,
                            ActionState = 16,
                            OutInState = 1,
                            OrderCode = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Transfer?.Reality?.Order,
                            HistorySafeLevel = InsideItem.SafeLevel
                        });
                        UpdateEpc.Add(InsideItem);
                    }
                }


            }
            foreach (var item in UpdateEpc)
            {
                InsideInvens.Remove(item);
            }
            return UpdateboTrReal;
        }
        /// <summary>
        /// 调拨出库
        /// </summary>
        /// <param name="trOutRealDetailEpcList"></param>
        /// <param name="trOutRealEpcList"></param>
        /// <param name="UpdateTrReal"></param>
        /// <param name="tempReality"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> TransferOut(UnitOfWork _unitOfWork, List<CommonJpTransferDetailReality> trOutRealDetailEpcList, List<CommonJpEquipmentInventory> trOutRealEpcList, ref List<CommonJpTransferDetailReality> UpdateTrReal, List<CommonJpTransferDetailReality> tempReality, ref List<CommonJpEquipmentInventory> OuterInvens, ref List<CommonJpEquipmentInventory> UpdateEpc, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            bool removeResult = false;//是否已移除
            int brCount = trOutRealDetailEpcList.Count > 0 ? trOutRealDetailEpcList.First().RealCount : 0;
            foreach (var realityItem in trOutRealDetailEpcList)
            {
                brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                var currentEpcList = trOutRealEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                if (currentEpcList.Count > 0)
                {
                    List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                    foreach (var invenItem in currentEpcList)
                    {

                        brCount++;
                        invenItem.CurrentState = 1;
                        invenItem.EquipmentLocation = 3;//外出
                        invenItem.UpdateUser = policeId;
                        if (trOutRealDetailEpcList.Count.Equals(0))
                        {
                            OuterInvens.Add(invenItem);

                        }
                        else
                        {
                            invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                            {
                                Id = Guid.NewGuid().ToString(),
                                PicUrl = picUrl,
                                TransferId = realityItem.Id,
                                OutTime = DateTime.Now,
                                OrgId = orgId,
                                WarehouseId = warehouseId,
                                State = 1,
                                PoliceId = policeId,
                                EqiupmentId = invenItem.Id,
                                CreateTime = DateTime.Now,
                                ActionState = 4,
                                OutInState = 0,
                                OrderCode = realityItem.Reality?.Order,
                                HistorySafeLevel = invenItem.SafeLevel
                            });
                            UpdateEpc.Add(invenItem);
                            OuterInvens.Remove(invenItem);
                            tempInv.Add(invenItem);
                            if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                            {
                                realityItem.RealCount = brCount;
                                realityItem.State = 1;

                                brCount = 0;

                                removeResult = true;

                                if (realityItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                {
                                    realityItem.Reality.CurrentState = 1;
                                    //更新redis上货架相关数据
                                    //UpdateOpenOrderInvInfo(_unitOfWork, warehouseId, "none", "", out string msg);
                                }
                                UpdateTrReal.Add(realityItem);
                                tempReality.Add(realityItem);
                                break;
                            }


                        }

                    }

                    if (trOutRealDetailEpcList.Count > 0 && removeResult.Equals(false))
                    {

                        realityItem.RealCount = brCount;
                        UpdateTrReal.Add(realityItem);
                        tempReality.Add(realityItem);

                    }
                    removeResult = false;
                    brCount = 0;//完成后重置计数状态

                    foreach (var item in tempInv)//记录过的库存全部清除
                    {
                        trOutRealEpcList.Remove(item);
                    }

                }

            }
            return tempReality;
        }
        /// <summary>
        /// 调拨入库
        /// </summary>
        /// <param name="UpdateTrReal"></param>
        /// <param name="trIntoRealDetailEpcList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpTransferDetailReality> TransferIn(List<CommonJpTransferDetailReality> UpdateTrReal, List<CommonJpTransferDetailReality> trIntoRealDetailEpcList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> InsideInvens, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            foreach (var InsideItem in InsideInvens)//找出本批物资中调拨入库的物资
            {
                var trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();
                var lastState = InsideItem.CommonJpEquipmentStates.Where(p => p.ActionState != 5).OrderByDescending(p => p.CreateTime).FirstOrDefault();
                if ((InsideItem.CurrentState.Equals(1) || (lastState.ActionState.Equals(4) && lastState.OutInState.Equals(0))) && InsideItem.CommonJpEquipmentStates.Count > 0)
                {
                    var transferId = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.TransferId;
                    if (trIntoRealDetailEpcItem == null || trIntoRealDetailEpcItem.Id == null || trIntoRealDetailEpcItem.Id != transferId)
                    {
                        trIntoRealDetailEpcItem = trIntoRealDetailEpcList.Where(p => p.State.Equals(1) && p.Id.Equals(transferId)).FirstOrDefault();//找出本批物资中对应的调拨单

                    }
                    if (trIntoRealDetailEpcItem == null)
                    {
                        continue;
                    }
                    if (trIntoRealDetailEpcItem.Reality.ReceiveWarehouseId.Equals(warehouseId) && trIntoRealDetailEpcItem.State.Equals(1))
                    {


                        InsideItem.CurrentState = 0;
                        InsideItem.EquipmentLocation = 0;
                        InsideItem.UpdateUser = policeId;
                        InsideItem.WarehouseCode = warehouseId;
                        InsideItem.OrgId = orgId;
                        if (trIntoRealDetailEpcItem.InsideRealCount == null)
                        {
                            trIntoRealDetailEpcItem.InsideRealCount = 0;
                        }
                        trIntoRealDetailEpcItem.InsideRealCount++;
                        if (trIntoRealDetailEpcItem.InsideRealCount.Equals(trIntoRealDetailEpcItem.RealCount))
                        {


                            trIntoRealDetailEpcItem.State = 2;
                            if (trIntoRealDetailEpcItem.Reality.CommonJpTransferDetailRealities.Where(p => p.State.Equals(1) || p.State.Equals(0)).ToList().Count() <= 0)
                            {
                                trIntoRealDetailEpcItem.Reality.CurrentState = 2;
                            }
                            UpdateTrReal.Add(trIntoRealDetailEpcItem);//更新调拨入库的表单状态
                            trIntoRealDetailEpcItem = new CommonJpTransferDetailReality();

                            trIntoRealDetailEpcList.Remove(trIntoRealDetailEpcList.Where(p => p.Id.Equals(transferId)).FirstOrDefault());
                        }
                        if (trIntoRealDetailEpcList.Count > 0 && trIntoRealDetailEpcItem.Id != null)
                        {
                            UpdateTrReal.Add(trIntoRealDetailEpcItem);//更新调拨入库的表单状态
                        }

                        InsideItem.CommonJpEquipmentStates?.Add(new CommonJpEquipmentState//新增一条记录表
                        {
                            Id = Guid.NewGuid().ToString(),
                            PicUrl = picUrl,
                            TransferId = transferId,
                            IntoTime = DateTime.Now,
                            OrgId = orgId,
                            OrderCode = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Transfer?.Reality?.Order,
                            WarehouseId = warehouseId,
                            State = 0,
                            EqiupmentId = InsideItem.Id,
                            CreateTime = DateTime.Now,
                            ActionState = 4,
                            OutInState = 1,
                            PoliceId = policeId,
                            HistorySafeLevel = InsideItem.SafeLevel
                        });
                        if (InsideItem.BoxMark != null)
                        {
                            InsideItem.BoxMark.WarehouseId = InsideItem.WarehouseCode;
                        }

                        UpdateEpc.Add(InsideItem);
                    }
                }


            }
            foreach (var item in UpdateEpc)
            {
                InsideInvens.Remove(item);
            }
            return UpdateTrReal;
        }

        /// <summary>
        /// 借用出库
        /// </summary>
        /// <param name="_unitOfWork"></param>
        /// <param name="brRealOutList"></param>
        /// <param name="brRealEpcDetailList"></param>
        /// <param name="brOutRealEpcList"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="UpdateBoReal"></param>
        /// <param name="boIntoRealDetailEpcList"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <param name="unitOfWork"></param>
        /// <returns></returns>
        public static List<CommonJpBorrowReturnDetailReality> BorrowOut(UnitOfWork _unitOfWork, List<CommonJpBorrowReturnDetailReality> brRealOutList, List<CommonJpBorrowReturnDetailReality> brRealEpcDetailList, List<CommonJpEquipmentInventory> brOutRealEpcList, ref List<CommonJpEquipmentInventory> OuterInvens, ref List<CommonJpEquipmentInventory> UpdateEpc, List<CommonJpBorrowReturnDetailReality> UpdateBoReal, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            foreach (var item in brRealOutList)
            {
                var outList = OuterInvens.Where(x => !brOutRealEpcList.Contains(x)
                && x.EquipmentCode.Equals(item.EquipmentDetailId) && x.CurrentState.Equals(0) && (x.IsBorrowed.Equals(false) || x.IsBorrowed == null)).ToList();//找出本批物资中借用出库的物资
                brOutRealEpcList.AddRange(outList);
                if (!brRealEpcDetailList.Contains(item) && (item.State.Equals(0) || item.State == null))
                {
                    brRealEpcDetailList.Add(item);
                }
            }
            List<CommonJpBorrowReturnDetailReality> borrowtempReality = new List<CommonJpBorrowReturnDetailReality>();
            if (brRealEpcDetailList.Count > 0)//如果没有计划表就不遍历
            {
                bool removeResult = false;//是否已移除
                int brCount = 0;
                if (brRealEpcDetailList.Count > 0)
                {
                    brCount = Convert.ToInt32(brRealEpcDetailList.FirstOrDefault().RealCount);
                }
                //brCount = brRealEpcDetailList.Count > 0 ? brRealEpcDetailList.First().RealCount : 0;
                foreach (var realityItem in brRealEpcDetailList)
                {
                    brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                    List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                    var currentEpcList = brOutRealEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                    if (currentEpcList.Count > 0)
                    {
                        foreach (var invenItem in currentEpcList)
                        {

                            brCount++;
                            invenItem.CurrentState = 2;
                            invenItem.EquipmentLocation = 3;//外出
                            invenItem.PoliceCode = realityItem.Reality?.PolicemanId;
                            invenItem.UpdateUser = policeId;
                            if (brRealEpcDetailList.Count.Equals(0))
                            {
                                OuterInvens.Add(invenItem);

                            }
                            else
                            {
                                invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    PicUrl = picUrl,
                                    BorrowId = realityItem.Id,
                                    OutTime = DateTime.Now,
                                    OrgId = orgId,
                                    OrderCode = realityItem?.Reality?.OrderCode,
                                    WarehouseId = warehouseId,
                                    State = 1,
                                    PoliceId = policeId,
                                    EqiupmentId = invenItem.Id,
                                    CreateTime = DateTime.Now,
                                    ActionState = 2,
                                    OutInState = 0,
                                    HistorySafeLevel = invenItem.SafeLevel
                                });
                                UpdateEpc.Add(invenItem);
                                OuterInvens.Remove(invenItem);
                                tempInv.Add(invenItem);
                                if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                                {
                                    realityItem.RealCount = brCount;
                                    realityItem.State = 1;

                                    brCount = 0;
                                    removeResult = true;
                                    if (realityItem.Reality.CommonJpBorrowReturnDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                    {
                                        realityItem.Reality.CurrentState = 1;
                                        //更新redis上货架相关数据
                                        //UpdateOpenOrderInvInfo(_unitOfWork, warehouseId, "none", "", out string msg);
                                    }
                                    UpdateBoReal.Add(realityItem);
                                    borrowtempReality.Add(realityItem);
                                    break;
                                }

                            }

                        }
                        if (brRealEpcDetailList.Count > 0 && removeResult.Equals(false))
                        {

                            realityItem.RealCount = brCount;
                            UpdateBoReal.Add(realityItem);
                            borrowtempReality.Add(realityItem);

                        }

                        removeResult = false;
                        brCount = 0;//完成后重置计数状态

                        foreach (var item in currentEpcList)//记录过的库存全部清除
                        {
                            brOutRealEpcList.Remove(item);
                        }


                    }


                }

            }

            foreach (var item in borrowtempReality)
            {
                brRealEpcDetailList.Remove(item);
            }
            return UpdateBoReal;
        }
        /// <summary>
        /// 报废出库
        /// </summary>
        /// <param name="brRealOutList"></param>
        /// <param name="brRealEpcDetailList"></param>
        /// <param name="brOutRealEpcList"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="UpdateBoReal"></param>
        /// <param name="boIntoRealDetailEpcList"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public static List<CommonJpBorrowReturnDetailReality> ScrapOut(List<CommonJpBorrowReturnDetailReality> brRealOutList, List<CommonJpBorrowReturnDetailReality> brRealEpcDetailList, List<CommonJpEquipmentInventory> brOutRealEpcList, ref List<CommonJpEquipmentInventory> OuterInvens, ref List<CommonJpEquipmentInventory> UpdateEpc, List<CommonJpBorrowReturnDetailReality> UpdateBoReal, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            string parent = Guid.NewGuid().ToString();
            var insertFlag = false;
            CommonJpEquipmentState parentState = new CommonJpEquipmentState
            {
                Id = parent,
                PicUrl = picUrl,
                OutInState = 0,
                State = 2,
                IntoTime = DateTime.Now,
                PoliceId = policeId,
                CreateTime = DateTime.Now,
                ActionState = 7,
                WarehouseId = warehouseId,
                OrgId = orgId,
            };
            foreach (var item in brRealOutList)
            {
                var outList = OuterInvens.Where(x => !brOutRealEpcList.Contains(x)
                && x.EquipmentCode.Equals(item.EquipmentDetailId) && x.CurrentState.Equals(0) && (x.IsBorrowed.Equals(false) || x.IsBorrowed == null)).ToList();//找出本批物资中借用出库的物资
                brOutRealEpcList.AddRange(outList);
                if (!brRealEpcDetailList.Contains(item) && (item.State.Equals(0) || item.State == null))
                {
                    brRealEpcDetailList.Add(item);
                }
            }
            List<CommonJpBorrowReturnDetailReality> borrowtempReality = new List<CommonJpBorrowReturnDetailReality>();
            if (brRealEpcDetailList.Count > 0)//如果没有计划表就不遍历
            {
                bool removeResult = false;//是否已移除
                int brCount = 0;
                if (brRealEpcDetailList.Count > 0)
                {
                    brCount = Convert.ToInt32(brRealEpcDetailList.FirstOrDefault().RealCount);
                }
                //brCount = brRealEpcDetailList.Count > 0 ? brRealEpcDetailList.First().RealCount : 0;
                foreach (var realityItem in brRealEpcDetailList)
                {
                    brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                    List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                    var currentEpcList = brOutRealEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                    if (currentEpcList.Count > 0)
                    {
                        foreach (var invenItem in currentEpcList)
                        {

                            brCount++;
                            invenItem.CurrentState = 2;
                            invenItem.EquipmentLocation = 3;//外出
                            invenItem.PoliceCode = realityItem.Reality?.PolicemanId;
                            invenItem.UpdateUser = policeId;
                            if (brRealEpcDetailList.Count.Equals(0))
                            {
                                OuterInvens.Add(invenItem);

                            }
                            else
                            {
                                invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                                {
                                    ParentId = parent,
                                    Id = Guid.NewGuid().ToString(),
                                    PicUrl = picUrl,
                                    BorrowId = realityItem.Id,
                                    OutTime = DateTime.Now,
                                    OrgId = orgId,
                                    OrderCode = realityItem?.Reality?.OrderCode,
                                    WarehouseId = warehouseId,
                                    State = 1,
                                    PoliceId = policeId,
                                    EqiupmentId = invenItem.Id,
                                    CreateTime = DateTime.Now,
                                    ActionState = 2,
                                    OutInState = 0,
                                    HistorySafeLevel = invenItem.SafeLevel
                                });
                                insertFlag = true;
                                UpdateEpc.Add(invenItem);
                                OuterInvens.Remove(invenItem);
                                tempInv.Add(invenItem);
                                if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                                {
                                    realityItem.RealCount = brCount;
                                    realityItem.State = 1;

                                    brCount = 0;
                                    removeResult = true;
                                    if (realityItem.Reality.CommonJpBorrowReturnDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                    {
                                        realityItem.Reality.CurrentState = 1;
                                    }
                                    UpdateBoReal.Add(realityItem);
                                    borrowtempReality.Add(realityItem);
                                    break;
                                }

                            }

                        }
                        if (brRealEpcDetailList.Count > 0 && removeResult.Equals(false))
                        {

                            realityItem.RealCount = brCount;
                            UpdateBoReal.Add(realityItem);
                            borrowtempReality.Add(realityItem);

                        }

                        removeResult = false;
                        brCount = 0;//完成后重置计数状态

                        foreach (var item in currentEpcList)//记录过的库存全部清除
                        {
                            brOutRealEpcList.Remove(item);
                        }


                    }


                }

            }

            foreach (var item in borrowtempReality)
            {
                brRealEpcDetailList.Remove(item);
            }

            if (insertFlag)
            {
                unitOfWork.EquipmentStateRepository.Insert(parentState, false);
            }

            return UpdateBoReal;
        }
        /// <summary>
        /// 借用入库
        /// </summary>
        /// <param name="UpdateEpc"></param>
        /// <param name="UpdateBoReal"></param>
        /// <param name="boIntoRealDetailEpcList"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <param name="InsertEpc"></param>
        /// <param name="ErrorEq"></param>
        /// <returns></returns>
        public static List<CommonJpBorrowReturnDetailReality> BorrowIn(ref List<CommonJpEquipmentInventory> UpdateEpc, List<CommonJpBorrowReturnDetailReality> UpdateBoReal, List<CommonJpBorrowReturnDetailReality> boIntoRealDetailEpcList, ref List<CommonJpEquipmentInventory> InsideInvens, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            foreach (var InsideItem in InsideInvens)//找出本批物资中借用入库的物资
            {
                var borrowIntoRealDetailEpcItem = new CommonJpBorrowReturnDetailReality();
                var lastState = InsideItem.CommonJpEquipmentStates.Where(p => p.ActionState != 5).OrderByDescending(p => p.CreateTime).FirstOrDefault();

                if ((InsideItem.CurrentState.Equals(2) || (lastState.ActionState.Equals(2) && lastState.OutInState.Equals(0))) && InsideItem.CommonJpEquipmentStates.Count > 0)
                {
                    var borrowId = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null && p.BorrowId != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.BorrowId;
                    var borrowReId = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null && p.BorrowId != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Borrow.RealityId;
                    if (borrowIntoRealDetailEpcItem.Id == null || borrowIntoRealDetailEpcItem.Id != borrowId)
                    {
                        borrowIntoRealDetailEpcItem = boIntoRealDetailEpcList.Where(p => p.State.Equals(1) && p.Id.Equals(borrowId))?.FirstOrDefault();//找出本批物资中对应的调拨单
                    }
                    if (borrowIntoRealDetailEpcItem == null)
                    {
                        continue;
                    }
                    //if (borrowIntoRealDetailEpcItem.Reality.Org.BaseJpWarehouses.Where(p => p.Id.Contains(warehouseId)).Count() > 0)
                    if (borrowIntoRealDetailEpcItem.Reality.WarehouseId.Equals(warehouseId))
                    {
                        InsideItem.CurrentState = 0;
                        InsideItem.EquipmentLocation = 0;
                        InsideItem.UpdateUser = policeId;
                        InsideItem.WarehouseCode = warehouseId;
                        InsideItem.PoliceCode = null;   //借用归还清空人员绑定
                        if (borrowIntoRealDetailEpcItem.InsideRealCount == null)
                        {
                            borrowIntoRealDetailEpcItem.InsideRealCount = 0;
                        }
                        borrowIntoRealDetailEpcItem.InsideRealCount++;
                        if (borrowIntoRealDetailEpcItem.InsideRealCount.Equals(borrowIntoRealDetailEpcItem.RealCount))
                        {
                            var newBorrowItem = boIntoRealDetailEpcList.Where(p => p.State < 2 && p.RealityId.Equals(borrowReId))?.FirstOrDefault();
                            borrowIntoRealDetailEpcItem.State = 2;
                            if (newBorrowItem.Reality.CommonJpBorrowReturnDetailRealities.Where(p => p.State.Equals(1) || p.State.Equals(0)).ToList().Count() <= 0)
                            {
                                borrowIntoRealDetailEpcItem.Reality.CurrentState = 2;
                            }
                            UpdateBoReal.Add(borrowIntoRealDetailEpcItem);//更新借用入库的表单状态
                            borrowIntoRealDetailEpcItem = new CommonJpBorrowReturnDetailReality();
                            boIntoRealDetailEpcList.Remove(boIntoRealDetailEpcList.Where(p => p.Id.Equals(borrowId)).FirstOrDefault());
                        }
                        if (boIntoRealDetailEpcList.Count > 0 && borrowIntoRealDetailEpcItem.Id != null)
                        {
                            UpdateBoReal.Add(borrowIntoRealDetailEpcItem);//更新借用入库的表单状态
                        }

                        InsideItem.CommonJpEquipmentStates?.Add(new CommonJpEquipmentState//新增一条记录表
                        {
                            Id = Guid.NewGuid().ToString(),
                            PicUrl = picUrl,
                            BorrowId = borrowId,
                            IntoTime = DateTime.Now,
                            OrgId = orgId,
                            OrderCode = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null && p.BorrowId != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Borrow?.Reality?.OrderCode,
                            WarehouseId = warehouseId,
                            State = 1,
                            EqiupmentId = InsideItem.Id,
                            CreateTime = DateTime.Now,
                            ActionState = 2,
                            OutInState = 1,
                            PoliceId = policeId,
                            HistorySafeLevel = InsideItem.SafeLevel
                        });
                        UpdateEpc.Add(InsideItem);
                    }
                }
            }

            foreach (var item in UpdateEpc)
            {
                InsideInvens.Remove(item);
            }
            return UpdateBoReal;

        }
        /// <summary>
        /// 领用
        /// </summary>
        /// <param name="_unitOfWork"></param>
        /// <param name="UpdateBoReal"></param>
        /// <param name="reRealList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="brOutRealEpcList"></param>
        /// <param name="fixInRealList"></param>
        /// <param name="reRealEpcDetailList"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="Rfids"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <param name="InsertEpc"></param>
        /// <param name="ErrorEq"></param>
        public static List<CommonJpBorrowReturnDetailReality> Recipients(UnitOfWork _unitOfWork, List<CommonJpBorrowReturnDetailReality> UpdateBoReal, List<CommonJpBorrowReturnDetailReality> reRealList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> brOutRealEpcList, List<CommonJpBorrowReturnDetailReality> reRealEpcDetailList, ref List<CommonJpEquipmentInventory> OuterInvens, string picUrl, string policeId, string warehouseId, string orgId)
        {
            var RealEpcList = brOutRealEpcList;
            foreach (var item in reRealList)
            {
                var outList = OuterInvens.Where(x => !RealEpcList.Contains(x)
                && x.EquipmentCode.Equals(item.EquipmentDetailId) && x.CurrentState.Equals(0) && (x.IsBorrowed.Equals(false) || x.IsBorrowed == null)).ToList();//找出本批物资中借用出库的物资
                RealEpcList.AddRange(outList);
                if (!reRealEpcDetailList.Contains(item) && (item.State.Equals(0) || item.State == null))
                {
                    reRealEpcDetailList.Add(item);
                }

            }

            List<CommonJpBorrowReturnDetailReality> borrowGetTempReality = new List<CommonJpBorrowReturnDetailReality>();
            if (reRealEpcDetailList.Count > 0)//如果没有计划表就不遍历
            {
                bool removeResult = false;//是否已移除
                int brCount = 0;
                if (reRealEpcDetailList.Count > 0)
                {
                    brCount = Convert.ToInt32(reRealEpcDetailList.FirstOrDefault().RealCount);
                }

                foreach (var realityItem in reRealEpcDetailList)
                {

                    var currentEpcList = RealEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                    if (currentEpcList.Count > 0)
                    {

                        if (realityItem.Estimate.ChangeFlag.Equals(0))
                        {
                            realityItem.Estimate.ChangeFlag = 1;
                            _unitOfWork.BorrowReturnApplyRepository.Update(realityItem.Estimate, true);
                        }
                        brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                        List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                        foreach (var invenItem in currentEpcList)
                        {

                            brCount++;
                            invenItem.PoliceCode = realityItem.Reality?.Apply?.PoliceId;
                            if (realityItem.Reality?.Apply?.IsBindCabinet == true)
                            {
                                var police = _unitOfWork.PolicemanRepository.Get(invenItem.PoliceCode);
                                if (police != null && !string.IsNullOrEmpty(police.CabinetId))
                                {
                                    //绑定单警柜
                                    invenItem.CabinetId = police.CabinetId;
                                    invenItem.CurrentState = 7;
                                    invenItem.EquipmentLocation = 3;//外出
                                }
                                else
                                {
                                    //无效设置，不绑定单警柜
                                    invenItem.CurrentState = 8;
                                    invenItem.EquipmentLocation = 3;//外出
                                }
                            }
                            else
                            {
                                invenItem.CurrentState = 8;
                                invenItem.EquipmentLocation = 3;//外出
                            }

                            invenItem.UpdateUser = policeId;
                            if (reRealEpcDetailList.Count.Equals(0))
                            {
                                OuterInvens.Add(invenItem);

                            }
                            else
                            {
                                invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    PicUrl = picUrl,
                                    BorrowId = realityItem.Id,
                                    OutTime = DateTime.Now,
                                    OrgId = orgId,
                                    OrderCode = realityItem?.Reality?.OrderCode,
                                    WarehouseId = warehouseId,
                                    State = 1,
                                    PoliceId = policeId,
                                    EqiupmentId = invenItem.Id,
                                    CreateTime = DateTime.Now,
                                    ActionState = 3,
                                    OutInState = 0,
                                    HistorySafeLevel = invenItem.SafeLevel
                                });
                                UpdateEpc.Add(invenItem);
                                OuterInvens.Remove(invenItem);
                                tempInv.Add(invenItem);
                                if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                                {
                                    realityItem.RealCount = brCount;
                                    realityItem.State = 1;

                                    brCount = 0;

                                    removeResult = true;
                                    if (realityItem.Reality.CommonJpBorrowReturnDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                    {
                                        realityItem.Reality.CurrentState = 1;
                                        //更新redis上货架相关数据
                                        //UpdateOpenOrderInvInfo(_unitOfWork, warehouseId, "none", "", out string msg);
                                    }
                                    UpdateBoReal.Add(realityItem);
                                    borrowGetTempReality.Add(realityItem);
                                    break;
                                }



                            }

                        }
                        if (reRealEpcDetailList.Count > 0 && removeResult.Equals(false))
                        {

                            realityItem.RealCount = brCount;
                            UpdateBoReal.Add(realityItem);
                            borrowGetTempReality.Add(realityItem);

                        }

                        removeResult = false;
                        brCount = 0;//完成后重置计数状态

                        foreach (var item in tempInv)//记录过的库存全部清除
                        {
                            RealEpcList.Remove(item);
                        }


                        //delay.Add(new DelayClose { id = reRealEpcDetailList.FirstOrDefault().RealityId, type = 2, warehouse = warehouseId });
                    }
                }
                brOutRealEpcList = RealEpcList;
            }


            foreach (var item in borrowGetTempReality)
            {
                reRealEpcDetailList.Remove(item);
            }
            return UpdateBoReal;

        }
        /// <summary>
        /// 销毁出库
        /// </summary>
        /// <param name="_unitOfWork"></param>
        /// <param name="UpdateBoReal"></param>
        /// <param name="reRealList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="brOutRealEpcList"></param>
        /// <param name="fixInRealList"></param>
        /// <param name="reRealEpcDetailList"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="Rfids"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <param name="InsertEpc"></param>
        /// <param name="ErrorEq"></param>
        public static List<CommonJpBorrowReturnDetailReality> Destruction(UnitOfWork _unitOfWork, List<CommonJpBorrowReturnDetailReality> UpdateBoReal, List<CommonJpBorrowReturnDetailReality> reRealList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> brOutRealEpcList, List<CommonJpBorrowReturnDetailReality> reRealEpcDetailList, ref List<CommonJpEquipmentInventory> OuterInvens, string picUrl, string policeId, string warehouseId, string orgId)
        {
            var RealEpcList = brOutRealEpcList;
            foreach (var item in reRealList)
            {
                var outList = OuterInvens.Where(x => !RealEpcList.Contains(x)
                && x.EquipmentCode.Equals(item.EquipmentDetailId) && x.CurrentState.Equals(0) && (x.IsBorrowed.Equals(false) || x.IsBorrowed == null)).ToList();//找出本批物资中借用出库的物资
                RealEpcList.AddRange(outList);
                if (!reRealEpcDetailList.Contains(item) && (item.State.Equals(0) || item.State == null))
                {
                    reRealEpcDetailList.Add(item);
                }

            }

            List<CommonJpBorrowReturnDetailReality> borrowGetTempReality = new List<CommonJpBorrowReturnDetailReality>();
            if (reRealEpcDetailList.Count > 0)//如果没有计划表就不遍历
            {
                bool removeResult = false;//是否已移除
                int brCount = 0;
                if (reRealEpcDetailList.Count > 0)
                {
                    brCount = Convert.ToInt32(reRealEpcDetailList.FirstOrDefault().RealCount);
                }

                foreach (var realityItem in reRealEpcDetailList)
                {

                    var currentEpcList = RealEpcList.Where(p => p.EquipmentCode.Equals(realityItem.EquipmentDetailId)).ToList();//当前出库单中的物资信息
                    if (currentEpcList.Count > 0)
                    {

                        if (realityItem.Estimate.ChangeFlag.Equals(0))
                        {
                            realityItem.Estimate.ChangeFlag = 1;
                            _unitOfWork.BorrowReturnApplyRepository.Update(realityItem.Estimate, true);
                        }
                        brCount = Convert.ToInt32(realityItem.RealCount == null ? 0 : realityItem.RealCount);
                        List<CommonJpEquipmentInventory> tempInv = new List<CommonJpEquipmentInventory>();
                        foreach (var invenItem in currentEpcList)
                        {

                            brCount++;
                            invenItem.CurrentState = 6;
                            invenItem.EquipmentLocation = 3;//外出
                            invenItem.PoliceCode = realityItem.Reality?.Apply?.PoliceId;
                            invenItem.UpdateUser = policeId;
                            if (reRealEpcDetailList.Count.Equals(0))
                            {
                                OuterInvens.Add(invenItem);

                            }
                            else
                            {
                                invenItem.CommonJpEquipmentStates.Add(new CommonJpEquipmentState//新增一条记录表
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    PicUrl = picUrl,
                                    BorrowId = realityItem.Id,
                                    OutTime = DateTime.Now,
                                    OrgId = orgId,
                                    OrderCode = realityItem?.Reality?.OrderCode,
                                    WarehouseId = warehouseId,
                                    State = 1,
                                    PoliceId = policeId,
                                    EqiupmentId = invenItem.Id,
                                    CreateTime = DateTime.Now,
                                    ActionState = 25,
                                    OutInState = 0,
                                    HistorySafeLevel = invenItem.SafeLevel
                                });
                                UpdateEpc.Add(invenItem);
                                OuterInvens.Remove(invenItem);
                                tempInv.Add(invenItem);
                                if (brCount >= realityItem.EquipmentCount)//如果增加的数量大于计划表的数量，则更新计划表并更换下一个计划表
                                {
                                    realityItem.RealCount = brCount;
                                    realityItem.State = 1;

                                    brCount = 0;

                                    removeResult = true;
                                    if (realityItem.Reality.CommonJpBorrowReturnDetailRealities.Where(p => p.State.Equals(0)).ToList().Count() <= 0)
                                    {
                                        realityItem.Reality.CurrentState = 1;
                                    }
                                    UpdateBoReal.Add(realityItem);
                                    borrowGetTempReality.Add(realityItem);
                                    break;
                                }



                            }

                        }
                        if (reRealEpcDetailList.Count > 0 && removeResult.Equals(false))
                        {

                            realityItem.RealCount = brCount;
                            UpdateBoReal.Add(realityItem);
                            borrowGetTempReality.Add(realityItem);

                        }

                        removeResult = false;
                        brCount = 0;//完成后重置计数状态

                        foreach (var item in tempInv)//记录过的库存全部清除
                        {
                            RealEpcList.Remove(item);
                        }


                        //delay.Add(new DelayClose { id = reRealEpcDetailList.FirstOrDefault().RealityId, type = 2, warehouse = warehouseId });
                    }
                }
                brOutRealEpcList = RealEpcList;
            }


            foreach (var item in borrowGetTempReality)
            {
                reRealEpcDetailList.Remove(item);
            }
            return UpdateBoReal;

        }

        /// <summary>
        /// 维修入库
        /// </summary>
        /// <param name="UpdateFixReal"></param>
        /// <param name="fixInRealList"></param>
        /// <param name="UpdateEpc"></param>
        /// <param name="OuterInvens"></param>
        /// <param name="InsideInvens"></param>
        /// <param name="Rfids"></param>
        /// <param name="picUrl"></param>
        /// <param name="policeId"></param>
        /// <param name="warehouseId"></param>
        /// <param name="orgId"></param>
        /// <param name="InsertEpc"></param>
        /// <param name="ErrorEq"></param>
        public static List<CommonJpFixUselessDetail> Fix(List<CommonJpFixUselessDetail> UpdateFixReal, List<CommonJpFixUselessDetail> fixInRealList, ref List<CommonJpEquipmentInventory> UpdateEpc, ref List<CommonJpEquipmentInventory> InsideInvens, string picUrl, string policeId, string warehouseId, string orgId, UnitOfWork unitOfWork)
        {
            if (InsideInvens.Count > 0)
            {

                CommonJpFixUselessDetail trIntoRealFixEpcItem = new CommonJpFixUselessDetail();
                foreach (var InsideItem in InsideInvens)//找出本批物资中维修入库的物资
                {
                    var lastState = InsideItem.CommonJpEquipmentStates.Where(p => p.ActionState != 5).OrderByDescending(p => p.CreateTime).FirstOrDefault();
                    if ((InsideItem.CurrentState.Equals(4) || lastState.ActionState.Equals(6)) && InsideItem.CommonJpEquipmentStates.Count > 0)
                    {

                        trIntoRealFixEpcItem = InsideItem.CommonJpEquipmentStates.Where(p => p.OutTime != null && p.Fix != null)?.OrderByDescending(p => p.OutTime)?.FirstOrDefault()?.Fix; ;

                        if (trIntoRealFixEpcItem != null)
                        {


                            if (trIntoRealFixEpcItem.Order.WarehouseId.Equals(warehouseId))
                            {


                                InsideItem.CurrentState = 0;
                                InsideItem.EquipmentLocation = 0;
                                InsideItem.UpdateUser = policeId;
                                InsideItem.WarehouseCode = warehouseId;

                                if (trIntoRealFixEpcItem.InsideRealCount == null)
                                {
                                    trIntoRealFixEpcItem.InsideRealCount = 0;
                                }
                                trIntoRealFixEpcItem.InsideRealCount++;
                                if (trIntoRealFixEpcItem.InsideRealCount.Equals(trIntoRealFixEpcItem.RealCount))
                                {
                                    trIntoRealFixEpcItem.State = 2;
                                    if (trIntoRealFixEpcItem.Order.CommonJpFixUselessDetails.Where(p => p.State.Equals(1)).ToList().Count <= 0)
                                    {
                                        trIntoRealFixEpcItem.Order.CurrentState = 2;
                                    }
                                    UpdateFixReal.Add(trIntoRealFixEpcItem);//更新维修入库的表单状态

                                    fixInRealList.Remove(trIntoRealFixEpcItem);
                                }

                                InsideItem.CommonJpEquipmentStates?.Add(new CommonJpEquipmentState//新增一条记录表
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    PicUrl = picUrl,
                                    FixId = trIntoRealFixEpcItem.Id,
                                    OrderCode = trIntoRealFixEpcItem?.Order?.OrderCode,
                                    IntoTime = DateTime.Now,
                                    OrgId = orgId,
                                    WarehouseId = warehouseId,
                                    State = 2,
                                    EqiupmentId = InsideItem.Id,
                                    CreateTime = DateTime.Now,
                                    ActionState = 6,
                                    OutInState = 1,
                                    PoliceId = policeId,
                                    HistorySafeLevel = InsideItem.SafeLevel
                                });
                                UpdateEpc.Add(InsideItem);
                            }
                        }
                    }
                }
            }
            foreach (var item in UpdateEpc)
            {
                InsideInvens.Remove(item);
            }
            return UpdateFixReal;
        }
        /// <summary>
        /// 采购
        /// </summary>
        /// <param name="purchaseEpcList">本仓库的采购单据</param>
        /// <param name="Rfids">本次入库的EPC</param>
        /// <param name="picUrl">出入库图片路径</param>
        /// <param name="policeId">警员ID</param>
        /// <param name="warehouseId">仓库ID</param>
        /// <param name="orgId">组织机构ID</param>
        /// <param name="OuterInvens">出库物资</param>
        /// <param name="InsertEpc">入库物资</param>
        /// <param name="ErrorEq">异常物资</param>
        public static List<CommonJpPurchaseEpc> Purchase(List<CommonJpPurchaseEpc> purchaseEpcList, List<CommonJpEquipmentInventory> OuterInvens, List<CommonJpEquipmentInventory> InsideInvens, List<string> Rfids, string picUrl, string policeId, string warehouseId, string orgId, ref List<CommonJpEquipmentInventory> InsertEpc, ref List<string> ErrorEq, UnitOfWork unitOfWork, ILogger logger = null)
        {
            #region 采购入库

            var purEpcs = purchaseEpcList.Where(p => Rfids.Contains(p.Epc)).ToList();//找出本次出入库中包含的采购入库Epc
            List<CommonJpEquipmentInventory> purchaseInventorys = new List<CommonJpEquipmentInventory>();
            List<CommonJpPurchaseEpc> purchaseEpc = new List<CommonJpPurchaseEpc>();

            if (purEpcs.Count > 0)
            {
                int purchaseCount = 0;
                foreach (var item in purEpcs)
                {
                    if (item.Detail.RealCount.Equals(null))
                    {
                        purchaseCount = 0;
                    }
                    else
                    {
                        purchaseCount = Convert.ToInt32(item.Detail.RealCount);
                    }



                    List<CommonJpEquipmentState> state = new List<CommonJpEquipmentState>();

                    state.Add(new CommonJpEquipmentState
                    {
                        Id = Guid.NewGuid().ToString(),
                        PicUrl = picUrl,
                        PurchaseId = item.DetailId,
                        EqiupmentId = item.Detail.EquipmentId,
                        OutInState = 1,
                        State = 5,
                        OrderCode = item.Detail?.Order?.OrderCode,
                        IntoTime = DateTime.Now,
                        PoliceId = policeId,
                        CreateTime = DateTime.Now,
                        ActionState = 1,
                        WarehouseId = warehouseId,
                        OrgId = orgId,
                    });
                    purchaseInventorys.Add(new CommonJpEquipmentInventory
                    {
                        Id = Guid.NewGuid().ToString(),
                        Epc = item.Epc,
                        SupplierCode = item.SupplierId,
                        EquipmentCode = item.Detail?.EquipmentId,
                        WarehouseCode = warehouseId,
                        EquipmentLocation = 0,
                        CurrentState = 0,
                        CreateTime = DateTime.Now,
                        CreateUser = policeId,
                        EquipmentSizecode = item.Detail?.SizeId,
                        UpdateUser = policeId,
                        CommonJpEquipmentStates = state,
                        Price = item.Price,
                        ProductTime = item.ProductTime,
                        UseTime = item.UseTime,
                        UseDirection = item.UseDirection,
                        WarrantyCycle = item.WarrantyCycle,
                        RepairCycle = item.RepairCycle,
                        ShelfId = item.ShelfId,
                        ShelfRange = item.ShelfRange,
                        ShelfRow = item.ShelfRow,
                        ShelfColumn = item.ShelfColumn,
                        OrgId = orgId,
                        Tid = item.Tid,
                    });
                    item.CurrentState = 2;
                    purchaseCount++;
                    item.Detail.RealCount = purchaseCount;
                    if (item.Detail.CommonJpPurchaseEpcs.Where(p => p.CurrentState != 2).Count() <= 0 && item.Detail.State != 1)//当前总数已完成
                    {
                        item.Detail.State = 1;
                        if (item.Detail.Order.CommonJpPurchaseDetails.Where(p => p.State.Equals(0) || p.State == null).ToList().Count <= 0)
                        {
                            item.Detail.Order.CurrentState = 1;
                            purchaseCount = 0;

                        }
                    }
                    purchaseEpc.Add(item);

                    Rfids.Remove(item.Epc);//把采购的入库的EPC移出计算列表
                }
                InsertEpc.AddRange(purchaseInventorys);
            }
            //防止将正常物资判定成异常物资，注释
            //if (OuterInvens.Count.Equals(0) && InsideInvens.Count.Equals(0))
            //{
            //    ErrorEq = Rfids;
            //}


            return purchaseEpc;


            #endregion

        }

        private class OutOrderGoods
        {
            public string Name { get; set; }
            public int Count { get; set; }
        }

        private class OutOrderInfo
        {
            public string orderCode { get; set; }
            public object data { get; set; }
        }
        public static bool UpdateOpenOrderInvInfo(UnitOfWork _unitOfWork, string warehouseId, string orderType, string orderCode, out string msg)
        {
            //替换为mqtt推送
            try
            {
                msg = "";

                using (var scope = Startup.ServiceLocator.Instance.CreateScope())
                {
                    var mqttServer = scope.ServiceProvider.GetService<MQTTServer>();
                    var statusList = mqttServer.mqttServer.GetClientStatusAsync().Result
                        .Where(x => x.ClientId.Length > 2 && x.ClientId.Substring(0, 2) == "SS")   //货架展示屏标识：SS
                        .ToList();

                    Expression<Func<VOrderInfo, bool>> expression = x => x.IsWork == true;
                    expression = expression.AndAlso(x => x.WarehouseId == warehouseId);

                    var res = _unitOfWork.VOrderInfoRepository.Get(expression);
                    if (res == null)
                    {
                        foreach (var status in statusList)
                        {
                            mqttServer.ServerPublishMqttTopic(status.ClientId, @$"/C|ResponseShelfGetOrder|{JsonConvert.SerializeObject(new
                            {
                                warehouseId = warehouseId,
                            })}");
                        }
                        msg = "无开启的单据";
                        return true;
                    }

                    switch (res.OrderType)
                    {
                        case "借用":
                        case "领用":
                            {
                                var t = _unitOfWork.DbContext.CommonJpBorrowReturnApplies
                                    .Include("Warehouse")
                                    .Include("CommonJpBorrowReturnDetailEstimates")
                                    .Include("CommonJpBorrowReturnDetailEstimates.Equipment")
                                    .Include("CommonJpBorrowReturnDetailEstimates.Size")
                                    .Include("CommonJpBorrowReturnDetailEstimates.Supplier")
                                    .Include("CommonJpBorrowReturns")
                                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities")
                                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.EquipmentDetail")
                                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Size")
                                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.Supplier")
                                    .First(x => x.Id == res.ApplyId);

                                var data = new
                                {
                                    type = t.ActionType.Equals(0) ? 2 : 3, //2借用，3领用
                                    t.ActionType,
                                    t.ChangeFlag,
                                    id = t.Id,
                                    warehouseId = t.WarehouseId,
                                    applyId = t.ApplyUser,
                                    applyName = t.ApplyUserName,
                                    applyTime = t.ApplyTime,
                                    note = t.Note,
                                    t.PoliceNote,
                                    createTime = t.CreateTime,
                                    warehouseName = t.Warehouse?.Name,
                                    t.OrderCode,
                                    expectedTime = t.ExpectedReturnTime,

                                    detailList = t.CommonJpBorrowReturnDetailEstimates?.Select(x => new
                                    {
                                        id = x.Id,
                                        equipmentId = x.Equipment?.Id,
                                        equipmentName = x.Equipment?.Name,
                                        equipmentSizeId = x.Size?.Id,
                                        equipmentSizeName = x.Size?.SizeName,
                                        quantity = x.EquipmentCount,
                                        supplierId = x.Supplier?.Id,
                                        supplierName = x.Supplier?.Name,
                                        sizeCount = _unitOfWork.EquipmentInventoryRepository.GetList(p =>
                                            p.EquipmentCode.Equals(x.EquipmentId) &&
                                            p.WarehouseCode.Equals(t.Warehouse.Id)).Count()

                                    }),
                                    applyResult = t.CommonJpBorrowReturns?.Select(p => new
                                    {
                                        p.CurrentState,
                                        resultList = p.CommonJpBorrowReturnDetailRealities?.Select(q => new
                                        {
                                            realityId = q.Id,
                                            quantity = q.EquipmentCount,
                                            equipmentId = q.EquipmentDetail?.Id,
                                            equipmentName = q.EquipmentDetail?.Name,
                                            equipmentCode = q.EquipmentDetail?.Code,
                                            equipmentSizeId = q.Size?.Id,
                                            equipmentSizeName = q.Size?.SizeName,
                                            //applyQuantity = t.CommonJpBorrowReturnDetailEstimates?.Where(x => q.SizeId.Equals(x.SizeId) && q.EquipmentDetailId.Equals(x.EquipmentId))?.FirstOrDefault().EquipmentCount,
                                            supplierId = q.Supplier?.Id,
                                            supplierName = q.Supplier?.Name,
                                            q.RealCount,
                                            q.InsideRealCount,
                                            q.State
                                        })
                                    }).FirstOrDefault()
                                };
                                var list = new List<object>();
                                foreach (var obj in data.applyResult.resultList)
                                {
                                    var count = obj.quantity - obj.RealCount;
                                    if (count == 0)
                                    {
                                        continue;
                                    }
                                    list.Add(new
                                    {
                                        Name = obj.equipmentName,
                                        Count = count
                                    });
                                }
                                foreach (var status in statusList)
                                {
                                    mqttServer.ServerPublishMqttTopic(status.ClientId, $@"/C|ResponseShelfGetOrder|{JsonConvert.SerializeObject(new
                                    {
                                        warehouseId = data.warehouseId,
                                        orderCode = data.OrderCode,
                                        data = list
                                    })}");
                                }
                                return true;
                            }
                        case "跨库借用":
                        case "跨库归还":
                        case "库存调拨":
                            {
                                Expression<Func<CommonJpProcessCurrent, bool>> expressionTrans = p => p.OrderId != null;
                                if (res.OrderType.Equals("库存调拨") || res.OrderType.Equals("跨库借用"))
                                {
                                    expressionTrans = expressionTrans.And(p => p.OrderId.Equals(res.ApplyId) || p.CommonJpTransferApplies.Any(c => c.Order.Equals(res.ApplyId)));
                                }
                                else if (res.OrderType.Equals("跨库归还"))
                                {
                                    expressionTrans = expressionTrans.And(p => p.OrderId.Equals(res.ApplyId) || p.CommonJpTransferApplies.FirstOrDefault().CommonJpTransfers.Any(q => q.Order.Equals(res.ApplyId)));
                                }

                                var t = _unitOfWork.DbContext.CommonJpProcessCurrents
                                    .Include("CommonJpTransferApplies")
                                    .Include("CommonJpTransferApplies.TransferWarehouseNavigation")
                                    .Include("CommonJpTransferApplies.Transfer")
                                    .Include("CommonJpTransferApplies.Target")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailEstimates")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailEstimates.EquipmentSize")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailEstimates.EquipmentDetail")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailEstimates.Supplier")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailRealities")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailRealities.Size")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailRealities.EquipmentDetail")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailRealities.Warehouse")
                                    .Include("CommonJpTransferApplies.CommonJpTransferDetailRealities.Supplier")
                                    .FirstOrDefault(expressionTrans);

                                string value = RedisCacheHelper.GetStringValue(t.CommonJpTransferApplies.FirstOrDefault()?.Order);//获取数据
                                dynamic entity = new object();
                                if (!string.IsNullOrEmpty(value))
                                {
                                    entity = JObject.Parse(value.ToString());
                                }

                                var data = new
                                {
                                    type = t.CommonJpTransferApplies.First().ActionType.ToString().Equals("0") ? 0 :
                                        t.CommonJpTransferApplies.First().ActionType.ToString().Equals("1") ? 7 : 9,

                                    t.UserInfo,
                                    t.UserType,
                                    t.DataScope,
                                    t.OrgId,
                                    t.CommonJpTransferApplies?.FirstOrDefault()?.UpdateTime,
                                    t.CurrentStepName,
                                    expectedReturnTime =
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                    CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                    id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                    applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                    applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                    applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                    note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                    createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                    warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()
                                        ?.TransferWarehouseNavigation?.Name,
                                    warehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                    order =
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.FirstOrDefault()
                                            ?.Order == null
                                            ? t.CommonJpTransferApplies?.FirstOrDefault()?.Order
                                            : t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers
                                                ?.FirstOrDefault()?.Order,
                                    transferName = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Name,
                                    transferId = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Id,
                                    targetName = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Name,
                                    targetId = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Id,

                                    detailList = t.CommonJpTransferApplies?.FirstOrDefault()
                                        ?.CommonJpTransferDetailEstimates?.Select(x => new
                                        {

                                            equipmentSizeId = x.EquipmentSize?.Id,
                                            equipmentSizeName = x.EquipmentSize?.SizeName,
                                            equipmentDetailId = x.EquipmentDetail?.Id,
                                            equipmentDetailName = x.EquipmentDetail?.Name,
                                            quantity = x.EquipmentCount,

                                            supplierId = x.Supplier?.Id,
                                            supplierName = x.Supplier?.Name,
                                        }).OrderBy(p => p.equipmentDetailName),
                                    realityDetailList =
                                        t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransferDetailRealities
                                            .Count() == 0
                                            ? entity.realityDetailList
                                            : t.CommonJpTransferApplies?.FirstOrDefault()
                                                ?.CommonJpTransferDetailRealities?.Select(x => new
                                                {
                                                    realityId = x.Id,
                                                    equipmentSizeId = x.Size?.Id,
                                                    equipmentSizeName = x.Size?.SizeName,
                                                    equipmentDetailId = x.EquipmentDetail?.Id,
                                                    equipmentDetailCode = x.EquipmentDetail?.Code,
                                                    warehouseId = x.WarehouseId,
                                                    warehouseName = x.Warehouse?.Name,
                                                    equipmentDetailName = x.EquipmentDetail?.Name,
                                                    quantity = x.EquipmentCount,
                                                    x.RealCount,
                                                    InsideRealCount = x.InsideRealCount ?? 0,
                                                    x.State,
                                                    supplierId = x.Supplier?.Id,
                                                    supplierName = x.Supplier?.Name,
                                                }).OrderBy(p => p.equipmentDetailName)
                                };

                                var list = new List<object>();
                                foreach (var obj in data.realityDetailList)
                                {
                                    var count = obj.quantity - obj.RealCount;
                                    if (count == 0)
                                    {
                                        continue;
                                    }
                                    list.Add(new
                                    {
                                        Name = obj.equipmentDetailName,
                                        Count = count
                                    });
                                }
                                foreach (var status in statusList)
                                {
                                    mqttServer.ServerPublishMqttTopic(status.ClientId, $@"/C|ResponseShelfGetOrder|{JsonConvert.SerializeObject(new
                                    {
                                        warehouseId = data.warehouseId,
                                        orderCode = data.order,
                                        data = list
                                    })}");
                                }
                                return true;
                            }
                        default:
                            {
                                foreach (var status in statusList)
                                {
                                    mqttServer.ServerPublishMqttTopic(status.ClientId, @$"/C|ResponseShelfGetOrder|{JsonConvert.SerializeObject(new
                                    {
                                        warehouseId = warehouseId,
                                    })}");
                                }
                                msg = "异常OrderType";
                                return false;
                            }
                    }
                }
            }
            catch (Exception e)
            {
                msg = e.ToString();
                return false;
            }

            //try
            //{
            //    msg = "";
            //    OutOrderInfo orders = new OutOrderInfo();
            //    //var res = _unitOfWork.VOrderInfoRepository.Get(expression);
            //    switch (orderType)
            //    {
            //        case "none"://所有单据都关闭
            //            orders.orderCode = "";
            //            orders.data = new List<OutOrderGoods>();
            //            return RedisCacheHelper.SetStringValue("Order" + warehouseId, JsonConvert.SerializeObject(orders), ref msg);

            //        case "借用":
            //        case "领用":
            //            {
            //                var t = _unitOfWork.DbContext.CommonJpBorrowReturnApplies
            //                    .Include("CommonJpBorrowReturns")
            //                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities")
            //                    .Include("CommonJpBorrowReturns.CommonJpBorrowReturnDetailRealities.EquipmentDetail")
            //                    .First(x => x.OrderCode == orderCode);

            //                var data = new
            //                {
            //                    t.OrderCode,
            //                    applyResult = t.CommonJpBorrowReturns?.Select(p => new
            //                    {
            //                        resultList = p.CommonJpBorrowReturnDetailRealities?.Select(q => new
            //                        {
            //                            quantity = q.EquipmentCount,
            //                            equipmentName = q.EquipmentDetail?.Name,
            //                            q.RealCount,
            //                        })
            //                    }).FirstOrDefault()
            //                };
            //                var list = new List<object>();
            //                foreach (var obj in data.applyResult.resultList)
            //                {
            //                    var count = obj.quantity - obj.RealCount;
            //                    if (count == 0)
            //                    {
            //                        continue;
            //                    }
            //                    list.Add(new
            //                    {
            //                        Name = obj.equipmentName,
            //                        Count = count
            //                    });
            //                }
            //                orders.orderCode = data.OrderCode;
            //                orders.data = list;
            //                return RedisCacheHelper.SetStringValue("Order" + warehouseId, JsonConvert.SerializeObject(orders), ref msg);

            //            }
            //        case "库存调拨":
            //            {
            //                Expression<Func<CommonJpProcessCurrent, bool>> expressionTrans = p => p.OrderId != null;

            //                var t = _unitOfWork.DbContext.CommonJpTransferApplies
            //                    .Include("CommonJpTransferDetailRealities")
            //                    .Include("CommonJpTransferDetailRealities.EquipmentDetail")
            //                    .FirstOrDefault(p => p.Order.Equals(orderCode));

            //                var data = new
            //                {
            //                    OrderCode = t.Order,
            //                    realityDetailList =
            //                        t.CommonJpTransferDetailRealities
            //                                .Select(x => new
            //                                {
            //                                    equipmentDetailName = x.EquipmentDetail?.Name,
            //                                    quantity = x.EquipmentCount,
            //                                    x.RealCount,
            //                                })
            //                };

            //                var list = new List<object>();
            //                foreach (var obj in data.realityDetailList)
            //                {
            //                    var count = obj.quantity - obj.RealCount;
            //                    if (count == 0)
            //                    {
            //                        continue;
            //                    }
            //                    list.Add(new
            //                    {
            //                        Name = obj.equipmentDetailName,
            //                        Count = count
            //                    });
            //                }
            //                orders.orderCode = data.OrderCode;
            //                orders.data = list;
            //                return RedisCacheHelper.SetStringValue("Order" + warehouseId, JsonConvert.SerializeObject(orders), ref msg);

            //            }
            //        default:
            //            {
            //                msg = "异常";
            //                return false;

            //            }
            //    }

            //}
            //catch (Exception ex)
            //{
            //    msg = ex.ToString();
            //    return false;
            //}
        }

        /// <summary>
        /// 更新redis上货架相关数据
        /// </summary>
        /// <param name="_unitOfWork"></param>
        /// <param name="warehouseId"></param>
        /// <param name="msg"></param>
        /// <returns></returns>
        public static bool UpdateShelfAndInventoryToRedis(UnitOfWork _unitOfWork, string warehouseId, out string msg)
        {
            try
            {
                msg = "";
                var shelfList = _unitOfWork.BaseJpShelfInfoRepository
                    .GetList(x =>
                        x.WarehouseId == warehouseId && x.Type == "Smart", null, true, includes: new[]
                    {
                        "Warehouse",
                        "Warehouse.Orgization",
                        "CommonJpEquipmentInventories",
                        "CommonJpEquipmentInventories.EquipmentCodeNavigation",
                        "CommonJpEquipmentInventories.EquipmentCodeNavigation.Equipment",
                    })
                    .Select(x => new
                    {
                        x.Url,
                        x.Name,
                        //x.WarehouseId,
                        OrganizationName = x.Warehouse.Orgization.Name,
                        InventoryList = x.CommonJpEquipmentInventories
                            .Where(y => y.ShelfId == x.Id && y.InventoryState != "loss")
                            .Select(y => new
                            {
                                //equipmentDetailId = y.EquipmentCode,
                                equipmentDetailName = y.EquipmentCodeNavigation.Name,
                                //equipmentId = y.EquipmentCodeNavigation.EquipmentId,
                                equipmentName = y.EquipmentCodeNavigation.Equipment.Name,
                                y.ShelfRange,
                                y.ShelfRow,
                                y.ShelfColumn,
                                y.CurrentState
                            })
                    })
                    .ToList();
                var res = true;
                if (shelfList.Count > 0)
                {
                    res = RedisCacheHelper.SetStringValue("Shelf" + warehouseId, JsonConvert.SerializeObject(shelfList), ref msg);
                }
                return res;
            }
            catch (Exception ex)
            {
                msg = ex.ToString();
                return false;
            }
        }
    }
}
