﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking.Internal;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Runtime.CompilerServices;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    /// <summary>
    /// 警员调岗业务
    /// </summary>
    [ApiController]
    [Route("api/[controller]")]
    public class PoliceShiftJobsController : ControllerBase
    {
        private ILogger<PoliceShiftJobsController> _logger;
        UnitOfWork _unitOfWork;
        private static readonly object _lockObj = new object();
        public PoliceShiftJobsController(ILogger<PoliceShiftJobsController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取警员调岗业务申请单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orderCode":"", //订单号
        ///         "approveType":0,  //0待审核,1已完成,2已驳回,3全部
        ///         "action":0,
        ///         "applyId":"",
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "orgId":"" 
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPagedListOrder")]
        public async Task<HttpResponseMessage> GetPagedListOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string applyId = entity.applyId ?? "";
                        string approvalId = entity.approvalId ?? "";
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(applyId) && string.IsNullOrEmpty(approvalId))
                        {
                            return JsonManager.SimpleCustResponse("applyId or approvalId is require");
                        }

                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpPoliceShiftJobsApplyDetails" ,
                       "ApplyOrg" ,
                       "TargetOrg" ,
                       "ApplyPolice" ,
                       "CommonJpPoliceShiftJobsApplyDetails.Equipment" ,
                       "CommonJpPoliceShiftJobsApplyDetails.Size" ,
                       "CommonJpPoliceShiftJobsApplyDetails.Supplier" ,
                    };

                        string orderCode = entity.orderCode ?? "";
                        string orgId = entity.orgId;
                        string actions = entity.action;
                        Expression<Func<CommonJpPoliceShiftJobsApply, bool>> expression = t => t.ApplyId == applyId;
                        if (string.IsNullOrEmpty(actions))
                        {
                            return JsonManager.SimpleCustResponse("action is require");

                        }
                        if (!string.IsNullOrEmpty(orgId))
                        {
                            expression = expression.And(t => t.ApplyOrgId.Equals(orgId));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = expression.And(t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }
                        if (!string.IsNullOrEmpty(orderCode))
                        {
                            expression = expression.And(t => t.OrderCode.Contains(orderCode));
                        }

                        expression = expression.And(t => t.ProcessCurrent.FlowType.Equals(actions));

                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => true);

                        var applyList = _unitOfWork.CommonJpPoliceShiftJobsApplyRepository
                            .GetList(expression, null, false, param)
                            .OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                        var applyValue = new
                        {
                            totalElements = applyList.Count(),
                            content = applyList.Skip(page * size).Take(size).ToList()
                        };

                        var data = applyValue?.content.Select(t => new
                        {
                            id = t.Id,
                            applyOrgId = t.ApplyOrgId,
                            targetOrgId = t.TargetOrgId,
                            policeId = t.ApplyPoliceId,
                            policeName = t.ApplyPolice.Name,
                            note = t.Note,
                            t.ProcessCurrent.UserInfo,
                            actionResult = t.ProcessCurrent?.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime).FirstOrDefault()?.AuditUserId == applyId ? "0" : "1",
                            UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.FirstOrDefault(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo)))?.Name,
                            t.ProcessCurrent.UpdateTime,
                            t.ProcessCurrent.OrgId,
                            t.ProcessCurrent.NextStepId,
                            t.ProcessCurrent.CurrentStepName,
                            t.ProcessCurrent.DataScope,
                            t.ProcessCurrent.UserType,
                            t.ProcessCurrent.FlowType,
                            processActionType = t.ProcessCurrent.ActionType,
                            flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                            applyId = t.ApplyId,
                            applyTime = t.ApplyTime,
                            createTime = t.CreateTime,
                            applyOrgName = t.ApplyOrg?.DName,
                            targetOrgName = t.TargetOrg?.DName,
                            orderCode = t.OrderCode,
                            applyName = t.ApplyName,
                            historyList = t.ProcessCurrent?.CommonJpProcessHistories?.Select(x => new
                            {
                                x.Id,
                                x.OrgId,
                                x.StepName,
                                x.UpdateTime,
                                x.AuditUserId,
                                x.AuditMind,
                                x.AuditUserName
                            }).OrderByDescending(c => c.UpdateTime),
                            detailList = t.CommonJpPoliceShiftJobsApplyDetails.Select(x => new
                            {
                                equipmentId = x.EquipmentId,
                                equipmentName = x.Equipment?.Name,
                                equipmentSizeId = x.SizeId,
                                equipmentSizeName = x.Size?.SizeName,
                                quantity = x.Quantity,
                                supplierId = x.SupplierId,
                                supplierName = x.Supplier?.Name,
                                typeId = x.Equipment?.EquipmentId,
                                id = x.Id,
                                x.Epc
                            }),

                        });


                        var content = new
                        {
                            applyValue?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取警员调岗业务订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetDetailById")]
        public async Task<HttpResponseMessage> GetDetailById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;


                        var param = new string[] {
                       "CommonJpProcessHistories",
                       "CommonJpPoliceShiftJobsApplies",
                       "CommonJpPoliceShiftJobsApplies.TargetOrg" ,
                       "CommonJpPoliceShiftJobsApplies.ApplyOrg" ,
                       "CommonJpPoliceShiftJobsApplies.ApplyPolice" ,
                       "CommonJpPoliceShiftJobsApplies.CommonJpPoliceShiftJobsApplyDetails" ,
                       "CommonJpPoliceShiftJobsApplies.CommonJpPoliceShiftJobsApplyDetails.Equipment" ,
                       "CommonJpPoliceShiftJobsApplies.CommonJpPoliceShiftJobsApplyDetails.Size" ,
                       "CommonJpPoliceShiftJobsApplies.CommonJpPoliceShiftJobsApplyDetails.Supplier" ,

                    };
                        Expression<Func<CommonJpProcessCurrent, bool>> expression = p => p.OrderId.Equals(id) || p.CommonJpPoliceShiftJobsApplies.Any(c => c.OrderCode.Equals(id));

                        var processCurrents = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).ToList();
                        if (processCurrents.Count > 0)
                        {


                            var data = processCurrents.Select(t => new
                            {
                                type = 13,
                                t.NextStepId,
                                t.FlowType,
                                flowState = Convert.ToBoolean(t.FlowState),
                                t.UserInfo,
                                t.UserType,
                                t.DataScope,
                                processActionType = t.ActionType ?? "",
                                applyOrgId = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyOrgId,
                                applyOrgName = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyOrg.DName,
                                targetOrgId = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.TargetOrgId,
                                targetOrgName = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.TargetOrg.DName,
                                policeId = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyPoliceId,
                                policeName = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyPolice.Name,
                                t.UpdateTime,
                                t.CurrentStepName,
                                id = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.Id,
                                applyId = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyId,
                                applyName = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyName,
                                applyTime = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyTime,
                                note = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.Note,
                                createTime = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.CreateTime,
                                t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.OrderCode,

                                actionResult = t.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.ApplyId) == true ? "0" : "1",


                                historyList = t.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    AuditMind = x.AuditMind ?? "",
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                detailList = t.CommonJpPoliceShiftJobsApplies?.FirstOrDefault()?.CommonJpPoliceShiftJobsApplyDetails?.Select(x => new
                                {
                                    realityId = x.OrderId,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.Quantity,
                                    supplierId = x.Supplier?.Id,
                                    x.Epc,
                                    supplierName = x.Supplier?.Name,
                                })
                            }).FirstOrDefault();

                            return JsonManager.ReturnSuccessResponse(data);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新警员调岗业务订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "applyId":"",
        ///         "warehouseId":"",
        ///         "applyOrgId":"",
        ///         "targetOrgId":"",
        ///         "policeId":"",
        ///         "orgCode":"",
        ///         "applyName":"",
        ///         "note":"请求理由",//可为空
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填
        ///            "equipmentId":"",
        ///            "equipmentSizeId":"",
        ///            "supplierId":"",
        ///            "epc":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyName is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyOrgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyOrgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.targetOrgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"targetOrgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.policeId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"policeId is require");
                        }
                        //else if (entity.detailList == null || entity.detailList.Count == 0)
                        //{
                        //    return JsonManager.SimpleCustResponse($"detailList is require");
                        //}
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool processResult = _unitOfWork.CheckProcess(id);
                            if (!processResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpPoliceShiftJobsApplies
                                    .Include(t => t.CommonJpPoliceShiftJobsApplyDetails)
                                    .FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {
                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, (string)entity.orgId, "update");

                                    order.ApplyId = entity.applyId;
                                    order.ApplyTime = DateTime.Now;
                                    order.CreateTime = DateTime.Now;

                                    order.ApplyOrgId = entity.applyOrgId;
                                    order.TargetOrgId = entity.targetOrgId;
                                    order.ApplyPoliceId = entity.policeId;
                                    order.ApplyName = entity.applyName;
                                    order.Note = entity.note;


                                    

                                    if (entity.detailList is IEnumerable)
                                    {
                                        List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);

                                        //移除不在上传数据内数据
                                        order.CommonJpPoliceShiftJobsApplyDetails = order
                                            .CommonJpPoliceShiftJobsApplyDetails.Where(x => tmpList.Contains(x.Id))
                                            .ToList();
                                        foreach (var item in entity.detailList)
                                        {
                                            if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                            {
                                                return JsonManager.SimpleCustResponse("equipmentId is require");
                                            }
                                            if (string.IsNullOrEmpty(item.epc ?? ""))
                                            {
                                                return JsonManager.SimpleCustResponse("epc is require");
                                            }
                                            else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                            {
                                                return JsonManager.SimpleCustResponse("supplierId is require");
                                            }
                                            else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                            {
                                                return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                            }
                                            else
                                            {
                                                //新增明细
                                                if (string.IsNullOrEmpty(item.id ?? ""))
                                                {
                                                    order.CommonJpPoliceShiftJobsApplyDetails.Add(new CommonJpPoliceShiftJobsApplyDetail()
                                                    {
                                                        Id = Guid.NewGuid().ToString(),
                                                        EquipmentId = item.equipmentId,
                                                        SizeId = item.equipmentSizeId,
                                                        OrderId = order.Id,
                                                        SupplierId = item.supplierId,
                                                        Epc = item.epc ?? ""

                                                    });
                                                }
                                                else
                                                {
                                                    var detail = order.CommonJpPoliceShiftJobsApplyDetails.FirstOrDefault(t => t.Id == item.id);
                                                    if (detail == null)
                                                    {
                                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                    }
                                                    else
                                                    {
                                                        detail.EquipmentId = item.equipmentId;
                                                        detail.SizeId = item.equipmentSizeId;
                                                        detail.OrderId = order.Id;
                                                        detail.Quantity = 1;
                                                        detail.SupplierId = item.supplierId;
                                                        detail.Epc = item.epc ?? "";
                                                        detail.State = 0;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                    else
                                    {
                                        //清空所有携带的装备
                                        order.CommonJpPoliceShiftJobsApplyDetails.Clear(); 
                                    }

                                    bool result = _unitOfWork.CommonJpPoliceShiftJobsApplyRepository.Update(order, true);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ACCOUNT_IS_AUDITED);
                            }
                        }
                        else
                        {
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();

                            string head_str = "DG";
                            string orderCode = $"{entity.orgCode}{head_str}{DateTime.Now.ToString("yyyyMMddHHmmss")}";
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, orderCode);




                            //新增数据
                            var order = new CommonJpPoliceShiftJobsApply()
                            {
                                ApplyId = entity.applyId,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                Note = entity.note,
                                ApplyOrgId = entity.applyOrgId,
                                Id = orderID,
                                TargetOrgId = entity.targetOrgId,
                                ApplyPoliceId = entity.policeId,
                                ApplyName = entity.applyName,
                                ProcessCurrentId = processCurrentId,
                                OrderCode = orderCode
                            };


                            var detailsList = new List<CommonJpPoliceShiftJobsApplyDetail>();
                            if (entity.detailList is IEnumerable)
                            {

                                foreach (var item in entity.detailList)
                                {
                                    if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                    {
                                        return JsonManager.SimpleCustResponse("equipmentId is require");
                                    }
                                    else if (string.IsNullOrEmpty(item.epc ?? ""))
                                    {
                                        return JsonManager.SimpleCustResponse("epc is require");
                                    }
                                    else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                    {
                                        return JsonManager.SimpleCustResponse("supplierId is require");
                                    }
                                    else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                    {
                                        return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                    }
                                    else
                                    {
                                        detailsList.Add(new CommonJpPoliceShiftJobsApplyDetail()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            EquipmentId = item.equipmentId,
                                            SizeId = item.equipmentSizeId,
                                            OrderId = order.Id,
                                            Quantity = 1,
                                            SupplierId = item.supplierId,
                                            Epc = item.epc ?? "",
                                            State = 0
                                        });
                                    }
                                }
                            }

                            order.CommonJpPoliceShiftJobsApplyDetails = detailsList;

                            if (flowState == "true")
                            {
                                order.CurrentState = flowState == "true" ? 1 : 0;
                                //更新子表状态
                                foreach (var detail in order.CommonJpPoliceShiftJobsApplyDetails)
                                {
                                    detail.State = 1;
                                    //生成流水表 调岗 仓库置空，组织机构为目标组织机构
                                    GenerateState(order.OrderCode, detail.Epc, detail.Id, null, order.TargetOrgId, order.ApplyId);
                                }
                                //去除当前人员所有物资关联
                                var resetInvList = _unitOfWork.EquipmentInventoryRepository.GetList(x => x.PoliceCode == order.ApplyPoliceId)
                                    .ToList();
                                foreach (var resetInv in resetInvList)
                                {
                                    resetInv.PoliceCode = null;
                                }
                                _unitOfWork.EquipmentInventoryRepository.Update(resetInvList, false);

                                //反写库存状态
                                UpdateInvState(order.CommonJpPoliceShiftJobsApplyDetails?.Select(x => x.Epc).ToList(), order.OrderCode, order.TargetOrgId, order.ApplyPoliceId);

                                //更新用户组织机构
                                var police = _unitOfWork.PolicemanRepository.Get(x => x.Id == order.ApplyPoliceId);
                                police.OrgizationCode = order.TargetOrgId;
                                //清除绑定柜子
                                police.CabinetId = null;
                                _unitOfWork.PolicemanRepository.Update(police, false);
                                //更新账号并将权限设置为普通警员
                                var user = _unitOfWork.CommonJpUserRepository.Get(x => x.PoliceId == police.Id);
                                if (user != null)
                                {
                                    var role = _unitOfWork.UsersRoleRepository.GetList(x => x.UserId == user.Id).ToList();
                                    var tempRole = role.FirstOrDefault(x => x.RoleId == 6);
                                    if (tempRole == null)
                                    {
                                        _unitOfWork.UsersRoleRepository.Insert(new UsersRole
                                        {
                                            UserId = user.Id,
                                            RoleId = 6
                                        }, false);
                                    }
                                    else
                                    {
                                        role.Remove(tempRole);
                                    }
                                    _unitOfWork.UsersRoleRepository.Delete(role, false);
                                    user.OrganizationId = order.TargetOrgId;
                                    _unitOfWork.CommonJpUserRepository.Update(user, false);
                                }
                            }

                            bool result = _unitOfWork.CommonJpPoliceShiftJobsApplyRepository.Insert(order, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除警员调岗业务订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"",
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteOrder")]
        public async Task<HttpResponseMessage> DeleteOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpPoliceShiftJobsApplies.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            var detailList = _unitOfWork.CommonJpPoliceShiftJobsApplyDetailRepository
                                .GetList(x => x.OrderId == order.Id)
                                .ToList();
                            _unitOfWork.CommonJpPoliceShiftJobsApplyDetailRepository.Delete(detailList, false);

                            bool result = _unitOfWork.CommonJpPoliceShiftJobsApplyRepository.Delete(order, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 审批警员调岗业务订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "idList":[{id:"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6"}],
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        lock (_lockObj)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            var isLost = entity?.isLost ?? false;
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }
                            else if (string.IsNullOrEmpty(entity?.flowState ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"flowState is require");
                            }
                            else
                            {

                                string id = entity.id ?? "";
                                if (string.IsNullOrEmpty(id))
                                {
                                    return JsonManager.SimpleCustResponse($"id is require");
                                }
                                var orderInfo = _unitOfWork.DbContext.CommonJpPoliceShiftJobsApplies
                                    .Include(t => t.CommonJpPoliceShiftJobsApplyDetails)
                                    .FirstOrDefault(t => t.Id == id);
                                var flowState = (string)(entity.flowState).ToLower();
                                if (orderInfo == null)
                                {
                                    return JsonManager.SimpleCustResponse("invalid id");
                                }
                                else
                                {
                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {
                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                         (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");
                                        orderInfo.ApprovalTime = DateTime.Now;

                                        if (flowState == "true")
                                        {
                                            orderInfo.CurrentState = flowState == "true" ? 1 : 0;
                                            //更新子表状态
                                            foreach (var detail in orderInfo.CommonJpPoliceShiftJobsApplyDetails)
                                            {
                                                detail.State = 1;
                                                //生成流水表 调岗 仓库置空，组织机构为目标组织机构
                                                GenerateState(orderInfo.OrderCode, detail.Epc, detail.Id, null, orderInfo.TargetOrgId, orderInfo.ApplyId);
                                            }
                                            //去除当前人员所有物资关联
                                            var resetInvList = _unitOfWork.EquipmentInventoryRepository.GetList(x => x.PoliceCode == orderInfo.ApplyPoliceId)
                                                .ToList();
                                            foreach (var resetInv in resetInvList)
                                            {
                                                resetInv.PoliceCode = null;
                                            }
                                            _unitOfWork.EquipmentInventoryRepository.Update(resetInvList, false);

                                            //反写库存状态
                                            UpdateInvState(orderInfo.CommonJpPoliceShiftJobsApplyDetails?.Select(x => x.Epc).ToList(), orderInfo.OrderCode, orderInfo.TargetOrgId, orderInfo.ApplyPoliceId);

                                            //更新用户组织机构
                                            var police = _unitOfWork.PolicemanRepository.Get(x => x.Id == orderInfo.ApplyPoliceId);
                                            police.OrgizationCode = orderInfo.TargetOrgId;
                                            //清除绑定柜子
                                            police.CabinetId = null;
                                            _unitOfWork.PolicemanRepository.Update(police, false);
                                            //更新账号并将权限设置为普通警员
                                            var user = _unitOfWork.CommonJpUserRepository.Get(x => x.PoliceId == police.Id);
                                            if (user != null)
                                            {
                                                var role = _unitOfWork.UsersRoleRepository.GetList(x => x.UserId == user.Id).ToList();
                                                var tempRole = role.FirstOrDefault(x => x.RoleId == 6);
                                                if (tempRole == null)
                                                {
                                                    _unitOfWork.UsersRoleRepository.Insert(new UsersRole
                                                    {
                                                        UserId = user.Id,
                                                        RoleId = 6
                                                    }, false);
                                                }
                                                else
                                                {
                                                    role.Remove(tempRole);
                                                }
                                                _unitOfWork.UsersRoleRepository.Delete(role, false);
                                                user.OrganizationId = orderInfo.TargetOrgId;
                                                _unitOfWork.CommonJpUserRepository.Update(user, false);
                                            }
                                        }

                                        //更新审批状态
                                        bool result = _unitOfWork.CommonJpPoliceShiftJobsApplyRepository.Update(orderInfo, true);
                                        if (!result)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                        }
                                        else
                                        {
                                            return JsonManager.ReturnSuccessResponse(new
                                            {
                                                orderCode = orderInfo.OrderCode
                                            });
                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"invalid parameter");
                    }

                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取当前人员所有装备（领用+单警柜）
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///        "policeId":"xxx-xxx-xxx-xxx"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetInventoryByPoliceId")]
        public async Task<HttpResponseMessage> GetInventoryByPoliceId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.policeId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"policeId is require");
                        }
                        else
                        {
                            string policeId = entity.policeId;

                            //8:领用 7:单警柜出库中 3:单警柜中
                            var invList = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Include(t => t.SupplierCodeNavigation)
                                .Include(t => t.EquipmentCodeNavigation)
                                .Include(t => t.EquipmentCodeNavigation.Equipment)
                                .Include(t => t.EquipmentSizecodeNavigation)
                                .Include(t => t.WarehouseCodeNavigation)
                                .Where(t => t.PoliceCode == policeId
                                && (t.CurrentState == 8 || t.CurrentState == 7 || t.CurrentState == 3)
                                && (t.LostFlag == false || t.LostFlag == null))
                                .ToList();

                            var data = invList.Select(x => new
                            {
                                equipmentId = x.EquipmentCode,
                                equipmentName = x.EquipmentCodeNavigation?.Name,
                                typeId = x.EquipmentCodeNavigation?.EquipmentId,
                                typeName = x.EquipmentCodeNavigation?.Equipment?.Name,
                                equipmentSizeId = x.EquipmentSizecode,
                                equipmentSizeName = x.EquipmentSizecodeNavigation?.SizeName,
                                supplierId = x.SupplierCode,
                                supplierName = x.SupplierCodeNavigation?.Name,
                                epc = x.Epc,
                                warehouseId = x.WarehouseCode,
                                warehouseName = x.WarehouseCodeNavigation?.Name,
                                currentState = x.CurrentState
                            });
                            return JsonManager.ReturnSuccessResponse(data);

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        private bool GenerateState(string orderCode, string epc, string detailId, string warehouseId, string orgId, string applyId)
        {
            var invInfo = _unitOfWork.DbContext.CommonJpEquipmentInventories.FirstOrDefault(t => t.Epc.Contains(epc));
            if (invInfo != null)
            {
                CommonJpEquipmentState equState = new CommonJpEquipmentState()
                {
                    OrderCode = orderCode,
                    Id = Guid.NewGuid().ToString(),
                    State = 1,
                    ActionState = 24,   //调岗
                    EqiupmentId = invInfo.Id,
                    OutInState = 0,     //0：出库
                    ShiftJobsId = detailId,
                    WarehouseId = null,
                    CreateTime = DateTime.Now,
                    OrgId = orgId,
                    OutTime = DateTime.Now,
                    PoliceId = _unitOfWork.DbContext.CommonJpUsers.FirstOrDefault(x => x.Id == applyId)?.PoliceId
                };
                _unitOfWork.DbContext.CommonJpEquipmentStates.Add(equState);
                return true;
            }
            else
            {
                return false;
            }
        }

        private void UpdateInvState(List<string> epcList, string orderCode, string orgId, string policeId)
        {
            if (epcList == null || epcList.Count == 0)
            {
                _logger.LogError($"[装备回库]未找到调岗单明细，{orderCode}");
            }
            var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories.Where(t => epcList.Contains(t.Epc)).ToList();
            if (wz_info.Count > 0)
            {
                wz_info.ForEach(x =>
                {
                    x.CurrentState = 8; //领用
                    x.EquipmentLocation = 3;
                    x.WarehouseCode = null;
                    x.OrgId = orgId;
                    x.PoliceCode = policeId;
                    x.UpdateTime=DateTime.Now;
                    _unitOfWork.EquipmentInventoryRepository.Update(x, false);
                });

            }
        }
    }
}
