﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Nacos;
using Nacos.AspNetCore;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Security.Policy;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class InventoryTableController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<PuchaseOrderController> _logger;
        //private readonly INacosServerManager _serverManager;
        //private readonly INacosNamingClient _serverManager;
        //private readonly IHttpClientFactory _clientFactory;
        UnitOfWork _unitOfWork;
        public InventoryTableController(ILogger<PuchaseOrderController> logger, UnitOfWork unitOfWork)
        {
            //, INacosServerManager serverManager, IHttpClientFactory clientFactory
            //_serverManager = serverManager;
            //_clientFactory = clientFactory;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }


        /// <summary>
        /// 获取盘点订单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "orderNo":"", //订单号
        ///         "applyId":"",
        ///         "approveType":"",
        ///         "warehouseId":"",
        ///         "startTime":"",
        ///         "endTime":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllTable")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetAllTable([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string applyId = entity?.applyId ?? "";
                        string approvalId = entity?.approvalId ?? "";
                        string orgid = entity.orgId ?? "";

                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        if (string.IsNullOrEmpty(applyId) && string.IsNullOrEmpty(approvalId))
                        {
                            return JsonManager.SimpleCustResponse("applyId or approvalId is require");
                        }

                        var param = new string[] {
                       "CommonJpInventoryDetails" ,
                       "Warehouse",
                       "User"
                    };
                        string orderNo = entity.orderNo ?? "";
                        string warehouseId = entity.warehouseId ?? "";
                        string startTime = entity.startTime ?? "";
                        string endTime = entity.endTime ?? "";
                        Expression<Func<CommonJpInventoryTable, bool>> expression = t => t.OrgId.Contains(orgid);
                        if (!string.IsNullOrEmpty(orderNo))
                        {
                            expression = LambdaExtensions.And(expression, t => t.OrderNo.Contains(orderNo));
                        }
                        expression = LambdaExtensions.And(expression, t => t.UserId == applyId);

                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.And(expression, t => t.WarehouseId.Equals(warehouseId));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = LambdaExtensions.And(expression, t => t.UpdateTime >= Convert.ToDateTime(startTime) && t.UpdateTime <= Convert.ToDateTime(endTime));
                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);



                        //var purchaseList = _unitOfWork.PurchaseOrderyRepository.GetPage(expression, "-ApprovalTime", page, size, false, param);
                        var purchaseList = _unitOfWork.CommonJpInventoryTableRepository.GetList(expression, null, false, param)
                            .OrderByDescending(x=>x.UpdateTime);
                        var borrowlocationValue = new
                        {
                            totalElements = purchaseList.Count(),
                            content = purchaseList.Skip(page * size).Take(size).ToList()
                        };
                        var data = borrowlocationValue?.content.Select(s => new
                        {
                            id = s.Id,
                            applyId = s.UserId,
                            warehouseName = s.Warehouse?.Name,
                            warehouseId = s.WarehouseId,
                            orderNo = s.OrderNo,
                            applyName = s.User?.NickName,
                            applyTime = s.UpdateTime,
                            actionState = s.ActionState,
                            s.DetailId,
                            s.SizeId,
                            s.Type,
                            s.ShelfId,
                            s.Column,
                            s.Side,
                            s.Line,

                            note = s.Remarks,
                        });
                        var content = new
                        {
                            totalElements = borrowlocationValue?.totalElements ?? 0,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取盘点订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetByID")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetByID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = string.Empty;
                        id = entity.id;

                        var param = new string[] {
                       "Warehouse",
                       "User",
                       "Size",
                       "Detail",
                       "Shelf"

                    };
                        Expression<Func<CommonJpInventoryTable, bool>> expression = p => p.Id.Equals(id);

                        var tables = _unitOfWork.CommonJpInventoryTableRepository.GetList(expression, null, false, param).ToList();
                        if (tables.Count > 0)
                        {
                            var tablesData = tables.Select(t => new
                            {

                                type = 1,

                                t.OrgId,
                                t.UpdateTime,

                                id = t.Id,
                                DetailId = t.DetailId,
                                DetailName = t.Detail?.Name,
                                tableType = t.Type,
                                sizeId = t.SizeId,
                                sizeName = t.Size?.SizeName,
                                column = t.Column,
                                side = t.Side,
                                line = t.Line,
                                ShelfId = t.ShelfId,
                                ShelfName = t.Shelf?.Name,
                                warehouseId = t.WarehouseId,
                                applyId = t.UserId,
                                applyName = t.User.NickName,
                                applyTime = t.UpdateTime,
                                note = t.Remarks,
                                warehouseName = t.Warehouse?.Name,
                                t.OrderNo,

                            }).FirstOrDefault();
                            return JsonManager.ReturnSuccessResponse(tablesData);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }





                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增盘点订单
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///    "id":"", //新增可不填
        ///    "applyReason":"物资补充",
        ///    "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///    "applyId":"8ff5a4a9-93f5-11ea-9c69-002324af7df5",
        ///    "userType":"用户类型"
        ///    "userInfo":"用户或组ID"
        ///    "dataScope":"上级或本级"
        ///    "note":"警用帽采购100个",
        ///    "nextStepId":"下一步ID"，
        ///    "currentStepName":"当前步骤"，
        ///    "flowState":"流程是否结束",
        ///    "applyName":"",
        ///    "warehouseId":"e08841f9-93f5-11ea-9c69-002324af7df5",
        ///    "type":"",//All为全盘，location位置盘点,variety物资类型盘点
        ///    "shelfId":"",//货架ID
        ///    "side":"",//面
        ///    "line":"",//行
        ///    "column":"",//列
        ///    "detailId":"",//物资ID
        ///    "sizeId":"",//号型ID
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateTable")]
        //[NoSign]

        public async Task<HttpResponseMessage> AddOrUpdateTable([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyName is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgCode is require");
                        }
                        if (entity.type == "location" && string.IsNullOrEmpty(entity.shelfId))
                        {
                            return JsonManager.SimpleCustResponse($"shelfId is require");
                        }

                        {
                            string warehouseId = entity.warehouseId;
                            //var waitTable= _unitOfWork.CommonJpInventoryTableRepository.GetList(p => p.WarehouseId.Equals(warehouseId) && (p.ActionState.Equals("waitAction")||p.ActionState.Equals("noAction"))).ToList();
                            //if (waitTable.Count>0)
                            //{
                            //    return JsonManager.SimpleStatusResponse(ResultCode.ORDER_EXIST);
                            //}
                            string orderID = Guid.NewGuid().ToString();
                            string orderCode = $"PK{DateTime.Now.ToString("yyyyMMddHHmmss")}";
                            string shelfId = entity.shelfId;
                            string sizeId = entity.sizeId;
                            string detailId = entity.detailId;
                            CommonJpInventoryTable order = new CommonJpInventoryTable()
                            {
                                Remarks = entity.note,
                                UpdateTime = DateTime.Now,
                                UserId = entity.applyId,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                ActionState = "noAction",
                                OrderNo = orderCode,
                                Type = entity.type,
                                Column = entity.column,
                                Side = entity.side,
                                Line = entity.line,

                            };

                            

                            if (!string.IsNullOrEmpty(shelfId))
                            {
                                order.ShelfId = shelfId;
                            }
                            if (!string.IsNullOrEmpty(sizeId))
                            {
                                order.SizeId = sizeId;
                            }
                            if (!string.IsNullOrEmpty(detailId))
                            {
                                order.DetailId = detailId;
                            }
                            bool result = _unitOfWork.CommonJpInventoryTableRepository.Insert(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 审批盘点申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "idList":[{id:"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6"}],
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "approvalMsg":"驳回理由",
        ///         "targetWarehouseID":"驳回理由",
        ///         "actionType":"操作状态" 0:撤销，1:驳回
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity?.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (string.IsNullOrEmpty(entity?.flowState ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"flowState is require");
                        }
                        else
                        {

                            string id = entity?.id ?? "";
                            var orderInfo = _unitOfWork.DbContext.CommonJpInventoryTables.FirstOrDefault(t => t.Id == id);

                            if (orderInfo == null)
                            {
                                return JsonManager.SimpleCustResponse("invalid id");
                            }
                            else
                            {
                                bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                if (processResult)
                                {
                                    var flowState = (string)(entity.flowState).ToLower();
                                    string targetWarehouseID = entity.targetWarehouseID;
                                    _unitOfWork.ApproveMessage(orderInfo.Id);
                                    _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                    (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");

                                    if (orderInfo == null)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                    }
                                    else if (flowState == "false")
                                    {
                                        orderInfo.UpdateTime = DateTime.Now;
                                        bool result = _unitOfWork.CommonJpInventoryTableRepository.Update(orderInfo, true);
                                        if (result)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                                        }
                                        else
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                        }
                                    }
                                    else
                                    {
                                        if (flowState == "true")
                                        {
                                            orderInfo.ActionState = "noAction";
                                            orderInfo.UpdateTime = DateTime.Now;
                                            bool result = _unitOfWork.CommonJpInventoryTableRepository.Update(orderInfo);
                                            if (result)
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                            }
                                            else
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                            }
                                        }
                                        else
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                        }
                                    }
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }


}
