﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Runtime.CompilerServices;
using System.Threading.Tasks;
using static JmpModel.Model.Enumerates.BorrowEnum;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class FixUselessController : ControllerBase
    {
        private ILogger<FixUselessController> _logger;
        UnitOfWork _unitOfWork;
        public FixUselessController(ILogger<FixUselessController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取维修保养申请单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "orderCode":"" //订单号
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllUseless")]
        public async Task<HttpResponseMessage> GetAllUseless([FromBody]JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string orgid = entity.orgId ?? "";

                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }

                        var param = new string[] {
                       "CommonJpFixUselessDetails" ,
                       "Warehouse" ,
                       "Apply" ,
                       "CommonJpFixUselessDetails.Equipment" ,
                       "CommonJpFixUselessDetails.Size" ,
                       "CommonJpFixUselessDetails.Supplier" ,
                    };

                        string orderCode = entity.orderCode ?? "";
                        var bSta = int.TryParse(entity.approvalStatus ?? "", out int approvalStatus);
                        Expression<Func<CommonJpFixUseless, bool>> expression = t => t.OrgId.Contains(orgid);
                        if (!string.IsNullOrEmpty(orderCode))
                        {
                            expression = LambdaExtensions.And(expression, t => t.OrderCode.Contains(orderCode));
                        }


                        var applyList = _unitOfWork.FixUselessRepository.GetPage(expression, "-CreateTime", page, size, false, param);
                        var data = applyList?.content.Select(t => new
                        {
                            action = t.Action,
                            id = t.Id,
                            sort = t.Sort,
                            warehouseId = t.WarehouseId,
                            applyId = t.ApplyId,
                            //applyName = t.Apply?.Name,
                            createTime = t.CreateTime,
                            warehouseName = t.Warehouse?.Name,
                            detailList = t.CommonJpFixUselessDetails.Select(x => new
                            {
                                equipmentId = x?.EquipmentId,
                                equipmentName = x?.Equipment?.Name,
                                equipmentSizeId = x.SizeId,
                                equipmentSizeName = x?.Size?.SizeName,
                                quantity = x.Quantity,
                                supplierId = x?.SupplierId,
                                supplierName = x?.Supplier?.Name,
                                typeId = x?.Equipment?.EquipmentId,
                                id = x.Id
                            })

                        });
                        var content = new
                        {
                            applyList?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        ///// <summary>
        ///// 新增/更新维修报废单
        ///// </summary>
        ///// <remarks>
        ///// ## 例子
        ///// 
        /////     {
        /////         "id":"", //新增可不填
        /////         "action":0,//修改时不填
        /////         "applyId":"",//修改时不填
        /////         "warehouseId":"",//修改时不填
        /////         "orgId":"",//修改时不填
        /////         "fixTime":"",//修改时不填
        /////         "estimateId":"",//修改时不填
        /////         "createUser":"",//修改时不填
        /////         "currentState":""
        /////         "detailList":[
        /////         {
        /////            "id":"", //新增可不填
        /////            "equipmentId":"",//修改时不填
        /////            "equipmentSizeId":"",//修改时不填
        /////            "quantity":"",//修改时不填
        /////            "supplierId":""//修改时不填
        /////         }]
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("AddOrUpdateUseless")]
        //public HttpResponseMessage AddOrUpdateUseless([FromBody]JObject jdata)
        //{
        //    try
        //    {
        //        if (jdata != null)
        //        {
        //            var entity = JsonManager.GetJsonEntity(jdata);
        //            string id = entity?.id ?? "";
        //            if (entity == null)
        //            {
        //                return JsonManager.SimpleCustResponse($"model is null");
        //            }
        //            else if (string.IsNullOrEmpty(entity.action ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse($"action is require");
        //            }
        //            else if (string.IsNullOrEmpty(entity.applyId ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse($"applyId is require");
        //            }
        //            else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse($"warehouseId is require");
        //            }
        //            else if (string.IsNullOrEmpty(entity.orgId ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse($"orgId is require");
        //            }
        //            else if (entity.detailList == null || entity.detailList.Count == 0)
        //            {
        //                return JsonManager.SimpleCustResponse($"detailList is require");
        //            }
        //            else if (!string.IsNullOrEmpty(id))
        //            {
        //                var order = _unitOfWork.DbContext.CommonJpFixUselesses.FirstOrDefault(t => t.Id == id);
        //                if (order == null)
        //                {
        //                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
        //                }
        //                else
        //                {
        //                    order.Action = int.Parse(entity.action);
        //                    order.ApplyId = entity.applyId;
        //                    order.WarehouseId = entity.warehouseId;
        //                    order.OrgId = entity.orgId;
        //                    order.CreateUser = entity.createUser ?? "";
        //                    order.FixTime = entity.fixTime;
        //                    order.Sort = 0;
        //                    order.EstimateId = entity.estimateId;
        //                    order.OrderCode = entity.orderCode;

        //                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
        //                    var tmpDetail = order.CommonJpFixUselessDetails?.Where(t => tmpList.Contains(t.Id));
        //                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
        //                    {
        //                        var tmp_dtl = tmpDetail.ElementAt(i);
        //                        order.CommonJpFixUselessDetails.Remove(tmp_dtl);
        //                    }

        //                    foreach (var item in entity.detailList)
        //                    {
        //                        int.TryParse(item.quantity, out int qty);
        //                        if (string.IsNullOrEmpty(item.equipmentId ?? ""))
        //                        {
        //                            return JsonManager.SimpleCustResponse("equipmentId is require");
        //                        }
        //                        else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
        //                        {
        //                            return JsonManager.SimpleCustResponse("equipmentSizeId is require");
        //                        }
        //                        else if (string.IsNullOrEmpty(item.supplierId ?? ""))
        //                        {
        //                            return JsonManager.SimpleCustResponse("supplierId is require");
        //                        }
        //                        else if (qty <= 0)
        //                        {
        //                            return JsonManager.SimpleCustResponse("quantity field error");
        //                        }
        //                        else
        //                        {
        //                            //新增明细
        //                            if (string.IsNullOrEmpty(item.id ?? ""))
        //                            {
        //                                order.CommonJpFixUselessDetails.Add(new CommonJpFixUselessDetail()
        //                                {
        //                                    Id = Guid.NewGuid().ToString(),
        //                                    EquipmentId = item.equipmentId,
        //                                    SizeId = item.equipmentSizeId,
        //                                    OrderId = order.Id,
        //                                    Quantity = qty,
        //                                    SupplierId = item.supplierId

        //                                });
        //                            }
        //                            else
        //                            {
        //                                var detail = order.CommonJpFixUselessDetails.FirstOrDefault(t => t.Id == item.id);
        //                                if (detail == null)
        //                                {
        //                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //                                }
        //                                else
        //                                {
        //                                    detail.EquipmentId = item.equipmentId;
        //                                    detail.SizeId = item.equipmentSizeId;
        //                                    detail.OrderId = order.Id;
        //                                    detail.Quantity = qty;
        //                                    detail.SupplierId = item.supplierId;

        //                                }
        //                            }
        //                        }
        //                    }

        //                    bool result = _unitOfWork.FixUselessRepository.Update(order);
        //                    if (result)
        //                    {
        //                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
        //                    }
        //                    else
        //                    {
        //                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //                    }
        //                }
        //            }
        //            else
        //            {
        //                int action = int.Parse(entity.action);
        //                string head_str = action == 0 ? "WX" : "BF";

        //                //新增数据
        //                CommonJpFixUseless order = new CommonJpFixUseless()
        //                {
        //                    Action = int.Parse(entity.action),
        //                    ApplyId = entity.applyId,
        //                    CreateTime = DateTime.Now,
        //                    WarehouseId = entity.warehouseId,
        //                    Id = Guid.NewGuid().ToString(),
        //                    OrgId = entity.orgId,
        //                    CreateUser = entity.createUser ?? "",
        //                    FixTime = Convert.ToDateTime(entity.fixTime),
        //                    Sort = 0,
        //                    EstimateId = entity.estimateId,
        //                    OrderCode = $"{entity.orgCode}{head_str}{DateTime.Now.ToString("yyyyMMddHHmmss")}"
        //                };

        //                List<CommonJpFixUselessDetail> detailsList = new List<CommonJpFixUselessDetail>();
        //                foreach (var item in entity.detailList)
        //                {
        //                    int.TryParse(item.quantity, out int qty);
        //                    if (string.IsNullOrEmpty(item.equipmentId ?? ""))
        //                    {
        //                        return JsonManager.SimpleCustResponse("equipmentId is require");
        //                    }
        //                    else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
        //                    {
        //                        return JsonManager.SimpleCustResponse("equipmentSizeId is require");
        //                    }
        //                    else if (string.IsNullOrEmpty(item.supplierId ?? ""))
        //                    {
        //                        return JsonManager.SimpleCustResponse("supplierId is require");
        //                    }
        //                    else if (qty <= 0)
        //                    {
        //                        return JsonManager.SimpleCustResponse("quantity field error");
        //                    }
        //                    else
        //                    {
        //                        detailsList.Add(new CommonJpFixUselessDetail()
        //                        {
        //                            Id = Guid.NewGuid().ToString(),
        //                            EquipmentId = item.equipmentId,
        //                            SizeId = item.equipmentSizeId,
        //                            OrderId = order.Id,
        //                            Quantity = qty,
        //                            SupplierId = item.supplierId,
        //                            State = Convert.ToInt32(CurrentState.进行中)
        //                        });
        //                    }
        //                }

        //                order.CommonJpFixUselessDetails = detailsList;

        //                bool result = _unitOfWork.FixUselessRepository.Insert(order);

        //                if (result)
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
        //                }
        //                else
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //                }
        //            }
        //        }
        //        else
        //        {
        //            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //        }
        //    }
        //    catch (Exception ex)
        //    {

        //        //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

        ///// <summary>
        ///// 删除维修报废单
        ///// </summary>
        ///// <remarks>
        ///// ## 例子
        ///// 
        /////     {
        /////         "id":"",
        /////         "orgId":""
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("DeleteOrder")]
        //public HttpResponseMessage DeleteOrder([FromBody]JObject jdata)
        //{
        //    try
        //    {
        //        if (jdata != null)
        //        {
        //            var entity = JsonManager.GetJsonEntity(jdata);
        //            if (entity == null)
        //            {
        //                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //            }
        //            else if (string.IsNullOrEmpty(entity.id ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse("id is require");
        //            }
        //            string id = entity.id ?? "";
        //            var order = _unitOfWork.DbContext.CommonJpFixUselesses.FirstOrDefault(t => t.Id == id);
        //            if (order == null)
        //            {
        //                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //            }
        //            else
        //            {
        //                bool result = _unitOfWork.FixUselessRepository.Delete(order);
        //                if (result)
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
        //                }
        //                else
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //                }
        //            }
        //        }
        //        else
        //        {
        //            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //        }
        //    }

        //    catch (Exception ex)
        //    {
        //        //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

        ///// <summary>
        ///// 根据EPC获取审批信息
        ///// </summary>
        ///// <remarks>
        ///// ## 例子
        ///// 
        /////     {
        /////        "epc:":"xxx-xxx-xxx-xxx"
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("ScrapOrRepairByEpc")]
        //public HttpResponseMessage ScrapOrRepairByEpc([FromBody]JObject jdata)
        //{
        //    try
        //    {
        //        if (jdata != null)
        //        {

        //            var entity = JsonManager.GetJsonEntity(jdata);
        //            if (entity == null)
        //            {
        //                return JsonManager.SimpleCustResponse($"model is null");
        //            }
        //            else if (entity.epcList == null || entity.epcList.Count == 0)
        //            {
        //                return JsonManager.SimpleCustResponse($"epc is require");
        //            }
        //            else if (string.IsNullOrEmpty(entity.action ?? ""))
        //            {
        //                return JsonManager.SimpleCustResponse($"action is require");
        //            }
        //            else
        //            {
        //                string epc = entity.epc ?? "";
        //                int.TryParse(entity.action ?? "", out int action);
        //                var order_info = _unitOfWork.DbContext.CommonJpFixUselessDetails.Include(t => t.Order).FirstOrDefault(t => t.Epc.Contains(epc) && t.Order.Action == action);
        //                if (order_info == null)
        //                {
        //                    return JsonManager.SimpleCustResponse("未找到审批信息");
        //                }
        //                else if (order_info.State == 0)
        //                {
        //                    return JsonManager.SimpleCustResponse("物资已处理");
        //                }
        //                else
        //                {
        //                    var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories.FirstOrDefault(t => t.Epc.Contains(epc));
        //                    var data = new
        //                    {
        //                        equipmentId = wz_info.EquipmentCode,
        //                        equipmentName = wz_info.EquipmentCodeNavigation.Name,
        //                        typeId = wz_info.EquipmentCodeNavigation.EquipmentId,
        //                        typeName = wz_info.EquipmentCodeNavigation.Equipment.Name,
        //                        equipmentSizeId = wz_info.EquipmentSizecode,
        //                        equipmentSizeNam = wz_info.EquipmentSizecodeNavigation.SizeName,
        //                        supplierId = wz_info.SupplierCode,
        //                        supplierName = wz_info.SupplierCodeNavigation.Name,
        //                        epc = wz_info.Epc
        //                    };

        //                    order_info.State = 1;
        //                    bool result = _unitOfWork.FixUselessDetailRepository.Update(order_info);
        //                    if (result)
        //                    {
        //                        //更新库存状态
        //                        wz_info.CurrentState = action == 0 ? 4 : 5;
        //                        _unitOfWork.EquipmentInventoryRepository.Update(wz_info);
        //                        return JsonManager.ReturnSuccessResponse(data);
        //                    }
        //                    else
        //                    {
        //                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //                    }
        //                }

        //            }
        //        }
        //        else
        //        {
        //            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

    }
}
