using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.WebSockets;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using JmpModel.Model.Repository.CommonRepository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.HttpsPolicy;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.StaticFiles;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Microsoft.OpenApi.Models;
using Nacos;
using Nacos.AspNetCore;
using NLog.Extensions.Logging;
using Rextec.SOA.Infrastructure;
using IHostingEnvironment = Microsoft.AspNetCore.Hosting.IHostingEnvironment;

namespace JunmpPoliceStation
{
    public class Startup
    {
        private readonly string _allowOrigins = "allowOrigins";

        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            if (bool.TryParse(Configuration.GetSection("Addons:EFProf").Value, out bool efProfFlag) && efProfFlag)
            {
                HibernatingRhinos.Profiler.Appender.EntityFramework.EntityFrameworkProfiler.Initialize();
            }
            var connection = Configuration.GetConnectionString("MySqlConnection");
            var msg_uri = Configuration["MessageUri"];
            GlobalContext.ServerNum = byte.Parse(Configuration["ServerNum"]);
            GlobalContext.UseNoticeService(new Uri(msg_uri));
            if (GlobalContext.ServerNum <= 0 || GlobalContext.ServerNum > 15)
            {
                throw new Exception("ŲȷӦ1-15֣֮JSONServerNumֶΡ");
            }
            else
            {
                services.AddSession();
                services.AddTransient(typeof(UnitOfWork));//ע빤Ԫ
                                                          //ÿԴ
                services.AddCors(options =>
                {
                    options.AddPolicy("cors",
                        builder => builder.AllowAnyOrigin()
                        .AllowAnyHeader()
                        .AllowAnyMethod()
                    );
                });
                ApiConfig apicfg = new ApiConfig();
                services.Configure<ApiConfig>(Configuration.GetSection("ApiConfig"));
                Configuration.GetSection("ApiConfig").Bind(apicfg);
                services.AddSingleton(apicfg);
                //services.AddEFSecondLevelCache(options =>
                //     options.UseMemoryCacheProvider().DisableLogging(true)

                // // Please use the `CacheManager.Core` or `EasyCaching.Redis` for the Redis cache provider.
                // );
                services.AddHttpClient();
                var redisConnectionString = ((ConfigurationSection)Configuration.GetSection("RedisConnectionStrings:Connection")).Value;
                var redisInstanceName = ((ConfigurationSection)Configuration.GetSection("RedisConnectionStrings:InstanceName")).Value;
                services.AddSingleton(new RedisCacheHelper(redisConnectionString, redisInstanceName));

                services.AddMvc(options =>
                {
                    options.Filters.Add<AuthLoginAttribute>();
                });

                services.AddControllers().AddNewtonsoftJson();
                services.AddMvc().SetCompatibilityVersion(CompatibilityVersion.Version_3_0);
                services.AddMvc().AddWebApiConventions();
                services.AddMvc().AddControllersAsServices();
                //Swagger
                //עSwaggerһSwagger ĵ
                services.AddSwaggerGen(c =>
                {
                    c.DocumentFilter<SwaggerIgnoreFilter>();
                    c.SwaggerDoc("v1", new OpenApiInfo
                    {
                        Version = "v1",
                        Title = "òֿƽ̨ӿ",
                        Description = "ֿAPI"
                    });

                    // Ϊ Swagger xmlĵע·
                    var xmlFile = $"{Assembly.GetExecutingAssembly().GetName().Name}.xml";
                    var xmlPath = Path.Combine(AppContext.BaseDirectory, xmlFile);
                    c.IncludeXmlComments(xmlPath);
                });
                services.AddDbContext<JunmppolicesqlContext>(options =>
                {
                    //options.UseLazyLoadingProxies(true);
                    options.UseSqlServer(connection);
                    //options.UseMySQL(connection);
                });

                services.AddControllers();
                services.AddNacosNaming(Configuration)
               .AddNacosConfig(Configuration)
               .AddNacosAspNetCore(Configuration);

                //MQTT
                //var mqtt = new MQTTServer(connection);
                //mqtt.StartMqttServer(Configuration);
                //services.AddSingleton(mqtt);

                //services.AddScoped<MQTTServer>(sp =>
                //{
                //    var server = sp.GetService<MQTTServer>();
                //    server?.StartMqttServer();
                //    return server;
                //});

                services.AddSingleton<MQTTServer>();
            }
        }

        public static class ServiceLocator
        {
            public static IServiceProvider Instance { get; set; }
        }
        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env, ILoggerFactory loggerFactory, INacosNamingClient _namingClient,MQTTServer mqttServer)
        {
            ServiceLocator.Instance = app.ApplicationServices;

            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
                app.UseHsts();
            }
            app.UseSession();


            //мSwaggerΪJSONս
            app.UseSwagger();
            //мswagger-uiָSwagger JSONս
            app.UseSwaggerUI(c =>
            {
                c.SwaggerEndpoint("/swagger/v1/swagger.json", "My API V1");
            });

            app.UseHttpsRedirection();


            //app.UseAuthorization();
            app.UseRouting();

            //пcorsConfigureServicesõĿ
            //ע⣺UseCorsUseRoutingUseEndpoints֮
            app.UseCors("cors");
            app.UseAuthentication();
            app.UseEndpoints(endpoints =>
            {

                endpoints.MapControllers().RequireCors("cors");

            });

            //app.UseMvc(routes =>
            //{
            //    routes.MapRoute(
            //            name: "default",
            //            template: "{controller=Home}/{action=Index}/{id?}");
            //});

            //עnacos
            //_namingClient.RegisterInstanceAsync(new RegisterInstanceRequest()
            //{
            //    ServiceName = "JunmpPoliceStation12",
            //    Ip = "192.168.10.24",
            //    Port = 18848
            //});

            app.UseStaticFiles(new StaticFileOptions()
            {
                ContentTypeProvider = new FileExtensionContentTypeProvider()
                {
                    Mappings = { [".exe"] = "application/octect-stream", [".apk"] = "application/octect-stream", [".log"] = "text/plain", [".mp4"] = "	video/mpeg4" }
                }
            });
        }

    }

    public class Setting
    {
        /// <summary>
        /// ݿַ
        /// </summary>
        public string MySqlConnection { get; set; }

        public string serviceName { get; set; }

        public string serviceIp { get; set; }
        public string servicePort { get; set; }
    }
}
