﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ScreenController : ControllerBase
    {
        private ILogger<ScreenController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        public ScreenController(ILogger<ScreenController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }     
        // 生成树
        private List<Node> CreateTreeNodes(List<Node> nodes, string id)
        {
            List<Node> root = nodes.FindAll(node => node.id.Equals(id));
            return SortNodes(nodes, root);
        }
        // 递归分组
        private List<Node> SortNodes(List<Node> nodes, List<Node> root)
        {

            for (int i = 0; i < root.Count; i++)
            {
                List<Node> children = nodes.FindAll(node => node.ParentId == root[i].id);
                for (var j = 0; j < children.Count; j++)
                {
                    children[j].Level = root[i].Level + 1;
                }
                SortNodes(nodes, children);
                if (children.Count == 0)
                {
                    root[i].Children = null;
                }
                else
                {
                    root[i].Children = children;
                }
            }
            return root;
        }
        /// <summary>
        /// 获取组织结构列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":"编号",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListOrg")]
        [NoSign]
        public async Task<HttpResponseMessage> GetListOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.id?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();
                        List<BaseJpOrganization> dataList = null;
                        List<Node> reDataList = null;
                        string id = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.id))
                        {
                            id = entity.id;
                        }
                        else
                        {
                            id = "A35F3DB1-80A1-45ED-A458-B7DEA193682G";
                        }

                        dataList = GetClassID(id);
                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(id))).ToList();

                        var data = dataList.Select(c => new
                        {
                            c.Id,
                            c.Code,
                            c.ParentId,
                            c.Name,
                            c.FindCode,
                            c.NameJc,
                            c.DName
                        }
                       ).OrderByDescending(c => c.FindCode.Length).ThenBy(c => c.FindCode).ToList();

                        List<Node> nodes = new List<Node>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            Node node = new Node();
                            node.code = data[i].Code;
                            node.id = data[i].Id;
                            node.Name = data[i].Name;
                            node.ParentId = data[i].ParentId;
                            node.FindCode = data[i].FindCode;
                            node.NameJc = data[i].NameJc;
                            node.Level = 1;
                            node.DName = data[i].DName == null ? "" : data[i].DName;
                            nodes.Add(node);
                        }

                        reDataList = CreateTreeNodes(nodes, id);

                        return JsonManager.ReturnSuccessResponse(reDataList, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取全部装备详细信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构ID",
        ///         "isCurrentLevel":"true"本级，"false"本级及下级
        ///         "currentState":"当前状态"
        ///         "createTime":"时间"
        ///         "page":"页数",
        ///         "size":"当页数量",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetEquipmentInfo")]
        [NoSign]
        public async Task<HttpResponseMessage> GetEquipmentInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string createTime = entity.createTime;
                        if (size == 0)
                        {
                            size = 10;
                        }
                        string isCurrentLevel = entity.isCurrentLevel;
                        if (string.IsNullOrEmpty(isCurrentLevel))
                        {
                            isCurrentLevel = "false";
                        }
                        string orgId = entity?.orgId ?? "";
                        string currentState= entity?.currentState ?? "";
                        Expression<Func<ViewEquipmentDetail, bool>> expression = t => t.Id!=null;
                        var param = new string[] {
                 
                        };
                        var stateParam = new string[] {
                            "Eqiupment",
                            "Transfer",
                            "Transfer.Reality",
                            "Transfer.Reality.ReceiveWarehouse",
                        };
                        Expression<Func<BaseJpOrganization, bool>> expressionOrg = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expressionOrg, t => t.Code).ToList();
                        //if (!string.IsNullOrEmpty(orgId))
                        //{
                        //    expression = expression.AndAlso(x => x.OrgId.Equals(orgId));
                        //}
                        if (isCurrentLevel.Equals("true"))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.OrgId.Equals(orgId));
                        }
                        else if (isCurrentLevel.Equals("false"))
                        {
                            List<BaseJpOrganization> dataList = null;
                            dataList = GetClassID(orgId);

                            dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgId))).ToList();

                            var orgNewList = _unitOfWork.OrganizationRepository.GetList(expressionOrg).Select(p => p.Id);
                            expression = LambdaExtensions.AndAlso(expression, t => dataList.Select(c => c.Id).Contains(t.OrgId) );
                        }
                        if (!string.IsNullOrEmpty(currentState))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.CurrentState.Equals(int.Parse(currentState)));

                        }
                        if (!string.IsNullOrEmpty(createTime))
                        {
                            expression = expression.AndAlso(t => t.CreateTime >= DateTime.Parse(createTime));
                        }
                       
                        var allState = _unitOfWork.EquipmentStateRepository.GetList(p => !string.IsNullOrEmpty(p.TransferId) && !string.IsNullOrEmpty(p.Eqiupment.Epc),null,false, stateParam).ToList();
                        var equipments = _unitOfWork.ViewEquipmentDetailRepository.GetPageAsync(expression, "-CreateTime", page, size, false, param).Result;

                        var data = equipments?.content.Select(t => new
                        {
                           
                           t.Id,
                           t.OrgId,
                           t.OrgName,
                           targetWarehouseId = t.CurrentState == 1 ? allState.Where(p => p.EqiupmentId.Equals(t.Id)).OrderByDescending(p => p.CreateTime).First().Transfer?.Reality?.ReceiveWarehouse.Id : "",
                           targetWarehouseName = t.CurrentState == 1 ? allState.Where(p => p.EqiupmentId.Equals(t.Id)).OrderByDescending(p => p.CreateTime).First().Transfer?.Reality?.ReceiveWarehouse?.Name : "",
                           scrpTime=t.CurrentState==6? allState.Where(p => p.EqiupmentId.Equals(t.Id)).FirstOrDefault()?.CreateTime.ToString() : "",
                           t.WarehouseId,
                           t.WarehouseName,
                           t.CurrentState,
                           t.Epc,
                           t.EquipmentName,
                           t.EquipmentCode,
                           t.SizeName,
                           t.EquipmentSizecode,
                           t.SupplierName,
                           location=string.IsNullOrEmpty(t.ShelfName)?"": t.ShelfName+(t.ShelfRow==null?"":t.ShelfRow + "行")+ (t.ShelfColumn == null ? "" : t.ShelfColumn + "列") + (t.ShelfRange == null ? "" : t.ShelfRange + "排"),
                           t.SafeLevel,
                           fixCount=t.FixCount==null?0:t.FixCount,
                           useCount = t.UseCount == null ? 0 : t.UseCount,
                           t.WarrantyCycle,
                           t.RepairCycle,
                           t.Price,
                           t.ProductTime,
                           t.FindCode,
                           t.AreaName,
                           DetailName= t.Name,
                           typeOne= t.ParentName,
                           typeTwo= t.TypeName,
                           typeThree= t.Name, 
                        });
                        var content = new
                        {
                            equipments?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 获取装备的出入库信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构ID",
        ///         "isCurrentLevel":"true"本级，"false"本级及下级
        ///         "page":"页数",
        ///         "size":"当页数量",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllStates")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllStates([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 10;
                        }
                        string isCurrentLevel = entity.isCurrentLevel;
                        if (string.IsNullOrEmpty(isCurrentLevel))
                        {
                            isCurrentLevel = "false";
                        }
                        string orgId = entity?.orgId ?? "";
                        Expression<Func<ViewState, bool>> expression = t => t.EqiupmentId != null;
                        var param = new string[] {

                        };
                        Expression<Func<BaseJpOrganization, bool>> expressionOrg = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expressionOrg, t => t.Code).ToList();
                  
                        if (isCurrentLevel.Equals("true"))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.OrgId.Equals(orgId));
                        }
                        else if (isCurrentLevel.Equals("false"))
                        {
                            List<BaseJpOrganization> dataList = null;
                            dataList = GetClassID(orgId);

                            dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgId))).ToList();

                            var orgNewList = _unitOfWork.OrganizationRepository.GetList(expressionOrg).Select(p => p.Id);
                            expression = LambdaExtensions.AndAlso(expression, t => dataList.Select(c => c.Id).Contains(t.OrgId));
                        }
                        var equipments = _unitOfWork.ViewStateRepository.GetPageAsync(expression, "-CreateTime", page, size, false, param).Result;

                        var data = equipments?.content.Select(t => new
                        {

                            t.OutInState,
                            t.OrgId,
                            t.OrgName,
                            t.EqiupmentId,
                            t.DetailCode,
                            t.DetailName,
                            t.SizeName,
                            t.CreateTime
                        });
                        var content = new
                        {
                            equipments?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content, true);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }
    }
}
