﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Nacos;
using Nacos.AspNetCore;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Security.Policy;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class PuchaseOrderController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<PuchaseOrderController> _logger;
        //private readonly INacosServerManager _serverManager;
        //private readonly INacosNamingClient _serverManager;
        //private readonly IHttpClientFactory _clientFactory;
        UnitOfWork _unitOfWork;
        public PuchaseOrderController(ILogger<PuchaseOrderController> logger, UnitOfWork unitOfWork)
        {
            //, INacosServerManager serverManager, IHttpClientFactory clientFactory
            //_serverManager = serverManager;
            //_clientFactory = clientFactory;
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        //[HttpGet]
        //public async Task<string> GetAsync()
        //{
        //    var result = await GetResultAsync();

        //    if (string.IsNullOrWhiteSpace(result))
        //    {
        //        result = "ERROR!!!";
        //    }

        //    return result;
        //}
        ////var client = IServiceProvider.GetService<INacosNamingClient>();
        //private async Task<string> GetResultAsync()
        //{
        //    try
        //    {


        //        //var baseUrl = await _serverManager.GetServerAsync("JunmpPoliceStation");
        //        //var baseUrl2 =  _serverManager2.GetServiceAsync(new GetServiceRequest { 
        //        //ServiceName= "wms-oauth-boot"
        //        //}).Result;

        //        //var baseUrl2 = await _serverManager.RegisterInstanceAsync(new RegisterInstanceRequest
        //        //{
        //        //    ServiceName = "wms-auth-boot",
        //        //    Ip = "192.168.2.220",
        //        //    Port = 10020
        //        //});
        //        //var listServices = await _serverManager2.ListServicesAsync(new ListServicesRequest
        //        //{
        //        //    PageNo = 0,
        //        //    PageSize = 10,
        //        //});
        //        //var listClusterServers = await _serverManager2.ListClusterServersAsync(new ListClusterServersRequest
        //        //{

        //        //});
        //        //var t = await _serverManager.ListInstancesAsync(new ListInstancesRequest
        //        //{
        //        //    ServiceName = "wms-oauth-boot",
        //        //});
        //        var baseUrl = await _serverManager.GetServerAsync("wms-auth-boot");
        //        if (string.IsNullOrWhiteSpace(baseUrl))
        //        {
        //            return "";
        //        }

        //        var url = $"{baseUrl}/info/profile";

        //        var client = _clientFactory.CreateClient();
        //        Url url1 = new Url(url);
        //        HttpCompletionOption hc = new HttpCompletionOption();
        //        var result = await client.GetAsync(url);
        //        var ts = result.Content.ReadAsStringAsync();
        //        //var resul2 = await client.PostAsync(url);
        //        return await result.Content.ReadAsStringAsync();
        //    }
        //    catch (Exception ex)
        //    {

        //        throw;
        //    }
        //}

        /// <summary>
        /// 获取采购订单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "orderCode":"", //订单号
        ///         "approvalStatus":0  //0待审批,1已审批,2已驳回
        ///         "applyId":"",
        ///         "approveType":"",
        ///         "warehouseId":"",
        ///         "startTime":"",
        ///         "endTime":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllPurchases")]
        public async Task<HttpResponseMessage> GetAllPurchases([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string applyId = entity?.applyId ?? "";
                        string approvalId = entity?.approvalId ?? "";
                        string orgid = entity.orgId ?? "";

                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        if (string.IsNullOrEmpty(applyId) && string.IsNullOrEmpty(approvalId))
                        {
                            return JsonManager.SimpleCustResponse("applyId or approvalId is require");
                        }

                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpPurchaseDetails" ,
                       "Warehouse" ,
                       "CommonJpPurchaseDetails.Equipment" ,
                       "CommonJpPurchaseDetails.Size" ,
                       "CommonJpPurchaseDetails.Supplier" ,

                    };
                        string orderCode = entity.orderCode ?? "";
                        string warehouseId = entity.warehouseId ?? "";
                        string startTime = entity.startTime ?? "";
                        string endTime = entity.endTime ?? "";
                        Expression<Func<CommonJpPurchaseOrder, bool>> expression = t => t.OrgId.Contains(orgid);
                        if (!string.IsNullOrEmpty(orderCode))
                        {
                            expression = LambdaExtensions.And(expression, t => t.OrderCode.Contains(orderCode));
                        }
                        expression = LambdaExtensions.And(expression, t => t.ApplyId == applyId);

                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }

                        }
                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.And(expression, t => t.WarehouseId.Equals(warehouseId));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = LambdaExtensions.And(expression, t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);



                        //var purchaseList = _unitOfWork.PurchaseOrderyRepository.GetPage(expression, "-ApprovalTime", page, size, false, param);
                        var purchaseList = _unitOfWork.PurchaseOrderyRepository.GetList(expression, null, false, param).OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                        var borrowlocationValue = new
                        {
                            totalElements = purchaseList.Count(),
                            content = purchaseList.Skip(page * size).Take(size).ToList()
                        };
                        var data = borrowlocationValue?.content.Select(s => new
                        {


                            id = s.Id,
                            title = s.Title,
                            //policeName = s.Police?.Name,
                            applyId = s.ApplyId,
                            warehouseName = s.Warehouse?.Name,
                            warehouseId = s.WarehouseId,
                            createTime = s.CreateTime,
                            orderCode = s.OrderCode,
                            applyName = s.ApplyName,
                            applyTime = s.ApplyTime,
                            s.ProcessCurrent?.UserInfo,
                            actionResult = s.ProcessCurrent.CommonJpProcessHistories.OrderByDescending(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(applyId) ? "0" : "1",
                            UserInfoName = string.IsNullOrEmpty(s.ProcessCurrent.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(s.ProcessCurrent.UserInfo))).FirstOrDefault().Name,
                            s.ProcessCurrent?.UpdateTime,
                            s.ProcessCurrent?.FlowType,
                            s.ProcessCurrent?.OrgId,
                            s.ProcessCurrent?.NextStepId,
                            s.ProcessCurrent?.CurrentStepName,
                            s.ProcessCurrent?.DataScope,
                            s.ProcessCurrent?.UserType,
                            note = s.ApplyReason,
                            processActionType = s.ProcessCurrent.ActionType,
                            flowState = Convert.ToBoolean(s.ProcessCurrent?.FlowState),
                            historyList = s.ProcessCurrent?.CommonJpProcessHistories?.Select(x => new
                            {
                                x.Id,
                                x.OrgId,
                                x.StepName,
                                x.UpdateTime,
                                x.AuditUserId,
                                x.AuditMind,
                                x.AuditUserName
                            }).OrderByDescending(c => c.UpdateTime),
                            detailList = s.CommonJpPurchaseDetails.Select(t => new
                            {
                                equipmentId = t.EquipmentId,
                                equipmentName = t.Equipment?.Name,
                                equipmentSizeId = t.SizeId,
                                equipmentSizeName = t.Size?.SizeName,
                                quantity = t.Quantity,
                                sort = t.Sort,
                                supplierName = t.Supplier?.Name,
                                supplierId = t.SupplierId,
                                typeId = t.Equipment?.EquipmentId,
                                id = t.Id
                            }).ToList()
                        });
                        var content = new
                        {
                            totalElements = borrowlocationValue?.totalElements ?? 0,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取采购订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetByID")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetByID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = string.Empty;
                        id = entity.id;


                        var param = new string[] {
                       "CommonJpProcessHistories",
                       "CommonJpPurchaseOrders",
                       "CommonJpPurchaseOrders.Warehouse" ,
                       "CommonJpPurchaseOrders.CommonJpPurchaseDetails" ,
                       "CommonJpPurchaseOrders.CommonJpPurchaseDetails.Equipment" ,
                       "CommonJpPurchaseOrders.CommonJpPurchaseDetails.Size" ,
                       "CommonJpPurchaseOrders.CommonJpPurchaseDetails.Supplier" ,
                       "CommonJpPurchaseOrders.CommonJpPurchaseDetails.CommonJpPurchaseEpcs" ,

                    };
                        Expression<Func<CommonJpProcessCurrent, bool>> expression = p => p.OrderId.Equals(id) || p.CommonJpPurchaseOrders.Where(c => c.OrderCode.Equals(id)).Count() > 0;

                        var purchase = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).ToList();
                        if (purchase.Count > 0)
                        {


                            var purchaseData = purchase.Select(t => new
                            {

                                type = 1,
                                t.NextStepId,
                                t.FlowType,
                                processActionType = t.ActionType,
                                flowState = Convert.ToBoolean(t.FlowState),
                                t.UserInfo,

                                t.DataScope,
                                t.UserType,
                                t.OrgId,
                                t.UpdateTime,
                                t.CurrentStepName,

                                actionResult = t.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyId) == true ? "0" : "1",

                                id = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Id,
                                warehouseId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.WarehouseId,
                                applyId = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyId,
                                applyName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyName,
                                applyTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyTime,
                                createTime = t.CommonJpPurchaseOrders?.FirstOrDefault()?.CreateTime,
                                note = t.CommonJpPurchaseOrders?.FirstOrDefault()?.ApplyReason,
                                warehouseName = t.CommonJpPurchaseOrders?.FirstOrDefault()?.Warehouse?.Name,
                                t.CommonJpPurchaseOrders?.FirstOrDefault()?.OrderCode,
                                t.CommonJpPurchaseOrders?.FirstOrDefault()?.IssuingOrg,
                                historyList = t.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    x.AuditUserName,
                                    x.AuditMind
                                }).OrderByDescending(c => c.UpdateTime),
                                detailList = t.CommonJpPurchaseOrders?.FirstOrDefault()?.CommonJpPurchaseDetails.Select(x => new
                                {
                                    realityId = x.Id,
                                    equipmentId = x.EquipmentId,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.SizeId,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.Quantity,
                                    sort = x.Sort,
                                    supplierName = x.Supplier?.Name,
                                    supplierId = x.SupplierId,
                                    typeId = x.Equipment?.EquipmentId,
                                    invCount = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.EquipmentSizecode.Equals(x.SizeId)).Count(),
                                    x.RealCount,
                                    epcs = x.CommonJpPurchaseEpcs
                                    .Select(y => new
                                    {
                                        y.Id,
                                        y.Epc,
                                        y.CurrentState,
                                        y.Num,
                                        y.CreateTime,
                                        y.WarrantyCycle,
                                        y.RepairCycle,
                                        y.ProductTime,
                                        y.UseTime,
                                        y.Price,
                                        y.UseDirection,
                                        y.SupplierName,
                                    }),
                                    priceList = _unitOfWork.DbContext.CommonJpEquipmentStates
                                        .Include(a => a.Eqiupment)
                                        .Where(a => a.PurchaseId == x.Id)
                                        .ToList()
                                        .GroupBy(y => y.Eqiupment.Price)
                                        .Select(y => new
                                        {
                                            equipmentName = x.Equipment?.Name,
                                            equipmentUnitType = x.Equipment?.UnitType,
                                            equipmentSizeName = x.Size?.SizeName,
                                            price = Convert.ToDecimal(y.Key).ToString("F2"),
                                            Count = y.Count(),
                                            totalPrice = Convert.ToDecimal(y.Key * y.Count()).ToString("F2")
                                        })
                                }
                                ),
                                resultPriceList = new List<object>()

                            }).FirstOrDefault();

                            if (purchaseData?.detailList != null)
                            {
                                foreach (var obj in purchaseData.detailList)
                                {
                                    purchaseData.resultPriceList.AddRange(obj.priceList);
                                }
                            }

                            return JsonManager.ReturnSuccessResponse(purchaseData);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.NO_PROCESS);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增采购订单
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///    "id":"", //新增可不填
        ///    "applyReason":"物资补充",
        ///    "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///    "applyId":"8ff5a4a9-93f5-11ea-9c69-002324af7df5",
        ///    "userType":"用户类型"
        ///    "userInfo":"用户或组ID"
        ///    "dataScope":"上级或本级"
        ///    "note":"警用帽采购100个",
        ///    "nextStepId":"下一步ID"，
        ///    "currentStepName":"当前步骤"，
        ///    "flowState":"流程是否结束",
        ///    "applyName":"",
        ///    "warehouseId":"e08841f9-93f5-11ea-9c69-002324af7df5",
        ///    "detailList":[{
        ///            "equipmentSizeId":"33f19525-93f6-11ea-9c69-002324af7df5",
        ///            "equipmentId":"08b47952-93f6-11ea-9c69-002324af7df5",
        ///            "quantity":"100",
        ///            "supplierId":"c3bb4326-93f5-11ea-9c69-002324af7df5",
        ///            "note":"望领导尽快审批"
        ///            "id":"" //新增可不填
        ///           }] ,
        ///     "orgCode":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdatePurchase")]
        public async Task<HttpResponseMessage> AddOrUpdatePurchase([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyName is require");
                        }

                        else if (string.IsNullOrEmpty(entity.orgCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgCode is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool processResult = _unitOfWork.CheckProcess(id);
                            if (!processResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpPurchaseOrders.Include(t => t.CommonJpPurchaseDetails).Include(t => t.ProcessCurrent).FirstOrDefault(t => t.Id == id && t.ProcessCurrent.FlowState == "false");
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"invalid id");
                                }
                                else
                                {
                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();

                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, "", "update");



                                    order.ApplyReason = entity.note;
                                    //order.ApplyTime = DateTime.Now;
                                    order.CreateTime = DateTime.Now;
                                    order.ApplyId = entity.applyId;
                                    order.Title = entity.title;
                                    order.WarehouseId = entity.warehouseId;
                                    order.OrgId = entity.orgId;
                                    order.ApplyName = entity.applyName;


                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    var tmpDetail = order.CommonJpPurchaseDetails?.Where(t => !tmpList.Contains(t.Id));
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        order.CommonJpPurchaseDetails.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);
                                        if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentId is require");
                                        }
                                        else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                        }
                                        else if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpPurchaseDetails.Add(new CommonJpPurchaseDetail()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    EquipmentId = item.equipmentId,
                                                    SizeId = item.equipmentSizeId,
                                                    Note = item.note,
                                                    OrderId = order.Id,
                                                    Quantity = qty,
                                                    State = 0,
                                                    SupplierId = null,
                                                    CreateTime = DateTime.Now

                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpPurchaseDetails.FirstOrDefault(t => t.Id.Equals((string)item.id));
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {
                                                    detail.EquipmentId = item.equipmentId;
                                                    detail.SizeId = item.equipmentSizeId;
                                                    detail.Note = item.note;
                                                    detail.OrderId = order.Id;
                                                    detail.Quantity = qty;
                                                    detail.State = 0;
                                                    detail.SupplierId = null;

                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.PurchaseOrderyRepository.Update(order);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ACCOUNT_IS_AUDITED);
                            }
                        }
                        else
                        {
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();
                            string orderCode = $"{entity.orgCode}CG{DateTime.Now.ToString("yyyyMMddHHmmss")}";
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, orderCode);

                            CommonJpPurchaseOrder order = new CommonJpPurchaseOrder()
                            {
                                ApplyReason = entity.note,
                                ApplyTime = DateTime.Now,
                                ApprovalId = entity.approvalId,
                                ApprovalName = entity.approvalName,
                                ApprovalResult = (int)ApproveType.待审批,
                                ApprovalTime = null,
                                CreateTime = DateTime.Now,
                                ApplyId = entity.applyId,
                                Title = entity.title,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                ApplyName = entity.applyName,
                                ProcessCurrentId = processCurrentId,
                                OrderCode = orderCode

                            };

                            List<CommonJpPurchaseDetail> detailsList = new List<CommonJpPurchaseDetail>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);
                                if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentId is require");
                                }
                                else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                }
                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    detailsList.Add(new CommonJpPurchaseDetail()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentId,
                                        SizeId = item.equipmentSizeId,
                                        Note = item.note,
                                        OrderId = order.Id,
                                        Quantity = int.Parse(item.quantity),
                                        SupplierId = null
                                    });
                                }
                            }
                            order.CommonJpPurchaseDetails = detailsList;

                            if (flowState == "true")
                            {
                                order.ApprovalTime = DateTime.Now;
                                order.TargetWarehouseId = order.WarehouseId;
                            }

                            bool result = _unitOfWork.PurchaseOrderyRepository.Insert(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        private static object PuchaseSign = new object();
        /// <summary>
        /// 审批采购申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "idList":[{id:"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6"}],
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "approvalMsg":"驳回理由",
        ///         "targetWarehouseID":"驳回理由",
        ///         "actionType":"操作状态" 0:撤销，1:驳回
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        //[NoSignAttribute]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    lock (PuchaseSign)
                    {


                        if (jdata != null)
                        {

                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity?.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }
                            else if (string.IsNullOrEmpty(entity?.flowState ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"flowState is require");
                            }
                            else
                            {

                                string id = entity?.id ?? "";
                                var orderInfo = _unitOfWork.DbContext.CommonJpPurchaseOrders
                                    .Include(t => t.CommonJpPurchaseDetails)
                                    .Include("CommonJpPurchaseDetails.Supplier")
                                    .Include("CommonJpPurchaseDetails.Equipment")
                                    .Include("CommonJpPurchaseDetails.Size").Include(c => c.ProcessCurrent).FirstOrDefault(t => t.Id == id);

                                if (orderInfo == null)
                                {
                                    return JsonManager.SimpleCustResponse("invalid id");
                                }
                                else
                                {
                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {
                                        var flowState = (string)(entity.flowState).ToLower();
                                        string targetWarehouseID = entity.targetWarehouseID;
                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                        (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");
                                        if (orderInfo.ProcessCurrent.FlowState == "ture")
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.ORDER_OPERATE_ERROR);
                                        }

                                        if (orderInfo == null)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.ORDER_OPERATE_ERROR);
                                        }

                                        else if (flowState == "false")
                                        {
                                            orderInfo.ApprovalTime = DateTime.Now;
                                            orderInfo.CreateTime = DateTime.Now;
                                            bool result = _unitOfWork.PurchaseOrderyRepository.Update(orderInfo, true);
                                            if (result)
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);

                                            }
                                            else
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                            }
                                        }
                                        else
                                        {
                                            orderInfo.ApprovalTime = DateTime.Now;
                                            orderInfo.TargetWarehouseId = targetWarehouseID;
                                            bool result = _unitOfWork.PurchaseOrderyRepository.Update(orderInfo);
                                            if (result)
                                            {
                                                var sizeList = orderInfo.CommonJpPurchaseDetails
                                                    .Select(x => x.SizeId)
                                                    .ToList();
                                                //重新计算阈值
                                                _unitOfWork.CalcThreshold(sizeList, orderInfo.OrgId, orderInfo.WarehouseId);

                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                            }
                                            else
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                            }

                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }
                            }
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        ///// <summary>
        ///// 维护装备基础信息
        ///// </summary>
        ///// <remarks>
        ///// ## 例子
        ///// 
        /////     { 
        /////       basicList:
        /////         [{
        /////         "warrantyCycle":0,
        /////         "repairCycle":0,
        /////         "productTime":"",
        /////         "useTime":"",
        /////         "price":0,
        /////         "useDirection":0,
        /////         "id":""
        /////         }]
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("UpdateBasicInfo")]
        //public HttpResponseMessage UpdateBasicInfo([FromBody] JObject jdata)
        //{
        //    try
        //    {
        //        if (jdata != null)
        //        {

        //            var entity = JsonManager.GetJsonEntity(jdata);
        //            if (entity == null)
        //            {
        //                return JsonManager.SimpleCustResponse($"model is null");
        //            }
        //            else if (entity?.basicList == null || entity?.basicList.Count == 0)
        //            {
        //                return JsonManager.SimpleCustResponse($"basicList is null");
        //            }
        //            else
        //            {
        //                List<string> failList = new List<string>();
        //                foreach (var item in entity?.basicList)
        //                {
        //                    bool bwarrantyCycle = int.TryParse(item?.warrantyCycle ?? "0", out int warrantyCycle);
        //                    bool brepairCycle = int.TryParse(item?.repairCycle ?? "0", out int repairCycle);
        //                    bool bproductTime = DateTime.TryParse(item?.productTime ?? "", out DateTime productTime);
        //                    bool buseTime = DateTime.TryParse(item?.useTime ?? "0", out DateTime useTime);
        //                    bool bprice = decimal.TryParse(item?.price ?? "0", out decimal price);
        //                    bool buseDirection = int.TryParse(item?.useDirection ?? "0", out int useDirection);
        //                    string id = item?.id ?? "";
        //                    bool flag = false;
        //                    if (string.IsNullOrEmpty(id))
        //                    {
        //                        return JsonManager.SimpleCustResponse($"id is require");
        //                    }

        //                    //else if (!bwarrantyCycle || warrantyCycle <= 0)
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"warrantyCycle is require");
        //                    //}
        //                    //else if (!brepairCycle || repairCycle <= 0)
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"repairCycle is require");
        //                    //}
        //                    //else if (!bproductTime || productTime == default)
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"productTime is require");
        //                    //}
        //                    //else if (!buseTime || useTime == default)
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"useTime is require");
        //                    //}
        //                    //else if (!bprice || price <= 0)
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"price is require");
        //                    //}
        //                    //else if (string.IsNullOrEmpty(item.useDirection ?? ""))
        //                    //{
        //                    //    return JsonManager.SimpleCustResponse($"useDirection is require");
        //                    //}
        //                    else if (!bwarrantyCycle && !brepairCycle
        //                        && !buseTime && !bproductTime
        //                        && !bprice && !buseDirection)
        //                    {
        //                        continue;
        //                    }
        //                    else
        //                    {
        //                        var detailInfo = _unitOfWork.DbContext.CommonJpPurchaseDetails
        //                            .Include(t => t.CommonJpPurchaseEpcs)
        //                            .FirstOrDefault(t => t.Id == id);
        //                        if (detailInfo == null)
        //                        {
        //                            return JsonManager.SimpleCustResponse($"data is null");
        //                        }
        //                        else
        //                        {
        //                            if (bwarrantyCycle)
        //                            {
        //                                flag = true;
        //                                detailInfo.WarrantyCycle = warrantyCycle;
        //                            }
        //                            if (brepairCycle)
        //                            {
        //                                flag = true;
        //                                detailInfo.RepairCycle = repairCycle;
        //                            }
        //                            if (bproductTime)
        //                            {
        //                                flag = true;
        //                                detailInfo.ProductTime = productTime;
        //                            }
        //                            if (buseDirection)
        //                            {
        //                                flag = true;
        //                                detailInfo.UseDirection = useDirection;
        //                            }
        //                            if (buseTime)
        //                            {
        //                                flag = true;
        //                                detailInfo.UseTime = useTime;
        //                            }
        //                            if (bprice)
        //                            {
        //                                flag = true;
        //                                detailInfo.Price = price;
        //                            }

        //                            if (flag)
        //                            {
        //                                bool result = _unitOfWork.PurchaseDetailRepository.Update(detailInfo);
        //                                if (!result)
        //                                {
        //                                    failList.Add(id);
        //                                }
        //                                else
        //                                {
        //                                    foreach (var inv in detailInfo.CommonJpPurchaseEpcs)
        //                                    {
        //                                        var _invItem = _unitOfWork.DbContext.CommonJpEquipmentInventories.FirstOrDefault(t => t.Epc.Contains(inv.Epc));
        //                                        if (_invItem != null)
        //                                        {
        //                                            _invItem.Price = price;
        //                                            _invItem.ProductTime = productTime;
        //                                            _invItem.UseTime = useTime;
        //                                            _invItem.UseDirection = useDirection;
        //                                            _invItem.WarrantyCycle = warrantyCycle;
        //                                            _invItem.RepairCycle = repairCycle;
        //                                            var res = _unitOfWork.EquipmentInventoryRepository.Update(_invItem);
        //                                        }
        //                                    }
        //                                }
        //                            }
        //                        }
        //                    }
        //                }

        //                if (failList.Count == 0)
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
        //                }
        //                else
        //                {
        //                    return JsonManager.SimpleCustResponse(ResultCode.OPERATE_FAILED.Message, failList);
        //                }
        //            }

        //        }
        //        else
        //        {
        //            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        _logger.LogError(ex.ToString());
        //        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //    }
        //}

        /// <summary>
        /// 删除维采购单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteOrder")]
        public async Task<HttpResponseMessage> DeleteOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpPurchaseOrders.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            bool result = _unitOfWork.PurchaseOrderyRepository.Delete(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


    }


}
