﻿using JmpCommon;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;
using JmpCommon.Tools;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class EquipmentDetailController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<EquipmentDetailController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpEquipmentInfo> ListEq = new List<BaseJpEquipmentInfo>();

        public EquipmentDetailController(ILogger<EquipmentDetailController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取装备列表（第三方使用）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "equipmentId":"第三层类型编号",
        ///         "name":"名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListEquipment")]
        public async Task<HttpResponseMessage> GetListEquipment([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => !t.Id.Equals(Guid.Empty.ToString());

                        ListEq = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList();

                        List<BaseJpEquipmentInfo> dataList = null;

                        string equipmentId = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.equipmentId))
                        {
                            equipmentId = entity.equipmentId;
                        }

                        dataList = GetClassID(equipmentId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(equipmentId))).ToList();


                        Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId);
                        }

                        var param = new string[] {
                       "Equipment",
                       "BaseJpSupplierEquipments"
                    };

                        List<BaseJpEquipmentDetail> dataDetailList = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, t => t.UpdateTime, false, param).ToList();


                        var data = dataDetailList.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.EquipmentId,
                            EquipmentName = c.Equipment?.Name,
                            c.Unit,
                            c.Note,
                            c.Code,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.UnitType,
                            supplierList = c.BaseJpSupplierEquipments.Select(t => new { t.SupplierCode })
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "equipmentId":"第三层类型编号",
        ///         "name":"名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListEquipmentDetail")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetListEquipmentDetail([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => !t.Id.Equals(Guid.Empty.ToString());

                        ListEq = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList();

                        List<BaseJpEquipmentInfo> dataList = null;

                        string equipmentId = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.equipmentId))
                        {
                            equipmentId = entity.equipmentId;
                        }

                        dataList = GetClassID(equipmentId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(equipmentId))).ToList();


                        Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId);
                        }

                        var param = new string[] {
                       "Equipment",
                       "BaseJpSupplierEquipments",
                       "BaseJpEquipmentSizes",
                    };

                        List<BaseJpEquipmentDetail> dataDetailList = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, t => t.UpdateTime, false, param).ToList();


                        var data = dataDetailList.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.EquipmentId,
                            EquipmentName = c.Equipment?.Name,
                            c.Unit,
                            c.Note,
                            c.Code,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.UnitType,
                            supplierList = c.BaseJpSupplierEquipments.Select(t => new { t.SupplierCode }),
                            sizeList = c.BaseJpEquipmentSizes.Select(x => new
                            {
                                x.Id,
                                x.SizeCode,
                                x.SizeName,
                                x.CreateTime,
                                x.UpdateUser,
                                x.DetailId,
                                x.Note,
                                x.UpdateTime,
                                x.EpcType,
                            }),
                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取装备分页列表根据更新时间
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "updateTime":""更新时间
        ///         "equipmentId":"第三层类型编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageEquipmentDetailByTime")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> GetPageEquipmentDetailByTime([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);





                        Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => !t.Id.Equals(Guid.Empty.ToString());

                        ListEq = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList();

                        List<BaseJpEquipmentInfo> dataList = null;

                        string equipmentId = Guid.Empty.ToString();
                        string updateTime = entity.updateTime;
                        if (!String.IsNullOrEmpty(entity.equipmentId))
                        {
                            equipmentId = entity.equipmentId;
                        }

                        dataList = GetClassID(equipmentId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(equipmentId))).ToList();


                        Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId);
                        }
                        expressionDetail = expressionDetail.AndAlso(t => t.UpdateTime >= DateTime.Parse(updateTime));
                        var param = new string[] {
                       "Equipment",
                       "BaseJpSupplierEquipments"
                    };

                        List<BaseJpEquipmentDetail> pagedata = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, p => p.UpdateTime, false, param).ToList();

                        var data = pagedata.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.EquipmentId,
                            c.Code,
                            EquipmentName = c.Equipment?.Name,
                            c.Unit,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.UnitType,
                            supplierList = c.BaseJpSupplierEquipments.Select(t => new { t.SupplierCode }),
                            hasChildren = true
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.Count,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "equipmentId":"第三层类型编号",
        ///         "name":"名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageEquipmentDetail")]
        public async Task<HttpResponseMessage> GetPageEquipmentDetail([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => !t.Id.Equals(Guid.Empty.ToString());

                        ListEq = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList();

                        List<BaseJpEquipmentInfo> dataList = null;

                        string equipmentId = Guid.Empty.ToString();
                        if (!String.IsNullOrEmpty(entity.equipmentId))
                        {
                            equipmentId = entity.equipmentId;
                        }

                        dataList = GetClassID(equipmentId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(equipmentId))).ToList();


                        Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = null;
                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string Name = entity.name;
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId) && t.Name.Contains(Name);
                        }
                        else
                        {
                            expressionDetail = t => dataList.Select(c => c.Id).Contains(t.EquipmentId);
                        }

                        var param = new string[] {
                       "Equipment",
                       "BaseJpSupplierEquipments"
                    };

                        PageData<BaseJpEquipmentDetail> pagedata = _unitOfWork.EquipmentDetailRepository.GetPage(expressionDetail, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.Sort,
                            c.Name,
                            c.EquipmentId,
                            EquipmentName = c.Equipment?.Name,
                            c.Unit,
                            c.Note,
                            c.CreateTime,
                            c.UpdateTime,
                            c.UpdateUser,
                            c.Code,
                            c.UnitType,
                            supplierList = c.BaseJpSupplierEquipments.Select(t => new { t.SupplierCode }),
                            hasChildren = true
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 添加或修改装备信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号",
        ///        "name":"装备名称",
        ///        "equipmentId" : "第三层类型ID",
        ///        "unit" : "单位",
        ///        "note" : "备注",
        ///        "updateUser":"操作用户ID"，
        ///        "supplierList":"供应商"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateEquipmentDetail")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateEquipmentDetail([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"Name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.equipmentId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"EquipmentId is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentDetail, bool>> expression = t => t.Id.Equals(id);

                            var param = new string[] {
                            "BaseJpSupplierEquipments"
                        };
                            BaseJpEquipmentDetail updateObject = _unitOfWork.EquipmentDetailRepository.GetList(expression, t => t.UpdateTime, false, param).FirstOrDefault();
                            if (updateObject != null)
                            {
                                string name = entity.name;
                                //判断重名
                                if (_unitOfWork.CommonJpTempEquipmentRepository.Any(x => x.Name == name && x.Id != updateObject.Id))
                                {
                                    return JsonManager.SimpleCustResponse($"已有相同名称物资在申请中");
                                }

                                updateObject.Name = name;
                                //updateObject.EquipmentId = entity.equipmentId; //不允许修改物资大类
                                updateObject.Unit = entity.unit;
                                updateObject.Note = entity.note;
                                updateObject.UnitType = entity.unitType;
                                updateObject.UpdateTime = System.DateTime.Now;
                                updateObject.UpdateUser = entity.updateUser;
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                            updateObject.BaseJpSupplierEquipments.Clear();
                            //for (var i = updateObject.BaseJpSupplierEquipments.Count; i > 0; i--)
                            //{
                            //    updateObject.BaseJpSupplierEquipments.Remove(updateObject.BaseJpSupplierEquipments.ToList()[i - 1]);
                            //}
                            if (entity.supplierList != null)
                            {
                                var eqid = updateObject.Id;
                                foreach (var item in entity.supplierList)
                                {
                                    string supplierId = item.supplierCode;
                                    if (!string.IsNullOrEmpty(supplierId))
                                    {
                                        BaseJpSupplierEquipment se = new BaseJpSupplierEquipment();
                                        se.Id = Guid.NewGuid().ToString();
                                        se.EquipmentId = eqid;
                                        se.SupplierCode = supplierId;
                                        se.State = 0;
                                        se.CreateTime = System.DateTime.Now;
                                        se.UpdateTime = System.DateTime.Now;
                                        se.UpdateUser = entity.updateUser;
                                        updateObject.BaseJpSupplierEquipments.Add(se);
                                    }
                                }
                            }

                            bool result = _unitOfWork.EquipmentDetailRepository.Update(updateObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {
                            //新增数据
                            var Id = Guid.NewGuid().ToString();
                            //获取code
                            string equipmentId = entity.equipmentId;

                            Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => t.Id.Equals(equipmentId);

                            var infoCode = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList().FirstOrDefault().Code.Substring(0, 4);

                            Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = t => t.EquipmentId.Equals(equipmentId);

                            var param = new string[] { };

                            string maxCount = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, t => t.UpdateTime, false, param).ToList().Max(c => c.Code);
                            var code = "";
                            if (string.IsNullOrEmpty(maxCount))
                            {
                                code = infoCode + "001";
                            }
                            else
                            {
                                code = infoCode + (int.Parse(maxCount.Substring(maxCount.Length - 3, 3)) + 1).ToString().PadLeft(3, '0');
                            }

                            BaseJpEquipmentDetail addObject = new BaseJpEquipmentDetail()
                            {
                                Id = Id,
                                Sort = null,
                                Name = entity.name,
                                EquipmentId = entity.equipmentId,
                                Unit = entity.unit,
                                Note = entity.note,
                                UnitType = entity.unitType,
                                CreateTime = System.DateTime.Now,
                                UpdateTime = System.DateTime.Now,
                                UpdateUser = entity.updateUser,
                                Code = code
                            };
                            string name = entity.name;
                            //判断重名
                            if (_unitOfWork.EquipmentDetailRepository.Any(x => x.Name == name))
                            {
                                return JsonManager.SimpleCustResponse($"装备名称重复");
                            }

                            if (entity.supplierList != null)
                            {
                                foreach (var item in entity.supplierList)
                                {
                                    string supplierId = item.supplierCode;
                                    if (!string.IsNullOrEmpty(supplierId))
                                    {
                                        BaseJpSupplierEquipment se = new BaseJpSupplierEquipment();
                                        se.Id = Guid.NewGuid().ToString();
                                        se.EquipmentId = Id;
                                        se.SupplierCode = supplierId;
                                        se.State = 0;
                                        se.CreateTime = System.DateTime.Now;
                                        se.UpdateTime = System.DateTime.Now;
                                        se.UpdateUser = entity.updateUser;
                                        addObject.BaseJpSupplierEquipments.Add(se);
                                    }
                                }
                            }

                            bool result = _unitOfWork.EquipmentDetailRepository.Insert(addObject);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 添加或修改装备信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///     "type" : "类型","detail,size,supplier"
        ///     "equipmentList":{
        ///     [   
        ///        "name":"名称",
        ///        "code" : "编码id",
        ///        "equipmentId":"大类ID",当type为detail时使用
        ///        "unit":"单位ID",当type为detail时使用
        ///        "detailId" : "物资id，当type为size时使用",
        ///        "epcType" : "epc类型",当type为size时使用
        ///        "supplierCode":"供应商ID"，当type为supplier时使用
        ///        "shortName":"简称"当type为supplier时使用
        ///        "equipmentName":"简称"当type为size时使用
        ///        "supplierList":{
        ///        [
        ///         supplierId:"供应商ID"当type为detail时使用
        ///         ]}
        ///        ]}
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddSizeDetailSupplier")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddSizeDetailSupplier([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }

                        else
                        {
                            string[] parmas = new string[] {

                            };

                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();



                            bool processResult = _unitOfWork.AddProcess(processCurrentId, "", (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, "");
                            string type = entity.type;
                            List<CommonJpTempEquipment> tempEqList = new List<CommonJpTempEquipment>();

                            List<string> sizeList = new List<string>();
                            if (type.Equals("detail"))//新增装备
                            {
                                var detailAmount = _unitOfWork.EquipmentDetailRepository.GetList(p => p.Id != null, null, false, parmas);

                                foreach (var item in entity.equipmentList)
                                {
                                    string equipmentId = item.equipmentId;

                                    //Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => t.Id.Equals(equipmentId);
                                    //var infoCode = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList().FirstOrDefault().Code.Substring(0, 4);


                                    //Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = t => t.EquipmentId.Equals(equipmentId);


                                    //var param = new string[] { };

                                    //string maxCount = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, t => t.UpdateTime, false, param).ToList().Max(c => c.Code);
                                    //var code = "";
                                    //if (string.IsNullOrEmpty(maxCount))
                                    //{
                                    //    code = infoCode + "001";
                                    //}
                                    //else
                                    //{
                                    //    code = infoCode + (int.Parse(maxCount.Substring(maxCount.Length - 3, 3)) + 1).ToString().PadLeft(3, '0');
                                    //}

                                    //string name = item.name;
                                    //var supplierAmount2 = _unitOfWork.CommonJpTempEquipmentRepository.GetList(p => p.Name.Equals(name));
                                    //if (detailAmount.Where(p => p.Name.Equals(name)).Count() > 0 || supplierAmount2.Count() > 0)
                                    //{
                                    //    return JsonManager.SimpleStatusResponse(ResultCode.BASE_EXIST);
                                    //}
                                    CommonJpTempEquipment tempEq = new CommonJpTempEquipment()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        //Code = code,
                                        Name = item.name,
                                        CurrnetId = processCurrentId,
                                        Type = type,
                                        Unit = item.unit,
                                        EquipmentId = item.equipmentId
                                    };

                                    tempEqList.Add(tempEq);
                                }


                            }

                            bool result = _unitOfWork.CommonJpTempEquipmentRepository.Insert(tempEqList, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 审核基础信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///     "type" : "类型","detail,size,supplier"
        ///     "currentID":""流程表ID
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproverSizeDetailSupplier")]
        public async Task<HttpResponseMessage> ApproverSizeDetailSupplier([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);


                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(entity.type ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"type is require");
                        }
                        else if (entity.equipmentList == null || entity.equipmentList.Count == null || entity.equipmentList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"equipmentList is require");
                        }

                        else
                        {
                            string[] parmas = new string[] {

                            };
                            bool result = false;
                            string type = entity.type;
                            string currentID = entity.currentID;
                            string flowType = entity.type;
                            string flowState = entity.flowState;
                            string currentType = string.Empty;
                            List<CommonJpTempEquipment> tempEqList = new List<CommonJpTempEquipment>();
                            if (flowType.Equals("detail") || flowType.Equals("size") || flowType.Equals("supplier"))
                            {
                                currentType = "baseInfo";
                            }
                            bool auditResult = _unitOfWork.AuditProcess(currentType, currentID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                    (string)entity.currentStepName, (string)entity.flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, "", "approve");
                            if (flowState.Equals("False"))
                            {
                                auditResult = _unitOfWork.SaveChanges() > 0;
                                if (auditResult)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else if (flowState.Equals("True"))
                            {
                                if (!auditResult)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                                var equipmetList = _unitOfWork.CommonJpTempEquipmentRepository.GetList(p => p.CurrnetId.Equals(currentID), null, false, parmas).ToList();
                                if (type.Equals("size"))//新增装备号型
                                {

                                    if (equipmetList.Count > 0)
                                    {
                                        List<BaseJpEquipmentSize> sizeUpdateList = new List<BaseJpEquipmentSize>();
                                        foreach (var item in equipmetList)
                                        {
                                            BaseJpEquipmentSize size = new BaseJpEquipmentSize()
                                            {
                                                Id = Guid.NewGuid().ToString(),
                                                SizeCode = int.Parse(item.Code),
                                                SizeName = item.Name,
                                                CreateTime = DateTime.Now,
                                                DetailId = item.DetailId,
                                                EpcType = int.Parse(item.EpcType),
                                                UpdateTime = DateTime.Now,
                                                UpdateUser = "系统管理员"

                                            };
                                            sizeUpdateList.Add(size);
                                        }
                                        result = _unitOfWork.EquipmentSizeRepository.Insert(sizeUpdateList);

                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }


                                }
                                else if (type.Equals("detail"))//新增装备
                                {
                                    List<BaseJpEquipmentDetail> detailList = new List<BaseJpEquipmentDetail>();

                                    var detailAmount = _unitOfWork.EquipmentDetailRepository.GetList(p => p.Id != null, null, false, parmas);

                                    using (var transaction = _unitOfWork.DbContext.Database.BeginTransaction())
                                    {
                                        try
                                        {
                                            //使用前台上传更新后的数据
                                            foreach (var item in entity.equipmentList)
                                            {
                                                string equipmentId = item.equipmentId;
                                                string tempId = item.id;
                                                //判重
                                                Expression<Func<BaseJpEquipmentInfo, bool>> expression = t => t.Id.Equals(equipmentId);
                                                var infoCode = _unitOfWork.EquipmentInfoRepository.GetList(expression, t => t.UpdateTime).ToList().FirstOrDefault().Code.Substring(0, 4);

                                                Expression<Func<BaseJpEquipmentDetail, bool>> expressionDetail = t => t.EquipmentId.Equals(equipmentId);

                                                var param = new string[] { };

                                                string maxCount = _unitOfWork.EquipmentDetailRepository.GetList(expressionDetail, t => t.UpdateTime, false, param).ToList().Max(c => c.Code);
                                                var code = "";
                                                if (string.IsNullOrEmpty(maxCount))
                                                {
                                                    code = infoCode + "001";
                                                }
                                                else
                                                {
                                                    code = infoCode + (int.Parse(maxCount.Substring(maxCount.Length - 3, 3)) + 1).ToString().PadLeft(3, '0');
                                                }

                                                string name = item.name;

                                                if (detailAmount.Where(p => p.Name.Equals(name)).Count() > 0)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.BASE_EXIST);
                                                }

                                                BaseJpEquipmentDetail detail = new BaseJpEquipmentDetail()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    State = "",
                                                    Code = code,
                                                    Name = item.name,
                                                    CreateTime = DateTime.Now,
                                                    EquipmentId = item.equipmentId,
                                                    Unit = item.unit,
                                                    UpdateTime = DateTime.Now,
                                                    UpdateUser = "系统管理员"

                                                };
                                                //detailList.Add(detail);
                                                _unitOfWork.EquipmentDetailRepository.Insert(detail);
                                            }

                                            _unitOfWork.CommonJpTempEquipmentRepository.Delete(equipmetList, true);
                                            //result = _unitOfWork.EquipmentDetailRepository.Insert(detailList, true);
                                            transaction.Commit();
                                            result = true;
                                        }
                                        catch (Exception e)
                                        {
                                            Console.WriteLine(e);
                                            result = false;
                                            transaction.Rollback();
                                        }
                                    }

                                }
                                else if (type.Equals("supplier"))//新增装备供应商
                                {
                                    List<BaseJpSupplier> supplierList = new List<BaseJpSupplier>();
                                    foreach (var item in equipmetList)
                                    {
                                        BaseJpSupplier supplier = new BaseJpSupplier()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            ShortName = item.ShortName,
                                            SupplierCode = item.SupplierCode,
                                            Name = item.Name,
                                            CreateTime = DateTime.Now,
                                            UpdateTime = DateTime.Now,
                                            UpdateUser = "系统管理员"

                                        };
                                        supplierList.Add(supplier);
                                    }
                                    result = _unitOfWork.SupplierRepository.Insert(supplierList);

                                }
                            }


                            //result = _unitOfWork.CommonJpTempEquipmentRepository.Insert(tempEqList, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除装备信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///        "id" : "编号"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteEquipmentDetail")]
        public async Task<HttpResponseMessage> DeleteEquipmentDetail([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            Expression<Func<BaseJpEquipmentDetail, bool>> expression = t => t.Id.Equals(id);
                            BaseJpEquipmentDetail deleteObject = _unitOfWork.EquipmentDetailRepository.Get(expression);
                            if (deleteObject != null)
                            {
                                bool result = _unitOfWork.EquipmentDetailRepository.Delete(deleteObject);

                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                        else
                        {

                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        //递归取数据
        private List<BaseJpEquipmentInfo> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }

    }
}
