using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration;
using System.Linq;
using System.Threading.Tasks;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using Microsoft.AspNetCore;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using NLog.Web;

namespace JmpMsgService
{
    public class Program
    {
        public static IConfiguration Configuration { get; }

        public static void Main(string[] args)
        {
            var logger = NLog.Web.NLogBuilder.ConfigureNLog("nlog.config.xml").GetCurrentClassLogger();
            try
            {
                CreateHostBuilder(args).Build().Run();
            }
            catch (Exception ex)
            {
                //NLog: catch setup errors
                logger.Error(ex);

            }
        }

        public static IHostBuilder CreateHostBuilder(string[] args) =>

               Host.CreateDefaultBuilder(args).UseWindowsService()
                   .ConfigureServices((hostContext, services) =>
                   {
                       services.AddHostedService<MsgPushService>();
                       //services.AddHostedService<GeneralService>();

                       services.AddTransient(typeof(UnitOfWork));//ע빤Ԫ
                       services.AddDbContext<JunmppolicesqlContext>(options =>
                       {

                           var builder = new ConfigurationBuilder().AddJsonFile("appsettings.json");
                           var configuration = builder.Build();
                           var connection = configuration.GetConnectionString("MySqlConnection");
                           options.UseSqlServer(connection);
                       }, ServiceLifetime.Singleton);
                   }).ConfigureLogging(logging =>
                   {
                       logging.ClearProviders();
                       logging.SetMinimumLevel(LogLevel.Information);
                   }).UseNLog();

    }
}
