﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Microsoft.OpenApi.Writers;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Net.WebSockets;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    [NoSignAttribute]
    public class ViewController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<ViewController> _logger;
        UnitOfWork _unitOfWork;

        public ViewController(ILogger<ViewController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 总数统计(在库总量、领用总量、维修数量、报废总量、单警柜个数、仓库个数) 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"组织机构查询ID",
        ///         "name":"大类名称",
        ///         "level":"本级、本级及下级"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCount")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetCount([FromBody] JObject jdata)
        {
            try
            {
                if (jdata != null)
                {


                    var entity = JsonManager.GetJsonEntity(jdata);

                    //在库总量、领用总量、维修数量、报废总量、单警柜数、仓库数
                    int zkTopCount = 0;
                    int zkCount = 0;
                    int lyCount = 0;
                    int wxCount = 0;
                    int bfCount = 0;
                    int houseCount = 0;

                    var jjbfCount = 0;

                    string FindCode = entity.findCode;

                    Expression<Func<ViewEquipment, bool>> ViewEquipmentExpression = t => !t.OrgId.Equals(null);

                    string level = entity.level;
                    if (string.IsNullOrEmpty(level))
                    {
                        level = "本级及下级";
                    }

                    if (level == "本级")
                    {
                        ViewEquipmentExpression = t => t.OrgCode == FindCode.PadRight(12, '0') && t.ParentName != null;
                    }
                    else if (level == "本级及下级")
                    {
                        ViewEquipmentExpression = t => t.OrgCode.IndexOf(FindCode) == 0 && t.ParentName != null;
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                    IQueryable<ViewEquipment> ViewEquipmentList = _unitOfWork.ViewEquipmentRepository.GetArray(ViewEquipmentExpression, t => t.FindCode, false);

                    //在库总量
                    zkTopCount = ViewEquipmentList.Count();

                    if (!String.IsNullOrEmpty(entity.name))
                    {
                        string parentName = entity.name;
                        zkCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                        //调拨数量
                        houseCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(1)).Count();
                        //领用总量
                        lyCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                        //维修数量
                        wxCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(4)).Count();
                        //报废总量
                        bfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(6)).Count();

                        //即将报废
                        jjbfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6)).Count();

                    }
                    else
                    {
                        zkCount = ViewEquipmentList.Where(c => (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                        //调拨数量
                        houseCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(1)).Count();
                        //领用总量
                        lyCount = ViewEquipmentList.Where(c => !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                        //维修数量
                        wxCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(4)).Count();
                        //报废总量
                        bfCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(6)).Count();

                        //即将报废
                        jjbfCount = ViewEquipmentList.Where(c => c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6)).Count();

                    }

                    var reData = new { zkCount = zkCount, lyCount = lyCount, wxCount = wxCount, bfCount = bfCount, houseCount = houseCount, zkTopCount = zkTopCount, jjbfCount = jjbfCount };

                    return JsonManager.ReturnSuccessResponse(reData);

                }
                else
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                }
            }
            catch (Exception ex)
            {

                //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
            }

        }


        /// <summary>
        /// 总数统计(在库总量、领用总量、维修数量、报废总量（销毁数量）、单警柜个数、仓库个数、报废区内装备数量) 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCountOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetCountOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {


                        var entity = JsonManager.GetJsonEntity(jdata);

                        //在库总量、领用总量、维修数量、报废总量、单警柜数、仓库数
                        int zkTopCount = 0;
                        int zkCount = 0;
                        int lyCount = 0;
                        int wxCount = 0;
                        int bfCount = 0;
                        int houseCount = 0;

                        //报废区内装备数量-》前端为报废数量
                        int baofeiquCount = 0;

                        //即将报废 已超期未报废 超期未还
                        var jjbfCount = 0;
                        var ycqCount = 0;
                        var cqwhCount = 0;

                        string orgId = entity.orgId;

                        Expression<Func<ViewEquipment, bool>> ViewEquipmentExpression = t => t.OrgId.Equals(orgId) && t.ParentName != null;

                        IQueryable<ViewEquipment> ViewEquipmentList = _unitOfWork.ViewEquipmentRepository.GetArray(ViewEquipmentExpression, t => t.WarehouseCode, false);

                        //在库总量
                        zkTopCount = ViewEquipmentList.Count();

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string parentName = entity.name;
                            zkCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                            //调拨数量
                            houseCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(1)).Count();
                            //领用总量
                            lyCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                            //维修数量
                            wxCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(4)).Count();
                            //报废总量
                            bfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(6)).Count();

                            //即将报废
                            jjbfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6) && c.IsFixed == false).Count();
                            //已超期未报废
                            ycqCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.SafeLevel.Equals(2) && !c.CurrentState.Equals(6) && c.IsFixed == false).Count();

                            //报废区内装备数量
                            baofeiquCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.IsFixed == true && !c.CurrentState.Equals(6)).Count();

                            //超期未还
                            cqwhCount = Convert.ToInt32(_unitOfWork.BorrowViewRepository.Count(x =>
                                x.OrgId.Contains(orgId) && x.IsOverdue.Contains("true")));


                        }
                        else
                        {
                            zkCount = ViewEquipmentList.Where(c => (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                            //调拨数量
                            houseCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(1)).Count();
                            //领用总量
                            lyCount = ViewEquipmentList.Where(c => !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                            //维修数量
                            wxCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(4)).Count();
                            //报废总量
                            bfCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(6)).Count();

                            //报废区内装备数量
                            baofeiquCount = ViewEquipmentList.Where(c => c.IsFixed == true && !c.CurrentState.Equals(6)).Count();

                            //即将报废
                            jjbfCount = ViewEquipmentList.Where(c => c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6) && c.IsFixed == false).Count();
                            //已超期未报废
                            ycqCount = ViewEquipmentList.Where(c => c.SafeLevel.Equals(2) && !c.CurrentState.Equals(6) && c.IsFixed == false).Count();

                            //超期未还
                            cqwhCount = Convert.ToInt32(_unitOfWork.BorrowViewRepository.Count(x =>
                                x.OrgId.Contains(orgId) && x.IsOverdue.Contains("true")));
                        }

                        var reData = new
                        {
                            zkCount = zkCount,
                            lyCount = lyCount,
                            wxCount = wxCount,
                            bfCount = bfCount,
                            houseCount = houseCount,
                            zkTopCount = zkTopCount,
                            jjbfCount = jjbfCount,
                            ycqCount = ycqCount,
                            cqwhCount = cqwhCount,
                            baofeiquCount = baofeiquCount,
                        };

                        return JsonManager.ReturnSuccessResponse(reData);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 总数统计 杭州自建(在库总量、领用总量、维修数量、报废总量、单警柜个数、仓库个数) 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCountOrgHZ")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetCountOrgHZ([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {


                        var entity = JsonManager.GetJsonEntity(jdata);

                        //在库总量、领用总量、维修数量、报废总量、单警柜数、仓库数
                        int zkTopCount = 0;
                        int zkCount = 0;
                        int lyCount = 0;
                        int wxCount = 0;
                        int bfCount = 0;
                        int houseCount = 0;

                        //即将报废 已超期未报废 超期未还
                        var jjbfCount = 0;
                        var ycqCount = 0;
                        var cqwhCount = 0;

                        string orgId = entity.orgId;

                        Expression<Func<ViewEquipment, bool>> ViewEquipmentExpression = t => t.OrgId.Equals(orgId) && t.ParentName != null;

                        IQueryable<ViewEquipment> ViewEquipmentList = _unitOfWork.ViewEquipmentRepository.GetArray(ViewEquipmentExpression, t => t.WarehouseCode, false);

                        //在库总量
                        zkTopCount = ViewEquipmentList.Count();

                        if (!String.IsNullOrEmpty(entity.name))
                        {
                            string parentName = entity.name;
                            zkCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                            //调拨数量
                            houseCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(1)).Count();
                            //领用总量
                            lyCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                            //维修数量
                            wxCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(4)).Count();
                            //报废总量
                            bfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.CurrentState.Equals(6)).Count();

                            //即将报废
                            jjbfCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6)).Count();
                            //已超期未报废
                            ycqCount = ViewEquipmentList.Where(c => c.ParentName.Equals(parentName) && c.SafeLevel.Equals(2) && !c.CurrentState.Equals(6)).Count();

                            //超期未还
                            cqwhCount = Convert.ToInt32(_unitOfWork.BorrowViewRepository.Count(x =>
                                x.OrgId.Contains(orgId) && x.IsOverdue.Contains("true")));
                        }
                        else
                        {
                            zkCount = ViewEquipmentList.Where(c => (c.CurrentState.Equals(0) || c.CurrentState.Equals(3))).Count();
                            //调拨数量
                            houseCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(1)).Count();
                            //领用总量
                            lyCount = ViewEquipmentList.Where(c => !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(1) || c.CurrentState.Equals(4) || c.CurrentState.Equals(6))).Count();
                            //维修数量
                            wxCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(4)).Count();
                            //报废总量
                            bfCount = ViewEquipmentList.Where(c => c.CurrentState.Equals(6)).Count();

                            //即将报废
                            jjbfCount = ViewEquipmentList.Where(c => c.SafeLevel.Equals(1) && !c.CurrentState.Equals(6)).Count();
                            //已超期未报废
                            ycqCount = ViewEquipmentList.Where(c => c.SafeLevel.Equals(2) && !c.CurrentState.Equals(6)).Count();

                            //超期未还
                            cqwhCount = Convert.ToInt32(_unitOfWork.BorrowViewRepository.Count(x =>
                                x.OrgId.Contains(orgId) && x.IsOverdue.Contains("true")));
                        }

                        var thisYear = new DateTime(DateTime.Now.Year, 1, 1);
                        //今年出库数 今年所有出入库记录为出库的数据
                        var jncksCount = _unitOfWork.EquipmentStateRepository.Count(x => x.OrgId == orgId && x.OutInState == 0 && x.OutTime > thisYear);

                        //今年报废数 统计今年所有报废单装备数量
                        var jnbfsCount = _unitOfWork.DbContext.CommonJpFixReceiveApplyDetails
                            .Include(x => x.Order)
                            .Count(x => x.Order.OrgId == orgId && x.Order.CurrentState == 1 && x.State == 1 &&
                                        x.Order.CreateTime > thisYear);

                        var reData = new
                        {
                            zkCount = zkCount,
                            lyCount = lyCount,
                            wxCount = wxCount,
                            bfCount = bfCount,
                            houseCount = houseCount,
                            zkTopCount = zkTopCount,
                            jjbfCount = jjbfCount,
                            ycqCount = ycqCount,
                            cqwhCount = cqwhCount,
                            jncksCount = jncksCount,
                            jnbfsCount = jnbfsCount
                        };

                        return JsonManager.ReturnSuccessResponse(reData);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 九大类在库总量 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///         "level":"本级、本级及下级"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetGroupByCount")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetGroupByCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<ViewEquipment, bool>> ViewEquipmentExpression = t => !t.OrgId.Equals(null);

                        string FindCode = entity.findCode;

                        string level = entity.level;
                        if (string.IsNullOrEmpty(level))
                        {
                            level = "本级及下级";
                        }

                        if (level == "本级")
                        {
                            ViewEquipmentExpression = t => t.OrgCode == FindCode.PadRight(12, '0') && t.ParentName != null && (t.CurrentState.Equals(0) || t.CurrentState.Equals(3));
                        }
                        else if (level == "本级及下级")
                        {
                            ViewEquipmentExpression = t => t.OrgCode.IndexOf(FindCode) == 0 && t.ParentName != null && (t.CurrentState.Equals(0) || t.CurrentState.Equals(3));
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        IQueryable<ViewEquipment> ViewEquipmentList = _unitOfWork.ViewEquipmentRepository.GetArray(ViewEquipmentExpression, t => t.FindCode, false);

                        var groupList = ViewEquipmentList.GroupBy(c => c.ParentName).Select(g => new { name = g.Key, value = g.Count() }).ToList();

                        return JsonManager.ReturnSuccessResponse(groupList);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 九大类在库总量 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetGroupByCountOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetGroupByCountOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;

                        if (String.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }


                        var param = new string[] {
                        "WarehouseCodeNavigation"
                    };

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.WarehouseCodeNavigation.OrgizationId.Equals(orgId);

                        IQueryable<CommonJpEquipmentInventory> inventoryList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, t => t.WarehouseCode, false, param);

                        Expression<Func<ViewEquipmentCount, bool>> ViewEquipmentCountExpression = t => t.OrgId.Equals(orgId);

                        IQueryable<ViewEquipmentCount> ViewEquipmentCountList = _unitOfWork.ViewEquipmentCountRepository.GetList(ViewEquipmentCountExpression, t => t.WarehouseCode, false);

                        var groupList = ViewEquipmentCountList.GroupBy(c => c.ParentName).Select(g => new { item = g.Key, count = g.Sum(s => s.SizeCount) });


                        //在库数、出库数、报废数
                        int zkCount = 0;
                        int ckCount = 0;
                        int bfCount = 0;

                        //在库数
                        zkCount = inventoryList.Where(c => (c.CurrentState.Equals(0) || c.CurrentState.Equals(3)) && (!c.InventoryState.Equals("loss"))).Count();

                        //出库数
                        ckCount = inventoryList.Where(c => (!(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(6))) && (!c.InventoryState.Equals("loss"))).Count();

                        //报废数
                        bfCount = inventoryList.Where(c => c.CurrentState.Equals(6) && (!c.InventoryState.Equals("loss"))).Count();


                        JArray reData = new JArray();

                        reData.Add(new JObject() {
                                        new JProperty("item","在库数"),
                                        new JProperty("count",zkCount),
                                    });

                        reData.Add(new JObject() {
                                        new JProperty("item","出库数"),
                                        new JProperty("count",ckCount),
                                    });
                        reData.Add(new JObject() {
                                        new JProperty("item","报废数"),
                                        new JProperty("count",bfCount),
                                    });

                        var returnData = new { tjList = reData, typeList = groupList };

                        return JsonManager.ReturnSuccessResponse(returnData);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 区域分类在库总量 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetGroupByAreaCount")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetGroupByAreaCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CAreaList> data = _unitOfWork.ViewEquipmentRepository.Exec_Pro(FindCode).ToList();

                        data = data.Where(c => c.SumCount > 0).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 使用次数近30天Top5 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetTop5")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetTop5([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP(" EXEC c_top5_sy_ps @p_findCode ='" + FindCode + "'").ToList();

                        List<Object> itemList = new List<object>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            var item = new { id = i + 1, itemNum = data[i].MonthP, workUnit = data[i].ParentName };
                            itemList.Add(item);
                        }
                        return JsonManager.ReturnSuccessResponse(itemList);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }



        /// <summary>
        /// 使用次数，维修，报废大屏页面 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetSyWxBf")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetSyWxBf([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CSyP> sydata = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_sy_ps @p_findCode ='" + FindCode + "'").ToList();
                        List<CSyP> wxdata = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_wx_p @p_findCode ='" + FindCode + "'").ToList();
                        List<CSyP> bfdata = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_bf_p @p_findCode ='" + FindCode + "'").ToList();

                        sydata = sydata.OrderBy(c => c.ParentName).ToList();
                        wxdata = wxdata.OrderBy(c => c.ParentName).ToList();
                        bfdata = bfdata.OrderBy(c => c.ParentName).ToList();

                        List<String> pList = new List<String>();

                        List<List<int>> dataType = new List<List<int>>();

                        for (var i = 0; i < sydata.Count; i++)
                        {
                            if (!pList.Contains(sydata[i].ParentName))
                            {
                                pList.Add(sydata[i].ParentName);
                            }
                        }

                        for (var i = 0; i < wxdata.Count; i++)
                        {
                            if (!pList.Contains(wxdata[i].ParentName))
                            {
                                pList.Add(wxdata[i].ParentName);
                            }
                        }

                        for (var i = 0; i < bfdata.Count; i++)
                        {
                            if (!pList.Contains(bfdata[i].ParentName))
                            {
                                pList.Add(bfdata[i].ParentName);
                            }
                        }

                        List<int> syList = new List<int>();
                        for (var i = 0; i < pList.Count; i++)
                        {
                            var flg = true;
                            for (var j = 0; j < sydata.Count; j++)
                            {
                                if (pList[i].Equals(sydata[j].ParentName))
                                {
                                    syList.Add(int.Parse(sydata[i].MonthP.ToString()));
                                    flg = false;
                                    break;
                                }
                            }
                            if (flg)
                            {
                                syList.Add(0);
                            }
                        }

                        dataType.Add(syList);

                        List<int> wxList = new List<int>();
                        for (var i = 0; i < pList.Count; i++)
                        {
                            var flg = true;
                            for (var j = 0; j < wxdata.Count; j++)
                            {
                                if (pList[i].Equals(wxdata[j].ParentName))
                                {
                                    wxList.Add(int.Parse(wxdata[i].WeekP.ToString()));
                                    flg = false;
                                    break;
                                }
                            }
                            if (flg)
                            {
                                wxList.Add(0);
                            }
                        }

                        dataType.Add(wxList);

                        List<int> bfList = new List<int>();
                        for (var i = 0; i < pList.Count; i++)
                        {
                            var flg = true;
                            for (var j = 0; j < bfdata.Count; j++)
                            {
                                if (pList[i].Equals(bfdata[j].ParentName))
                                {
                                    bfList.Add(int.Parse(bfdata[i].WeekP.ToString()));
                                    flg = false;
                                    break;
                                }
                            }
                            if (flg)
                            {
                                bfList.Add(0);
                            }
                        }

                        dataType.Add(bfList);

                        var reData = new { pList = pList, dataType = dataType };

                        return JsonManager.ReturnSuccessResponse(reData);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }





        /// <summary>
        /// 使用率统计按近7天和近30天 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetSyP")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetSyP([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP(" EXEC c_sy_ps @p_findCode ='" + FindCode + "'").ToList();

                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 维修近90天和近180天次数
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWxP")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetWxP([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_wx_p @p_findCode ='" + FindCode + "'").ToList();
                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 报废近90天和近180天次数
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetBfP")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetBfP([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string FindCode = entity.findCode;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_bf_p @p_findCode ='" + FindCode + "'").ToList();
                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 使用次数统计按近7天和近30天 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetSyPOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetSyPOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP(" EXEC c_sy_ps_org @p_orgId ='" + orgId + "'").ToList();

                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();
                        List<Object> tList = new List<Object>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            var t = new { ParentName = data[i].ParentName, 近七天使用次数 = data[i].WeekP, 近三十天使用次数 = data[i].MonthP };
                            tList.Add(t);
                        }

                        return JsonManager.ReturnSuccessResponse(tList);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }



        /// <summary>
        /// 维修次数统计按近7天和近30天 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWxPOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetWxPOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_wx_p_org @p_orgId ='" + orgId + "'").ToList();
                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();

                        List<Object> tList = new List<Object>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            var t = new { ParentName = data[i].ParentName, 近三个月维修次数 = data[i].WeekP, 近半年维修次数 = data[i].MonthP };
                            tList.Add(t);
                        }
                        return JsonManager.ReturnSuccessResponse(tList);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 报废数计按近7天和近30天 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetBfPOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetBfPOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;

                        List<CSyP> data = _unitOfWork.ViewEquipmentRepository.Exec_ProP("EXEC c_bf_p_org @p_orgId ='" + orgId + "'").ToList();
                        data = data.Where(c => c.MonthP > 0 || c.WeekP > 0).ToList();
                        List<Object> tList = new List<Object>();
                        for (var i = 0; i < data.Count; i++)
                        {
                            var t = new { ParentName = data[i].ParentName, 近三个月报废数 = data[i].WeekP, 近半年使报废数 = data[i].MonthP };
                            tList.Add(t);
                        }
                        return JsonManager.ReturnSuccessResponse(tList);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }



        /// <summary>
        /// 大屏类型区域统计
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAreaType")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetAreaType([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string findcode = entity.findCode;
                        if (string.IsNullOrEmpty(findcode))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        Expression<Func<ViewEquipment, bool>> expressionPoliceman = null;

                        expressionPoliceman = t => t.FindCode.Contains(findcode);

                        List<ViewEquipment> equipmentList = _unitOfWork.ViewEquipmentRepository.GetList(expressionPoliceman).OrderBy(c => c.FindCode.Length).ToList();

                        if (findcode.Length == 6)
                        {
                            var data = equipmentList.GroupBy(t => t.OrgName).Select(c => new
                            {
                                c.FirstOrDefault().OrgName,
                                c.FirstOrDefault().OrgCode,
                                c.FirstOrDefault().FindCode,
                                c.FirstOrDefault().IsMap,
                                children = c.GroupBy(a => a.ParentName).Select(c => new
                                {
                                    id = c.FirstOrDefault().TypeOneId,
                                    name = c.FirstOrDefault().ParentName,
                                    zsCount = c.Count(f => f.CurrentState != null)
                                }).Where(f => f.id != null && f.zsCount != 0).OrderBy(c => c.id).ToList()
                            }).ToList();

                            List<String> pList = new List<String>();

                            for (var i = 0; i < data.Count; i++)
                            {
                                for (var j = 0; j < data[i].children.Count; j++)
                                {
                                    if (!pList.Contains(data[i].children[j].name))
                                    {
                                        pList.Add(data[i].children[j].name);
                                    }
                                }
                            }

                            var redata = new { data = data.OrderBy(x => x.OrgCode).ToList(), pList = pList };

                            return JsonManager.ReturnSuccessResponse(redata);
                        }
                        else
                        {
                            var codeLen = findcode.Length + 2;
                            var data = equipmentList.GroupBy(t => t.FindCode.PadLeft(codeLen, '0').Substring(0, codeLen)).Select(c => new
                            {
                                OrgName = c.FirstOrDefault().AreaName,
                                c.FirstOrDefault(x => x.OrgCode == c.FirstOrDefault().FindCode.PadRight(12, '0'))?.OrgCode,
                                c.FirstOrDefault().FindCode,
                                isMap = c.FirstOrDefault(x => x.OrgCode == c.FirstOrDefault().FindCode.PadRight(12, '0'))?.IsMap ?? 0,
                                zsCount = c.Count(f => f.CurrentState != null),
                                children = c.GroupBy(a => a.ParentName).Select(c => new
                                {
                                    id = c.FirstOrDefault().TypeOneId,
                                    name = c.FirstOrDefault().ParentName,
                                    zsCount = c.Count(f => f.CurrentState != null)
                                }).Where(f => f.id != null).OrderBy(c => c.id).ToList()
                            }).ToList();
                            List<String> pList = new List<String>();

                            for (var i = 0; i < data.Count; i++)
                            {
                                for (var j = 0; j < data[i].children.Count; j++)
                                {
                                    if (!pList.Contains(data[i].children[j].name))
                                    {
                                        pList.Add(data[i].children[j].name);
                                    }
                                }
                            }

                            var redata = new { data = data.OrderBy(x => x.OrgCode).ToList(), pList = pList };

                            return JsonManager.ReturnSuccessResponse(redata);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 大屏名称统计列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "findCode":"33"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetNameList")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetNameList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string findcode = entity.findCode;

                        Expression<Func<ViewEquipment, bool>> expressionPoliceman = null;

                        string level = entity.level;
                        if (string.IsNullOrEmpty(level))
                        {
                            level = "本级及下级";
                        }

                        if (level == "本级")
                        {
                            expressionPoliceman = t => t.OrgCode == findcode.PadRight(12, '0');
                        }
                        else if (level == "本级及下级")
                        {
                            expressionPoliceman = t => t.FindCode.Contains(findcode);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        List<ViewEquipment> equipmentList = _unitOfWork.ViewEquipmentRepository.GetList(expressionPoliceman).OrderBy(c => c.FindCode.Length).ToList();

                        var data = equipmentList.GroupBy(t => t.EquipmentName).Select(c => new
                        {
                            ParentName = c.FirstOrDefault().ParentName,
                            name = c.FirstOrDefault().EquipmentName,
                            zsCount = c.Count(f => f.CurrentState != null),
                            zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                            ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6) || f.CurrentState.Equals(1) || f.CurrentState.Equals(4))).Count(),
                            dbCount = c.Where(f => f.CurrentState.Equals(1)).Count(),
                            bfCount = c.Where(f => f.CurrentState.Equals(6)).Count()
                        }).Where(c => c.name != null).ToList();
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();
        /// <summary>
        /// 人员统计报表 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID",
        ///         "policeCode":"警员Code"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPoliceOrg")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPoliceOrg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string orgId = entity.orgId;
                        string policeCode = entity.policeCode;
                        List<BaseJpOrganization> dataList = null;
                        ListEq = _unitOfWork.OrganizationRepository.GetList(t => t.State == 1, t => t.Code).ToList();

                        dataList = GetClassID(orgId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgId))).ToList();
                        if (String.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var param = new string[] {
                            "WarehouseCodeNavigation",
                            "PoliceCodeNavigation"
                        };

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => true;

                        if (!String.IsNullOrEmpty(policeCode))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.PoliceCode.Equals(policeCode));
                        }
                        else
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.PoliceCode != null);
                        }
                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        if (!String.IsNullOrEmpty(entity.level))
                        {
                            if (entity.level == "本级")
                            {
                                expression = expression.AndAlso(t => t.OrgId.Equals(orgId));
                            }
                            else
                            {
                                expression = expression.AndAlso(t => IdList.Contains(t.OrgId));
                            }
                        }
                        else
                        {
                            expression = expression.AndAlso(t => IdList.Contains(t.OrgId));
                        }

                        IQueryable<CommonJpEquipmentInventory> inventoryList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, t => t.WarehouseCode, false, param);

                        var groupData = inventoryList.Select(c => new
                        {
                            id = c.PoliceCode,
                            c.PoliceCodeNavigation.PoliceCode,
                            c.PoliceCodeNavigation.Name,
                            c.CurrentState
                        }).ToList();


                        var data = groupData.GroupBy(t => new { t.id, t.PoliceCode, t.Name }).Where(c => !string.IsNullOrEmpty(c.Key.id)).Select(c => new
                        {
                            c.Key.id,
                            c.Key.PoliceCode,
                            c.Key.Name,
                            zkCount = c.Where(c => c.CurrentState.Equals(0) || c.CurrentState.Equals(3)).Count(),
                            ckCount = c.Where(c => !(c.CurrentState.Equals(0) || c.CurrentState.Equals(3) || c.CurrentState.Equals(6))).Count(),
                            zsCount = c.Where(c => !c.CurrentState.Equals(6)).Count()
                        }).OrderBy(c => c.PoliceCode).ToList();

                        var dataPage = new
                        {
                            totalElements = data.Count,
                            content = data.Skip(page * size).Take(size)
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }

        /// <summary>
        /// 人员统计报表展开
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构查询ID",
        ///         "policeCode":"警员Code"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPoliceOrgList")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPoliceOrgList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        string orgId = entity.orgId;

                        string policeCode = entity.policeCode;

                        if (String.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        if (String.IsNullOrEmpty(policeCode))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var param = new string[] {
                            "WarehouseCodeNavigation",
                            "PoliceCodeNavigation",
                            "EquipmentCodeNavigation",
                            "Cabinet",
                            "SupplierCodeNavigation",
                            "EquipmentSizecodeNavigation"
                        };

                        //Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.WarehouseCodeNavigation.OrgizationId.Equals(orgId) && t.PoliceCode.Equals(policeCode);
                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.PoliceCode.Equals(policeCode);
                        IQueryable<CommonJpEquipmentInventory> inventoryList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, t => t.WarehouseCode, false, param);

                        var data = inventoryList.Select(c => new
                        {
                            c.Id,
                            EquipmentName = c.EquipmentCodeNavigation.Name,
                            c.EquipmentSizecodeNavigation.SizeName,
                            SupplierName = c.SupplierCodeNavigation.Name,
                            c.ProductTime,
                            CabinetName = c.Cabinet.CabinetNum + "-" + c.Cabinet.CabinetChildNum,
                            c.CurrentState
                        });

                        return JsonManager.ReturnSuccessResponse(data);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}
