﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class MessageReminderController : ControllerBase
    {
        private ILogger<MessageReminderController> _logger;
        UnitOfWork _unitOfWork;
        public MessageReminderController(ILogger<MessageReminderController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取当前组织机构下全部消息推送设置
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMessageReminderConfigByOrgId")]
        public async Task<HttpResponseMessage> GetMessageReminderConfigByOrgId([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;
                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var org = _unitOfWork.OrganizationRepository.Get(orgId);
                        if (org == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var config = _unitOfWork.DbContext
                            .BaseJpMessageReminderConfigs
                            .FirstOrDefault(x => x.OrgId == orgId);

                        if (config == null)
                        {
                            //创建默认配置
                            config = new BaseJpMessageReminderConfig
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                OrgId = orgId,
                                IsPushParentWithFixed = false,
                                IsPushParentWithBorrow = false,
                                IsPushParentWithFailWarehouse = false,
                                Enable = true
                            };
                            _unitOfWork.DbContext.BaseJpMessageReminderConfigs.Add(config);
                            _unitOfWork.SaveChanges();
                        }

                        return JsonManager.ReturnSuccessResponse(new
                        {
                            config.Id,
                            createTime = config.CreateTime,
                            config.OrgId,
                            config.UpdateTime,
                            config.UpdateUserId,
                            config.UpdateUserName,
                            config.IsPushParentWithFixed,
                            config.IsPushParentWithBorrow,
                            config.IsPushParentWithFailWarehouse,
                            config.EquipmentJson,
                            config.Enable
                        });
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 保存消息推送设置
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "id":""
        ///         "orgId":""
        ///         "updateUserId":""
        ///         "updateUserName":""
        ///         "isPushParentWithFixed":""
        ///         "isPushParentWithBorrow":""
        ///         "isPushParentWithFailWarehouse":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddAndUpdateMessageReminderConfig")]
        public async Task<HttpResponseMessage> AddAndUpdateMessageReminderConfig([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string id = entity.id;
                        string orgId = entity.orgId;
                        string updateUserId = entity.updateUserId;
                        string updateUserName = entity.updateUserName;
                        string equipmentJson = entity.equipmentJson;
                        bool.TryParse(entity.isPushParentWithFixed, out bool isPushParentWithFixed);
                        bool.TryParse(entity.isPushParentWithBorrow, out bool isPushParentWithBorrow);
                        bool.TryParse(entity.isPushParentWithFailWarehouse, out bool isPushParentWithFailWarehouse);
                        bool.TryParse(entity.enable, out bool enable);
                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        if (string.IsNullOrEmpty(updateUserId))
                        {
                            return JsonManager.SimpleCustResponse("updateUserId is require");
                        }

                        if (!string.IsNullOrEmpty(id))
                        {
                            var old = _unitOfWork.DbContext.BaseJpMessageReminderConfigs.FirstOrDefault(x => x.Id == id);
                            if (old == null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                            old.UpdateTime = DateTime.Now;
                            old.UpdateUserId = updateUserId;
                            old.UpdateUserName = updateUserName;
                            old.IsPushParentWithFixed = isPushParentWithFixed;
                            old.IsPushParentWithBorrow = isPushParentWithBorrow;
                            old.IsPushParentWithFailWarehouse = isPushParentWithFailWarehouse;
                            old.Enable = enable;
                            old.EquipmentJson = equipmentJson;
                            _unitOfWork.DbContext.BaseJpMessageReminderConfigs.Update(old);
                            if (_unitOfWork.SaveChanges() > 0)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }
                        else
                        {
                            _unitOfWork.DbContext.BaseJpMessageReminderConfigs.Add(new BaseJpMessageReminderConfig
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                OrgId = orgId,
                                UpdateTime = DateTime.Now,
                                UpdateUserId = updateUserId,
                                UpdateUserName = updateUserName,
                                IsPushParentWithFixed = isPushParentWithFixed,
                                IsPushParentWithBorrow = isPushParentWithBorrow,
                                IsPushParentWithFailWarehouse = isPushParentWithFailWarehouse,
                                Enable = enable,
                                EquipmentJson = equipmentJson,
                            });
                            if (_unitOfWork.SaveChanges() > 0)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        ///// <summary>
        ///// 保存装备配置json
        ///// </summary>
        ///// <remarks>
        ///// 
        ///// ## 例子
        ///// 
        /////     {
        /////         "id":""
        /////         "equipmentJson":""
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("SaveMessageReminderConfigEquipmentJson")]
        //public async Task<HttpResponseMessage> SaveMessageReminderConfigEquipmentJson([FromBody] JObject jdata)
        //{
        //    return await Task.Run(() =>
        //    {
        //        try
        //        {
        //            if (jdata != null)
        //            {
        //                var entity = JsonManager.GetJsonEntity(jdata);

        //                string id = entity.id;
        //                string equipmentJson = entity.equipmentJson;
        //                if (string.IsNullOrEmpty(id))
        //                {
        //                    return JsonManager.SimpleCustResponse("id is require");
        //                }
        //                if (string.IsNullOrEmpty(equipmentJson))
        //                {
        //                    return JsonManager.SimpleCustResponse("equipmentJson is require");
        //                }

        //                var obj = _unitOfWork.DbContext
        //                    .BaseJpMessageReminderConfigs
        //                    .FirstOrDefault(x => x.Id == id);
        //                if (obj == null)
        //                {
        //                    return JsonManager.SimpleCustResponse("id is require");
        //                }
        //                else
        //                {
        //                    obj.EquipmentJson = equipmentJson;
        //                    _unitOfWork.DbContext.BaseJpMessageReminderConfigs.Update(obj);
        //                }

        //                if (_unitOfWork.SaveChanges() > 0)
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
        //                }
        //                else
        //                {
        //                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //                }
        //            }
        //            else
        //            {
        //                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
        //            }
        //        }
        //        catch (Exception ex)
        //        {

        //            //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
        //            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
        //        }
        //    });
        //}

        /// <summary>
        /// 获取当前组织机构下全部消息推送设置
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetMessageReminderLog")]
        public async Task<HttpResponseMessage> GetMessageReminderLog([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgId = entity.orgId;
                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var bjLogList = _unitOfWork.DbContext
                            .BaseJpMessageReminderLogs
                            .Where(x => x.OrgId == orgId && x.EquCount != 0)
                            .ToList();
                        var xjLogList = _unitOfWork.DbContext
                            .BaseJpMessageReminderLogs
                            .Where(x => x.ParentOrgId == orgId && x.IsNeedPushParent && x.EquCount != 0)
                            .ToList();

                        var message = new List<string>();
                        foreach (var log in bjLogList)
                        {
                            switch (log.Type)
                            {
                                case 0:
                                    {
                                        //已超期未报废
                                        message.Add($"已超期未报废装备共{log.EquCount}件，请尽快处理");
                                        break;
                                    }
                                case 1:
                                    {
                                        //超期未归还
                                        message.Add($"超期未归还装备共{log.EquCount}件，请尽快处理");
                                        break;
                                    }
                                case 2:
                                    {
                                        //非本仓库装备
                                        message.Add($"本仓库存在其他仓库装备{log.EquCount}件，请尽快处理");
                                        break;
                                    }
                            }
                        }

                        return JsonManager.ReturnSuccessResponse(message);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }

}
