﻿using JmpModel.Model;
using JmpModel.Model.Repository;
using JmpModel.Model.Repository.CommonRepository;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Threading.Tasks;
using System.Xml;
using Microsoft.EntityFrameworkCore;

namespace JunmpPoliceStation.Extensions
{
    public static class UnitOfWorkExtension
    {
        /// <summary>
        /// 检查审核的流程是否被撤回
        /// </summary>
        /// <param name="processId"></param>
        /// <returns></returns>
        public static bool CheckProcess(this UnitOfWork unitOfWork, string orderId)
        {
            Expression<Func<CommonJpProcessCurrent, bool>> expression = t => t.OrderId == orderId;
            var param = new string[] {
                };

            var CurrentProcess = unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, t => t.Id, false, param).FirstOrDefault();

            if (CurrentProcess == null || string.IsNullOrEmpty(CurrentProcess.UserInfo))
            {
                return false;
            }
            else
            {
                return true;
            }
        }
        /// <summary>
        /// 处理消息
        /// </summary>
        public static void ApproveMessage(this UnitOfWork unitOfWork, string messageId)
        {
            var tmp_list = new List<string>();
            var messages = unitOfWork.MessageRepository.GetList(p => p.MessageInfo.Equals(messageId) && p.State == 0).ToList();
            foreach (var item in messages)
            {
                item.State = 1;
                if (!tmp_list.Contains(item.SendName))
                {
                    tmp_list.Add(item.SendName);
                    //GlobalContext.SendMessage(item.SendName);
                }
            }
            unitOfWork.MessageRepository.Update(messages);

        }
        /// <summary>
        /// 发送消息
        /// </summary>
        /// <param name="process"></param>
        public static void SendMessage(this UnitOfWork unitOfWork, CommonJpProcessCurrent process, string firstName, string orderCode)
        {
            List<CommonJpMessage> messges = new List<CommonJpMessage>();
            string orderId = orderCode;
            if (string.IsNullOrEmpty(orderId))
            {
                switch (process.FlowType)
                {
                    case "purchase":
                        orderId = process.CommonJpPurchaseOrders.FirstOrDefault().OrderCode;
                        break;
                    case "borrow":
                        orderId = process.CommonJpBorrowReturnApplies.FirstOrDefault().OrderCode;
                        break;
                    case "borrowMy":
                        orderId = process.CommonJpBorrowReturnApplies.FirstOrDefault().OrderCode;
                        break;
                    case "returnOther":
                        orderId = process.CommonJpBorrowReturnApplies.FirstOrDefault().OrderCode;
                        break;
                    case "collect":
                        orderId = process.CommonJpBorrowReturnApplies.FirstOrDefault().OrderCode;
                        break;
                    case "repair":
                        orderId = process.CommonJpFixReceiveApplies.FirstOrDefault().OrderCode;
                        break;
                    case "scrap":
                        orderId = process.CommonJpFixReceiveApplies.FirstOrDefault().OrderCode;
                        break;
                    case "allocationDown":
                    case "allocationUp":
                        orderId = process.CommonJpTransferApplies.FirstOrDefault().Order;
                        break;
                    case "borrowOther":
                        orderId = process.CommonJpTransferApplies.FirstOrDefault().Order;
                        break;
                    default:
                        break;
                }
            }


            if (process.UserType.Equals("role"))//组用户
            {

                List<UsersRole> roles = unitOfWork.processGetUserList(process.UserInfo, process.DataScope, process.OrgId);
                string pcNum = Guid.NewGuid().ToString();

                foreach (var item in roles)
                {
                    CommonJpMessage message = new CommonJpMessage()
                    {
                        Id = Guid.NewGuid().ToString(),
                        SendName = item.UserId,
                        State = 0,
                        SendTime = DateTime.Now,
                        PcNumber = Guid.NewGuid().ToString(),
                        MessageInfo = process.OrderId,
                        OrderName = "",
                        MessageType = process.FlowType,
                        OrderType = "审核",
                        OrderId = orderId

                    };
                    messges.Add(message);
                    GlobalContext.SendMessage(message.SendName);
                }
            }
            else if (process.UserType.Equals("assignee"))//指定用户
            {
                CommonJpMessage message = new CommonJpMessage()
                {
                    Id = Guid.NewGuid().ToString(),
                    SendName = process.UserInfo,
                    State = 0,
                    SendTime = DateTime.Now,
                    PcNumber = Guid.NewGuid().ToString(),
                    MessageInfo = process.OrderId,
                    OrderName = "",
                    MessageType = process.FlowType,
                    OrderType = "审核",
                    OrderId = orderId
                };
                GlobalContext.SendMessage(message.SendName);
                messges.Add(message);
            }
            else
            {
                string OrderType = string.Empty;
                if (process.FlowState.Equals("false"))
                {
                    OrderType = "驳回";
                }
                else
                {
                    OrderType = "结束";
                }
                CommonJpMessage message = new CommonJpMessage()
                {
                    Id = Guid.NewGuid().ToString(),
                    SendName = firstName,
                    State = 0,
                    SendTime = DateTime.Now,
                    PcNumber = Guid.NewGuid().ToString(),
                    MessageInfo = process.OrderId,
                    OrderName = "",
                    MessageType = process.FlowType,
                    OrderType = OrderType,
                    OrderId = orderId
                };
                GlobalContext.SendMessage(message.SendName);
                messges.Add(message);
            }
            if (messges.Count > 0)
            {
                unitOfWork.MessageRepository.Insert(messges, false);
            }
        }

        /// <summary>
        /// 获取本级或上级用户ID
        /// </summary>
        /// <param name="roleId"></param>
        /// <param name="dataScope"></param>
        /// <param name="orgId"></param>
        /// <returns></returns>
        private static List<UsersRole> processGetUserList(this UnitOfWork unitOfWork, string roleId, string dataScope, string orgId)
        {
            try
            {
                var param = new string[] {
                    "User",
                    "User.Organization"
                };

                Expression<Func<UsersRole, bool>> expressionProcess = t => t.RoleId == int.Parse(roleId);

                IQueryable<UsersRole> UsersRoleList = unitOfWork.UsersRoleRepository.GetList(expressionProcess, t => t.RoleId, false, param);
                var parentId = unitOfWork.OrganizationRepository.Get(p => p.Id.Equals(orgId)).ParentId;

                if (dataScope.Equals("本级"))
                {
                    UsersRoleList = UsersRoleList.Where(c => c.User.OrganizationId.Equals(orgId) && c.User.Enabled == 1);
                }
                else
                {
                    UsersRoleList = UsersRoleList.Where(c => c.User.Organization.ParentId.Equals(parentId) && c.User.Enabled.Equals(1));
                }

                return UsersRoleList.ToList();
            }
            catch (Exception ex)
            {
                return null;
            }
        }
        /// <summary>
        /// 添加流程方法
        /// </summary>
        /// <param name="orderId"></param>
        /// <param name="userType"></param>
        /// <param name="userInfo"></param>
        /// <param name="dataScope"></param>
        /// <param name="nextStepId"></param>
        /// <param name="currentStepName"></param>
        /// <param name="flowState"></param>
        /// <param name="auditMind"></param>
        /// <param name="AuditUser"></param>
        /// <param name="AuditUserName"></param>
        /// <returns></returns>
        public static bool AddProcess(this UnitOfWork unitOfWork, string id, string orderId, string userType, string userInfo, string dataScope, string nextStepId, string currentStepName, string flowType, string flowName, string flowId, string flowState, string orgId, string auditMind, string AuditUser, string AuditUserName, string orderCode)
        {

            //新增数据
            CommonJpProcessCurrent addObject = new CommonJpProcessCurrent()
            {
                Id = id,
                OrderId = orderId,
                UserType = userType,
                UserInfo = userInfo,
                DataScope = dataScope,
                NextStepId = nextStepId,
                CurrentStepName = currentStepName,
                FlowType = flowType,
                FlowName = flowName,
                FlowId = flowId,
                FlowState = flowState,
                OrgId = orgId,
                UpdateTime = System.DateTime.Now
            };
            unitOfWork.CommonJpProcessCurrentRepository.Insert(addObject, false);

            var param = new string[] {
                       "CommonJpBorrowReturnApplies",
                       "CommonJpFixReceiveApplies",
                       "CommonJpProcessHistories",
                       "CommonJpPurchaseOrders",
                       "CommonJpTransferApplies",
                    };
            var CurrentProcess = unitOfWork.CommonJpProcessCurrentRepository.GetList(p => p.Id.Equals(id), t => t.Id, false, param).FirstOrDefault();
            if (!string.IsNullOrEmpty(orderCode))
            {
                unitOfWork.SendMessage(addObject, "", orderCode);
            }

            Expression<Func<BaseJpProcess, bool>> ProcessExpression = t => t.Code.Equals(flowType) && (t.OrgId == null || t.OrgId.Equals(orgId)) && t.PublishStatus == true;

            List<BaseJpProcess> ProcessList = unitOfWork.BaseJpProcessRepository.GetList(ProcessExpression, t => t.OrgId, false).ToList();

            var StepName = "开始";
            if (ProcessList.Count > 0)
            {
                //用户是否有自定义流程
                var process = ProcessList.Where(c => c.OrgId != null).FirstOrDefault();
                if (process == null)
                {
                    //默认流程
                    process = ProcessList.Where(c => c.OrgId == null).FirstOrDefault();
                }

                //解析XML流程定义字符
                string processXml = process.ProcessXml;
                if (!string.IsNullOrEmpty(processXml))
                {

                    XmlDocument pXml = new XmlDocument();

                    processXml = processXml.Replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "");
                    pXml.LoadXml(processXml);

                    string jsonStr = JsonConvert.SerializeXmlNode(pXml);

                    JObject jsonObject = JObject.Parse(jsonStr);

                    var definitionsJson = jsonObject["bpmn2:definitions"];

                    var processJson = definitionsJson["bpmn2:process"];

                    //起点
                    var TaskList = processJson["bpmn2:task"];

                    List<string> returnData = new List<string>();
                    StepName = TaskList["@name"].ToString();
                }
            }

            CommonJpProcessHistory addHisObject = new CommonJpProcessHistory()
            {
                Id = Guid.NewGuid().ToString(),
                ProcessCurrentId = id,
                OrderId = orderId,
                StepId = "",
                StepName = StepName,
                FlowType = flowType,
                FlowName = flowName,
                FlowId = flowId,
                FlowState = flowState,
                OrgId = orgId,
                UpdateTime = System.DateTime.Now,
                AuditMind = auditMind,
                AuditUserId = AuditUser,
                AuditUserName = AuditUserName
            };
            unitOfWork.CommonJpProcessHistoryRepository.Insert(addHisObject, false);

            return true;


        }
        /// <summary>
        /// 审核或修改
        /// </summary>
        /// <param name="orderId"></param>
        /// <param name="userType"></param>
        /// <param name="userInfo"></param>
        /// <param name="dataScope"></param>
        /// <param name="nextStepId"></param>
        /// <param name="currentStepName"></param>
        /// <param name="flowState"></param>
        /// <param name="auditMind"></param>
        /// <param name="AuditUser"></param>
        /// <param name="AuditUserName"></param>
        /// <returns></returns>
        public static bool AuditProcess(this UnitOfWork unitOfWork, string actionType, string orderId, string userType, string userInfo, string dataScope, string nextStepId, string currentStepName, string flowState, string auditMind, string AuditUser, string AuditUserName, string orgid, string type)
        {
            try
            {
                if (string.IsNullOrEmpty(actionType))
                {
                    actionType = "";
                }
                Expression<Func<CommonJpProcessCurrent, bool>> expression = t => t.Id != null;
                if (!actionType.Equals("baseInfo") || string.IsNullOrEmpty(actionType))
                {
                    expression = t => t.OrderId == orderId;
                }
                else
                {
                    expression = t => t.Id == orderId;
                }

                var param = new string[] {
                       "CommonJpBorrowReturnApplies",
                       "CommonJpFixReceiveApplies",
                       "CommonJpProcessHistories",
                       "CommonJpPurchaseOrders",
                       "CommonJpTransferApplies",
                    };
                var CurrentProcess = unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, t => t.Id, false, param).FirstOrDefault();
                var ProvessHistory = unitOfWork.CommonJpProcessHistoryRepository.GetList(p => p.ProcessCurrentId.Equals(CurrentProcess.Id)).OrderBy(p => p.UpdateTime).FirstOrDefault();
                if (CurrentProcess == null)
                {
                    return false;
                }

                //新增历史数据
                CommonJpProcessHistory addObject = new CommonJpProcessHistory()
                {

                    Id = Guid.NewGuid().ToString(),

                    ProcessCurrentId = CurrentProcess.Id,
                    OrderId = CurrentProcess.OrderId,
                    StepId = CurrentProcess.NextStepId,
                    StepName = CurrentProcess.CurrentStepName,
                    FlowType = CurrentProcess.FlowType,
                    FlowName = CurrentProcess.FlowName,
                    FlowId = CurrentProcess.FlowId,
                    FlowState = CurrentProcess.FlowState,
                    OrgId = CurrentProcess.OrgId,
                    UpdateTime = System.DateTime.Now,
                    AuditMind = auditMind,
                    AuditUserId = AuditUser,
                    AuditUserName = AuditUserName
                };

                unitOfWork.CommonJpProcessHistoryRepository.Insert(addObject, false);
                if (type.Equals("update"))
                {
                    if (string.IsNullOrEmpty(CurrentProcess.UserInfo) && CurrentProcess.FlowState.Equals("false"))
                    {
                        CurrentProcess.ActionType = actionType;
                        CurrentProcess.UserType = userType;
                        CurrentProcess.UserInfo = userInfo;
                        CurrentProcess.DataScope = dataScope;
                        CurrentProcess.UpdateTime = System.DateTime.Now;
                        CurrentProcess.FlowState = flowState;
                        CurrentProcess.NextStepId = nextStepId;
                        CurrentProcess.CurrentStepName = currentStepName;
                        if (!string.IsNullOrEmpty(orgid))
                        {
                            CurrentProcess.OrgId = orgid;
                        }

                        unitOfWork.CommonJpProcessCurrentRepository.Update(CurrentProcess, false);
                    }
                }
                else if (type.Equals("approve"))
                {

                    CurrentProcess.ActionType = actionType;
                    CurrentProcess.UserType = userType;
                    CurrentProcess.UserInfo = userInfo;
                    CurrentProcess.DataScope = dataScope;
                    CurrentProcess.UpdateTime = System.DateTime.Now;
                    CurrentProcess.FlowState = flowState;
                    CurrentProcess.NextStepId = nextStepId;
                    CurrentProcess.CurrentStepName = currentStepName;
                    if (!string.IsNullOrEmpty(orgid))
                    {
                        CurrentProcess.OrgId = orgid;
                    }

                    unitOfWork.CommonJpProcessCurrentRepository.Update(CurrentProcess, false);



                }
                if (!actionType.Equals("baseInfo"))
                {
                    unitOfWork.SendMessage(CurrentProcess, ProvessHistory.AuditUserId, "");
                }

                return true;

            }
            catch (Exception ex)
            {
                return false;
            }
        }


        #region Threshold

        /// <summary>
        /// 计算阈值
        /// </summary>
        public static bool CalcThreshold(this UnitOfWork unitOfWork, IList<string> sizeIdList, string orgId, string warehouseId)
        {
            try
            {
                var insertList = new List<CommonJpEquipmentThresholdResult>();
                var updateList = new List<CommonJpEquipmentThresholdResult>();
                //检查指定仓库阈值配置
                var warehouseThresholds = unitOfWork.DbContext.CommonJpEquipmentThresholds
                    .Where(x => x.WarehouseId == warehouseId
                                && x.ScopeType == "Warehouse"
                                && x.IsEnabled)
                    .ToList();
                foreach (var threshold in warehouseThresholds)
                {
                    if (sizeIdList.Contains(threshold.EquipmentSizeId))
                    {
                        //计算阈值
                        //实际在库总数
                        var count1 = unitOfWork.EquipmentInventoryRepository.Count(x =>
                            x.CurrentState == 0
                            && x.InventoryState != "loss"
                            && x.EquipmentSizecode == threshold.EquipmentSizeId
                            && x.EquipmentCode == threshold.EquipmentDetailId
                            && x.WarehouseCode == threshold.WarehouseId
                            );
                        //当前仓库总数
                        var count2 = unitOfWork.EquipmentInventoryRepository.Count(x =>
                            (x.CurrentState == 0 || x.CurrentState == 2 || x.CurrentState == 4 || x.CurrentState == 14)
                            && x.InventoryState != "loss"
                            && x.EquipmentSizecode == threshold.EquipmentSizeId
                            && x.EquipmentCode == threshold.EquipmentDetailId
                            && x.WarehouseCode == threshold.WarehouseId
                            );
                        //采购单补填总数 （采购单采购总数-已采购总数）
                        var purchaseDetailList = unitOfWork.DbContext.CommonJpPurchaseDetails
                            .Include(x => x.Equipment)
                            .Include(x => x.Size)
                            .Include(x => x.Order.ProcessCurrent)
                            .Include(x => x.Order)
                            .Where(x => x.Order.WarehouseId == warehouseId
                                        && (x.Order.CurrentState == 0 || x.Order.CurrentState == null)
                                        && x.Order.ProcessCurrent.FlowState == "true"
                                        && x.EquipmentId == threshold.EquipmentDetailId
                                        && x.SizeId == threshold.EquipmentSizeId)
                            .ToList();
                        var count3 = purchaseDetailList.Sum(x => x.Quantity)
                                     - purchaseDetailList.Sum(x => x.RealCount);

                        //阈值计算：当前仓库总数+采购单补填总数
                        var isBelowThreshold = threshold.ThresholdCount > count2 + count3;
                        //查找旧数据
                        var oldThresholdResult = unitOfWork.DbContext.CommonJpEquipmentThresholdResults
                            .FirstOrDefault(x => x.ThresholdId == threshold.Id);
                        if (oldThresholdResult != null)
                        {
                            oldThresholdResult.InsideCount = Convert.ToInt32(count2);
                            oldThresholdResult.RealInsideCount = Convert.ToInt32(count1);
                            oldThresholdResult.PurchaseFillCount = Convert.ToInt32(count3);
                            oldThresholdResult.IsBelowThreshold = isBelowThreshold;
                            updateList.Add(oldThresholdResult);
                        }
                        else
                        {
                            insertList.Add(new CommonJpEquipmentThresholdResult
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                ThresholdId = threshold.Id,
                                InsideCount = Convert.ToInt32(count2),
                                RealInsideCount = Convert.ToInt32(count1),
                                PurchaseFillCount = Convert.ToInt32(count3),
                                IsBelowThreshold = isBelowThreshold
                            });
                        }
                    }
                }
                //检查组织机构阈值配置
                var organizationThresholds = unitOfWork.DbContext.CommonJpEquipmentThresholds
                    .Where(x => x.OrgId == orgId
                                && x.ScopeType == "Organization"
                                && x.IsEnabled)
                    .ToList();
                foreach (var threshold in organizationThresholds)
                {
                    if (sizeIdList.Contains(threshold.EquipmentSizeId))
                    {
                        //计算阈值
                        //实际在库总数
                        var count1 = unitOfWork.DbContext.CommonJpEquipmentInventories
                            .Include(x => x.WarehouseCodeNavigation)
                            .Count(x =>
                            x.CurrentState == 0
                            && x.InventoryState != "loss"
                            && x.EquipmentSizecode == threshold.EquipmentSizeId
                            && x.EquipmentCode == threshold.EquipmentDetailId
                            && x.WarehouseCodeNavigation.OrgizationId == threshold.OrgId
                        );
                        //当前仓库总数
                        var count2 = unitOfWork.DbContext.CommonJpEquipmentInventories
                            .Include(x => x.WarehouseCodeNavigation)
                            .Count(x =>
                            (x.CurrentState == 0 || x.CurrentState == 2 || x.CurrentState == 4 || x.CurrentState == 14)
                            && x.InventoryState != "loss"
                            && x.EquipmentSizecode == threshold.EquipmentSizeId
                            && x.EquipmentCode == threshold.EquipmentDetailId
                            && x.WarehouseCodeNavigation.OrgizationId == threshold.OrgId
                        );
                        //采购单补填总数 （采购单采购总数-已采购总数）
                        var purchaseDetailList = unitOfWork.DbContext.CommonJpPurchaseDetails
                            .Include(x => x.Equipment)
                            .Include(x => x.Size)
                            .Include(x => x.Order.ProcessCurrent)
                            .Include(x => x.Order)
                            .Where(x => x.Order.OrgId == orgId
                                        && (x.Order.CurrentState == 0 || x.Order.CurrentState == null)
                                        && x.Order.ProcessCurrent.FlowState == "true"
                                        && x.EquipmentId == threshold.EquipmentDetailId
                                        && x.SizeId == threshold.EquipmentSizeId)
                            .ToList();
                        var count3 = purchaseDetailList.Sum(x => x.Quantity)
                                     - purchaseDetailList.Sum(x => x.RealCount);

                        //阈值计算：当前仓库总数+采购单补填总数
                        var isBelowThreshold = threshold.ThresholdCount > count2 + count3;
                        //查找旧数据
                        var oldThresholdResult = unitOfWork.DbContext.CommonJpEquipmentThresholdResults
                            .FirstOrDefault(x => x.ThresholdId == threshold.Id);
                        if (oldThresholdResult != null)
                        {
                            oldThresholdResult.InsideCount = Convert.ToInt32(count2);
                            oldThresholdResult.RealInsideCount = Convert.ToInt32(count1);
                            oldThresholdResult.PurchaseFillCount = Convert.ToInt32(count3);
                            oldThresholdResult.IsBelowThreshold = isBelowThreshold;
                            updateList.Add(oldThresholdResult);
                        }
                        else
                        {
                            insertList.Add(new CommonJpEquipmentThresholdResult
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                ThresholdId = threshold.Id,
                                InsideCount = Convert.ToInt32(count2),
                                RealInsideCount = Convert.ToInt32(count1),
                                PurchaseFillCount = Convert.ToInt32(count3),
                                IsBelowThreshold = isBelowThreshold
                            });
                        }
                    }
                }
                //保存数据
                unitOfWork.DbContext.CommonJpEquipmentThresholdResults.AddRange(insertList);
                unitOfWork.DbContext.CommonJpEquipmentThresholdResults.UpdateRange(updateList);
                unitOfWork.DbContext.SaveChanges();
                return true;
            }
            catch (Exception ex)
            {
                return false;
            }
        }


        #endregion
    }
}
