﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Microsoft.VisualBasic;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Net.WebSockets;
using System.Threading.Tasks;
using Microsoft.EntityFrameworkCore.Internal;
using JmpModel.TempModel;
using JunmpPoliceStation.Extensions;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    [NoSignAttribute]
    public class TjController : ControllerBase
    {
        //private ICabinetRepository _CabinetRepository;
        private ILogger<TjController> _logger;
        UnitOfWork _unitOfWork;
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();

        public TjController(ILogger<TjController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }


        /// <summary>
        /// 获取分页库存统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "warehouseName": "仓库名称",
        ///         "equName":"资产名称",
        ///         "sizeName":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageKcTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageKcTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();



                        Expression<Func<ViewEquipmentCount, bool>> expressionPoliceman = null;

                        string warehouseName = entity.warehouseName;
                        string equName = entity.equName;
                        string sizeName = entity.sizeName;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(warehouseName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseName.Contains(warehouseName));
                        }

                        if (!String.IsNullOrEmpty(equName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquName.Contains(equName));
                        }

                        if (!String.IsNullOrEmpty(sizeName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.SizeName.Contains(sizeName));
                        }

                        var param = new string[] {
                    };

                        PageData<ViewEquipmentCount> pagedata = _unitOfWork.ViewEquipmentCountRepository.GetPage(expressionPoliceman, "OrgId,SizeId", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.OrgId,
                            c.OrgName,
                            c.WarehouseCode,
                            c.WarehouseName,
                            c.EquName,
                            c.SizeCode,
                            c.SizeName,
                            c.SizeCount,
                            c.DjgCount
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }


        /// <summary>
        /// 获取分页使用率统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "warehouseName": "仓库名称",
        ///         "equName":"资产名称",
        ///         "sizeName":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageSyPTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageSyPTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();



                        Expression<Func<ViewSyP, bool>> expressionPoliceman = null;

                        string warehouseName = entity.warehouseName;
                        string equName = entity.equName;
                        string sizeName = entity.sizeName;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(warehouseName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseName.Contains(warehouseName));
                        }

                        if (!String.IsNullOrEmpty(equName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquName.Contains(equName));
                        }

                        if (!String.IsNullOrEmpty(sizeName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.SizeName.Contains(sizeName));
                        }

                        var param = new string[] {
                    };

                        PageData<ViewSyP> pagedata = _unitOfWork.ViewSyPRepository.GetPage(expressionPoliceman, "OrgId,SizeId", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.OrgId,
                            c.OrgName,
                            c.WarehouseCode,
                            c.WarehouseName,
                            c.EquName,
                            c.SizeCode,
                            c.SizeName,
                            c.SizeCount,
                            c.WeekP,
                            c.MonthP
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取分页维修率统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "warehouseName": "仓库名称",
        ///         "equName":"资产名称",
        ///         "sizeName":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageWxPTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageWxPTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();



                        Expression<Func<ViewWxP, bool>> expressionPoliceman = null;

                        string warehouseName = entity.warehouseName;
                        string equName = entity.equName;
                        string sizeName = entity.sizeName;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(warehouseName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseName.Contains(warehouseName));
                        }

                        if (!String.IsNullOrEmpty(equName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquName.Contains(equName));
                        }

                        if (!String.IsNullOrEmpty(sizeName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.SizeName.Contains(sizeName));
                        }

                        var param = new string[] {
                    };

                        PageData<ViewWxP> pagedata = _unitOfWork.ViewWxPRepository.GetPage(expressionPoliceman, "OrgId,SizeId", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.OrgId,
                            c.OrgName,
                            c.WarehouseCode,
                            c.WarehouseName,
                            c.EquName,
                            c.SizeCode,
                            c.SizeName,
                            c.SizeCount,
                            c.WeekP,
                            c.MonthP
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取分页报废率统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "warehouseName": "仓库名称",
        ///         "equName":"资产名称",
        ///         "sizeName":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageBfPTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageBfPTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();



                        Expression<Func<ViewBfP, bool>> expressionPoliceman = null;

                        string warehouseName = entity.warehouseName;
                        string equName = entity.equName;
                        string sizeName = entity.sizeName;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(warehouseName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseName.Contains(warehouseName));
                        }

                        if (!String.IsNullOrEmpty(equName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquName.Contains(equName));
                        }

                        if (!String.IsNullOrEmpty(sizeName))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.SizeName.Contains(sizeName));
                        }

                        var param = new string[] {
                    };

                        PageData<ViewBfP> pagedata = _unitOfWork.ViewBfPRepository.GetPage(expressionPoliceman, "OrgId,SizeId", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.OrgId,
                            c.OrgName,
                            c.WarehouseCode,
                            c.WarehouseName,
                            c.EquName,
                            c.SizeCode,
                            c.SizeName,
                            c.SizeCount,
                            c.WeekP,
                            c.MonthP
                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }




        /// <summary>
        /// 按组织机构报表统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "typeId":"资产类型ID",
        ///         "equipmentCode":"资产名称",
        ///         "equipmentSizecode":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageOrgTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageOrgTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string orgId = entity.orgId;
                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        var org = _unitOfWork.DbContext.BaseJpOrganizations.FirstOrDefault(x => x.Id == orgId);
                        if (org == null)
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }

                        var orgModelList = new List<OrgTreeModel>();
                        if (MemoryCacheHelper.Exists("orgModelList"))
                        {
                            orgModelList = (List<OrgTreeModel>)MemoryCacheHelper.Get("orgModelList");
                        }
                        else
                        {
                            orgModelList = _unitOfWork.OrganizationRepository
                                .Entities
                                .Select(x => new OrgTreeModel
                                {
                                    Id = x.Id,
                                    State = x.State == 1,
                                    Name = x.Name,
                                    Code = x.Code,
                                    ParentId = x.ParentId
                                })
                                .ToList();

                            //默认过期时间1天
                            MemoryCacheHelper.AddMemoryCache("orgModelList", orgModelList, 1440);
                        }


                        Expression<Func<ViewEquipment, bool>> expressionPoliceman = null;

                        string typeId = entity.typeId;
                        string equipmentCode = entity.equipmentCode;
                        string equipmentSizecode = entity.equipmentSizecode;

                        var idList = OrgTreeModel.GetOrgIdList(orgModelList, org.Id);
                        //expressionPoliceman = t => idList.Contains(t.OrgId);
                        expressionPoliceman = t => t.OrgId== org.Id;

                        if (!String.IsNullOrEmpty(typeId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.TypeOneId.Equals(typeId) || t.TypeTwoId.Equals(typeId) || t.TypeThreeId.Equals(typeId));
                        }

                        if (!String.IsNullOrEmpty(equipmentCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentCode.Equals(equipmentCode));
                        }

                        if (!String.IsNullOrEmpty(equipmentSizecode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentSizecode.Equals(equipmentSizecode));
                        }

                        List<ViewEquipment> equipmentList = _unitOfWork.ViewEquipmentRepository.GetList(expressionPoliceman).OrderBy(c => c.FindCode.Length).ToList();

                        if (org.FindCode.Length == 6)
                        {
                            var data = equipmentList.GroupBy(t => t.OrgName).Select(c => new
                            {
                                c.FirstOrDefault().OrgName,
                                c.FirstOrDefault().FindCode,
                                c.FirstOrDefault().OrgCode,
                                zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                priceCount = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null).Sum(k => k.Price),
                                children = c.OrderBy(z => z.TypeOneId).ThenBy(z => z.TypeTwoId).ThenBy(z => z.TypeThreeId).GroupBy(a => a.EquipmentCode).Select(c => new
                                {
                                    id = c.FirstOrDefault().EquipmentCode,
                                    name = c.FirstOrDefault().EquipmentName,
                                    zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                    zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                    ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                    bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                    priceCount = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null).Sum(k => k.Price)
                                }).Where(f => f.id != null && f.zsCount != 0).ToList()
                            }).ToList();

                            data = data.Where(c => c.zsCount != 0)
                                .OrderBy(c => c.FindCode.Length)
                                .ThenBy(c => c.FindCode)
                                .ThenBy(c => c.OrgCode)
                                .ToList();

                            var dataPage = new
                            {
                                totalElements = data.Count,
                                zsCount = data.Sum(c => c.zsCount),
                                zkCount = data.Sum(c => c.zkCount),
                                ckCount = data.Sum(c => c.ckCount),
                                bfCount = data.Sum(c => c.bfCount),
                                priceCount = data.Sum(c => c.priceCount),
                                content = data.Skip(page * size).Take(size)
                            };
                            return JsonManager.ReturnSuccessResponse(dataPage);
                        }
                        else
                        {
                            var codeLen = org.FindCode.Length + 2;
                            var data = equipmentList.GroupBy(t => t.FindCode.PadLeft(codeLen, '0').Substring(0, codeLen)).Select(c => new
                            {
                                OrgName = c.OrderBy(f => f.OrgCode).FirstOrDefault().AreaName,
                                c.OrderBy(f => f.OrgCode).FirstOrDefault().FindCode,
                                c.OrderBy(f => f.OrgCode).FirstOrDefault().OrgCode,
                                zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                priceCount = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null).Sum(k => k.Price),
                                children = c.OrderBy(z => z.TypeOneId).ThenBy(z => z.TypeTwoId).ThenBy(z => z.TypeThreeId).GroupBy(a => a.EquipmentCode).Select(c => new
                                {
                                    id = c.FirstOrDefault().EquipmentCode,
                                    name = c.FirstOrDefault().EquipmentName,
                                    zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                    zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                    ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                    bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                    priceCount = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null).Sum(k => k.Price)
                                }).Where(f => f.id != null && f.zsCount != 0).ToList()
                            }).ToList();

                            data = data.Where(c => c.zsCount != 0)
                                .OrderBy(c => c.FindCode.Length)
                                .ThenBy(c => c.FindCode)
                                .ThenBy(c => c.OrgCode)
                                .ToList();

                            var dataPage = new
                            {
                                totalElements = data.Count,
                                zsCount = data.Sum(c => c.zsCount),
                                zkCount = data.Sum(c => c.zkCount),
                                ckCount = data.Sum(c => c.ckCount),
                                bfCount = data.Sum(c => c.bfCount),
                                priceCount = data.Sum(c => c.priceCount),
                                content = data.Skip(page * size).Take(size)
                            };
                            return JsonManager.ReturnSuccessResponse(dataPage);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 使用次数报表详情
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "size":10,
        ///         "page":0,
        ///         "orgId":"当前组织机构代码",
        ///         "equipmentCode":"装备名称",
        ///         "startTime":"开始时间",
        ///         "endTime":"结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetSyCountDetail")]

        public async Task<HttpResponseMessage> GetSyCountDetail([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        //int.TryParse(entity.page, out int page);
                        //int.TryParse(entity.size, out int size);

                        //if (size == 0)
                        //{
                        //    size = 10;
                        //}

                        string OrgId = Guid.Empty.ToString();
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            OrgId = entity.orgId;
                        }
                        var param = new string[] {
                        "EquipmentCodeNavigation",
                        "Org" ,
                        "Org.BaseJpCabinetOutinlogs" ,
                        "CommonJpEquipmentStates",

                         };
                        var Infoparam = new string[] { };

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => OrgId == t.OrgId && (!t.InventoryState.Equals("loss"));

                        //装备名称
                        if (!String.IsNullOrEmpty(entity.equipmentCode))
                        {
                            string equipmentCode = entity.equipmentCode;
                            expression = LambdaExtensions.AndAlso(expression, t => t.EquipmentCode.Equals(equipmentCode));
                        }
                        //var infoList=_unitOfWork.EquipmentInfoRepository.GetList(t=>t.Id!=null).ToList();

                        //var query = from t1 in infoList
                        //            join t2 in infoList
                        //            on t1.ParentId equals t2.Id
                        //            join t3 in infoList
                        //            on t2.ParentId equals t3.Id
                        //            select new ViewEquipment
                        //            {
                        //                TypeOneId = t1.Id,
                        //                TypeTwoId = t2.Id,
                        //                TypeThreeId = t3.Id,
                        //            };

                        var EquipmentList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, null, false, param).ToList();
                        var datas = EquipmentList.GroupBy(p => p.EquipmentCode).Select(c => new
                        {
                            code = c.FirstOrDefault().EquipmentCodeNavigation?.Equipment?.Code,
                            equipmentCode = c.Key,
                            equipmentName = c.FirstOrDefault().EquipmentCodeNavigation.Name,
                            sumCount = c.Where(p => p.CurrentState != 6).Count(),
                            syCount = c.Sum(c => c.CommonJpEquipmentStates.Where(f => (f.ActionState.Equals(2) || f.ActionState.Equals(3) || f.ActionState.Equals(5) || f.ActionState.Equals(14) || f.ActionState.Equals(15)) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count()),
                            wxCount = c.Sum(c => c.CommonJpEquipmentStates.Where(f => f.ActionState.Equals(6) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count())

                        }).OrderBy(f => f.code).ToList();

                        //var content = new
                        //{
                        //    totalElements = datas.Count(),
                        //    content = datas.Skip(page * size).Take(size).ToList()
                        //};

                        return JsonManager.ReturnSuccessResponse(datas);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }

        /// <summary>
        /// 使用次数报表统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "size":10,
        ///         "page":0,
        ///         "orgId":"当前组织机构代码",
        ///         "equipmentCode":"装备名称",
        ///         "startTime":"开始时间",
        ///         "endTime":"结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListSy")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetListSy([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string OrgId = Guid.Empty.ToString();
                        string startTime = entity.startTime;
                        string endTime = Convert.ToDateTime(entity.endTime).AddDays(1).ToString();



                        Expression<Func<BaseJpOrganization, bool>> expressionOrg = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expressionOrg, t => t.Code).ToList();

                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            OrgId = entity.orgId;
                        }

                        dataList = GetClassID(OrgId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(OrgId))).ToList();

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        var param = new string[] {
                       "EquipmentSizecodeNavigation" ,
                       "EquipmentCodeNavigation" ,
                       "WarehouseCodeNavigation" ,
                       "WarehouseCodeNavigation.Orgization",
                       "CommonJpEquipmentStates",
                       "Org",
                       "Org.BaseJpCabinetOutinlogs",
                        };

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => IdList.Contains(t.WarehouseCodeNavigation.OrgizationId) && (!t.InventoryState.Equals("loss"));

                        //装备名称
                        if (!String.IsNullOrEmpty(entity.equipmentCode))
                        {
                            string equipmentCode = entity.equipmentCode;
                            expression = LambdaExtensions.AndAlso(expression, t => t.EquipmentCode.Contains(equipmentCode));
                        }

                        var EquipmentList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, null, false, param).ToList();
                        //var EquipmentList = _unitOfWork.EquipmentInventoryRepository.GetGroupPage(expression,t => new { t.WarehouseCode,t.EquipmentCode,t.EquipmentSizecode },"", page,size, false, param);

                        var datas = EquipmentList.GroupBy(p => p.WarehouseCodeNavigation.OrgizationId).Select(x => new
                        {
                            x.FirstOrDefault().WarehouseCodeNavigation.OrgizationId,
                            orgName = x.FirstOrDefault().WarehouseCodeNavigation.Orgization.Name,
                            orgCode = x.FirstOrDefault().WarehouseCodeNavigation.Orgization.Code,
                            sumCount = x.Count(),
                            syCount = x.Sum(c => c.CommonJpEquipmentStates.Where(f => (f.ActionState.Equals(2) || f.ActionState.Equals(3) || f.ActionState.Equals(5) || f.ActionState.Equals(14) || f.ActionState.Equals(15)) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count()),
                            wxCount = x.Sum(c => c.CommonJpEquipmentStates.Where(f => f.ActionState.Equals(6) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count()),
                            children = x.GroupBy(a => a.EquipmentCode).Select(c => new
                            {
                                equipmentCode = c.Key,
                                equipmentName = c.FirstOrDefault().EquipmentCodeNavigation.Name,
                                sumCount = c.Count(),
                                syCount = c.Sum(c => c.CommonJpEquipmentStates.Where(f => (f.ActionState.Equals(2) || f.ActionState.Equals(3) || f.ActionState.Equals(5) || f.ActionState.Equals(14) || f.ActionState.Equals(15)) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count()),
                                wxCount = c.Sum(c => c.CommonJpEquipmentStates.Where(f => f.ActionState.Equals(6) && f.OutTime >= Convert.ToDateTime(startTime) && f.OutTime <= Convert.ToDateTime(endTime)).Count())
                            }).OrderByDescending(f => f.syCount).ToList()
                        }).OrderBy(c => c.orgCode).ToList().Where(c => c.syCount > 0);

                        var content = new
                        {
                            totalElements = datas.Count(),
                            content = datas.Skip(page * size).Take(size).ToList()
                        };

                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }
        /// <summary>
        /// 使用次数报表统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "size":10,
        ///         "page":0,
        ///         "orgId":"当前组织机构代码",
        ///         "equipmentCode":"装备名称",
        ///         "startTime":"开始时间",
        ///         "endTime":"结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListSyCount")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetListSyCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string OrgId = Guid.Empty.ToString();

                        if (!DateTime.TryParse(entity.startTime, out DateTime startTime))
                        {
                            return JsonManager.SimpleCustResponse("startTime is require");
                        }
                        if (!DateTime.TryParse(entity.endTime, out DateTime endTime))
                        {
                            return JsonManager.SimpleCustResponse("endTime is require");
                        }
                        string equipmentCode = entity.equipmentCode;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            OrgId = entity.orgId;
                        }
                        int newpage = page * size;
                        int newsize = size;
                        List<useCountResult> data = _unitOfWork.ViewEquipmentRepository.Exec_UseCount(" EXEC useCount @orgid ='" + OrgId + "',@startTime ='" + startTime.ToString("yyyy-MM-dd") + "'" +
                            ",@endTime ='" + endTime.AddDays(1).ToString("yyyy-MM-dd") + "'" + ",@eqcode ='" + equipmentCode + "'" + ",@newspage ='" + newpage + "'" + ",@pageSize ='" + newsize + "'").ToList();
                        //var  x= data[0].result.ToString();
                        //JsonData requestData = JsonMapper.ToObject(x);
                        var res = JsonConvert.DeserializeObject(data[0]?.result?.ToString() ?? string.Empty);
                        //var content = new
                        //{
                        //    totalElements = data.Count(),
                        //    content = data.Skip(page * size).Take(size).ToList()
                        //};

                        if (res == null)
                        {
                            res = new List<object>()
                            {
                                new
                                {
                                    totalElements = 0,
                                    content = new List<object>()
                                }
                            };
                        }

                        return JsonManager.ReturnSuccessResponse(res);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });

        }


        /// <summary>
        /// 财务报表统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "year":"年度",
        ///         "orgId":"组织机构ID",
        ///         "typeId":"资产类型ID",
        ///         "equipmentCode":"资产名称",
        ///         "equipmentSizecode":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageYearTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageYearTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        var findcode = ListEq.Where(c => c.Id.Equals(orgizationCode)).FirstOrDefault().FindCode;

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();

                        Expression<Func<ViewEquipment, bool>> expressionPoliceman = null;

                        string typeId = entity.typeId;
                        string equipmentCode = entity.equipmentCode;
                        string equipmentSizecode = entity.equipmentSizecode;

                        int year = System.DateTime.Now.Year;
                        if (!String.IsNullOrEmpty(entity.year))
                        {
                            year = int.Parse(entity.year);
                        }

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(typeId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.TypeOneId.Equals(typeId) || t.TypeTwoId.Equals(typeId) || t.TypeThreeId.Equals(typeId));
                        }

                        if (!String.IsNullOrEmpty(equipmentCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentCode.Equals(equipmentCode));
                        }

                        if (!String.IsNullOrEmpty(equipmentSizecode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentSizecode.Equals(equipmentSizecode));
                        }

                        List<ViewEquipment> equipmentList = _unitOfWork.ViewEquipmentRepository.GetList(expressionPoliceman).OrderBy(c => c.FindCode.Length).ToList();

                        if (findcode.Length == 6)
                        {
                            var data = equipmentList.GroupBy(t => t.OrgName).Select(c => new
                            {
                                c.FirstOrDefault().OrgName,
                                c.FirstOrDefault().OrgCode,
                                yearStartCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year < year),
                                yearStartPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year < year).Sum(k => k.Price),
                                yearEndCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year <= year),
                                yearEndPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year <= year).Sum(k => k.Price),
                                yearAddCount = c.Where(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                yearDelCount = c.Where(f => f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                children = c.OrderBy(z => z.TypeOneId).ThenBy(z => z.TypeTwoId).ThenBy(z => z.TypeThreeId).ThenBy(z => z.EquipmentCode1).GroupBy(a => a.EquipmentCode).Select(c => new
                                {
                                    id = c.FirstOrDefault().EquipmentCode,
                                    name = c.FirstOrDefault().EquipmentName,
                                    yearStartCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year < year),
                                    yearStartPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year < year).Sum(k => k.Price),
                                    yearEndCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year <= year),
                                    yearEndPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year <= year).Sum(k => k.Price),
                                    yearAddCount = c.Where(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                    yearDelCount = c.Where(f => f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count()
                                }).Where(f => f.id != null).ToList()
                            }).ToList();

                            data = data.OrderBy(c => c.OrgCode).ToList();

                            var dataPage = new
                            {
                                totalElements = data.Count,
                                yearStartCount = data.Sum(c => c.yearStartCount),
                                yearStartPrice = data.Sum(c => c.yearStartPrice),
                                yearEndCount = data.Sum(c => c.yearEndCount),
                                yearEndPrice = data.Sum(c => c.yearEndPrice),
                                yearAddCount = data.Sum(c => c.yearAddCount),
                                yearDelCount = data.Sum(c => c.yearDelCount),
                                content = data.Skip(page * size).Take(size)
                            };
                            return JsonManager.ReturnSuccessResponse(dataPage);
                        }
                        else
                        {
                            var codeLen = findcode.Length + 2;
                            var temp = equipmentList.GroupBy(t => t.FindCode.PadLeft(codeLen, '0').Substring(0, codeLen))
                                .ToList();
                            var data = temp.Select(c => new
                            {
                                FindCode = c.FirstOrDefault().FindCode,
                                OrgName = codeLen < 6 ?
                                    ListEq.FirstOrDefault(x => x.Code == c.FirstOrDefault().FindCode.Substring(0, codeLen).PadRight(12, '0')).AreaName
                                    : c.FirstOrDefault().AreaName,
                                c.FirstOrDefault().OrgCode,
                                yearStartCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year < year),
                                yearStartPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year < year).Sum(k => k.Price),
                                yearEndCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year <= year),
                                yearEndPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year <= year).Sum(k => k.Price),
                                yearAddCount = c.Where(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                yearDelCount = c.Where(f => f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                children = c.OrderBy(z => z.TypeOneId).ThenBy(z => z.TypeTwoId).ThenBy(z => z.TypeThreeId).ThenBy(z => z.EquipmentCode1).GroupBy(a => a.EquipmentCode).Select(c => new
                                {
                                    id = c.FirstOrDefault().EquipmentCode,
                                    name = c.FirstOrDefault().EquipmentName,
                                    yearStartCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year < year),
                                    yearStartPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year < year).Sum(k => k.Price),
                                    yearEndCount = c.Count(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year <= year),
                                    yearEndPrice = c.Where(f => !f.CurrentState.Equals(6) && f.Price != null && f.CreateTime?.Year <= year).Sum(k => k.Price),
                                    yearAddCount = c.Where(f => !f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count(),
                                    yearDelCount = c.Where(f => f.CurrentState.Equals(6) && f.CreateTime?.Year == year).Count()
                                }).Where(f => f.id != null).ToList()
                            }).ToList();

                            data = data.OrderBy(c => c.OrgCode).ToList();

                            var dataPage = new
                            {
                                totalElements = data.Count,
                                yearStartCount = data.Sum(c => c.yearStartCount),
                                yearStartPrice = data.Sum(c => c.yearStartPrice),
                                yearEndCount = data.Sum(c => c.yearEndCount),
                                yearEndPrice = data.Sum(c => c.yearEndPrice),
                                yearAddCount = data.Sum(c => c.yearAddCount),
                                yearDelCount = data.Sum(c => c.yearDelCount),
                                content = data.Skip(page * size).Take(size)
                            };
                            return JsonManager.ReturnSuccessResponse(dataPage);
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 按类型统计信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构ID",
        ///         "typeId":"资产类型ID",
        ///         "equipmentCode":"资产名称",
        ///         "equipmentSizecode":"型号名称"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageTypeTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageTypeTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = GetClassID(orgizationCode);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();

                        Expression<Func<ViewEquipment, bool>> expressionPoliceman = null;

                        string typeId = entity.typeId;
                        string equipmentCode = entity.equipmentCode;
                        string equipmentSizecode = entity.equipmentSizecode;

                        List<string> IdList = dataList.Select(c => c.Id).ToList();

                        expressionPoliceman = t => t.CurrentState != null && IdList.Contains(t.OrgId);

                        if (!String.IsNullOrEmpty(typeId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.TypeOneId.Equals(typeId) || t.TypeTwoId.Equals(typeId) || t.TypeThreeId.Equals(typeId));
                        }

                        if (!String.IsNullOrEmpty(equipmentCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentCode.Equals(equipmentCode));
                        }

                        if (!String.IsNullOrEmpty(equipmentSizecode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentSizecode.Equals(equipmentSizecode));
                        }

                        List<ViewEquipment> equipmentList = _unitOfWork.ViewEquipmentRepository.GetList(expressionPoliceman).OrderBy(c => c.FindCode.Length).ToList();

                        var data = equipmentList.GroupBy(t => t.TypeOneId).Select(c => new
                        {
                            id = c.FirstOrDefault().TypeOneId,
                            name = c.FirstOrDefault().ParentName,
                            zsCount = c.Count(f => f.CurrentState != 6 && f.InventoryState != "loss"),
                            zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                            ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                            bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                            children = c.GroupBy(a => a.TypeTwoId).Select(c => new
                            {
                                id = c.FirstOrDefault().TypeTwoId,
                                name = c.FirstOrDefault().TypeName,
                                zsCount = c.Count(f => f.CurrentState != 6 && f.InventoryState != "loss"),
                                zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                children = c.GroupBy(a => a.TypeThreeId).Select(c => new
                                {
                                    id = c.FirstOrDefault().TypeThreeId,
                                    name = c.FirstOrDefault().Name,
                                    zsCount = c.Count(f => f.CurrentState != 6 && f.InventoryState != "loss"),
                                    zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                    ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                    bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                    children = c.GroupBy(a => a.EquipmentCode).Select(c => new
                                    {
                                        id = c.FirstOrDefault().EquipmentCode,
                                        name = c.FirstOrDefault().EquipmentName,
                                        zsCount = c.Count(f => f.CurrentState != 6 && f.InventoryState != "loss"),
                                        zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                        ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                        bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                        children = c.GroupBy(a => a.EquipmentSizecode).Select(c => new
                                        {
                                            id = c.FirstOrDefault().EquipmentSizecode,
                                            name = c.FirstOrDefault().SizeName,
                                            zsCount = c.Count(f => f.CurrentState != 6 && f.InventoryState != "loss"),
                                            zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                            ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                            bfCount = c.Where(f => f.CurrentState.Equals(6)).Count()
                                        }
                                        ).OrderBy(c => c.id).ToList()
                                    }
                                    ).OrderBy(c => c.id).ToList()
                                }
                                ).OrderBy(c => c.id).ToList()
                            }
                            ).OrderBy(c => c.id).ToList()
                        }
                        ).OrderBy(c => c.id).ToList();

                        var dataPage = new
                        {
                            totalElements = data.Count,
                            content = data.Skip(page * size).Take(size)
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }




        /// <summary>
        /// 储备报表导出
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "level":"本级、本级及下级",
        ///         "orgId":"组织机构ID",
        ///         "typeId":"资产类型ID",
        ///         "equipmentCode":"资产名称",
        ///         "equipmentSizecode":"型号名称",
        ///         "warehouseId":"仓库id",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageCBTjExp")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageCBTjExp([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        Expression<Func<ViewEquipmentType, bool>> expressionPoliceman = null;

                        string typeId = entity.typeId;
                        string equipmentCode = entity.equipmentCode;
                        string equipmentSizecode = entity.equipmentSizecode;
                        string warehouseId = entity.warehouseId;
                        string level = entity.level;

                        if (level == "本级")
                        {
                            expressionPoliceman = t => t.OrgId.Equals(orgizationCode) && t.CurrentState != null && t.CurrentState != 5 && t.CurrentState != 6;
                        }
                        else
                        {
                            var orgModelList = new List<OrgTreeModel>();
                            if (MemoryCacheHelper.Exists("orgModelList"))
                            {
                                orgModelList = (List<OrgTreeModel>)MemoryCacheHelper.Get("orgModelList");
                            }
                            else
                            {
                                orgModelList = _unitOfWork.OrganizationRepository
                                    .Entities
                                    .Select(x => new OrgTreeModel
                                    {
                                        Id = x.Id,
                                        State = x.State == 1,
                                        Name = x.Name,
                                        Code = x.Code,
                                        ParentId = x.ParentId
                                    })
                                    .ToList();

                                //默认过期时间1天
                                MemoryCacheHelper.AddMemoryCache("orgModelList", orgModelList, 1440);
                            }
                            var idList = OrgTreeModel.GetOrgIdList(orgModelList, orgizationCode);
                            
                            expressionPoliceman = t => idList.Contains(t.OrgId) && t.CurrentState != 5 && t.CurrentState != 6;
                        }


                        if (!String.IsNullOrEmpty(typeId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.TypeOneId.Equals(typeId) || t.TypeTwoId.Equals(typeId) || t.TypeThreeId.Equals(typeId));
                        }

                        if (!String.IsNullOrEmpty(equipmentCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentCode.Equals(equipmentCode));
                        }

                        if (!String.IsNullOrEmpty(equipmentSizecode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentSizecode.Equals(equipmentSizecode));
                        }

                        if (!String.IsNullOrEmpty(warehouseId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseId.Equals(warehouseId));
                        }

                        List<ViewEquipmentType> equipmentList = _unitOfWork.ViewEquipmentTypeRepository.GetList(expressionPoliceman)
                            .OrderBy(c => c.TypeOneId).ThenBy(c => c.TypeTwoId).ThenBy(c => c.TypeThreeId).ToList();

                        var data = equipmentList
                            .GroupBy(t => new { t.TypeOneId, t.EquipmentCode, t.Price, t.EquipmentSizecode }).Select(
                                c => new
                                {
                                    id = c.FirstOrDefault().TypeOneId,
                                    TypeTwoId = c.FirstOrDefault().TypeTwoId,
                                    TypeThreeId = c.FirstOrDefault().TypeThreeId,
                                    EquipmentCode = c.FirstOrDefault().EquipmentCode,
                                    EquipmentSizecode = c.FirstOrDefault().EquipmentSizecode,
                                    ParentName = c.FirstOrDefault().Name,
                                    EquipmentName = c.FirstOrDefault().EquipmentName,
                                    SizeName = c.FirstOrDefault().SizeName,
                                    zsCount = c.Count(f => f.CurrentState != 6),
                                    Price = c.FirstOrDefault().Price,
                                    sumPrice = c.Count(f => f.CurrentState != 6) * c.Key.Price,
                                }
                            ).OrderBy(x => x.id)
                            .ThenBy(x => x.TypeTwoId)
                            .ThenBy(x => x.TypeThreeId)
                            .ThenBy(x => x.EquipmentCode)
                            .ThenBy(x => x.EquipmentSizecode)
                            .ToList();

                        return JsonManager.ReturnSuccessResponse(new
                        {
                            totalElements = data.Count,
                            content = data.Skip(page * size).Take(size)
                        });

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 储备报表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "level":"本级、本级及下级",
        ///         "orgId":"组织机构ID",
        ///         "typeId":"资产类型ID",
        ///         "equipmentCode":"资产名称",
        ///         "equipmentSizecode":"型号名称",
        ///         "warehouseId":"仓库id",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageCBTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetPageCBTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        Expression<Func<ViewEquipmentType, bool>> expressionPoliceman = null;

                        string typeId = entity.typeId;
                        string equipmentCode = entity.equipmentCode;
                        string equipmentSizecode = entity.equipmentSizecode;
                        string warehouseId = entity.warehouseId;
                        string level = entity.level;

                        if (level == "本级")
                        {
                            expressionPoliceman = t => t.OrgId.Equals(orgizationCode) || t.CurrentState == null;
                        }
                        else
                        {
                            var orgModelList = new List<OrgTreeModel>();
                            if (MemoryCacheHelper.Exists("orgModelList"))
                            {
                                orgModelList = (List<OrgTreeModel>)MemoryCacheHelper.Get("orgModelList");
                            }
                            else
                            {
                                orgModelList = _unitOfWork.OrganizationRepository
                                    .Entities
                                    .Select(x => new OrgTreeModel
                                    {
                                        Id = x.Id,
                                        State = x.State == 1,
                                        Name = x.Name,
                                        Code = x.Code,
                                        ParentId = x.ParentId
                                    })
                                    .ToList();

                                //默认过期时间1天
                                MemoryCacheHelper.AddMemoryCache("orgModelList", orgModelList, 1440);
                            }
                            var idList = OrgTreeModel.GetOrgIdList(orgModelList, orgizationCode);
                            expressionPoliceman = t => idList.Contains(t.OrgId) || t.CurrentState == null;
                        }


                        if (!String.IsNullOrEmpty(typeId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.TypeOneId.Equals(typeId) || t.TypeTwoId.Equals(typeId) || t.TypeThreeId.Equals(typeId));
                        }

                        if (!String.IsNullOrEmpty(equipmentCode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentCode.Equals(equipmentCode));
                        }

                        if (!String.IsNullOrEmpty(equipmentSizecode))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.EquipmentSizecode.Equals(equipmentSizecode));
                        }

                        if (!String.IsNullOrEmpty(warehouseId))
                        {
                            expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.WarehouseId.Equals(warehouseId));
                        }

                        List<ViewEquipmentType> equipmentList = _unitOfWork.ViewEquipmentTypeRepository.GetList(expressionPoliceman).OrderBy(c => c.TypeOneId).ThenBy(c => c.TypeTwoId).ThenBy(c => c.TypeThreeId).ToList();

                        var data = equipmentList.OrderBy(c => c.TypeOneId).GroupBy(t => t.TypeOneId).Select((c, idx) => new
                        {
                            rowNumber = (idx + 1) + "",
                            id = c.FirstOrDefault().TypeOneId,
                            name = c.FirstOrDefault().ParentName,
                            zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                            zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                            ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                            bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                            children = c.Where(c => c.TypeTwoId != c.TypeOneId).OrderBy(c => c.TypeTwoId).GroupBy(a => a.TypeTwoId).Select((c, idx1) => new
                            {
                                rowNumber = (idx + 1) + "." + (idx1 + 1),
                                id = c.FirstOrDefault().TypeTwoId,
                                name = c.FirstOrDefault().TypeName,
                                zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                children = c.Where(c => c.TypeThreeId != c.TypeTwoId).OrderBy(c => c.TypeThreeId).GroupBy(a => a.TypeThreeId).Select((c, idx2) => new
                                {
                                    rowNumber = (idx + 1) + "." + (idx1 + 1) + "." + (idx2 + 1),
                                    id = c.FirstOrDefault().TypeThreeId,
                                    name = c.FirstOrDefault().Name,
                                    zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                    zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                    ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                    bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                    children = c.OrderBy(c => c.EquipmentCode).GroupBy(a => a.EquipmentCode).Select((c, idx3) => new
                                    {
                                        rowNumber = (idx + 1) + "." + (idx1 + 1) + "." + (idx2 + 1) + "." + (idx3 + 1),
                                        id = c.FirstOrDefault().EquipmentCode,
                                        name = c.FirstOrDefault().EquipmentName,
                                        zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                        zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                        ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                        bfCount = c.Where(f => f.CurrentState.Equals(6)).Count(),
                                        children = c.OrderBy(c => c.EquipmentSizecode).GroupBy(a => new { a.EquipmentSizecode, a.Address, a.SupplierName, a.Price }).Select((c, idx4) => new
                                        {
                                            rowNumber = (idx + 1) + "." + (idx1 + 1) + "." + (idx2 + 1) + "." + (idx3 + 1) + "." + (idx4 + 1),
                                            id = c.FirstOrDefault().EquipmentSizecode,
                                            name = c.FirstOrDefault().SizeName,
                                            address = c.Key.Address,
                                            suplierName = c.Key.SupplierName,
                                            price = c.Key.Price,
                                            sumPrice = c.Count(f => f.CurrentState != null) * c.Key.Price,
                                            zsCount = c.Count(f => f.CurrentState != 6 && f.CurrentState != null),
                                            zkCount = c.Where(f => f.CurrentState.Equals(0) || f.CurrentState.Equals(3)).Count(),
                                            ckCount = c.Where(f => !(f.CurrentState == null || f.CurrentState.Equals(0) || f.CurrentState.Equals(3) || f.CurrentState.Equals(6))).Count(),
                                            bfCount = c.Where(f => f.CurrentState.Equals(6)).Count()
                                        }
                                        ).Where(c => c.id != null).ToList()
                                    }
                                    ).Where(c => c.id != null).ToList()
                                }
                                  ).Where(c => c.id != null).ToList()
                            }
                            ).Where(c => c.id != null).ToList()
                        }
                        ).Where(c => c.id != null).ToList();

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 统计一段时间内各组织机构装备使用情况（指定组织机构本级及下级全部组织机构，并行）
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"组织机构ID",
        ///         "startDate":"开始日期",
        ///         "endDate":"结束日期",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetUseByDateTj")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetUseByDateTj([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationCode = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgId))
                        {
                            orgizationCode = entity.orgId;
                        }

                        dataList = _unitOfWork.OrganizationRepository.GetList(x => x.ParentId == orgizationCode).ToList();
                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationCode))).ToList();
                        List<string> IdList = dataList.Select(c => c.Id).ToList();
                        Expression<Func<CommonJpEquipmentState, bool>> expressionPoliceman = t => IdList.Contains(t.OrgId) && !string.IsNullOrEmpty(t.EqiupmentId);

                        if (!DateTime.TryParse(entity.startDate, out DateTime startDate))
                        {
                            return JsonManager.SimpleCustResponse("startDate is require");
                        }
                        if (!DateTime.TryParse(entity.endDate, out DateTime endDate))
                        {
                            return JsonManager.SimpleCustResponse("endDate is require");
                        }

                        expressionPoliceman = expressionPoliceman.AndAlso(x => (x.State.Equals(1) || x.State.Equals(3)) && (x.ActionState.Equals(2) || x.ActionState.Equals(3) || x.ActionState.Equals(5) || x.ActionState.Equals(14) || x.ActionState.Equals(15)));

                        expressionPoliceman = expressionPoliceman.AndAlso(x => x.OutTime > startDate.Date && x.OutTime < endDate.Date.AddDays(1));

                        var res = _unitOfWork.EquipmentStateRepository.GetList(expressionPoliceman, includes: new[] { "Org" }).ToList();
                        var data = res.GroupBy(x => x.OrgId)
                            .Select(x => new
                            {
                                orgId = x.Key,
                                orgCode = x.FirstOrDefault().Org.Code,
                                orgName = x.FirstOrDefault().Org.Name,
                                count = x.Count(),
                                oneDay = x.GroupBy(y => y.CreateTime.Value.Date)
                                    .OrderByDescending(y => y.Key)
                                    .Select(y => new
                                    {
                                        date = y.Key.ToString("yyyy-MM-dd"),
                                        count = y.Count()
                                    })
                            })
                            .OrderBy(x => x.orgCode)
                            .ToList();
                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }

    }
}
