﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using JunmpPoliceStation.Extensions;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ThirdControlController : ControllerBase
    {
        private ILogger<ThirdControlController> _logger;
        UnitOfWork _unitOfWork;
        MQTTServer _mqttServer;
        public ThirdControlController(ILogger<ThirdControlController> logger, UnitOfWork unitOfWork, MQTTServer mqttServer)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
            _mqttServer = mqttServer;
        }

        /// <summary>
        /// 获取单警柜出入库记录
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page":"page",
        ///         "size":"size",
        ///         "orgId":"组织机构id",
        ///         "startTime":"记录起始时间",
        ///         "endTime":"记录结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetInOutHistory")]
        public async Task<HttpResponseMessage> GetCabinetInOutHistory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 10;
                        }


                        var param = new string[]
                        {
                            "Eqiupment",
                            "Eqiupment.EquipmentCodeNavigation",
                            "Eqiupment.EquipmentSizecodeNavigation",
                            "Org",
                            "Police",
                            "CabinetIdIntoNavigation",
                            "CabinetIdOutNavigation",
                        };

                        string OrgId = entity.orgId;
                        string actionUserName = entity.actionUserName;
                        string cabinetId = entity.cabinetId;

                        if (String.IsNullOrEmpty(OrgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        Expression<Func<CommonJpEquipmentState, bool>> expression = t => t.OrgId.Equals(OrgId);

                        //单警柜
                        expression = expression.AndAlso(t => string.IsNullOrEmpty(t.EqiupmentId));
                        //if (!string.IsNullOrEmpty(actionUserName))
                        //{
                        //    expression = expression.AndAlso(x => x.Police.Name.Contains(actionUserName));
                        //}
                        //if (!string.IsNullOrEmpty(cabinetId))
                        //{
                        //    expression = expression.AndAlso(x => x.CabinetIdInto == cabinetId || x.CabinetIdOut == cabinetId);
                        //}

                        //if (!String.IsNullOrEmpty(entity.outInState))
                        //{
                        //    string outInState = entity.outInState;

                        //    expression = LambdaExtensions.AndAlso(expression, t => t.OutInState.Equals(Convert.ToInt32(outInState)));
                        //}

                        //if (!String.IsNullOrEmpty(entity.equipmentDetail))
                        //{
                        //    string equipmentDetail = entity.equipmentDetail;

                        //    expression = LambdaExtensions.AndAlso(expression, t => t.Eqiupment.EquipmentCodeNavigation.Name.Contains(equipmentDetail));
                        //}

                        if (entity.startTime != null)
                        {
                            if (!DateTime.TryParse(entity.startTime, out DateTime startTime))
                            {
                                return JsonManager.SimpleCustResponse("startTime is require");
                            }
                            if (entity.endTime != null)
                            {
                                if (!DateTime.TryParse(entity.endTime, out DateTime endTime))
                                {
                                    return JsonManager.SimpleCustResponse("startTime is require");
                                }
                                expression = expression.AndAlso(t => t.CreateTime.Value.Date >= startTime && t.CreateTime.Value.Date <= endTime);
                            }
                            else
                            {
                                expression = expression.AndAlso(t => t.CreateTime.Value.Date >= startTime);
                            }
                        }
                        expression = expression.AndAlso(t => string.IsNullOrEmpty(t.ErrorEpc) && string.IsNullOrEmpty(t.ParentId));

                        var equipmentStates = _unitOfWork.EquipmentStateRepository.GetPageAsync(expression, "-CreateTime", page, size, false, param).Result;
                        var data = equipmentStates?.content.Select(t => new
                        {
                            //result = _unitOfWork.EquipmentStateRepository.GetList(p => p.EqiupmentId.Equals(t.EqiupmentId)).OrderByDescending(p => p.CreateTime).FirstOrDefault().Id.Equals(t.Id) ? true : false,
                            orgCode = t.Org.FindCode.PadRight(6, '0'),

                            t.PicUrl,
                            cabinetId = t.CabinetIdInto == null ? t.CabinetIdOut : t.CabinetIdInto,
                            cabinetName = t.CabinetIdIntoNavigation == null ? (t.CabinetIdOutNavigation?.CabinetNum + "-" + t.CabinetIdOutNavigation?.CabinetChildNum.ToString()) : (t.CabinetIdIntoNavigation?.CabinetNum + "-" + t.CabinetIdIntoNavigation?.CabinetChildNum.ToString()),
                            t.OutInState,
                            orgId = t.OrgId,
                            orgName = t.OrgId == null ? "" : t.Org?.Name,
                            t.CreateTime,
                            t.PoliceId,
                            policeName = t.PoliceId == null ? "" : t.Police?.Name,
                            detail = _unitOfWork.EquipmentStateRepository
                                .GetList(x => x.ParentId == t.Id, includes: new[] { "Eqiupment", "Eqiupment.EquipmentSizecodeNavigation", "Eqiupment.EquipmentCodeNavigation" })
                                .ToList()
                                .GroupBy(x => x.Eqiupment.EquipmentSizecode)
                                .Select(x => new
                                {
                                    count = x.Count(),
                                    equipmentName = x.FirstOrDefault()?.Eqiupment?.EquipmentCodeNavigation?.Name,
                                    sizeName = string.IsNullOrEmpty(x.FirstOrDefault()?.EqiupmentId) ? "" : x.FirstOrDefault()?.Eqiupment?.EquipmentSizecodeNavigation?.SizeName,
                                    safeLevel = x.FirstOrDefault()?.HistorySafeLevel
                                }).ToList()
                        });
                        var content = new
                        {
                            equipmentStates?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 人员统计报表 
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page":"page",
        ///         "size":"size",
        ///         "orgId":"组织机构id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPoliceView")]
        public async Task<HttpResponseMessage> GetPoliceView([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        string orgId = entity.orgId;
                        string policeCode = entity.policeCode;

                        if (String.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        var param = new string[] {
                            "WarehouseCodeNavigation",
                            "PoliceCodeNavigation",
                            "EquipmentCodeNavigation",
                            "EquipmentSizecodeNavigation",
                            "SupplierCodeNavigation",
                        };

                        Expression<Func<CommonJpEquipmentInventory, bool>> expression = t => t.WarehouseCodeNavigation.OrgizationId.Equals(orgId);

                        if (!string.IsNullOrEmpty(policeCode))
                        {
                            expression = expression.AndAlso(t => t.PoliceCode.Equals(policeCode));
                        }
                        else
                        {
                            expression = expression.AndAlso(t => t.PoliceCode != null);
                        }
                        //过滤已报废数据
                        expression = expression.AndAlso(t => t.CurrentState != 6);
                        IQueryable<CommonJpEquipmentInventory> inventoryList = _unitOfWork.EquipmentInventoryRepository.GetList(expression, t => t.WarehouseCode, false, param);

                        var groupData = inventoryList.Select(c => new
                        {
                            id = c.PoliceCode,
                            c.PoliceCodeNavigation.PoliceCode,
                            c.PoliceCodeNavigation.Name,
                            c.CurrentState,
                            cabinetName = c.Cabinet == null ? "" : (c.Cabinet.CabinetNum + "-" + c.Cabinet.CabinetChildNum),
                            equipmentName = c.EquipmentCodeNavigation.Name,
                            sizeName = c.EquipmentSizecodeNavigation.SizeName,
                            supplierName = c.SupplierCodeNavigation.Name,
                            productTime = c.ProductTime,
                            c.Epc
                        }).ToList();


                        var data = groupData.GroupBy(t => new { t.id, t.PoliceCode, t.Name }).Where(c => !string.IsNullOrEmpty(c.Key.id)).Select(c => new
                        {
                            c.Key.id,
                            c.Key.PoliceCode,
                            c.Key.Name,
                            zkCount = c.Count(d => d.CurrentState.Equals(0) || d.CurrentState.Equals(3)),
                            ckCount = c.Count(d => !(d.CurrentState.Equals(0) || d.CurrentState.Equals(3))),
                            zsCount = c.Count(),
                            detail = groupData
                                .Where(x => x.id == c.Key.id)
                                .Select(x => new
                                {
                                    x.Epc,
                                    x.cabinetName,
                                    x.equipmentName,
                                    x.sizeName,
                                    x.supplierName,
                                    x.productTime,
                                    state = (x.CurrentState == 0 || x.CurrentState == 3) ? "in" : "out",
                                })
                        }).OrderBy(c => c.PoliceCode).ToList();

                        var dataPage = new
                        {
                            totalElements = data.Count,
                            content = data.Skip(page * size).Take(size)
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取人员分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPolicemanInfo")]
        public async Task<HttpResponseMessage> GetPolicemanInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }
                        string orgId = entity.orgId;

                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        Expression<Func<BaseJpPoliceman, bool>> expressionPoliceman = t => t.OrgizationCode.Equals(orgId);


                        //if (!String.IsNullOrEmpty(entity.name))
                        //{
                        //    expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.Name.Contains(Name));
                        //}

                        //if (!String.IsNullOrEmpty(entity.policeCode))
                        //{
                        //    expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.PoliceCode.Contains(PoliceCode));
                        //}

                        //if (!String.IsNullOrEmpty(entity.cabinetId))
                        //{
                        //    expressionPoliceman = LambdaExtensions.AndAlso(expressionPoliceman, t => t.CabinetId.Contains(CabinetId));
                        //}


                        var param = new string[]
                        {
                            "Cabinet",
                            "OrgizationCodeNavigation"
                        };

                        PageData<BaseJpPoliceman> pagedata = _unitOfWork.PolicemanRepository.GetPage(expressionPoliceman, "-UpdateTime", page, size, false, param);

                        var data = pagedata.content.Select(c => new
                        {
                            c.Id,
                            c.CreateTime,
                            c.Name,
                            c.PoliceCode,
                            c.Sex,
                            c.Phone,

                            c.CabinetId,
                            cabinetName = c.Cabinet == null ? "" : (c.Cabinet.CabinetNum + "-" + c.Cabinet.CabinetChildNum),

                            orgizationId = c.OrgizationCode,
                            orgizationName = c.OrgizationCodeNavigation?.Name,
                            orgizationCode = c.OrgizationCodeNavigation?.Code,


                        }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = pagedata.totalElements,
                            content = data
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取单警柜分页列表
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page": "0",
        ///         "size": "10",
        ///         "orgId":"组织机构id"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCabinetInfo")]
        public async Task<HttpResponseMessage> GetCabinetInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        //第三方调用接口验证orgId正确性
                        if (!string.IsNullOrEmpty(entity._PUSHORG))
                        {
                            if (entity.orgId?.ToString() != entity._PUSHORG.ToString())
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORGANIZATION_ERROR);
                            }
                        }

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }
                        string orgId = entity.orgId;

                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        Expression<Func<BaseJpCabinet, bool>> expression = t => t.OrganizationId.Equals(orgId) && t.Type == 0;

                        var param = new string[] {
                            "Organization",
                            "BaseJpPolicemen"
                        };
                        var onlineDevice = _mqttServer.mqttServer.GetClientStatusAsync().Result;
                        var data = _unitOfWork.CabinetRepository.GetList(expression, x => x.CabinetChildNum, false, param).ToList();

                        var res = data
                            .GroupBy(p => p.CabinetRealNum)
                            .Select(t => new
                            {
                                state = onlineDevice.Any(x => x.ClientId == t.Key) ? "在线" : "离线",
                                count = t.Count(),
                                freeCount = t.Count(x => string.IsNullOrEmpty(x.BaseJpPolicemen?.FirstOrDefault()?.Id)),

                                t.FirstOrDefault()?.CabinetNum,
                                Id = t.FirstOrDefault()?.CabinetRealNum,

                                t.FirstOrDefault()?.OrganizationId,
                                t.FirstOrDefault()?.Organization.Name,

                                children = t.Select(x => new
                                {
                                    x.Id,
                                    x.CabinetChildNum,
                                    policeName = x.BaseJpPolicemen?.FirstOrDefault()?.Name,
                                    policeId = x.BaseJpPolicemen?.FirstOrDefault()?.Id,

                                }),
                                errLog = _unitOfWork.DbContext.BaseJpCabinetInvErrorMsgs
                                    .Where(y => y.CabinetRealNum == t.Key)
                                    .OrderByDescending(x => x.PushTime)
                                    .Take(10)
                                    .Select(x => new
                                    {
                                        x.State,
                                        x.Msg,
                                        x.UserName,
                                        x.CurrentUserName,
                                        x.Epc,
                                        x.PushTime
                                    })
                            }
                        ).ToList();

                        var dataPage = new
                        {
                            totalElements = res.Count,
                            content = res.Skip(page * size).Take(size).ToList()
                        };

                        return JsonManager.ReturnSuccessResponse(dataPage);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }
}
