﻿using JmpCommon;
using JunmpPoliceStation.Extensions;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Logging;
using System;

namespace JunmpPoliceStation.App_Start
{
    public class ActionLimitAttribute : ActionFilterAttribute
    {
        private ILogger<ActionLimitAttribute> _logger;

        public ActionLimitAttribute(ILogger<ActionLimitAttribute> logger)
        {
            _logger = logger;
        }
        public override void OnActionExecuting(ActionExecutingContext filterContext)
        {
            try
            {
                //获取访问ip
                var userHostAddress = filterContext.HttpContext.Connection.RemoteIpAddress?.MapToIPv4().ToString();
                if (!string.IsNullOrEmpty(userHostAddress) && IsIP(userHostAddress))
                {
                    //有效ip
                    var url = filterContext.ActionDescriptor.RouteValues["controller"] + "/" + filterContext.ActionDescriptor.RouteValues["action"];
                    _logger.LogDebug("获取访问ip:" + userHostAddress + "地址：api/" + url);

                    if (userHostAddress == "127.0.0.1")
                    {
                        //本地ip过滤
                        return;
                    }

                    var key = userHostAddress + url;
                    if (MemoryCacheHelper.Exists(key))
                    {
                        int value = int.Parse(MemoryCacheHelper.Get(key).ToString() ?? string.Empty);
                        if (value > 25) //每分钟上限访问25次
                        {
                            filterContext.Result = new JsonResult(ResultCode.ACTION_LIMIT);
                            return;
                        }
                        else
                        {
                            value += 1;
                        }
                        MemoryCacheHelper.AddMemoryCache(key, value);
                    }
                    else
                    {
                        MemoryCacheHelper.AddMemoryCache(key, 1);
                    }
                }
            }
            catch (Exception e)
            {
                _logger.LogError("ActionLimitAttribute 错误:" + e.ToString());
                filterContext.Result = new JsonResult(e.ToString());
            }
        }


        /// <summary>
        /// 检查IP地址格式
        /// </summary>
        /// <param name="ip"></param>
        /// <returns></returns>
        private static bool IsIP(string ip)
        {
            return System.Text.RegularExpressions.Regex.IsMatch(ip, @"^((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)$");
        }

    }
}
