﻿using JmpModel.Model.DataContext;
using JunmpPoliceStation.Models.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace JmpModel.Model.Repository.BaseRepository
{
    public class OrganizationRepository : BaseRepository<BaseJpOrganization>
    {
        private List<BaseJpOrganization> _listEq = new List<BaseJpOrganization>();
        public OrganizationRepository(JunmppolicesqlContext context) : base(context)
        {

        }

        /// <summary>
        /// 获取本级及下级组织机构
        /// </summary>
        /// <param name="orgId"></param>
        /// <returns></returns>
        public List<BaseJpOrganization> GetAllChildListByOrgId(string orgId)
        {
            _listEq = DbContext.BaseJpOrganizations
                .Where(x => x.State == 1)
                .OrderByDescending(x => x.Code)
                .ToList();
            List<BaseJpOrganization> dataList = GetClassID(orgId);

            dataList = dataList.Concat(_listEq.Where(c => c.Id.Equals(orgId))).ToList();
            return dataList;
        }

        private List<BaseJpOrganization> GetClassID(string id)
        {
            var query = (from c in _listEq
                         where c.ParentId == id
                         select c)
                .ToList();
            return query.Concat(query.SelectMany(t => GetClassID(t.Id))).ToList();
        }
    }
}
