﻿using Microsoft.Extensions.Caching.Distributed;
using Microsoft.Extensions.Caching.Memory;
using System;
using System.Collections.Generic;
using System.Linq;
using JmpModel.Model;

namespace JunmpPoliceStation.Extensions
{
    public class MemoryCacheHelper
    {
        public static MemoryCache _cache = new MemoryCache(new MemoryCacheOptions());
        /// <summary>
        /// 验证缓存项是否存在
        /// </summary>
        /// <param name="key">缓存Key</param>
        /// <returns></returns>
        public static bool Exists(string key)
        {
            if (key == null)
            {
                return false;
            }
            return _cache.TryGetValue(key, out _);
        }

        /// <summary>
        /// 获取缓存
        /// </summary>
        /// <param name="key">缓存Key</param>
        /// <returns></returns>
        /// <exception cref="ArgumentNullException"></exception>
        public static object Get(string key)
        {
            if (key == null)
            {
                throw new ArgumentNullException(nameof(key));
            }
            if (!Exists(key))
                throw new ArgumentNullException(nameof(key));


            return _cache.Get(key);
        }

        /// <summary>
        /// 添加缓存
        /// </summary>
        /// <param name="key"></param>
        /// <param name="value"></param>
        /// <returns></returns>
        /// <exception cref="ArgumentNullException"></exception>
        public static bool AddMemoryCache(string key, object value, int minutes = 1)
        {
            if (key == null)
            {
                throw new ArgumentNullException(nameof(key));
            }
            if (value == null)
            {
                throw new ArgumentNullException(nameof(value));
            }
            DateTimeOffset time = DateTimeOffset.Now.AddMinutes(minutes); //一分钟后过期
            _cache.Set(key, value, time);
            return Exists(key);
        }

        /// <summary>
        /// 添加缓存
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        /// <exception cref="ArgumentNullException"></exception>
        public static bool RemoveMemoryCache(string key)
        {
            if (key == null)
            {
                throw new ArgumentNullException(nameof(key));
            }
            _cache.Remove(key);
            return !Exists(key);
        }
    }


    public class OrgTreeModel
    {
        public OrgTreeModel()
        {
            Children = new List<OrgTreeModel>();
        }
        public string Id { get; set; }
        public string Name { get; set; }
        public string Code { get; set; }
        public bool State { get; set; }
        public string ParentId { get; set; }
        public List<OrgTreeModel> Children { get; set; }

        /// <summary>
        /// 获取组织机构本级及下级idList
        /// </summary>
        /// <param name="allList"></param>
        /// <returns></returns>
        public static List<string> GetOrgIdList(List<OrgTreeModel> allList, string id)
        {
            var top = allList.FirstOrDefault(x => x.Id == id);
            if (top == null)
            {
                return new List<string>();
            }

            var strList = new List<string>();
            if (top.State)
            {
                strList.Add(top.Id);
            }
            TraversalOrgTree(allList, allList.Where(x => x.ParentId == top.Id).ToList(), ref strList);

            return strList;
        }

        /// <summary>
        /// 遍历
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        private static void TraversalOrgTree(List<OrgTreeModel> allList, List<OrgTreeModel> list, ref List<string> strList)
        {
            if (list.Count == 0)
            {
                return;
            }
            foreach (var org in list)
            {
                if (org.State)
                {
                    strList.Add(org.Id);
                }
                TraversalOrgTree(allList, allList.Where(x => x.ParentId == org.Id).ToList(), ref strList);

            }
            return;
        }
    }
}


