﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class WarehouseDevController : ControllerBase
    {

        //private ICabinetRepository _CabinetRepository;
        private ILogger<WarehouseDevController> _logger;
        UnitOfWork _unitOfWork;
        public WarehouseDevController(ILogger<WarehouseDevController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }
        private List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }



        /// <summary>
        /// 获取除湿机图表信息
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "warehouseId":"仓库ID",
        ///         "devIp":"设备IP",
        ///         "startTime":"历史记录起始时间",
        ///         "endTime":"历史记录结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWarehouseInfo")]
        public async Task<HttpResponseMessage> GetWarehouseInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);


                        if (String.IsNullOrEmpty(entity.warehouseId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        if (String.IsNullOrEmpty(entity.devIp))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string warehouseId = entity.warehouseId;

                        string devIp = entity.devIp;
                        bool bStartTime = DateTime.TryParse(entity.startTime, out DateTime startTime);
                        bool bEndTime = DateTime.TryParse(entity.endTime, out DateTime endTime);

                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = t => t.Id.Equals(warehouseId);

                        var param = new string[] {
                       "BaseJpWarehouseDevs",
                       "BaseJpWarehouseDevHistories"
                    };

                        BaseJpWarehouse warehouseList = _unitOfWork.WarehouseRepository.GetList(expressionHouse, t => t.UpdateTime, false, param).FirstOrDefault();

                        BaseJpWarehouseDev devInfo = warehouseList?.BaseJpWarehouseDevs?.Where(c => c.DevIp.Equals(devIp)).FirstOrDefault();
                        if (devInfo == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        List<BaseJpWarehouseDevHistory> historyList;
                        if (bStartTime)
                        {
                            historyList = warehouseList.BaseJpWarehouseDevHistories.Where(c => c.DevIp.Equals(devIp) && c.UpdateTime > startTime).ToList();
                            if (bEndTime)
                            {
                                historyList = historyList.Where(x => x.UpdateTime < endTime).ToList();
                            }
                        }
                        else
                        {
                            //默认2天
                            historyList = warehouseList.BaseJpWarehouseDevHistories?.Where(c => c.DevIp.Equals(devIp) && c.UpdateTime > DateTime.Now.AddDays(-2)).ToList();
                        }

                        var data = new
                        {
                            devInfo.WarehouseId,
                            devInfo.DevIp,
                            devInfo.DevName,
                            devInfo.WarehouseSd,
                            devInfo.WarehouseWd,
                            devInfo.DevState,
                            devInfo.DevPort,
                            devInfo.DevCode,
                            devInfo.SetSd,
                            list = historyList?.Select(t => new
                            {
                                UpdateTime = t.UpdateTime.ToString("yyyy/MM/dd HH:00:00"),
                                湿度 = t.WarehouseSd,
                                温度 = t.WarehouseWd
                            }).OrderByDescending(c => c.UpdateTime)
                        };

                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取除湿机历史记录
        /// </summary>
        /// <remarks>
        /// 
        /// ## 例子
        /// 
        ///     {
        ///         "page":0,
        ///         "size":10,
        ///         "warehouseId":"仓库ID",
        ///         "devIp":"设备IP",
        ///         "startTime":"历史记录起始时间",
        ///         "endTime":"历史记录结束时间"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWarehouseHistory")]
        public async Task<HttpResponseMessage> GetWarehouseHistory([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        if (size == 0)
                        {
                            size = 10;
                        }
                        string warehouseId = entity.warehouseId ?? "";
                        string devIp = entity.devIp ?? "";
                        bool bStartTime = DateTime.TryParse(entity.startTime, out DateTime startTime);
                        bool bEndTime = DateTime.TryParse(entity.endTime, out DateTime endTime);

                        if (string.IsNullOrEmpty(warehouseId))
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        Expression<Func<BaseJpWarehouseDevHistory, bool>> expression = t => t.WarehouseId == warehouseId;
                        if (!string.IsNullOrEmpty(devIp))
                        {
                            expression = expression.AndAlso(x => x.DevIp == devIp);
                        }

                        if (bStartTime)
                        {
                            expression = expression.AndAlso(x => x.UpdateTime > startTime);
                            if (bEndTime)
                            {
                                expression = expression.AndAlso(x => x.UpdateTime < endTime);
                            }
                        }

                        var list = _unitOfWork.BaseJpWarehouseDevHistoryRepository.GetPage(expression, "-UpdateTime",
                            page, size);

                        return JsonManager.ReturnSuccessResponse(list);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取所有设备信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "orgId":"",
        ///         "warehouseId":"",
        ///         "devId":"",
        ///         "devName":"", //设备名称
        ///         "devCode":"" //设备编号
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetListDev")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetListDev([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string devName = entity.devName ?? "";
                        string devCode = entity.devCode ?? "";
                        string orgid = entity.orgId ?? Guid.Empty.ToString();
                        string warehouseId = entity.warehouseId ?? "";
                        string devId = entity.devId ?? "";

                        var param = new string[] {
                       "Warehouse" ,
                       "Warehouse.Orgization" ,
                    };

                        ListEq = _unitOfWork.OrganizationRepository.GetList(t => t.State == 1, t => t.Code).ToList();
                        var dataList = GetClassID(orgid).Concat(ListEq.Where(c => c.Id.Equals(orgid))).ToList();
                        Expression<Func<BaseJpWarehouseDev, bool>> expression = t => dataList.Select(c => c.Id).Contains(t.Warehouse.OrgizationId);

                        if (!string.IsNullOrEmpty(devName))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.DevName.Contains(devName));
                        }
                        if (!string.IsNullOrEmpty(devCode))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.DevCode.Contains(devCode));
                        }

                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.WarehouseId.Equals(warehouseId));
                        }

                        if (!string.IsNullOrEmpty(devId))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.DevId.Equals(devId));
                        }

                        var devList = _unitOfWork.WarehouseDevRepository.GetList(expression, t => t.DevId, false, param).ToList();
                        var data = devList?.Select(s => new
                        {
                            s.DevId,
                            s.DevName,
                            s.DevCode,
                            orgName = s.Warehouse?.Orgization?.Name ?? "",
                            orgId = s.Warehouse?.OrgizationId,
                            s.WarehouseId,
                            warehouseName = s.Warehouse?.Name ?? "",
                            s.DevIp,
                            s.DevPort,
                            s.DevState,
                            s.WarehouseSd,
                            s.WarehouseWd
                        });

                        return JsonManager.ReturnSuccessResponse(data);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 获取所有设备信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"",
        ///         "warehouseId":"",
        ///         "devName":"", //设备名称
        ///         "devCode":"" //设备编号
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPageDev")]
        public async Task<HttpResponseMessage> GetPageDev([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string devName = entity.devName ?? "";
                        string devCode = entity.devCode ?? "";
                        string orgid = entity.orgId ?? Guid.Empty.ToString();
                        string warehouseId = entity.warehouseId ?? "";


                        if (size == 0)
                        {
                            size = 10;
                        }

                        var param = new string[] {
                       "Warehouse" ,
                       "Warehouse.Orgization" ,
                    };

                        ListEq = _unitOfWork.OrganizationRepository.GetList(t => t.State == 1, t => t.Code).ToList();
                        var dataList = GetClassID(orgid).Concat(ListEq.Where(c => c.Id.Equals(orgid))).ToList();
                        Expression<Func<BaseJpWarehouseDev, bool>> expression = t => dataList.Select(c => c.Id).Contains(t.Warehouse.OrgizationId);

                        if (!string.IsNullOrEmpty(devName))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.DevName.Contains(devName));
                        }
                        if (!string.IsNullOrEmpty(devCode))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.DevCode.Contains(devCode));
                        }

                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = LambdaExtensions.AndAlso(expression, t => t.WarehouseId.Equals(warehouseId));
                        }

                        var devList = _unitOfWork.WarehouseDevRepository.GetPage(expression, "DevId", page, size, false, param);
                        var data = devList?.content.Select(s => new
                        {
                            s.DevId,
                            s.DevName,
                            s.DevCode,
                            orgName = s.Warehouse?.Orgization?.Name ?? "",
                            orgId = s.Warehouse?.OrgizationId,
                            s.WarehouseId,
                            warehouseName = s.Warehouse?.Name ?? "",
                            s.DevIp,
                            s.DevPort,
                            s.DevState,
                            s.WarehouseSd,
                            s.WarehouseWd
                        });
                        var content = new
                        {
                            totalElements = devList?.totalElements ?? 0,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 修改/新增设备配置
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "devId":"",
        ///      "devName":"",
        ///      "devCode":"",
        ///      "warehouseId":"",
        ///      "devIp":"",
        ///      "devPort":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateDev")]
        public async Task<HttpResponseMessage> AddOrUpdateDev([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string devId = entity?.devId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.devName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"devName is require");
                        }
                        else if (string.IsNullOrEmpty(entity.devCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"devCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.devIp ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"devIp is require");
                        }
                        else if (string.IsNullOrEmpty(entity.devPort ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"devPort is require");
                        }
                        else if (!string.IsNullOrEmpty(devId))
                        {
                            var dev = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevId == devId);
                            if (dev == null)
                            {
                                return JsonManager.SimpleCustResponse($"DevId:{devId}数据不存在");
                            }
                            else
                            {
                                int.TryParse(entity?.devPort ?? "8000", out int devPort);
                                string devCode = entity.devCode;
                                dev.DevName = entity.devName;
                                dev.DevCode = devCode.ToUpper();
                                dev.DevIp = entity.devIp;
                                dev.DevPort = devPort;
                                dev.WarehouseId = entity.warehouseId;

                                bool result = _unitOfWork.WarehouseDevRepository.Update(dev);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }

                            }
                        }
                        else
                        {
                            int.TryParse(entity?.devPort ?? "8000", out int devPort);
                            string devCode = entity.devCode;
                            BaseJpWarehouseDev dev = new BaseJpWarehouseDev()
                            {
                                DevId = Guid.NewGuid().ToString(),
                                WarehouseId = entity.warehouseId,
                                DevState = 0,
                                DevName = entity.devName,
                                DevCode = devCode.ToUpper(),
                                DevIp = entity.devIp,
                                DevPort = devPort,
                                WarehouseSd = 0,
                                WarehouseWd = 0
                            };


                            bool result = _unitOfWork.WarehouseDevRepository.Insert(dev);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 信息上报
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "devCode":"",
        ///      "devIp":"",
        ///      "warehouseSd":"",
        ///      "warehouseWd":"",
        ///      "devState":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpDevDevelop")]
        [ServiceFilter(typeof(ActionLimitAttribute))]
        public async Task<HttpResponseMessage> UpDevDevelop([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string warehouseId = entity?.warehouseId ?? "";
                        string devCode = entity?.devCode ?? "";
                        string devIp = entity?.devIp ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(devCode))
                        {
                            return JsonManager.SimpleCustResponse($"devCode is require");
                        }
                        else if (string.IsNullOrEmpty(devIp))
                        {
                            return JsonManager.SimpleCustResponse($"devIp is require");
                        }
                        else
                        {
                            var dev = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevCode == devCode && t.DevIp == devIp);
                            if (dev == null)
                            {
                                return JsonManager.SimpleCustResponse($"仓库编号:{devCode}数据不存在");
                            }
                            else
                            {
                                float.TryParse(entity?.warehouseSd ?? "0", out float WarehouseSd);
                                float.TryParse(entity?.warehouseWd ?? "0", out float WarehouseWd);
                                int.TryParse(entity?.devState ?? "0", out int DevState);

                                dev.WarehouseSd = WarehouseSd;
                                dev.WarehouseWd = WarehouseWd;
                                dev.DevState = DevState;

                                bool result = _unitOfWork.WarehouseDevRepository.Update(dev);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }

                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 信息上报
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "devId":"",
        ///      "Humid":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpdateHumid")]

        public async Task<HttpResponseMessage> UpdateHumid([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string Humid = entity?.Humid ?? "";
                        string devId = entity?.devId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(Humid))
                        {
                            return JsonManager.SimpleCustResponse($"Humid is require");
                        }
                        else if (string.IsNullOrEmpty(devId))
                        {
                            return JsonManager.SimpleCustResponse($"devId is require");
                        }
                        else
                        {
                            var dev = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevId == devId);
                            if (dev == null)
                            {
                                return JsonManager.SimpleCustResponse($"除湿机数据不存在");
                            }
                            else
                            {
                                dev.SetSd = Humid;

                                bool result = _unitOfWork.WarehouseDevRepository.Update(dev);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }

                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 信息上报
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "devCode":"",
        ///      "devIp":"",
        ///      "warehouseSd":"",
        ///      "warehouseWd":"",
        ///      "devState":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("UpDev")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UpDev([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        string warehouseId = entity?.warehouseId ?? "";
                        string devCode = entity?.devCode ?? "";
                        string devIp = entity?.devIp ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(devCode))
                        {
                            return JsonManager.SimpleCustResponse($"devCode is require");
                        }
                        else if (string.IsNullOrEmpty(devIp))
                        {
                            return JsonManager.SimpleCustResponse($"devIp is require");
                        }
                        else
                        {
                            var dev = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevCode == devCode && t.DevIp == devIp);
                            if (dev == null)
                            {
                                return JsonManager.SimpleCustResponse($"仓库编号:{devCode}数据不存在");
                            }
                            else
                            {
                                float.TryParse(entity?.warehouseSd ?? "0", out float WarehouseSd);
                                float.TryParse(entity?.warehouseWd ?? "0", out float WarehouseWd);
                                int.TryParse(entity?.devState ?? "0", out int DevState);

                                dev.WarehouseSd = WarehouseSd;
                                dev.WarehouseWd = WarehouseWd;
                                dev.DevState = DevState;

                                bool result = _unitOfWork.WarehouseDevRepository.Update(dev);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }

                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除设备配置
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "devId":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteCfg")]
        public async Task<HttpResponseMessage> DeleteCfg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.devId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("devId is require");
                        }
                        string devId = entity.devId ?? "";
                        var order = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevId == devId);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            bool result = _unitOfWork.WarehouseDevRepository.Delete(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 控制设备
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "devId":"bc8fd03d-3532-479d-901f-31a1bd42736c",
        ///         "Humid":"湿度",
        ///         "OpenState":"开:1、关:0"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ControlDev")]
        public async Task<HttpResponseMessage> ControlDev([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.devId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("devId is require");
                        }
                        string devId = entity.devId ?? "";

                        var order = _unitOfWork.DbContext.BaseJpWarehouseDevs.FirstOrDefault(t => t.DevId == devId);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            DevClass dev = new DevClass();
                            dev.DevId = order.DevId;
                            dev.DevCode = order.DevCode;
                            dev.DevIp = order.DevIp;
                            dev.DevPort = order.DevPort;
                            dev.Humid = entity.Humid;
                            dev.OpenState = entity.OpenState;
                            if (ResultCode.devDic.ContainsKey(dev.DevCode))
                            {
                                ResultCode.devDic.Remove(dev.DevCode);
                            }
                            ResultCode.devDic.Add(dev.DevCode, JsonConvert.SerializeObject(dev));
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }



        /// <summary>
        /// 获取设备控制信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "devCode":"00:E2:69:2E:0C:C1"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetDevControlInfo")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> GetDevControlInfo([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.devCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("devCode is require");
                        }
                        string devCode = entity.devCode;

                        try
                        {
                            ResultInfo data = new ResultInfo { Code = "10000", Msg = ResultCode.devDic[devCode] };

                            ResultCode.devDic.Remove(devCode);

                            return JsonManager.SimpleStatusResponse(data);
                        }
                        catch
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }





    }

    public class DevClass
    {
        public string DevId { get; set; }
        public string DevCode { get; set; }
        public string DevIp { get; set; }
        public int? DevPort { get; set; }
        public string Humid { get; set; }
        public string OpenState { get; set; }
    }
}
