﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Nacos;
using Nacos.AspNetCore;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Linq.Expressions;
using System.Net;
using System.Net.Http;
using System.Security.Policy;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Threading.Tasks;
using System.Web.Http;
using MQTTnet;
using MQTTnet.Client.Publishing;
using Newtonsoft.Json.Serialization;

namespace JunmpPoliceStation.Controllers
{
    [ApiController]
    [Route("api/[controller]")]
    public class ChannelCfgController : ControllerBase
    {
        private IWebHostEnvironment _hostingEnvironment;
        private readonly INacosServerManager _serverManager;
        private readonly INacosNamingClient _serverManager2;
        private readonly IHttpClientFactory _clientFactory;
        private ILogger<ChannelCfgController> _logger;
        private UnitOfWork _unitOfWork;
        protected MQTTServer mqttServer;

        public ChannelCfgController(ILogger<ChannelCfgController> logger, INacosNamingClient serverManager2, INacosServerManager serverManager, IHttpClientFactory clientFactory, UnitOfWork unitOfWork, IWebHostEnvironment _hostingEnvironment, MQTTServer mqttServer)
        {
            _clientFactory = clientFactory;
            _serverManager2 = serverManager2;
            _serverManager = serverManager;
            this._logger = logger;
            this._hostingEnvironment = _hostingEnvironment;
            this._unitOfWork = unitOfWork;
            this.mqttServer = mqttServer;

        }
        private List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }

        ///// <summary>
        ///// ceshi
        ///// </summary>
        ///// <remarks>
        ///// ## 例子
        ///// 
        /////     {
        /////         "updateCicle":"删除周期:天为单位",
        /////         "urlText":"照片,单警柜日志文件夹",可为空
        /////         "logUrl":"系统日志文件夹",可为空
        /////     }
        ///// 
        ///// </remarks>
        ///// <param name="jdata"></param>
        ///// <returns></returns>
        //[HttpPost("GetAsync")]
        //[HttpGet]
        //public async Task<string> GetAsync()
        //{
        //    var result = await GetResultAsync();

        //    if (string.IsNullOrWhiteSpace(result))
        //    {
        //        result = "ERROR!!!";
        //    }

        //    return result;
        //}

        //private async Task<string> GetResultAsync()
        //{
        //    var baseUrlRe = await _serverManager2.RegisterInstanceAsync(new RegisterInstanceRequest
        //    {
        //        ServiceName = "police-user",
        //        Ip = "192.168.3.102",
        //        Port = 18761
        //    });
        //    var baseUrl = await _serverManager.GetServerAsync("police-user");


        //    var url = $"{baseUrl}/api/demo/auth/userLogin";

        //    var client = _clientFactory.CreateClient();
        //    var urlInfo = new UrlInfos { username = "admin", password = "junmp123"};


        //    //设置Http的正文
        //    var content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(urlInfo), Encoding.UTF8, "application/json");
        //    var result = await client.PostAsync(url, content);
        //    //var result = await client.GetAsync(url);
        //    return await result.Content.ReadAsStringAsync();
        //}

        //public class UrlInfos
        //{
        //    /// <summary>
        //    /// 菜单Id
        //    /// </summary>
        //    public string username { get; set; }

        //    /// <summary>
        //    /// 菜单地址
        //    /// </summary>
        //    public string password { get; set; }
        //}


        /// <summary>
        /// 设置定期删除信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "updateCicle":"删除周期:天为单位",
        ///         "urlText":"照片,单警柜日志文件夹",可为空
        ///         "logUrl":"系统日志文件夹",可为空
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("SetLogCfg")]
        public async Task<HttpResponseMessage> SetLogCfg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id ?? "";

                        bool bCri = int.TryParse(entity.updateCicle ?? "", out int updateCicle);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.updateCicle ?? "") || !bCri)
                        {
                            return JsonManager.SimpleCustResponse("updateCicle is require");
                        }
                        else if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        else
                        {
                            string urlText = entity.urlText ?? "";
                            string logUrl = entity.logUrl ?? "";

                            var result = _unitOfWork.CommonJpLogCfgRepository.Get(p => p.Id == id);
                            if (result != null)
                            {
                                result.UpdateCicle = updateCicle;
                                result.UrlText = urlText;
                                result.LogUrl = logUrl;

                                var res = _unitOfWork.CommonJpLogCfgRepository.Update(result);
                                if (!res)
                                {
                                    GlobalContext.SendUpdateCfg(JsonConvert.SerializeObject(
                                        new
                                        {
                                            cmdType = 1,
                                            cmdPara = new
                                            {
                                                updateCicle = updateCicle,
                                                urlText = urlText,
                                                logUrl = logUrl
                                            }
                                        }));
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleCustResponse("配置更新失败");
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        #region 旧通道结构

        /// <summary>
        /// 获取所有通道配置
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"",
        ///         "code":"", //通道编号
        ///         "name":"" //通道名称
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllCfg")]
        public async Task<HttpResponseMessage> GetAllCfg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string name = entity.name ?? "";
                        string code = entity.code ?? "";
                        string orgid = entity.orgId ?? "";

                        if (size == 0)
                        {
                            size = 10;
                        }

                        var param = new string[] {
                       "Warehouse" ,
                       "Warehouse.Orgization" ,
                    };

                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        else
                        {
                            //ListEq = _unitOfWork.OrganizationRepository.GetList(t => t.State == 1, t => t.Code).ToList();
                            //var dataList = GetClassID(orgid).Concat(ListEq.Where(c => c.Id.Equals(orgid))).ToList();
                            Expression<Func<CommonJpChannelCfg, bool>> expression = t => t.Warehouse.OrgizationId.Contains(orgid);

                            if (!string.IsNullOrEmpty(name))
                            {
                                expression = LambdaExtensions.AndAlso(expression, t => t.Name.Contains(name));
                            }
                            if (!string.IsNullOrEmpty(code))
                            {
                                expression = LambdaExtensions.AndAlso(expression, t => t.Code.Contains(code));
                            }

                            var cfgList = _unitOfWork.ChannelCfgRepository.GetPage(expression, "CreateTime", page, size, false, param);
                            var data = cfgList?.content.Select(s => new
                            {
                                id = s.Id,
                                location = s.Location,
                                name = s.Name,
                                state = s.CurrentState,
                                orgName = s.Warehouse?.Orgization?.Name ?? "",
                                createTime = s.CreateTime.Value.ToString("yyyy-MM-dd HH:mm"),
                                warehouseId = s.WarehouseId,
                                warehouseName = s.Warehouse?.Name ?? "",
                                updateUser = s.UpdateUser,
                                code = s.Code,
                                orgId = s.Warehouse?.OrgizationId,
                                faceAddress = s.FaceAddress,
                                facePort = s.FacePort,
                                faceUser = s.FaceUser,
                                facePwd = s.FacePwd,
                                readerTime = s.ReaderTime,
                                readerAddress = s.ReaderAddress,
                                faceEnable = s.FaceEnable,
                                filterTime = s.FilterTime,
                                useSnapshot = s.UseSnapshot,
                                camAddress = s.CamAddress,
                                camPort = s.CamPort,
                                camUser = s.CamUser,
                                camPwd = s.CamPwd,
                                camChannel = s.CamChannel,
                                camType = s.CamType,
                                gpioAddr = s.GpioAddr,
                                gpioPort = s.GpioPort,
                                useGpio = s.UseGpio,
                                currentState = s.CurrentState
                            });
                            var content = new
                            {
                                totalElements = cfgList?.totalElements ?? 0,
                                content = data
                            };
                            return JsonManager.ReturnSuccessResponse(content);

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据编号获取通道配置
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "code":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCfgByNum")]
        public async Task<HttpResponseMessage> GetCfgByNum([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string code = entity?.code ?? "";
                        if (string.IsNullOrEmpty(code))
                        {
                            return JsonManager.SimpleCustResponse("code is require");
                        }

                        var cfg = _unitOfWork.DbContext.CommonJpChannelCfgs
                            .Include(t => t.Warehouse)
                            .FirstOrDefault(t => t.Code.Replace(" ", "") == code && t.CurrentState == true);
                        if (cfg == null)
                        {
                            return JsonManager.ReturnSuccessResponse(new { });
                        }
                        else
                        {
                            var data = new
                            {
                                orgId = cfg?.Warehouse?.OrgizationId,
                                warehouseId = cfg?.WarehouseId,
                                faceAddress = cfg.FaceAddress,
                                faceUser = cfg.FaceUser,
                                facePwd = cfg.FacePwd,
                                facePort = cfg.FacePort ?? 8000,
                                faceEnable = cfg.FaceEnable,
                                readerAddress = cfg.ReaderAddress,
                                readerTime = cfg.ReaderTime ?? 3000,
                                filterTime = cfg.FilterTime ?? 3,
                                useSnapshot = cfg.UseSnapshot,
                                camAddress = cfg.CamAddress,
                                camPort = cfg.CamPort,
                                camUser = cfg.CamUser,
                                camPwd = cfg.CamPwd,
                                camChannel = cfg.CamChannel,
                                camType = cfg.CamType,
                                gpioAddr = cfg.GpioAddr,
                                gpioPort = cfg.GpioPort,
                                useGpio = cfg.UseGpio,
                                currentState = cfg.CurrentState,
                                showText = cfg?.Warehouse?.Name ?? "" + cfg.Warehouse?.Orgization?.Name ?? ""
                            };
                            return JsonManager.ReturnSuccessResponse(data);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/修改通道配置
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "id":"", //新增可不填
        ///      "updateUser":"",
        ///      "state":0, //0启用，1禁用
        ///      "name":"",
        ///      "code":"",
        ///      "location":"",
        ///      "warehouseId":"",
        ///      "faceAddress":"",//人脸识别登录地址
        ///      "faceUser":"", //人脸识别登录用户
        ///      "facePort":"", //人脸识别登录端口
        ///      "facePwd":"", //人脸识别登录密码
        ///      "faceEnable":"true", //启用禁用人脸识别
        ///      "readerAddress":"",//读写器连接地址
        ///      "readerTime":3000 //读写器读取时间，毫秒为单位
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateCfg")]
        public async Task<HttpResponseMessage> AddOrUpdateCfg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        bool.TryParse(entity?.state ?? false, out bool state);
                        bool bPort = int.TryParse(entity?.facePort, out int facePort);
                        bool bFliter = int.TryParse(entity?.filterTime, out int filterTime);
                        bool bTime = int.TryParse(entity?.readerTime, out int readerTime);
                        bool.TryParse(entity?.faceEnable ?? "false", out bool faceEnable);
                        bool.TryParse(entity?.useSnapshot ?? "false", out bool useSnapshot);
                        bool bCPort = int.TryParse(entity?.camPort, out int camPort);
                        bool bChannel = int.TryParse(entity?.camChannel, out int camChannel);
                        bool bCamType = int.TryParse(entity?.camType, out int camType);
                        bool bGpioPort = int.TryParse(entity?.gpioPort, out int gpioPort);
                        bool.TryParse(entity?.useGpio ?? false, out bool useGpio);

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (!bFliter || filterTime <= 0)
                        {
                            return JsonManager.SimpleCustResponse($"filterTime is require");
                        }
                        else if (string.IsNullOrEmpty(entity.name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"name is require");
                        }
                        else if (string.IsNullOrEmpty(entity.code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }
                        else if (string.IsNullOrEmpty(entity.location ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"location is require");
                        }
                        else if (string.IsNullOrEmpty(entity.state ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"state is require");
                        }
                        else if (!bTime || readerTime <= 1000)
                        {
                            return JsonManager.SimpleCustResponse($"readerTime is require");
                        }
                        else if (string.IsNullOrEmpty(entity.readerAddress ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"readerAddress is require");
                        }
                        else if (!IPAddress.TryParse(entity.readerAddress ?? "", out IPAddress _readerAddress))
                        {
                            return JsonManager.SimpleCustResponse($"readerAddress invalid");
                        }
                        #region 门禁参数
                        else if (faceEnable && (!bPort || facePort <= 0))
                        {
                            return JsonManager.SimpleCustResponse($"facePort is require");
                        }
                        else if (faceEnable && string.IsNullOrEmpty(entity.faceAddress ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"faceAddress is require");
                        }
                        else if (faceEnable && !IPAddress.TryParse(entity.faceAddress ?? "", out IPAddress _faceAddress))
                        {
                            return JsonManager.SimpleCustResponse($"faceAddress invalid");
                        }
                        else if (faceEnable && string.IsNullOrEmpty(entity.facePwd ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"facePwd is require");
                        }
                        else if (faceEnable && string.IsNullOrEmpty(entity.faceUser ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"faceUser is require");
                        }
                        #endregion

                        #region 抓拍参数

                        else if (useSnapshot && string.IsNullOrEmpty(entity.camAddress ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"camAddress is require");
                        }
                        else if (useSnapshot && !IPAddress.TryParse(entity.camAddress ?? "", out IPAddress _camAddress))
                        {
                            return JsonManager.SimpleCustResponse($"camAddress invalid");
                        }
                        else if (useSnapshot && string.IsNullOrEmpty(entity.camUser ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"camUser invalid");
                        }
                        else if (useSnapshot && string.IsNullOrEmpty(entity.camPwd ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"camPwd invalid");
                        }
                        else if (useSnapshot && (!bCPort || camPort <= 0))
                        {
                            return JsonManager.SimpleCustResponse($"camPort is require");
                        }
                        else if (useSnapshot && (!bChannel || camChannel < 0))
                        {
                            return JsonManager.SimpleCustResponse($"camChannel is require");
                        }
                        else if (useSnapshot && (!bCamType || camType < 0))
                        {
                            return JsonManager.SimpleCustResponse($"camType is require");
                        }

                        #endregion

                        #region GPIO参数

                        else if (useGpio && (string.IsNullOrEmpty(entity.gpioAddr) || !IPAddress.TryParse(entity.gpioAddr ?? "", out IPAddress _gpioAddr)))
                        {
                            return JsonManager.SimpleCustResponse($"gpioAddr is require");
                        }
                        else if (useGpio && (!bGpioPort || gpioPort < 0))
                        {
                            return JsonManager.SimpleCustResponse($"gpioPort is require");
                        }

                        #endregion

                        else if (!string.IsNullOrEmpty(id))
                        {
                            var cfg = _unitOfWork.DbContext.CommonJpChannelCfgs.FirstOrDefault(t => t.Id == id);
                            if (cfg == null)
                            {
                                return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                            }
                            else
                            {
                                cfg.Code = entity.code;
                                cfg.Location = entity.location;
                                cfg.UpdateUser = entity.updateUser;
                                cfg.Name = entity.name;
                                cfg.CurrentState = state;
                                cfg.CreateTime = DateTime.Now;
                                cfg.WarehouseId = entity.warehouseId;
                                cfg.FaceAddress = entity.faceAddress;
                                cfg.FacePort = facePort;
                                cfg.FacePwd = entity.facePwd;
                                cfg.FaceUser = entity.faceUser;
                                cfg.ReaderAddress = entity.readerAddress;
                                cfg.ReaderTime = readerTime;
                                cfg.FaceEnable = faceEnable;
                                cfg.FilterTime = filterTime;

                                cfg.CamAddress = entity.camAddress;
                                cfg.CamChannel = camChannel;
                                cfg.CamPort = camPort;
                                cfg.CamPwd = entity.camPwd;
                                cfg.CamUser = entity.camUser;
                                cfg.CamType = camType;
                                cfg.UseSnapshot = useSnapshot;

                                cfg.GpioAddr = entity.gpioAddr;
                                cfg.GpioPort = gpioPort;
                                cfg.UseGpio = useGpio;

                                //校验通道编号是否存在
                                var exits = _unitOfWork.DbContext.CommonJpChannelCfgs.FirstOrDefault(t => t.Id != cfg.Id && t.Code.Replace(" ", "") == cfg.Code.Replace(" ", ""));
                                if (exits != null)
                                {
                                    return JsonManager.SimpleCustResponse("code already exist", ResultCode.CHANNEL_CODE_EXIST.Code);
                                }
                                else
                                {
                                    bool result = _unitOfWork.ChannelCfgRepository.Update(cfg);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                        }
                        else
                        {
                            CommonJpChannelCfg cfg = new CommonJpChannelCfg()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                WarehouseId = entity.warehouseId,
                                CurrentState = state,
                                Code = entity.code,
                                Location = entity.location,
                                Name = entity.name,
                                UpdateUser = entity.updateUser,
                                FaceAddress = entity.faceAddress,
                                FacePort = facePort,
                                FacePwd = entity.facePwd,
                                FaceUser = entity.faceUser,
                                ReaderAddress = entity.readerAddress,
                                ReaderTime = readerTime,
                                FaceEnable = faceEnable,
                                FilterTime = filterTime,
                                CamAddress = entity.camAddress,
                                CamChannel = camChannel,
                                CamPort = camPort,
                                CamPwd = entity.camPwd,
                                CamUser = entity.camUser,
                                CamType = camType,
                                UseSnapshot = useSnapshot,
                                GpioAddr = entity.gpioAddr,
                                GpioPort = gpioPort,
                                UseGpio = useGpio
                            };

                            //校验通道编号是否存在
                            var exits = _unitOfWork.DbContext.CommonJpChannelCfgs.FirstOrDefault(t => t.Code.Replace(" ", "") == cfg.Code.Replace(" ", ""));
                            if (exits != null)
                            {
                                return JsonManager.SimpleCustResponse("code already exist", ResultCode.CHANNEL_CODE_EXIST.Code);
                            }
                            else
                            {
                                bool result = _unitOfWork.ChannelCfgRepository.Insert(cfg);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除通道配置
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteCfg")]
        public async Task<HttpResponseMessage> DeleteCfg([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpChannelCfgs.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            bool result = _unitOfWork.ChannelCfgRepository.Delete(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        #endregion

        #region 新通道结构
        public class CommonJpChannelCfgV2Model
        {
            public string Id { get; set; }

            /// <summary>
            /// 通道编号
            /// </summary>
            public string Code { get; set; }
            /// <summary>
            /// 仓库id
            /// </summary>
            public string WarehouseId { get; set; }
            /// <summary>
            /// 位置
            /// </summary>
            public string Location { get; set; }
            /// <summary>
            /// 通道状态
            /// </summary>
            public bool State { get; set; }
            /// <summary>
            /// 通道名称
            /// </summary>
            public string Name { get; set; }
            /// <summary>
            /// 更新用户
            /// </summary>
            public string UpdateUser { get; set; }
            /// <summary>
            /// 读写器配置
            /// </summary>
            public List<ReaderConfig> ReaderConfig { get; set; }
            /// <summary>
            /// 过滤时间（单位 秒 所有读写器共用）
            /// </summary>
            public int? FilterTime { get; set; }
            /// <summary>
            /// 门禁机配置json
            /// </summary>
            public List<FaceConfig> FaceConfig { get; set; }
        }
        public class FaceConfig
        {
            /// <summary>
            /// 人脸识别登录地址
            /// </summary>
            public string faceAddress { get; set; }
            /// <summary>
            /// 人脸识别登录端口
            /// </summary>
            public int facePort { get; set; }
            /// <summary>
            /// 人脸识别登录用户
            /// </summary>
            public string faceUser { get; set; }
            /// <summary>
            /// 读写器端口
            /// </summary>
            public string facePwd { get; set; }
            /// <summary>
            /// 启用禁用人脸识别
            /// </summary>
            public bool faceEnable { get; set; }
        }
        public class ReaderConfig
        {
            /// <summary>
            /// 读写器类型
            /// 英频杰：0
            /// 索立得：1
            /// </summary>
            public int type { get; set; }
            /// <summary>
            /// 读写器名（不能重复，涉及到配置文件命名）
            /// </summary>
            public string name { get; set; }
            /// <summary>
            /// 读写器地址
            /// </summary>
            public string address { get; set; }
            /// <summary>
            /// 读写器端口
            /// </summary>
            public int port { get; set; }
            /// <summary>
            /// 读写时间(毫秒)
            /// </summary>
            public int readerTime { get; set; }

            /// <summary>
            /// gpio地址
            /// </summary>
            public string gpioAddr { get; set; }
            /// <summary>
            /// gpio端口
            /// </summary>
            public int gpioPort { get; set; }

            /// <summary>
            /// 是否出入库分离
            /// </summary>
            public bool isCameraSeparate { get; set; }
            /// <summary>
            /// 是否抓拍（出库）
            /// </summary>
            public bool useSnapshot { get; set; }
            /// <summary>
            /// 视频厂商（出库）
            /// 大华：0
            /// 海康：1
            /// </summary>
            public int camType { get; set; }
            /// <summary>
            /// 视频地址（出库）
            /// </summary>
            public string camAddress { get; set; }
            /// <summary>
            /// 视频端口（出库）
            /// </summary>
            public int camPort { get; set; }
            /// <summary>
            /// 视频用户（出库）
            /// </summary>
            public string camUser { get; set; }
            /// <summary>
            /// 视频密码（出库）
            /// </summary>
            public string camPwd { get; set; }
            /// <summary>
            /// 视频通道（出库）
            /// </summary>
            public int camChannel { get; set; }

            /// <summary>
            /// 是否抓拍（入库）
            /// </summary>
            public bool useSnapshot2 { get; set; }
            /// <summary>
            /// 视频厂商（入库）
            /// 大华：0
            /// 海康：1
            /// </summary>
            public int camType2 { get; set; }
            /// <summary>
            /// 视频地址（入库）
            /// </summary>
            public string camAddress2 { get; set; }
            /// <summary>
            /// 视频端口（入库）
            /// </summary>
            public int camPort2 { get; set; }
            /// <summary>
            /// 视频用户（入库）
            /// </summary>
            public string camUser2 { get; set; }
            /// <summary>
            /// 视频密码（入库）
            /// </summary>
            public string camPwd2 { get; set; }
            /// <summary>
            /// 视频通道（入库）
            /// </summary>
            public int camChannel2 { get; set; }
        }

        /// <summary>
        /// 获取所有通道配置
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orgId":"",
        ///         "code":"", //通道编号
        ///         "name":"" //通道名称
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllCfgV2")]
        [NoSign]
        public async Task<HttpResponseMessage> GetAllCfgV2([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string name = entity.name ?? "";
                        string code = entity.code ?? "";
                        string orgid = entity.orgId ?? "";
                        string warehouseId = entity.warehouseId ?? "";
                        string level = entity?.level ?? "";
                        if (size == 0)
                        {
                            size = 10;
                        }

                        var param = new string[] {
                            "Warehouse" ,
                            "Warehouse.Orgization" ,
                        };

                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        else
                        {
                            Expression<Func<CommonJpChannelCfgV2, bool>> expression = t => true;

                            if (level == "本级及下级")//本级及下级
                            {
                                ListEq = _unitOfWork.OrganizationRepository.GetList(t => t.State == 1, t => t.Code).ToList();
                                var dataList = GetClassID(orgid).Concat(ListEq.Where(c => c.Id.Equals(orgid))).ToList();
                                expression = expression.AndAlso(t => dataList.Select(c => c.Id).Contains(t.Warehouse.OrgizationId));
                            }
                            else //本级
                            {
                                expression = expression.AndAlso(t => t.Warehouse.OrgizationId.Contains(orgid));
                            }

                            if (!string.IsNullOrEmpty(name))
                            {
                                expression = expression.AndAlso(t => t.Name.Contains(name));
                            }
                            if (!string.IsNullOrEmpty(code))
                            {
                                expression = expression.AndAlso(t => t.Code.Contains(code));
                            }
                            if (!string.IsNullOrEmpty(warehouseId))
                            {
                                expression = expression.AndAlso(t => t.WarehouseId == warehouseId);
                            }
                            var cfgList = _unitOfWork.ChannelCfgV2Repository.GetPage(expression, "CreateTime", page, size, false, param);
                            var data = cfgList?.content.Select(s => new
                            {
                                id = s.Id,
                                location = s.Location,
                                name = s.Name,
                                state = s.CurrentState,
                                orgName = s.Warehouse?.Orgization?.Name ?? "",
                                createTime = s.CreateTime.Value.ToString("yyyy-MM-dd HH:mm"),
                                warehouseId = s.WarehouseId,
                                warehouseName = s.Warehouse?.Name ?? "",
                                updateUser = s.UpdateUser,
                                code = s.Code,
                                orgId = s.Warehouse?.OrgizationId,

                                currentState = s.CurrentState,
                                filterTime = s.FilterTime,
                                faceConfig = string.IsNullOrEmpty(s.FaceConfigJson)
                                    ? new List<FaceConfig>()
                                    : JsonConvert.DeserializeObject<List<FaceConfig>>(s.FaceConfigJson),

                                readerConfig = string.IsNullOrEmpty(s.ReaderConfigJson)
                                    ? new List<ReaderConfig>()
                                    : JsonConvert.DeserializeObject<List<ReaderConfig>>(s.ReaderConfigJson)
                            });
                            var content = new
                            {
                                totalElements = cfgList?.totalElements ?? 0,
                                content = data
                            };
                            return JsonManager.ReturnSuccessResponse(content);

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据编号获取通道配置
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "code":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetCfgByNumV2")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetCfgByNumV2([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string code = entity?.code ?? "";
                        if (string.IsNullOrEmpty(code))
                        {
                            return JsonManager.SimpleCustResponse("code is require");
                        }

                        var cfg = _unitOfWork.DbContext.CommonJpChannelCfgV2s
                            .Include(t => t.Warehouse)
                            .FirstOrDefault(t => t.Code.Replace(" ", "") == code && t.CurrentState == true);
                        if (cfg == null)
                        {
                            return JsonManager.ReturnSuccessResponse(new { });
                        }
                        else
                        {
                            var data = new
                            {
                                orgId = cfg?.Warehouse?.OrgizationId,
                                warehouseId = cfg?.WarehouseId,

                                currentState = cfg.CurrentState,
                                filterTime = cfg.FilterTime,
                                showText = cfg?.Warehouse?.Name ?? "" + cfg.Warehouse?.Orgization?.Name ?? "",
                                channelReadEquTypeJson = cfg.Warehouse?.IsEnableChannelReadEqu == true ? cfg.Warehouse?.ChannelReadEquTypeJson : "",
                                faceConfig = string.IsNullOrEmpty(cfg.FaceConfigJson)
                                    ? new List<FaceConfig>()
                                    : JsonConvert.DeserializeObject<List<FaceConfig>>(cfg.FaceConfigJson),

                                readerConfig = string.IsNullOrEmpty(cfg.ReaderConfigJson)
                                    ? new List<ReaderConfig>()
                                    : JsonConvert.DeserializeObject<List<ReaderConfig>>(cfg.ReaderConfigJson)
                            };
                            return JsonManager.ReturnSuccessResponse(data);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/修改通道配置
        /// </summary>
        /// <remarks>
        ///## 例子
        ///
        ///    {
        ///      "id":"", //新增可不填
        ///      "updateUser":"",
        ///      "state":0, //0启用，1禁用
        ///      "name":"",
        ///      "code":"",
        ///      "location":"",
        ///      "warehouseId":"",
        ///      "filterTime":"过滤时间(秒)",
        ///      "faceConfig":
        ///      [
        ///         {
        ///             "faceAddress":"",//人脸识别登录地址
        ///             "faceUser":"", //人脸识别登录用户
        ///             "facePort":"", //人脸识别登录端口
        ///             "facePwd":"", //人脸识别登录密码
        ///             "faceEnable":true, //启用禁用人脸识别
        ///         }
        ///      ]
        ///      "readerConfig":
        ///         [
        ///             {
        ///                 "type":"读写器类型 英频杰：0 索立得：1",
        ///                 "name":"读写器名（不能重复，涉及到配置文件命名）",
        ///                 "address":"读写器地址",
        ///                 "port":"读写器端口",
        ///                 "readerTime":"读写时间(毫秒)",
        ///                 "gpioAddr":"gpio地址",
        ///                 "gpioPort":"gpio端口",
        /// 
        ///                 "useSnapshot":"是否抓拍",
        ///                 "camType":"视频厂商",
        ///                 "camAddress":"视频地址",
        ///                 "camPort":"视频端口",
        ///                 "camUser":"视频用户",
        ///                 "camPwd":"视频密码",
        ///                 "camChannel":"视频通道"
        ///                 
        ///             }
        ///         ]
        ///     }
        /// 
        /// </remarks>
        /// <param name="model"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateCfgV2")]
        [NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateCfgV2([FromBody] CommonJpChannelCfgV2Model model)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (model != null)
                    {
                        if (string.IsNullOrEmpty(model.WarehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (string.IsNullOrEmpty(model.Name ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"name is require");
                        }
                        else if (string.IsNullOrEmpty(model.Code ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"code is require");
                        }
                        else if (string.IsNullOrEmpty(model.Location ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"location is require");
                        }
                        else if (model.FilterTime <= 0)
                        {
                            return JsonManager.SimpleCustResponse($"filterTime is require");
                        }

                        else if (model.FaceConfig == null)
                        {
                            return JsonManager.SimpleCustResponse($"faceConfig is require");
                        }
                        else if (model.ReaderConfig == null)
                        {
                            return JsonManager.SimpleCustResponse($"readerConfig is require");
                        }

                        var readerNameCheckList = model.ReaderConfig
                            .GroupBy(x => x.name)
                            .Where(x => x.Count() > 1)
                            .ToList();
                        if (readerNameCheckList.Count > 0)
                        {
                            return JsonManager.SimpleCustResponse($"readerName is repeat");
                        }
                        if (!string.IsNullOrEmpty(model.Id))
                        {
                            var cfg = _unitOfWork.DbContext.CommonJpChannelCfgV2s.FirstOrDefault(t => t.Id == model.Id);
                            if (cfg == null)
                            {
                                return JsonManager.SimpleCustResponse($"id:{model.Id}数据不存在");
                            }
                            else
                            {
                                cfg.Code = model.Code;
                                cfg.Location = model.Location;
                                cfg.UpdateUser = model.UpdateUser;
                                cfg.Name = model.Name;
                                cfg.CurrentState = model.State;
                                cfg.CreateTime = DateTime.Now;
                                cfg.WarehouseId = model.WarehouseId;


                                cfg.FilterTime = model.FilterTime;

                                cfg.FaceConfigJson = model.FaceConfig == null
                                    ? "[]"
                                    : JsonConvert.SerializeObject(model.FaceConfig);

                                cfg.ReaderConfigJson = model.ReaderConfig == null
                                    ? "[]"
                                    : JsonConvert.SerializeObject(model.ReaderConfig);


                                //校验通道编号是否存在
                                var exits = _unitOfWork.DbContext.CommonJpChannelCfgV2s.FirstOrDefault(t => t.Id != cfg.Id && t.Code.Replace(" ", "") == cfg.Code.Replace(" ", ""));
                                if (exits != null)
                                {
                                    return JsonManager.SimpleCustResponse("code already exist", ResultCode.CHANNEL_CODE_EXIST.Code);
                                }
                                else
                                {
                                    bool result = _unitOfWork.ChannelCfgV2Repository.Update(cfg);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                        }
                        else
                        {
                            var cfg = new CommonJpChannelCfgV2()
                            {
                                Id = Guid.NewGuid().ToString(),
                                CreateTime = DateTime.Now,
                                WarehouseId = model.WarehouseId,
                                CurrentState = model.State,
                                Code = model.Code,
                                Location = model.Location,
                                Name = model.Name,
                                UpdateUser = model.UpdateUser,

                                FilterTime = model.FilterTime,

                                FaceConfigJson = model.FaceConfig == null
                                    ? "[]"
                                    : JsonConvert.SerializeObject(model.FaceConfig),

                                ReaderConfigJson = model.ReaderConfig == null
                                    ? "[]"
                                    : JsonConvert.SerializeObject(model.ReaderConfig)
                            };

                            //校验通道编号是否存在
                            var exits = _unitOfWork.DbContext.CommonJpChannelCfgV2s.FirstOrDefault(t => t.Code.Replace(" ", "") == cfg.Code.Replace(" ", ""));
                            if (exits != null)
                            {
                                return JsonManager.SimpleCustResponse("code already exist", ResultCode.CHANNEL_CODE_EXIST.Code);
                            }
                            else
                            {
                                bool result = _unitOfWork.ChannelCfgV2Repository.Insert(cfg);
                                if (result)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除通道配置
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteCfgV2")]
        [NoSign]
        public async Task<HttpResponseMessage> DeleteCfgV2([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpChannelCfgV2s.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            bool result = _unitOfWork.ChannelCfgV2Repository.Delete(order);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        #endregion

        /// <summary>
        /// 上报通道监控epc（本次出入库读取到的所有epc）
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///            "orgId": "0320200512000808",
        ///            "warehouseId": "",
        ///            "policeId": "1",
        ///            "currentState": "当前出入库状态",//0出库,1入库
        ///            "picUrl": "出入库图片路径",
        ///            "RFIDList": [{
        ///            "RFID": "A12C621596CDF8A02B18538A"
        ///             },{
        ///             "RFID": "A12C6215BCE9F863C2896E0A"
        ///            },{
        ///           "RFID": "A12C6215BCE9F863C284DF0A"
        ///            }] 
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApplyMonitorEpcList")]
        public async Task<HttpResponseMessage> ApplyMonitorEpcList([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                    //暂时不清楚功能，停止使用
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }

                        string orgId = entity.orgId ?? "";
                        string warehouseId = entity.warehouseId ?? "";
                        string policeId = entity.policeId ?? "";
                        string currentState = entity.currentState ?? "";
                        string picUrl = entity.picUrl ?? "";

                        if (string.IsNullOrEmpty(orgId))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        if (string.IsNullOrEmpty(warehouseId))
                        {
                            return JsonManager.SimpleCustResponse("warehouseId is require");
                        }
                        if (string.IsNullOrEmpty(currentState))
                        {
                            return JsonManager.SimpleCustResponse("currentState is require");
                        }

                        if (entity.RFIDList == null)
                        {
                            return JsonManager.SimpleCustResponse("RFIDList is require");
                        }

                        var record = new CommonJpChannelMonitorRecord()
                        {
                            Id = Guid.NewGuid().ToString(),
                            CreateTime = DateTime.Now,
                            OutInState = Convert.ToInt32(currentState),
                            WarehouseId = warehouseId,
                            OrgId = orgId,
                            PoliceId = string.IsNullOrEmpty(policeId) ? null : policeId,
                            PicUrl = picUrl
                        };
                        foreach (var item in entity.RFIDList)
                        {
                            string rfidItem = item.RFID;

                            if (!string.IsNullOrEmpty(rfidItem) && rfidItem.Length == 64)
                            {
                                var inv = _unitOfWork.EquipmentInventoryRepository.Get(x => x.Epc == rfidItem);

                                var epc_info = EpcConvert.EpcAnlysing(EpcConvert.ToHexByte(rfidItem));
                                var recordInv = new CommonJpChannelMonitorRecordInventory
                                {
                                    Id = Guid.NewGuid().ToString(),
                                    CreateTime = DateTime.Now,
                                    RecordId = record.Id,
                                    Epc = rfidItem,
                                    EpcType = Convert.ToInt32(epc_info.TagType),
                                    SupplierId = inv?.SupplierCode,
                                    EquipmentId = inv?.EquipmentCode,
                                    SizeId = inv?.EquipmentSizecode,
                                    InventoryId = inv?.Id,
                                };
                                record.CommonJpChannelMonitorRecordInventories.Add(recordInv);
                            }
                        }
                        _unitOfWork.DbContext.CommonJpChannelMonitorRecords.Add(record);

                        if (_unitOfWork.SaveChanges() > 0)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 上传抓拍文件
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "warehouseId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "picture":"",//图片二进制
        ///         "directoy":"日期文件夹（例：20200813）"
        ///     }
        /// 
        /// </remarks>
        /// <param name="snapshot"></param>
        /// <returns></returns>
        [HttpPost("UploadPic")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadPic([FromForm] Snapshot snapshot)
        {
            return await Task.Run(() =>
             {
                 try
                 {
                     if (snapshot == null)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter");
                     }
                     else if (string.IsNullOrEmpty(snapshot.id))
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter warehouseId");
                     }
                     else if (snapshot.type != 0 && snapshot.type != 1)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter type");
                     }
                     else if (string.IsNullOrEmpty(snapshot.directoy) || !DateTime.TryParseExact(snapshot.directoy, "yyyyMMdd", CultureInfo.InvariantCulture, DateTimeStyles.None, out DateTime _dir))
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter directoy");
                     }
                     else if (snapshot.picture == null)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter picture");
                     }
                     else if (snapshot.picture.Length > 1024 * 1024 * 3)//3M
                     {
                         return JsonManager.SimpleCustResponse("file size too big");
                     }
                     else
                     {
                         if (snapshot.type == 0 && _unitOfWork
                             .DbContext
                             .BaseJpWarehouses
                             .FirstOrDefault(t => t.Id == snapshot.id) == null)
                         {

                             return JsonManager.SimpleCustResponse("Invalid parameter id");

                         }
                         else if (snapshot.type == 1 && _unitOfWork
                             .DbContext
                             .BaseJpCabinets
                             .FirstOrDefault(t => t.CabinetRealNum == snapshot.id) == null)
                         {
                             return JsonManager.SimpleCustResponse("Invalid parameter id");
                         }
                         else
                         {
                             List<string> extList = new List<string>()
                     {
                        ".png",
                        ".jpg"
                     };
                             var ext = Path.GetExtension(snapshot.picture.FileName).ToLower();
                             if (!extList.Contains(ext))
                             {
                                 return JsonManager.SimpleCustResponse("unsupport media type");
                             }
                             else
                             {
                                 var saveType = snapshot.type == 0 ? "Channel" : "Cabinet";
                                 var mainDir = $"{_hostingEnvironment.WebRootPath}\\SnapPic";
                                 if (!Directory.Exists(mainDir))
                                 {
                                     Directory.CreateDirectory(mainDir);
                                 }
                                 using (MemoryStream ms = new MemoryStream())
                                 {
                                     //拷贝文件到内存流
                                     snapshot.picture.CopyTo(ms);
                                     var tmp = ms.GetBuffer();
                                     var fileType = tmp[0].ToString() + tmp[1].ToString();
                                     if (fileType == "13780" || fileType == "255216")
                                     {
                                         var _path = $"{_hostingEnvironment.WebRootPath}\\SnapPic\\{saveType}\\{snapshot.id.Replace("-", "")}\\{snapshot.directoy}";
                                         if (!Directory.Exists(_path))
                                         {
                                             Directory.CreateDirectory(_path);
                                         }
                                         Bitmap.FromStream(ms).Save($"{_path}\\{snapshot.picture.FileName}");
                                         return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                     }
                                     else
                                     {
                                         return JsonManager.SimpleCustResponse("unsupport media type");
                                     }
                                 }
                             }

                         }
                     }
                 }
                 catch (Exception ex)
                 {
                     _logger.LogError(ex.ToString());
                     return JsonManager.SimpleCustResponse("unsupport media type");
                 }
             });
        }

        /// <summary>
        /// 警员图片上传
        /// </summary>
        /// <remarks>
        /// 
        /// ## from 类型为enctype="multipart/form-data"   
        /// 
        /// </remarks>
        /// <returns></returns>
        [HttpPost("UploadFace")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadFace([FromForm] FacePic facePic)
        {
            try
            {
                return await Task.Run(() =>
                {
                    try
                    {
                        if (facePic == null)
                        {
                            return JsonManager.SimpleCustResponse("Invalid parameter");
                        }
                        else if (string.IsNullOrEmpty(facePic.id))
                        {
                            return JsonManager.SimpleCustResponse("Invalid parameter warehouseId");
                        }

                        else if (facePic.picture == null)
                        {
                            return JsonManager.SimpleCustResponse("Invalid parameter picture");
                        }
                        else if (facePic.picture.Length > 204800)//200k
                        {
                            return JsonManager.SimpleCustResponse("file size too big(limit 200kb)");
                        }
                        else
                        {
                            var policeInfo = _unitOfWork
                                .DbContext
                                .BaseJpPolicemen
                                .FirstOrDefault(t => t.Id == facePic.id);
                            if (policeInfo == null)
                            {
                                return JsonManager.SimpleCustResponse("Invalid parameter id");
                            }
                            else
                            {
                                List<string> extList = new List<string>()
                     {
                        ".png",
                        ".jpg"
                     };
                                var ext = Path.GetExtension(facePic.picture.FileName).ToLower();
                                if (!extList.Contains(ext))
                                {
                                    return JsonManager.SimpleCustResponse("unsupport media type");
                                }
                                else
                                {
                                    using (MemoryStream ms = new MemoryStream())
                                    {
                                        //拷贝文件到内存流
                                        facePic.picture.CopyTo(ms);
                                        var tmp = ms.GetBuffer();
                                        var fileType = tmp[0].ToString() + tmp[1].ToString();
                                        if (fileType == "13780" || fileType == "255216")
                                        {
                                            var _path = $"{_hostingEnvironment.WebRootPath}\\personImg\\";
                                            var _fileName = $"{Guid.NewGuid().ToString().Replace("-", "")}{Path.GetExtension(facePic.picture.FileName)}";
                                            if (!Directory.Exists(_path))
                                            {
                                                Directory.CreateDirectory(_path);
                                            }

                                            Image.FromStream(ms).Save(Path.Combine(_path, _fileName));
                                            //更新人脸地址
                                            policeInfo.Photo = Path.Combine("/personImg", _fileName).Replace("\\", "/");
                                            if (_unitOfWork.PolicemanRepository.Update(policeInfo))
                                            {
                                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                            }
                                            else
                                            {
                                                return JsonManager.SimpleCustResponse("update photo filed failed");
                                            }
                                        }
                                        else
                                        {
                                            return JsonManager.SimpleCustResponse("unsupport media type");
                                        }
                                    }
                                }

                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        _logger.LogError(ex.ToString());
                        return JsonManager.SimpleCustResponse("unsupport media type");
                    }
                });
            }
            catch (Exception ex)
            {

                _logger.LogError(ex.ToString());
                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
            }

        }

        /// <summary>
        /// 上传日志文件
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///         "logFile":"",//日志文件
        ///         "directoy":"日期文件夹（例：20200813）"
        ///     }
        /// 
        /// </remarks>
        /// <param name="logUpload"></param>
        /// <returns></returns>
        [HttpPost("UploadLog")]
        [NoSignAttribute]
        public async Task<HttpResponseMessage> UploadLog([FromForm] LogUpload logUpload)
        {
            return await Task.Run(() =>
             {
                 try
                 {
                     if (logUpload == null)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter");
                     }
                     else if (string.IsNullOrEmpty(logUpload.id))
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter id");
                     }
                     else if (string.IsNullOrEmpty(logUpload.directoy) || !DateTime.TryParseExact(logUpload.directoy, "yyyyMMdd", CultureInfo.InvariantCulture, DateTimeStyles.None, out DateTime _dir))
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter directoy");
                     }
                     else if (logUpload.type != 0 && logUpload.type != 1)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter type");
                     }
                     else if (logUpload.logFile == null)
                     {
                         return JsonManager.SimpleCustResponse("Invalid parameter logFile");
                     }
                     else if (logUpload.logFile.Length > 1024 * 1024 * 3)//3M
                     {
                         return JsonManager.SimpleCustResponse("file size too big");
                     }
                     else
                     {
                         if (logUpload.type == 0 && _unitOfWork
                             .DbContext
                             .BaseJpWarehouses
                             .FirstOrDefault(t => t.Id == logUpload.id) == null)
                         {

                             return JsonManager.SimpleCustResponse("Invalid parameter id");

                         }
                         else if (logUpload.type == 1 && _unitOfWork
                             .DbContext
                             .BaseJpCabinets
                             .FirstOrDefault(t => t.CabinetRealNum == logUpload.id) == null)
                         {
                             return JsonManager.SimpleCustResponse("Invalid parameter id");
                         }
                         else
                         {
                             List<string> extList = new List<string>()
                     {
                        ".txt",
                        ".log"
                     };
                             var ext = Path.GetExtension(logUpload.logFile.FileName).ToLower();
                             if (!extList.Contains(ext))
                             {
                                 return JsonManager.SimpleCustResponse("unsupport media type");
                             }
                             else
                             {
                                 var saveType = logUpload.type == 0 ? "Channel" : "Cabinet";
                                 var _path = $"{_hostingEnvironment.WebRootPath}\\LogFile\\{saveType}\\{logUpload.id.Replace("-", "")}\\{logUpload.directoy}";
                                 if (!Directory.Exists(_path))
                                 {
                                     Directory.CreateDirectory(_path);
                                 }
                                 using (FileStream ms = new FileStream($"{_path}\\{logUpload.logFile.FileName}", FileMode.Create, FileAccess.Write))
                                 {
                                     //拷贝文件到内存流
                                     logUpload.logFile.CopyTo(ms);
                                     ms.Flush();
                                     ms.Close();
                                     return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                 }
                             }

                         }
                     }
                 }
                 catch (Exception ex)
                 {
                     _logger.LogError(ex.ToString());
                     return JsonManager.SimpleCustResponse("unsupport media type");
                 }
             });
        }

        /// <summary>
        /// 获取服务器时间
        /// </summary>
        /// <returns></returns>
        [HttpGet("GetServerTime")]
        public async Task<HttpResponseMessage> GetServerTime()
        {

            //NacosDiscoveryDelegatingHandler nacos = new NacosDiscoveryDelegatingHandler(_serverManager, _clientFactory);
            //var nacosGet= nacos.GetAsync();
            //_logger.LogDebug("LogDebug");
            //_logger.LogError("LogError");
            //_logger.LogDebug("LogDebug");
            return await Task.Run(() =>
            {
                return JsonManager.ReturnSuccessResponse(DateTime.Now);
            });
        }

        /// <summary>
        /// 同步用户账号
        /// </summary>
        /// <returns></returns>
        [HttpGet("SyncUser")]
        public async Task<HttpResponseMessage> SyncUser()
        {

            return await Task.Run(() =>
            {
                try
                {
                    //查询没有账号的组织机构
                    var orgList = _unitOfWork.DbContext.BaseJpOrganizations
                        .Include(x => x.CommonJpUsers)
                        .Where(x => x.CommonJpUsers.Count == 0)
                        .ToList();
                    if (orgList.Count == 0)
                    {
                        return JsonManager.ReturnSuccessResponse($"没有要操作的组织机构");
                    }
                    var userList = new List<CommonJpUser>();
                    foreach (var organization in orgList)
                    {
                        var glUserId = Guid.NewGuid().ToString();
                        var glUser = new CommonJpUser
                        {
                            Id = glUserId,
                            Email = "",
                            Enabled = 1,
                            Password = "e10adc3949ba59abbe56e057f20f883e",
                            Username = "gl" + organization.Code,
                            Phone = "",
                            CreateTime = DateTime.Now,
                            NickName = organization.Name + "仓管员",
                            OrganizationId = organization.Id,
                            UsersRoles = new List<UsersRole>()
                            {
                                new UsersRole
                                {
                                    RoleId=2,
                                    UserId = glUserId
                                }
                            }
                        };
                        Thread.Sleep(1);
                        var shUserId = Guid.NewGuid().ToString();
                        var shUser = new CommonJpUser
                        {
                            Id = shUserId,
                            Email = "",
                            Enabled = 1,
                            Password = "e10adc3949ba59abbe56e057f20f883e",
                            Username = "sh" + organization.Code,
                            Phone = "",
                            CreateTime = DateTime.Now,
                            NickName = organization.Name + "审核员",
                            OrganizationId = organization.Id,
                            UsersRoles = new List<UsersRole>()
                            {
                                new UsersRole
                                {
                                    RoleId=3,
                                    UserId = shUserId
                                }
                            }
                        };
                        Thread.Sleep(1);
                        var ywUserId = Guid.NewGuid().ToString();
                        var ywUser = new CommonJpUser
                        {
                            Id = ywUserId,
                            Email = "",
                            Enabled = 1,
                            Password = "e10adc3949ba59abbe56e057f20f883e",
                            Username = "yw" + organization.Code,
                            Phone = "",
                            CreateTime = DateTime.Now,
                            NickName = organization.Name + "运维",
                            OrganizationId = organization.Id,
                            UsersRoles = new List<UsersRole>()
                            {
                                new UsersRole
                                {
                                    RoleId=4,
                                    UserId = ywUserId
                                }
                            }
                        };
                        Thread.Sleep(1);
                        userList.Add(glUser);
                        userList.Add(shUser);
                        userList.Add(ywUser);
                    }


                    var res = _unitOfWork.CommonJpUserRepository.Insert(userList);
                    if (res)
                    {
                        return JsonManager.ReturnSuccessResponse($"本次共添加{orgList.Count}组组织机构的账号信息");
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse("更新数据库失败");
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 获取对应组织机构人员
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        [HttpPost("GetOrgStaff")]
        public async Task<HttpResponseMessage> GetOrgStaff([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string orgid = entity.orgId ?? "";



                        if (string.IsNullOrEmpty(orgid))
                        {
                            return JsonManager.SimpleCustResponse("orgId is require");
                        }
                        else
                        {
                            Expression<Func<BaseJpPoliceman, bool>> expression = t => t.OrgizationCode == orgid;

                            var cfgList = _unitOfWork.DbContext.BaseJpPolicemen.Where(expression);
                            var data = cfgList?.Select(s => new
                            {
                                id = s.Id,
                                name = s.Name,
                                policeCode = s.PoliceCode,
                                photo = s.Photo,
                                udateTime = s.UpdateTime,
                                createTime = s.CreateTime,
                                fingerList = s.BaseJpPolicefingers.Where(t => t.Type == "海康").Select(s => new
                                {
                                    fingerInfo = s.FingerInfo,
                                    fingerNum = s.FingerNum
                                })
                            });
                            return JsonManager.ReturnSuccessResponse(data);

                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取对应组织机构人员
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        [HttpPost("UpdateFinger")]
        public async Task<HttpResponseMessage> UpdateFinger([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
             {
                 try
                 {
                     if (jdata != null)
                     {
                         var entity = JsonManager.GetJsonEntity(jdata);
                         string policeId = entity.policeId ?? "";


                         if (string.IsNullOrEmpty(policeId))
                         {
                             return JsonManager.SimpleCustResponse("policeId is require");
                         }
                         else if (entity.fingerList == null || entity.fingerList.Count == 0)
                         {
                             return JsonManager.SimpleCustResponse("fingerList is require");
                         }
                         else
                         {
                             Expression<Func<BaseJpPoliceman, bool>> expression = t => t.Id == policeId;
                             var policeInfo = _unitOfWork.DbContext.BaseJpPolicemen
                                 .Include(x => x.BaseJpPolicefingers)
                                 .FirstOrDefault(expression);
                             if (policeInfo == null)
                             {
                                 return JsonManager.SimpleCustResponse("invalid policeId");
                             }
                             else
                             {
                                 foreach (var item in entity.fingerList)
                                 {
                                     int.TryParse(item.fingerNum ?? "0", out int num);
                                     if (num <= 0 || string.IsNullOrEmpty(item.fingerInfo ?? ""))
                                     {
                                         return JsonManager.SimpleCustResponse("invalid finger info");
                                     }
                                 }

                                 foreach (var item in entity.fingerList)
                                 {
                                     int.TryParse(item.fingerNum ?? "0", out int num);
                                     string info = item.fingerInfo;
                                     var tmp = policeInfo.BaseJpPolicefingers.FirstOrDefault(t => t.FingerNum == num && t.Type == "海康");
                                     if (tmp == null)
                                     {
                                         policeInfo.BaseJpPolicefingers.Add(new BaseJpPolicefinger()
                                         {
                                             Id = Guid.NewGuid().ToString(),
                                             FingerInfo = info,
                                             FingerNum = num,
                                             PoliceId = policeId,
                                             Type = "海康"
                                         });
                                     }
                                     else
                                     {
                                         tmp.FingerInfo = info;
                                     }
                                 }

                                 var res = _unitOfWork.PolicemanRepository.Update(policeInfo);
                                 if (res)
                                 {
                                     return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                 }
                                 else
                                 {
                                     return JsonManager.SimpleCustResponse("save failed");
                                 }
                             }

                         }
                     }
                     else
                     {
                         return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                     }

                 }
                 catch (Exception ex)
                 {

                     _logger.LogError(ex.ToString());
                     return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                 }
             });
        }


        /// <summary>
        /// 获取mqtt信息
        /// </summary>
        [HttpGet("GetMQTTLogList")]
        [NoSign]
        public async Task<HttpResponseMessage> GetMQTTLogList([FromUri] MQTTLogSearchModel model)
        {
            return await Task.Run(() =>
            {
                try
                {
                    var clientStatusList = this.mqttServer.mqttServer.GetClientStatusAsync().Result;
                    var orgId = "A35F3DB1-80A1-45ED-A458-B7DEA193682G"; //浙江省公安厅
                    if (!string.IsNullOrEmpty(model.OrganizationId))
                    {
                        orgId = model.OrganizationId;
                    }

                    var dataList = _unitOfWork.OrganizationRepository.GetAllChildListByOrgId(orgId).Select(x => x.Id);

                    switch (model.Type)
                    {
                        case "单警柜":
                            {
                                var cabinetList = _unitOfWork.DbContext.BaseJpCabinets
                                    .Include(x => x.Organization)
                                    .Where(x => x.State == 1 && dataList.Contains(x.OrganizationId))
                                    .ToList();

                                var resData = cabinetList
                                    .GroupBy(x => x.CabinetRealNum)
                                    .Select(x => new
                                    {
                                        Id = x.FirstOrDefault()?.CabinetRealNum,
                                        DeviceName = x.FirstOrDefault()?.CabinetNum,
                                        OrganizationId = x.FirstOrDefault()?.OrganizationId,
                                        OrganizationName = x.FirstOrDefault()?.Organization?.Name,
                                        Status = clientStatusList.Any(y => y.ClientId == x.FirstOrDefault()?.CabinetRealNum) ? 1 : 0
                                    })
                                    .ToList();

                                if (model.Status == "在线")
                                {
                                    resData = resData.Where(x => x.Status == 1).ToList();
                                }
                                else if (model.Status == "离线")
                                {
                                    resData = resData.Where(x => x.Status == 0).ToList();
                                }

                                return new HttpResponseMessage
                                {
                                    Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                                    {
                                        code = 0,
                                        count = resData.Count,
                                        data = resData.ToList()
                                    }), Encoding.GetEncoding("UTF-8"), "application/json")
                                };
                            }
                        case "通道":
                            {
                                var channelList = _unitOfWork.DbContext.CommonJpChannelCfgV2s
                                    .Include(x => x.Warehouse)
                                    .Include(x => x.Warehouse.Orgization)
                                    .Where(x => x.CurrentState == true && dataList.Contains(x.Warehouse.OrgizationId))
                                    .ToList();

                                var resData = channelList
                                    .Select(x => new
                                    {
                                        Id = x.Code,
                                        DeviceName = x.Name,
                                        OrganizationId = x.Warehouse.OrgizationId,
                                        OrganizationName = x.Warehouse.Orgization.Name,
                                        WarehouseName = x.Warehouse.Name,
                                        Status = clientStatusList.Any(y => y.ClientId == x.Code) ? 1 : 0
                                    })
                                    .ToList();

                                if (model.Status == "在线")
                                {
                                    resData = resData.Where(x => x.Status == 1).ToList();
                                }
                                else if (model.Status == "离线")
                                {
                                    resData = resData.Where(x => x.Status == 0).ToList();
                                }
                                return new HttpResponseMessage
                                {
                                    Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                                    {
                                        code = 0,
                                        count = resData.Count,
                                        data = resData.ToList()
                                    }), Encoding.GetEncoding("UTF-8"), "application/json")
                                };
                            }
                        default:
                            return new HttpResponseMessage
                            {
                                Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                                {
                                    message = "无效设备类型",
                                    state = "3"
                                }), Encoding.GetEncoding("UTF-8"), "application/json")
                            };
                    }

                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return new HttpResponseMessage
                    {
                        Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                        {
                            message = "操作失败",
                            state = "3"
                        }), Encoding.GetEncoding("UTF-8"), "application/json")
                    };
                }
            });
        }

        /// <summary>
        /// 获取mqtt日志
        /// </summary>
        [HttpGet("GetMQTTLogById")]
        [NoSign]
        public async Task<HttpResponseMessage> GetMQTTLogById([FromUri] string id, [FromUri] PageInfo pageInfo)
        {
            return await Task.Run(() =>
            {
                try
                {
                    var result = _unitOfWork.ApiMqttMessageRepository
                        .GetPage(x => x.DeviceNo == id, "-CreateTime", pageInfo.page - 1, pageInfo.limit, false);

                    return new HttpResponseMessage
                    {
                        Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                        {
                            code = "0",
                            count = result.totalElements,
                            data = result.content,
                            msg = ""
                        }, new JsonSerializerSettings()
                        {
                            DateFormatString = "yyyy-MM-dd HH:mm:ss",
                            ReferenceLoopHandling = ReferenceLoopHandling.Ignore,
                            ContractResolver = new DefaultContractResolver(),
                            StringEscapeHandling = StringEscapeHandling.EscapeNonAscii
                        }), Encoding.GetEncoding("UTF-8"), "application/json")
                    };
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return new HttpResponseMessage
                    {
                        Content = new StringContent(Newtonsoft.Json.JsonConvert.SerializeObject(new
                        {
                            message = "操作失败",
                            state = "3"
                        }), Encoding.GetEncoding("UTF-8"), "application/json")
                    };
                }
            });
        }
        /// <summary>
        /// 远程亮灯（货架）
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"装备id",
        ///     }
        /// 
        /// </remarks>
        [HttpPost("RemoteOpenShelfLight")]
        public async Task<HttpResponseMessage> RemoteOpenShelfLight([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id ?? "";

                        if (string.IsNullOrEmpty(id))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }

                        var inventory = _unitOfWork.DbContext.CommonJpEquipmentInventories
                            .Include(x => x.Shelf)
                            .FirstOrDefault(x => x.Id == id);
                        if (inventory == null)
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }

                        if (inventory.CurrentState != 0)
                        {
                            return JsonManager.SimpleCustResponse("装备状态不是在库");
                        }

                        if (string.IsNullOrEmpty(inventory.ShelfId))
                        {
                            return JsonManager.SimpleCustResponse("装备不在货架上");
                        }

                        var channelCfg = _unitOfWork.ChannelCfgV2Repository.Get(x => x.WarehouseId == inventory.WarehouseCode);
                        if (channelCfg == null)
                        {
                            return JsonManager.SimpleCustResponse("当前装备所在仓库无通道程序");

                        }
                        var channel = mqttServer.mqttServer
                            .GetClientStatusAsync()
                            .Result
                            .FirstOrDefault(x => x.ClientId == channelCfg.Code);
                        if (channel == null)
                        {
                            return JsonManager.SimpleCustResponse("通道未在线");
                        }
                        var token = (DateTime.Now.ToUniversalTime().Ticks - 621355968000000000) / 10000000;
                        mqttServer.ServerPublishMqttTopic(channelCfg.Code, $"/C|RemoteOpenShelfLight|{{\"shelfUrl\":\"{inventory.Shelf.Url}\",\"token\":\"{token}\"}}");

                        Thread.Sleep(5000);
                        var message = _unitOfWork.DbContext.ApiMqttMessages
                            .FirstOrDefault(x =>
                                x.DeviceNo == channelCfg.Code && x.Topic == "Response" && x.Token == token.ToString());

                        if (message != null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse("未收到回复信息");
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 远程开门
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "channelCode":"TDA5F2555F1EB099A6B4330EFBB8118FA8A815242E",
        ///         "userId":"用户id"
        ///     }
        /// 
        /// </remarks>
        [HttpPost("RemoteOpenDoor")]
        public async Task<HttpResponseMessage> RemoteOpenDoor([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string channelCode = entity.channelCode ?? "";
                        string userId = entity.userId ?? "";


                        if (string.IsNullOrEmpty(channelCode))
                        {
                            return JsonManager.SimpleCustResponse("channelCode is require");
                        }

                        if (string.IsNullOrEmpty(userId))
                        {
                            return JsonManager.SimpleCustResponse("userId is require");
                        }

                        var user = _unitOfWork.PolicemanRepository.Get(userId);
                        if (user == null)
                        {
                            return JsonManager.SimpleCustResponse("userId is require");
                        }

                        var channel = mqttServer.mqttServer
                            .GetClientStatusAsync()
                            .Result
                            .FirstOrDefault(x => x.ClientId == channelCode);
                        if (channel == null)
                        {
                            return JsonManager.SimpleCustResponse("通道未在线，远程开门失败");
                        }
                        var token = (DateTime.Now.ToUniversalTime().Ticks - 621355968000000000) / 10000000;
                        mqttServer.ServerPublishMqttTopic(channelCode, $"/C|RemoteOpen|{{\"userId\":\"{userId}\",\"name\":\"{user.Name}\",\"token\":\"{token}\"}}");

                        Thread.Sleep(5000);
                        var message = _unitOfWork.DbContext.ApiMqttMessages
                            .FirstOrDefault(x =>
                                x.DeviceNo == channelCode && x.Topic == "Response" && x.Token == token.ToString());

                        if (message != null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                        }
                        else
                        {
                            return JsonManager.SimpleCustResponse("未收到回复信息，开门状态未知");
                        }


                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {
                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
    }
    public class Snapshot
    {
        public string directoy { get; set; }
        public int type { get; set; }
        public IFormFile picture { get; set; }
        public string id { get; set; }
    }

    public class FacePic
    {
        public IFormFile picture { get; set; }
        public string id { get; set; }
    }

    public class LogUpload
    {
        public string directoy { get; set; }
        public int type { get; set; }
        public IFormFile logFile { get; set; }
        public string id { get; set; }
    }
    public class MQTTLogSearchModel
    {
        /// <summary>
        /// 设备类型
        /// </summary>
        public string Type { get; set; }
        /// <summary>
        /// 组织机构
        /// </summary>
        public string OrganizationId { get; set; }
        /// <summary>
        /// 设备状态
        /// </summary>
        public string Status { get; set; }
    }
    public class PageInfo
    {
        //当前页码
        public int page { get; set; }
        //每页数据量
        public int limit { get; set; }
    }
}
