using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.IO.Pipes;
using System.Linq;
using System.Linq.Expressions;
using System.Security.AccessControl;
using System.Security.Principal;
using System.Threading;
using System.Threading.Tasks;
using Fleck;
using JmpModel.Model;
using JmpModel.Model.DataContext;
using JmpModel.Model.Repository;
using JmpModel.Notice;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using NLog;

namespace JmpMsgService
{
    public class MsgPushService : BackgroundService
    {
        private ILogger<MsgPushService> _logger;
        private object lcObj = new object();
        public IConfiguration Configuration { get; }
        //private CancellationTokenSource cMsg;
        //private CancellationTokenSource cDel;
        UnitOfWork _unitOfWork;
        private event Action<string> onRefresh;
        private event Action<string, IWebSocketConnection, string> onReciveMsg;
        private CfgNotice clearConfig;
        public MsgPushService(ILogger<MsgPushService> logger, UnitOfWork unitOfWork, IConfiguration configuration)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
            Configuration = configuration;
        }

        public WebSocketServer wsServer = default;
        string checkTime = string.Empty;
        private Dictionary<string, string> dict_client_role = new Dictionary<string, string>();
        private Dictionary<string, IWebSocketConnection> dic_client = new Dictionary<string, IWebSocketConnection>();
        //private Dictionary<string, string> send_dic_client = new Dictionary<string, string>();
        //private string sendName = string.Empty;
        //private string ip = string.Empty;
        //private CancellationTokenSource cMsg;
        protected override async Task ExecuteAsync(CancellationToken stoppingToken)
        {
            try
            {
                onRefresh += SendRefresh;
                onReciveMsg += OnMessageReceived;
                //启动Ws服务
                wsServer = new WebSocketServer("ws://0.0.0.0:8090");
                Console.WriteLine("消息服务 启动成功");
                wsServer.Start(socket =>
                {
                    socket.OnOpen = () =>
                    {
                        OnClientConnected(socket.ConnectionInfo.ClientIpAddress + ":" + socket.ConnectionInfo.ClientPort.ToString(), socket);
                    };
                    socket.OnClose = () =>
                    {
                        OnClientDisconnected(socket.ConnectionInfo.ClientIpAddress + ":" + socket.ConnectionInfo.ClientPort.ToString(), socket);
                    };
                    socket.OnMessage = (message) =>
                    {
                        onReciveMsg?.Invoke(socket.ConnectionInfo.ClientIpAddress + ":" + socket.ConnectionInfo.ClientPort.ToString(), socket, message);
                    };
                });

                var checkTime = Configuration.GetConnectionString("CheckTime");
                while (!stoppingToken.IsCancellationRequested)
                {
                    CheckMessage();

                    CheckDelete();

                    await Task.Delay(int.Parse(checkTime) * 60 * 1000); //单位：分钟
                }

            }
            catch (Exception ex)
            {
                _logger.LogError("消息服务 ExecuteAsync:" + ex.ToString());
            }
        }
        public override Task StopAsync(CancellationToken cancellationToken)
        {
            //cMsg?.Cancel();
            //pipeServer?.Disconnect();
            //pipeServer?.Close();
            return base.StopAsync(cancellationToken);
        }
        private void CheckMessage()
        {
            //启动轮询

            DateTime CheckTime = DateTime.Now.Date;
            checkTime = Configuration.GetConnectionString("CheckTime");
            string[] parameBorrow = new string[] {
                        "CommonJpBorrowReturns"
                        };
            string[] parameTr = new string[] {
                        "CommonJpTransfers"
                        };
            string[] parameScrap = new string[] {

                        };
            string[] parame = new string[] {
                            "UsersRoles"
                        };
            string[] parameInventory = new string[] {
                            "CommonJpEquipmentStates",
                            "EquipmentCodeNavigation",
                            "EquipmentSizecodeNavigation",
                            "WarehouseCodeNavigation",
                            "WarehouseCodeNavigation.Orgization",
                            "WarehouseCodeNavigation.Orgization.CommonJpUsers",
                            "WarehouseCodeNavigation.Orgization.CommonJpUsers.UsersRoles",
                        };
            Expression<Func<VScrapView, bool>> expression = p => p.WarrantyTime != null;
            //var userInfo1 = _unitOfWork.CommonJpUserRepository.GetList(p=>p.Id!=null);
            var scrapList = _unitOfWork.ScrapViewRepository.GetList(expression, p => p.WarrantyTime, false, parameScrap);//超期数据
            var orgList = scrapList.ToList().GroupBy(p => p.OrgId);
            List<string> orgs = new List<string>();
            foreach (var item in orgList)
            {
                orgs.Add(item.FirstOrDefault().OrgId);
            }
            Expression<Func<CommonJpUser, bool>> userExpression = p => orgs.Contains(p.OrganizationId) && p.Enabled == 1 && p.UsersRoles.Where(t => t.RoleId == 2).Count() > 0;
            var userInfo = _unitOfWork.CommonJpUserRepository.GetList(userExpression, null, false, parame).ToList();
            var borrowList = _unitOfWork.BorrowReturnApplyRepository.GetList(p => p.ExpectedReturnTime != null && p.CommonJpBorrowReturns.FirstOrDefault().CurrentState.Equals(1) && p.ExpectedReturnTime <= DateTime.Now.Date, null, false, parameBorrow).ToList();
            var historyMessage = _unitOfWork.MessageRepository.GetList(p => (p.MessageType.Equals("rebackWaring") || p.MessageType.Equals("scrapWaring")) && !string.IsNullOrEmpty(p.OrderId)).ToList();
            var borrowTranList = _unitOfWork.TransferApplyRepository.GetList(p => p.ExpectedReturnTime != null && p.CommonJpTransfers.FirstOrDefault().CurrentState.Equals(1) && p.ExpectedReturnTime > DateTime.Now.Date, null, false, parameTr).ToList();//跨库借用单
            var borrowCurrentList = _unitOfWork.EquipmentInventoryRepository.GetList(p => p.CurrentState.Equals(14)&&p.InventoryState!="loss", null, false, parameInventory).ToList();
            List<CommonJpMessage> messges = new List<CommonJpMessage>();
            foreach (var item in borrowTranList)
            {


                if (historyMessage.Where(p => p.MessageInfo.Equals(item.Id) && p.SendName.Equals(item.ApplyUser)).Count() <= 0)
                {
                    CommonJpMessage message = new CommonJpMessage();
                    message.Id = Guid.NewGuid().ToString();
                    message.State = 0;
                    message.SendName = item.ApplyUser;
                    message.MessageType = "rebackWaring";
                    message.MessageInfo = item.Order;
                    message.SendTime = DateTime.Now;
                    message.PcNumber = Guid.NewGuid().ToString();
                    message.OrderType = "跨仓库归还提醒";
                    message.OrderId = item.Order;
                    messges.Add(message);
                    onRefresh?.Invoke(message.SendName);
                }
            }
            foreach (var borrowState in borrowCurrentList)
            {
                if (borrowState.CommonJpEquipmentStates.Count > 0 && borrowState.CommonJpEquipmentStates.Where(p => p.OutTime != null).ToList().Count() > 0)
                {
                    var borrowTime = borrowState.CommonJpEquipmentStates.Where(p => p.OutTime != null).ToList().Select(p => new
                    {
                        p.Id,
                        p.OutTime,
                    }).OrderByDescending(p => p.OutTime).FirstOrDefault().OutTime;
                    var sendList = borrowState.WarehouseCodeNavigation.Orgization.CommonJpUsers.Where(p => p.UsersRoles.Where(t => t.RoleId.Equals(2)).Count() > 0);
                    foreach (var sendItem in sendList)
                    {
                        //bool aa = (historyMessage.Where(p => p.MessageInfo.Equals(borrowState.Id) && p.SendName.Equals(sendItem.Id)).ToList().Count() <= 0);
                        //if ((borrowTime.Value.AddMinutes(2) <= DateTime.Now) && (historyMessage.Where(p => p.MessageInfo.Equals(borrowState.Id) && p.SendName.Equals(sendItem.Id)).ToList().Count() <= 0))
                        if (borrowTime.Value.AddMonths(-1) <= DateTime.Now.Date && historyMessage.Where(p => p.MessageInfo.Equals(borrowState.Id) && p.SendName.Equals(sendItem.Id)).ToList().Count() <= 0)
                        {
                            CommonJpMessage message = new CommonJpMessage();
                            message.Id = Guid.NewGuid().ToString();
                            message.State = 0;
                            message.SendName = sendItem.Id;
                            message.MessageType = "rebackWaring";
                            message.MessageInfo = borrowState.Id;
                            message.SendTime = DateTime.Now;
                            message.PcNumber = Guid.NewGuid().ToString();
                            message.OrderType = "本仓库归还提醒";
                            message.OrderId = borrowState.EquipmentCodeNavigation?.Name + "-" + borrowState.EquipmentSizecodeNavigation?.SizeName;
                            messges.Add(message);
                            onRefresh?.Invoke(message.SendName);
                        }
                    }
                }

            }
            foreach (var item in scrapList)//添加报废消息到消息数据表
            {
                string id = item.Id;
                string orgId = item.OrgId;
                var sendUser = userInfo.Where(p => p.OrganizationId.Equals(item.OrgId));//当前存的管理员
                string pcNum = Guid.NewGuid().ToString();
                if (item.WarrantyTime.Value.AddMonths(-1) <= DateTime.Now)
                {
                    foreach (var user in sendUser)
                    {
                        if (historyMessage.Where(p => p.MessageInfo.Equals(id) && p.SendName.Equals(user.Id)).ToList().Count() <= 0)
                        {
                            CommonJpMessage message = new CommonJpMessage();
                            message.Id = Guid.NewGuid().ToString();
                            message.State = 0;
                            message.SendName = user.Id;
                            message.MessageType = "scrapWaring";
                            message.MessageInfo = item.Id;
                            message.SendTime = DateTime.Now;
                            message.PcNumber = pcNum;
                            message.OrderType = "报废提醒";
                            message.OrderId = item.EquName + "-" + item.SizeName;
                            messges.Add(message);
                            onRefresh?.Invoke(message.SendName);
                            //messages.Enqueue(message);
                        }
                    }
                }

            }
            foreach (var item in borrowList)//添加归还消息到消息数据表
            {


                if (historyMessage.Where(p => p.MessageInfo.Equals(item.Id) && p.SendName.Equals(item.ApplyUser)).Count() <= 0)
                {
                    CommonJpMessage message = new CommonJpMessage();
                    message.Id = Guid.NewGuid().ToString();
                    message.State = 0;
                    message.SendName = item.ApplyUser;
                    message.MessageType = "rebackWaring";
                    message.MessageInfo = item.OrderCode;
                    message.SendTime = DateTime.Now;
                    message.PcNumber = Guid.NewGuid().ToString();
                    message.OrderType = "归还提醒";
                    message.OrderId = item.OrderCode;
                    messges.Add(message);
                    onRefresh?.Invoke(message.SendName);

                }

            }

            bool result = _unitOfWork.MessageRepository.Insert(messges, true);
            //_logger.LogDebug("Worker running at: {time},Result:{result}", DateTimeOffset.Now, result);
            Task.Delay(int.Parse(checkTime) * 60 * 1000); //单位：分钟


        }
        private void CheckDelete()
        {
            try
            {
                clearConfig = new CfgNotice();
                //启动后读取一次数据库的配置信息
                var cfg = _unitOfWork.CommonJpLogCfgRepository.Get(p => p.Id != null);//全局配置信息
                clearConfig.id = cfg.Id;
                clearConfig.updateCicle = cfg.UpdateCicle;
                clearConfig.lastTime = DateTime.Now;
                clearConfig.urlText = cfg.UrlText;
                clearConfig.logUrlText = cfg.LogUrl;


                ClearCache();
                clearConfig.lastTime = DateTime.Now;
                Task.Delay(int.Parse(checkTime) * 60 * 1000); //单位：分钟
            }
            catch (Exception ex)
            {

                _logger.LogError("消息服务 WaitData:" + ex.ToString());
            }
        }
        private void RefreshCfg(string json)
        {
            try
            {
                var cfg = JsonConvert.DeserializeObject<CfgNotice>(json);
                clearConfig.urlText = cfg.urlText;
                clearConfig.logUrlText = cfg.logUrlText;
                clearConfig.updateCicle = cfg.updateCicle;
                clearConfig.id = cfg.id;

            }
            catch (Exception ex)
            {
                _logger.LogError(ex.ToString());
            }
        }
        private void SendRefresh(string sendName)
        {
            lock (lcObj)
            {
                var send_client = dict_client_role.Where(p => sendName.Contains(p.Value)).ToList();
                if (send_client != null && send_client.Count > 0)
                {
                    send_client.ForEach(s =>
                    {
                        if (dic_client.ContainsKey(s.Key))
                        {
                            var client_info = dic_client[s.Key];
                            if (client_info.IsAvailable)
                            {
                                client_info.Send("refresh");
                                Console.WriteLine($"发送至:{s.Key}");
                            }
                        }
                    });
                }
            }


            //try
            //{
            //    using (NamedPipeClientStream pipeClient =
            //  new NamedPipeClientStream(".", "MsgPipe", PipeDirection.InOut, PipeOptions.None))
            //    {

            //        pipeClient.Connect();
            //        using (StreamWriter sw = new StreamWriter(pipeClient))
            //        {
            //            sw.WriteLine(sendName);
            //            sw.Flush();
            //        }
            //    }
            //}
            //catch (Exception ex)
            //{
            //    _logger.LogError(ex.ToString());
            //}

        }
        private void ClearCache()
        {
            var _channelPath = clearConfig.urlText + "\\SnapPic";
            var _cabinetPath = clearConfig.urlText + "\\LogFile\\Cabinet";
            var _logPath = clearConfig.logUrlText;
            DirectoryInfo channelPic = new DirectoryInfo(_channelPath);
            DirectoryInfo cabPic = new DirectoryInfo(_cabinetPath);
            DirectoryInfo logFile = new DirectoryInfo(_logPath);

            //遍历文件夹
            if (Directory.Exists(channelPic.ToString()))
            {
                foreach (DirectoryInfo NextFolder in channelPic.GetDirectories())//遍历通道
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (DirectoryInfo NextNewFolder in NewTheFolder.GetDirectories())//遍历仓库
                    {
                        DirectoryInfo NewDataFolder = new DirectoryInfo(NextNewFolder.FullName);
                        foreach (DirectoryInfo item in NewDataFolder.GetDirectories())//遍历仓库下的日期文件夹
                        {
                            if (item.CreationTime.AddDays(clearConfig.updateCicle) < DateTime.Now.Date)
                            {

                                if (item.Exists)
                                {

                                    //Directory.Delete(item.FullName, true);
                                    //File.Delete(item.FullName);
                                }
                            }
                        }

                    }
                }
            }
            if (Directory.Exists(cabPic.ToString()))
            {
                foreach (DirectoryInfo NextFolder in cabPic.GetDirectories())//遍历单警柜日志文件夹
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (DirectoryInfo NextNewFolder in NewTheFolder.GetDirectories())//遍历主柜
                    {


                        if (NextNewFolder.CreationTime.AddDays(clearConfig.updateCicle) < DateTime.Now.Date)
                        {
                            Directory.Delete(NextNewFolder.FullName, true);

                        }


                    }
                }
            }
            if (Directory.Exists(logFile.ToString()))
            {
                foreach (DirectoryInfo NextFolder in logFile.GetDirectories())//遍历日志文件夹
                {
                    DirectoryInfo NewTheFolder = new DirectoryInfo(NextFolder.FullName);
                    foreach (FileInfo item in NewTheFolder.GetFiles())//遍历日志文件夹下的其他文件夹
                    {
                        if (item.CreationTime.AddDays(clearConfig.updateCicle) < DateTime.Now.Date)
                        {
                            File.Delete(item.FullName);
                        }
                    }
                }
            }

        }
        private void OnMessageReceived(string client, IWebSocketConnection connnection, string msg)
        {
            try
            {
                var cmdInfo = JsonConvert.DeserializeObject<CmdInfo>(msg);
                if (cmdInfo == null) { _logger.LogInformation("无效的JSON字符串"); }
                else
                {
                    switch (cmdInfo.cmdType)
                    {
                        case CmdType.刷新消息:
                            if (!dict_client_role.ContainsKey(client)&&!client.Contains("127.0.0.1"))
                            {
                                dict_client_role.Add(client, cmdInfo.cmdPara);
                            }
                            onRefresh?.Invoke(cmdInfo.cmdPara);
                            break;
                        case CmdType.缓存删除:
                            RefreshCfg(cmdInfo.cmdPara);
                            break;
                        default: break;
                    }
                }
            }
            catch (Exception ex)
            {
                _logger.LogError(ex.ToString());
            }
        }
        private void OnClientDisconnected(string client, IWebSocketConnection connnection)
        {
            lock (lcObj)
            {
                if (dic_client.ContainsKey(client))
                {
                    dic_client.Remove(client);
                }

                if (dict_client_role.ContainsKey(client))
                {
                    dict_client_role.Remove(client);
                }
            }
        }
        private void OnClientConnected(string client, IWebSocketConnection connnection)
        {
            if (!dic_client.ContainsKey(client))
            {
                dic_client.Add(client, connnection);
            }
        }
    }
}
