﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace JunmpPoliceStation
{
    public static class GlobalContext
    {
        public static byte ServerNum { get; set; }
        private static Websocket.Client.WebsocketClient client;
        public static void UseNoticeService(Uri url)
        {
            if (url == null)
            {
                throw new NotImplementedException("消息服务地址未配置");
            }
            else
            {
                client = new Websocket.Client.WebsocketClient(url);
                client.Start();
            }
        }
        public static void SendMessage(string id)
        {
            if (client == null)
            {
                Console.WriteLine($"[{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}]-消息服务未实例化");
            }
            else if (client?.IsRunning ?? false)
            {
                var data = new
                {
                    cmdType = 0,
                    cmdPara = id
                };
                client.Send(JsonConvert.SerializeObject(data));
            }
            else
            {
                Console.WriteLine($"[{DateTime.Now.ToString("yyyy - MM - dd HH: mm:ss")}]-消息服务未连接");
            }
        }
        public static void SendUpdateCfg(string json)
        {
            if (client == null)
            {
                Console.WriteLine($"[{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}]-消息服务未实例化");
            }
            else if (client?.IsRunning ?? false)
            {
                var data = new
                {
                    cmdType = 1,
                    cmdPara = json
                };
                client.Send(JsonConvert.SerializeObject(data));
            }
            else
            {
                Console.WriteLine($"[{DateTime.Now.ToString("yyyy - MM - dd HH: mm:ss")}]-消息服务未连接");
            }
        }

    }
}
