﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Threading.Tasks;
using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Rextec.SOA.Infrastructure;
using static JmpModel.Model.Enumerates.BorrowEnum;

namespace JunmpPoliceStation.Controllers
{

    [Route("api/[controller]")]
    [ApiController]
    /// <summary>
    /// <remarks>
    /// 调拨模块
    /// </remarks>
    /// </summary>
    public class TransferController : ControllerBase
    {
        private ILogger<TransferController> _logger;
        UnitOfWork _unitOfWork;
        public TransferController(ILogger<TransferController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            //_CabinetRepository = CabinetRepository;
            _unitOfWork = unitOfWork;
        }
        public List<BaseJpOrganization> ListEq = new List<BaseJpOrganization>();
        //递归取数据
        private List<BaseJpOrganization> GetClassID(String id)
        {

            var query = from c in ListEq
                        where c.ParentId == id
                        select c;
            return query.ToList().Concat(query.ToList().SelectMany(t => GetClassID(t.Id))).ToList();
        }


        /// <summary>
        /// 获取调拨订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///         "type":"调拨,跨库借用,跨库归还"
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetByID")]
        //[NoSign]
        public async Task<HttpResponseMessage> GetByID([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = string.Empty;
                        id = entity.id;
                        string type = entity.type;

                        var param = new string[] {
                       "CommonJpProcessHistories",
                       "CommonJpTransferApplies",
                       "CommonJpTransferApplies.Transfer",
                       "CommonJpTransferApplies.CommonJpTransfers",
                       "CommonJpTransferApplies.Target",
                       "CommonJpTransferApplies.TransferWarehouseNavigation" ,
                       "CommonJpProcessHistories" ,

                       "CommonJpTransferApplies.CommonJpTransferDetailEstimates.EquipmentSize" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailEstimates.EquipmentDetail" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailEstimates.Supplier" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailRealities.Size" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailRealities.EquipmentDetail" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailRealities.Supplier" ,
                       "CommonJpTransferApplies.CommonJpTransferDetailRealities.Warehouse" ,

                    };
                        Expression<Func<CommonJpProcessCurrent, bool>> expression = p => p.OrderId != null;
                        if (string.IsNullOrEmpty(type))
                        {
                            expression = LambdaExtensions.And(expression, p => p.OrderId.Equals(id) || p.CommonJpTransferApplies.Where(c => c.Order.Equals(id)).Count() > 0);
                        }
                        else
                        {
                            if (type.Equals("调拨") || type.Equals("跨库借用"))
                            {
                                expression = LambdaExtensions.And(expression, p => p.OrderId.Equals(id) || p.CommonJpTransferApplies.Where(c => c.Order.Equals(id)).Count() > 0);
                            }
                            else if (type.Equals("跨库归还"))
                            {
                                expression = LambdaExtensions.And(expression, p => p.OrderId.Equals(id) || p.CommonJpTransferApplies.FirstOrDefault().CommonJpTransfers.Where(p => p.Order.Equals(id)).Count() > 0);
                            }
                        }


                        var transfer = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).ToList();




                        if (transfer.Count > 0)
                        {


                            string value = RedisCacheHelper.GetStringValue(transfer.FirstOrDefault().CommonJpTransferApplies.FirstOrDefault().Order);//获取数据

                            if (!string.IsNullOrEmpty(value))
                            {
                                entity = JObject.Parse(value.ToString());
                            }




                            var transferData = transfer.Select(t => new
                            {

                                type = t.CommonJpTransferApplies.First().ActionType.ToString().Equals("0") ? 0 : t.CommonJpTransferApplies.First().ActionType.ToString().Equals("1") ? 7 : 9,
                                t.NextStepId,
                                t.FlowType,
                                processActionType = t.ActionType,
                                flowState = Convert.ToBoolean(t.FlowState),
                                t.UserInfo,
                                t.UserType,
                                t.DataScope,
                                t.OrgId,
                                t.CommonJpTransferApplies?.FirstOrDefault()?.UpdateTime,
                                t.CurrentStepName,
                                expectedReturnTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ExpectedReturnTime,
                                CurrentOrg = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferId,
                                id = t.CommonJpTransferApplies?.FirstOrDefault()?.Id,
                                applyId = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser,
                                applyName = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUserName,
                                applyTime = t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyTime,
                                note = t.CommonJpTransferApplies?.FirstOrDefault()?.Reason,
                                createTime = t.CommonJpTransferApplies?.FirstOrDefault()?.CreateTime,
                                warehouseName = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouseNavigation?.Name,
                                warehouseId = t.CommonJpTransferApplies?.FirstOrDefault()?.TransferWarehouse,
                                order = t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.FirstOrDefault()?.Order == null ? t.CommonJpTransferApplies?.FirstOrDefault().Order : t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransfers?.FirstOrDefault()?.Order,
                                transferName = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Name,
                                transferShortName = string.IsNullOrEmpty(t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.DName) ?
                                    t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Name
                                : t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.DName,
                                transferId = t.CommonJpTransferApplies?.FirstOrDefault()?.Transfer?.Id,
                                targetName = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Name,
                                targetShortName = string.IsNullOrEmpty(t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.DName) ?
                                    t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Name
                                    : t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.DName,
                                targetId = t.CommonJpTransferApplies?.FirstOrDefault()?.Target?.Id,

                                actionResult = t.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.CommonJpTransferApplies?.FirstOrDefault()?.ApplyUser) == true ? "0" : "1",


                                historyList = t.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    x.AuditMind,
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                detailList = t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransferDetailEstimates?.Select(x => new
                                {

                                    equipmentSizeId = x.EquipmentSize?.Id,
                                    equipmentSizeName = x.EquipmentSize?.SizeName,
                                    equipmentDetailId = x.EquipmentDetail?.Id,
                                    equipmentDetailName = x.EquipmentDetail?.Name,
                                    equipmentDetailUnitType = x.EquipmentDetail?.UnitType,
                                    quantity = x.EquipmentCount,

                                    supplierId = x.Supplier?.Id,
                                    supplierName = x.Supplier?.Name,
                                    unitPrice = x.UnitPrice,
                                    price = x.Price,

                                }).OrderBy(p => p.equipmentDetailName),
                                realityDetailList = t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransferDetailRealities.Count() == 0 ? entity.realityDetailList
                                : t.CommonJpTransferApplies?.FirstOrDefault()?.CommonJpTransferDetailRealities?.Select(x => new
                                {
                                    realityId = x.Id,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    equipmentDetailId = x.EquipmentDetail?.Id,
                                    warehouseId = x.WarehouseId,
                                    warehouseName = x.Warehouse?.Name,
                                    equipmentDetailName = x.EquipmentDetail?.Name,
                                    quantity = x.EquipmentCount,
                                    x.RealCount,
                                    InsideRealCount = x.InsideRealCount == null ? 0 : x.InsideRealCount,
                                    x.State,
                                    supplierId = x.Supplier?.Id,
                                    supplierName = x.Supplier?.Name,

                                    //priceList = _unitOfWork.DbContext.CommonJpEquipmentStates
                                    //    .Include(a => a.Eqiupment)
                                    //    .Include(a => a.Eqiupment.EquipmentSizecodeNavigation)
                                    //    .Where(a => a.TransferId == x.Id && a.OutInState == 0)
                                    //    .ToList()
                                    //    .GroupBy(y => y.Eqiupment.Price)
                                    //    .Select(y => new
                                    //    {
                                    //        equipmentName = x.EquipmentDetail?.Name,
                                    //        equipmentUnitType = x.EquipmentDetail?.UnitType,
                                    //        equipmentSizeName = y.FirstOrDefault()?.Eqiupment?.EquipmentSizecodeNavigation.SizeName,
                                    //        price = Convert.ToDecimal(y.Key).ToString("F2"),
                                    //        Count = y.Count(),
                                    //        totalPrice = Convert.ToDecimal(y.Key * y.Count()).ToString("F2")
                                    //    })
                                }).OrderBy(p => p.equipmentDetailName),

                                resultPriceList = new List<object>()

                            }).FirstOrDefault();

                            if (transferData?.detailList != null)
                            {
                                foreach (var obj in transferData.detailList)
                                {
                                    if (obj != null)
                                    {
                                        transferData.resultPriceList.Add(new
                                        {
                                            equipmentName = obj.equipmentDetailName,
                                            equipmentUnitType = obj.equipmentDetailUnitType,
                                            equipmentSizeName = obj.equipmentSizeName,
                                            price = obj.unitPrice?.ToString("F2"),
                                            count = obj.quantity,
                                            totalPrice = obj.price?.ToString("F2"),
                                        });
                                    }
                                }
                            }

                            return JsonManager.ReturnSuccessResponse(transferData);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }





                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 根据物资名称获取未到仓库的物资数量
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "equipmentId":10,
        ///         "orgizationId":"组织机构ID",
        ///         
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPurDetailLCount")]

        public async Task<HttpResponseMessage> GetPurDetailLCount([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);

                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);

                        if (size == 0)
                        {
                            size = 10;
                        }

                        if (String.IsNullOrEmpty(entity.equipmentId))
                        {
                            return JsonManager.SimpleCustResponse($"equipmentId is require");
                        }

                        Expression<Func<BaseJpOrganization, bool>> expression = t => t.State == 1;

                        ListEq = _unitOfWork.OrganizationRepository.GetList(expression, t => t.Code).ToList();

                        string orgizationId = Guid.Empty.ToString();
                        List<BaseJpOrganization> dataList = null;

                        if (!String.IsNullOrEmpty(entity.orgizationId))
                        {
                            orgizationId = entity.orgizationId;
                        }

                        dataList = GetClassID(orgizationId);

                        dataList = dataList.ToList().Concat(ListEq.Where(c => c.Id.Equals(orgizationId))).ToList();

                        string EquipmentId = entity.equipmentId;
                        Expression<Func<BaseJpWarehouse, bool>> expressionHouse = null;
                        Expression<Func<CommonJpPurchaseOrder, bool>> expressionPurchase = null;
                        expressionHouse = t => dataList.Select(c => c.Id).Contains(t.OrgizationId);
                        expressionPurchase = t => dataList.Select(c => c.Id).Contains(t.TargetWarehouse.OrgizationId) && t.CurrentState.Equals(0) && t.CommonJpPurchaseDetails.Where(p => p.EquipmentId.Equals(EquipmentId)).Count() > 0;


                        var paramPurchase = new string[] {
                        "TargetWarehouse",
                       "CommonJpPurchaseDetails",
                        "CommonJpPurchaseDetails.Equipment",
                    };
                        var pagedata = _unitOfWork.PurchaseOrderyRepository.GetList(expressionPurchase, p => p.CreateTime, false, paramPurchase).ToList();

                        var data = pagedata.Select(c => new
                        {
                            c.Id,
                            count = c.CommonJpPurchaseDetails.FirstOrDefault().Quantity - c.CommonJpPurchaseDetails.FirstOrDefault().RealCount,
                            warehouseName = c.TargetWarehouse?.Name,
                            equipmentName = c.CommonJpPurchaseDetails.FirstOrDefault().Equipment.Name,
                            orderNum = c.OrderCode,

                        }
                        ).ToList();


                        return JsonManager.ReturnSuccessResponse(data);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取全部调拨审批单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "size":10,
        ///         "page":0,
        ///         "order":"",
        ///         "applyDate":"",
        ///         "currentState":""
        ///         "actionType":""
        ///         "flowType:":""
        ///         "applyId":"",
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "warehouseId":""
        ///        }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetAllTransfersVerify")]
        public async Task<HttpResponseMessage> GetAllTransfersVerify([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        if (size == 0)
                        {
                            size = 10;
                        }

                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpTransferDetailEstimates" ,
                       "CommonJpTransferDetailRealities" ,
                       "TransferWarehouseNavigation" ,
                       "Transfer" ,
                       "Target" ,
                       "ApprovalPersonNavigation" ,
                       "Apply",
                       "CommonJpTransferDetailRealities.Warehouse" ,
                       "CommonJpTransferDetailRealities.EquipmentDetail" ,
                       "CommonJpTransferDetailRealities.Size" ,
                       "CommonJpTransferDetailRealities.Supplier" ,
                       "CommonJpTransferDetailEstimates.EquipmentDetail" ,
                       "CommonJpTransferDetailEstimates.EquipmentSize" ,
                       "CommonJpTransferDetailEstimates.Supplier" ,
                    };
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => p.Id != null);
                        string applyId = entity.applyId;
                        string actionType = entity.actionType;
                        string flowType = entity.flowType;
                        Expression<Func<CommonJpTransferApply, bool>> expression = t => !t.Id.Equals(null);
                        expression = LambdaExtensions.And(expression, t => t.ApplyUser == applyId);
                        if (!string.IsNullOrEmpty(actionType))
                        {
                            expression = LambdaExtensions.And(expression, t => t.ActionType == int.Parse(actionType));
                        }
                        if (!(string.IsNullOrEmpty(flowType) || "allocation".Equals(flowType)))
                        {
                            expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowType.Equals(flowType));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = LambdaExtensions.And(expression, t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }

                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }

                        }
                        if (!string.IsNullOrEmpty(entity.currentState))
                        {
                            string currentState = entity.currentState;

                            expression = LambdaExtensions.And(expression, t => t.ProcessCurrent.FlowType.Equals(currentState));


                        }
                        if (!String.IsNullOrEmpty(entity.applyDate))
                        {
                            DateTime applyDate = Convert.ToDateTime(entity.applyDate);

                            expression = LambdaExtensions.AndAlso(expression, t => t.ApplyTime.Day.Equals(applyDate));
                        }

                        if (!String.IsNullOrEmpty(entity.warehouseId))
                        {
                            string warehouseId = entity.warehouseId;

                            expression = LambdaExtensions.AndAlso(expression, t => t.TransferWarehouse.Equals(warehouseId));
                        }

                        if (!String.IsNullOrEmpty(entity.orderCode))
                        {
                            string orderCode = entity.orderCode;

                            expression = LambdaExtensions.AndAlso(expression, t => t.Order.Contains(orderCode));
                        }

                        var detailList = _unitOfWork.TransferApplyRepository.GetList(expression, null, false, param).OrderByDescending(p => p.UpdateTime);
                        var borrowlocationValue = new
                        {
                            totalElements = detailList.Count(),
                            content = detailList.Skip(page * size).Take(size).ToList()
                        };
                        var data = borrowlocationValue?.content.Select(t => new
                        {
                            t.ProcessCurrent.FlowType,
                            id = t.Id,
                            warehouseId = t.TransferWarehouse,
                            targetId = t.TargetId,
                            t.ExpectedReturnTime,
                            targetName = t.Target?.Name,
                            t.TransferId,
                            transferName = t.Transfer?.Name,
                            order = t.Order,
                            t.ApplyTime,
                            t.UpdateTime,
                            ApplyName = t.ApplyUserName,
                            note = t.Reason,
                            actionResult = t.ProcessCurrent.CommonJpProcessHistories.OrderBy(p => p.UpdateTime).FirstOrDefault().AuditUserId.Equals(applyId) ? "0" : "1",
                            warehouseName = t.TransferWarehouseNavigation?.Name,
                            dataCount = t.CommonJpTransferDetailEstimates.Sum(x => x.EquipmentCount),
                            realityDataCount = t.CommonJpTransferDetailRealities.Sum(x => x.EquipmentCount),
                            trueDataCount = t.CommonJpTransferDetailRealities.Sum(x => x.RealCount),
                            t.ProcessCurrent.UserInfo,
                            UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.Where(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo))).FirstOrDefault().Name,
                            t.ProcessCurrent.OrgId,
                            t.ProcessCurrent.NextStepId,
                            t.ProcessCurrent.CurrentStepName,
                            t.ProcessCurrent.DataScope,
                            t.ProcessCurrent.UserType,
                            processActionType = t.ProcessCurrent.ActionType,
                            flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                            historyList = t.ProcessCurrent.CommonJpProcessHistories.Select(x => new
                            {
                                x.Id,
                                x.OrgId,
                                x.StepName,
                                x.UpdateTime,
                                x.AuditUserId,
                                x.AuditMind,
                                x.AuditUserName
                            }).OrderByDescending(c => c.UpdateTime),

                            detailList = t.CommonJpTransferDetailEstimates.Select(x => new
                            {
                                equipmentSizeId = x.EquipmentSize?.Id,
                                equipmentSizeName = x.EquipmentSize?.SizeName,
                                equipmentDetailId = x.EquipmentDetail?.Id,
                                equipmentDetailName = x.EquipmentDetail.Name,
                                quantity = x.EquipmentCount,
                                supplierId = x.Supplier?.Id,
                                supplierName = x.Supplier?.Name,
                                x.UnitPrice,
                                x.Price
                            }),
                            realityDetailList = t.CommonJpTransferDetailRealities.Select(x => new
                            {
                                equipmentSizeId = x.Size?.Id,
                                equipmentSizeName = x.Size?.SizeName,
                                equipmentDetailId = x.EquipmentDetail?.Id,
                                warehouseId = x.WarehouseId,
                                warehouseName = x.Warehouse?.Name,
                                equipmentDetailName = x.EquipmentDetail.Name,
                                quantity = x.EquipmentCount,
                                x.RealCount,
                                supplierId = x.Supplier?.Id,
                                supplierName = x.Supplier?.Name,
                            })
                        });
                        var content = new
                        {
                            borrowlocationValue.totalElements,
                            content = data.ToList()
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新调拨申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "targetId":"当前组织机构编号",
        ///         "transferId":"申请的组织机构编号",
        ///         "warehouseId":"请求仓库",
        ///         "note":"请求理由",
        ///         "createUser":"登录人员ID",
        ///         "orgId":"机构代码",
        ///         "applyId":"申请人员",
        ///         "applyName":"申请人员名字",
        ///         "actionType":"0调拨，1垮库借用",
        ///         "expectedReturnTime":"借用归还时间"
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填
        ///            "equipmentDetailId":"",
        ///            "quantity":"",
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateTransferOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateTransferOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        string warehouseId = entity?.warehouseId ?? "";

                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }



                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }

                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool processResult = _unitOfWork.CheckProcess(id);
                            if (!processResult)
                            {


                                var order = _unitOfWork.DbContext.CommonJpTransferApplies.Include(t => t.CommonJpTransferDetailEstimates).FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {
                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, (string)entity.orgId, "update");

                                    if (!string.IsNullOrEmpty(entity.expectedReturnTime))
                                    {
                                        order.ExpectedReturnTime = DateTime.Parse(entity.expectedReturnTime);
                                    }
                                    string transferId = entity.transferId;
                                    if (!string.IsNullOrEmpty(transferId))
                                    {
                                        order.TransferId = transferId;
                                    }

                                    //目标组织机构为目标仓库的组织机构 无视上传TargetId
                                    order.TargetId = _unitOfWork.WarehouseRepository.Get(warehouseId)?.OrgizationId;

                                    order.Reason = entity.note;
                                    order.TransferWarehouse = entity.warehouseId;
                                    order.UpdateTime = System.DateTime.Now;
                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    var tmpDetail = order.CommonJpTransferDetailEstimates?.Where(t => !tmpList.Contains(t.Id));
                                    for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                    {
                                        var tmp_dtl = tmpDetail.ElementAt(i);
                                        order.CommonJpTransferDetailEstimates.Remove(tmp_dtl);
                                    }

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);
                                        if (string.IsNullOrEmpty(item.equipmentDetailId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentDetailId is require");
                                        }
                                        else if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                            var bPrice = decimal.TryParse(item.price, out decimal price);
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpTransferDetailEstimates.Add(new CommonJpTransferDetailEstimate()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    EquipmentDetailId = item.equipmentDetailId,
                                                    EquipmentSizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                                    EstimateId = order.Id,
                                                    EquipmentCount = qty,
                                                    SupplierId = string.IsNullOrEmpty(item.supplierId) ? null : item.supplierId,
                                                    UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                                    Price = bPrice ? price : (decimal?)null,
                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpTransferDetailEstimates.FirstOrDefault(t => t.Id == item.id);
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {
                                                    detail.Id = Guid.NewGuid().ToString();
                                                    detail.EquipmentSizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId;
                                                    detail.EquipmentDetailId = item.equipmentDetailId;
                                                    detail.EstimateId = order.Id;
                                                    detail.EquipmentCount = qty;
                                                    detail.SupplierId = string.IsNullOrEmpty(item.supplierId) ? null : item.supplierId;
                                                    detail.UnitPrice = bUnitPrice ? unitPrice : (decimal?)null;
                                                    detail.Price = bPrice ? price : (decimal?)null;
                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.TransferApplyRepository.Update(order);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ACCOUNT_IS_AUDITED);
                            }
                        }
                        else
                        {
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();
                            string orderCode = string.Empty;
                            string actionType = entity.actionType;
                            if (actionType.Equals("0"))
                            {
                                orderCode = entity.orgCode + "DB" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            }
                            else if (actionType.Equals("1"))
                            {
                                orderCode = entity.orgCode + "JY" + DateTime.Now.ToString("yyyyMMddHHmmss");
                            }
                            var ExistOrder = _unitOfWork.TransferApplyRepository.Get(p => p.Order == orderCode);
                            if (ExistOrder != null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ORDER_IS_EXIST);
                            }
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, orderCode);

                            //目标组织机构为目标仓库的组织机构 无视上传TargetId
                            var targetId = _unitOfWork.WarehouseRepository.Get(warehouseId)?.OrgizationId;


                            //新增数据
                            CommonJpTransferApply order = new CommonJpTransferApply()
                            {

                                Id = orderID,
                                ExpectedReturnTime = !string.IsNullOrEmpty(entity.expectedReturnTime) ? DateTime.Parse(entity.expectedReturnTime) : null,
                                ActionType = int.Parse(entity.actionType),
                                TransferId = entity.transferId,
                                Reason = entity.note,
                                ApplyUser = entity.applyId,
                                ApplyUserName = entity.applyName,
                                CreateUser = entity.createUser,
                                TransferWarehouse = entity.warehouseId,
                                TargetId = targetId,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                UpdateTime = DateTime.Now,
                                ProcessCurrentId = processCurrentId,
                                Order = orderCode,
                            };

                            List<CommonJpTransferDetailEstimate> detailsList = new List<CommonJpTransferDetailEstimate>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);
                                //if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                //{
                                //    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                //}
                                if (string.IsNullOrEmpty(item.equipmentDetailId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentDetailId is require");
                                }

                                //if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                //{
                                //    return JsonManager.SimpleCustResponse("supplierId is require");
                                //}
                                if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    var bUnitPrice = decimal.TryParse(item.unitPrice, out decimal unitPrice);
                                    var bPrice = decimal.TryParse(item.price, out decimal price);
                                    detailsList.Add(new CommonJpTransferDetailEstimate()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentSizeId = string.IsNullOrEmpty(item.equipmentSizeId) ? null : item.equipmentSizeId,
                                        EquipmentDetailId = item.equipmentDetailId,
                                        EstimateId = order.Id,
                                        EquipmentCount = qty,
                                        UnitPrice = bUnitPrice ? unitPrice : (decimal?)null,
                                        Price = bPrice ? price : (decimal?)null,
                                        //SupplierId = item.supplierId
                                    });
                                }
                            }

                            order.CommonJpTransferDetailEstimates = detailsList;

                            bool result = _unitOfWork.TransferApplyRepository.Insert(order);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        private static object TransferSign = new object();
        /// <summary>
        /// 审批调拨申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6",
        ///         "approvalId":"审批人员代码",
        ///         "approvalName":"审批人员名称",
        ///         "orgId":"当前组织机构代码",
        ///         "startTime":"开始时间",//如果驳回则为空
        ///         "approvalRsult":1, // 1已通过 2已驳回
        ///         "approvalMsg":"驳回理由",
        ///         "updateFlag":""true/false
        ///         "realityDetailList":[//实际出货
        ///         { 
        ///            "sendWarehouseId":"发货仓库代码",//如果驳回则为空
        ///            "equipmentSizeId":"",
        ///            "equipmentDetailId":"",
        ///            
        ///            "supplierId":""
        ///             "warehouseList":{
        ///               "warehouseId":"",
        ///               "quantity":""
        ///             }
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    lock (TransferSign)
                    {
                        if (jdata != null)
                        {

                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }

                            else
                            {
                                var id = (string)(entity.id);
                                var orderInfo = _unitOfWork.DbContext.CommonJpTransferApplies.Include(c => c.CommonJpTransferDetailRealities).Include(c => c.ProcessCurrent).FirstOrDefault(t => t.Id == id);
                                var flowState = (string)(entity.flowState).ToLower();
                                var updateFlag = "false";
                                bool result = false;

                                if (!string.IsNullOrEmpty(entity.updateFlag))
                                {
                                    updateFlag = entity.updateFlag;
                                    updateFlag = updateFlag.ToLower();
                                }
                                //跨库借用取消之后 接受发货组织机构强制覆盖更新
                                string transferId = entity.transferId;
                                if (!string.IsNullOrEmpty(transferId))
                                {
                                    orderInfo.TransferId = transferId;
                                }
                                if (orderInfo.ProcessCurrent.FlowState == "ture")
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.ORDER_OPERATE_ERROR);
                                }
                                if (orderInfo == null)
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                                else
                                {

                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {
                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                         (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");

                                        orderInfo.UpdateTime = DateTime.Now;
                                        orderInfo.ApprovalMsg = entity.ApprovalMsg;
                                        var updateOrder = orderInfo;
                                        if (updateFlag.Equals("true") || flowState.Equals("true"))
                                        {
                                            if (flowState.Equals("false"))
                                            {
                                                string errmsg = "";
                                                var redisresult = RedisCacheHelper.SetStringValue(orderInfo.Order, JsonConvert.SerializeObject(jdata), ref errmsg);//添加数据
                                                if (redisresult == false)
                                                {
                                                    _logger.LogDebug("Redis错误" + errmsg.ToString());
                                                }
                                                //_logger.LogDebug("Redis设置结果" + redisresult.ToString());
                                                result = _unitOfWork.TransferApplyRepository.Update(updateOrder);


                                            }
                                            else
                                            {
                                                string value = RedisCacheHelper.GetStringValue(orderInfo.Order);//获取数据
                                                if (!string.IsNullOrEmpty(value))
                                                {
                                                    RedisCacheHelper.Remove(orderInfo.Order);
                                                }

                                                if (!string.IsNullOrEmpty(value))
                                                {
                                                    entity = JObject.Parse(value.ToString());
                                                }

                                                List<CommonJpTransfer> detailsList = new List<CommonJpTransfer>();
                                                CommonJpTransfer transferCom = new CommonJpTransfer();
                                                transferCom.Id = Guid.NewGuid().ToString();
                                                transferCom.ReceiveOrgizationId = orderInfo.TransferId;
                                                transferCom.SendOrgizationId = entity.orgId;
                                                transferCom.ReceiveWarehouseId = orderInfo.TransferWarehouse;
                                                transferCom.CurrentState = (int)CurrentState.未出去;
                                                transferCom.ApplyId = entity.id;
                                                transferCom.ActionType = orderInfo.ActionType;
                                                transferCom.Order = orderInfo.Order;
                                                transferCom.CreateTime = DateTime.Now;
                                                transferCom.UpdateTime = DateTime.Now;
                                                transferCom.ApplyId = orderInfo.Id;
                                                transferCom.IsWork = false;
                                                if (entity.realityDetailList == null)
                                                {
                                                    return JsonManager.SimpleCustResponse($"realityDetailList is require");
                                                }
                                                foreach (var item in entity.realityDetailList)
                                                {
                                                    //int.TryParse(item.quantity, out int qty);
                                                    string equipmentDetailId = item.equipmentDetailId;
                                                    if (string.IsNullOrEmpty(equipmentDetailId))
                                                    {
                                                        return JsonManager.SimpleCustResponse("equipmentDetailId is require");
                                                    }

                                                    else
                                                    {
                                                        var tmpDetail = orderInfo.CommonJpTransferDetailRealities.ToList();

                                                        for (int i = tmpDetail.Count() - 1; i >= 0; i--)
                                                        {
                                                            var tmp_dtl = tmpDetail.ElementAt(i);
                                                            orderInfo.CommonJpTransferDetailRealities.Remove(tmp_dtl);
                                                        }
                                                        var warehouseList = item.warehouseList;
                                                        foreach (var warehouseItem in warehouseList)
                                                        {

                                                            string sendWarehouseId = warehouseItem.id;
                                                            string count = warehouseItem.quantity;
                                                            if (count != null && count != "0")
                                                            {
                                                                transferCom.CommonJpTransferDetailRealities.Add(new CommonJpTransferDetailReality()
                                                                {
                                                                    Id = Guid.NewGuid().ToString(),
                                                                    SizeId = item.equipmentSizeId,
                                                                    EquipmentDetailId = item.equipmentDetailId,
                                                                    RealityId = transferCom.Id,
                                                                    State = (int)CurrentState.未出去,
                                                                    EstimateId = entity.id,
                                                                    EquipmentCount = int.Parse(count),
                                                                    WarehouseId = sendWarehouseId,
                                                                    SupplierId = item.supplierId,

                                                                });
                                                            }

                                                        }
                                                        //transferCom.CommonJpTransferDetailRealities = transferDetailsList;

                                                    }
                                                    detailsList.Add(transferCom);
                                                }


                                                orderInfo.CommonJpTransfers = detailsList;
                                                result = _unitOfWork.TransferApplyRepository.Update(orderInfo);
                                            }


                                        }
                                        else
                                        {
                                            result = _unitOfWork.TransferApplyRepository.Update(orderInfo);
                                        }




                                        //result = _unitOfWork.TransferApplyRepository.Update(orderInfo);
                                        if (result)
                                        {

                                            return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                        }
                                        else
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }

                            }

                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        /// <summary>
        /// 审批归还申请单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6",
        ///         "userType":"",
        ///         "userInfo":"",
        ///         "dataScope":"",
        ///         "nextStepId":"",
        ///         "currentStepName":"",
        ///         "flowType":"",
        ///         "flowName":"",
        ///         "orgId":"",
        ///         "note":"",
        ///         "flowState":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveReturnOrder")]
        public async Task<HttpResponseMessage> ApproveReturnOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }

                        else
                        {
                            var id = (string)(entity.id);
                            var returnInfo = _unitOfWork.DbContext.CommonJpTransferApplies.Include(p => p.Transfer).FirstOrDefault(t => t.Id == id);
                            var borrowInfo = _unitOfWork.DbContext.CommonJpTransferApplies.Include(p => p.CommonJpTransferDetailRealities).Include(p => p.CommonJpTransfers).Include(p => p.Transfer).FirstOrDefault(t => t.Id == returnInfo.BorrowOrderId);
                            var flowState = (string)(entity.flowState).ToLower();

                            if (returnInfo == null || borrowInfo == null)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                            else
                            {
                                _unitOfWork.ApproveMessage(returnInfo.Id);
                                _unitOfWork.AuditProcess((string)entity.actionType, returnInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                 (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");

                                returnInfo.UpdateTime = DateTime.Now;
                                CommonJpTransfer transferCom = new CommonJpTransfer();
                                if (flowState.Equals("false"))
                                {

                                }
                                else
                                {


                                    transferCom.Id = Guid.NewGuid().ToString();
                                    transferCom.ReceiveOrgizationId = borrowInfo.CommonJpTransfers.FirstOrDefault().SendOrgizationId;
                                    transferCom.SendOrgizationId = borrowInfo.CommonJpTransfers.FirstOrDefault().ReceiveOrgizationId;
                                    //transferCom.ReceiveWarehouseId = borrowInfo;
                                    //transferCom.SendWarehouseId = borrowInfo.TransferWarehouse;
                                    transferCom.CurrentState = (int)CurrentState.未出去;
                                    transferCom.ApplyId = entity.id;
                                    transferCom.Order = returnInfo.Order.Contains("GH") ? returnInfo.Order : returnInfo.Order.Replace("JY", "GH");
                                    transferCom.CreateTime = DateTime.Now;
                                    transferCom.UpdateTime = DateTime.Now;
                                    transferCom.ApplyId = returnInfo.Id;
                                    transferCom.ActionType = 2;
                                    transferCom.IsWork = false;
                                    List<CommonJpTransferDetailReality> RealitydetailsList = new List<CommonJpTransferDetailReality>();
                                    foreach (var item in borrowInfo.CommonJpTransferDetailRealities)
                                    {
                                        RealitydetailsList.Add(new CommonJpTransferDetailReality()
                                        {
                                            Id = Guid.NewGuid().ToString(),
                                            SizeId = item.SizeId,
                                            EquipmentDetailId = item.EquipmentDetailId,
                                            ReceivedWarehouseId = item.WarehouseId,
                                            RealityId = transferCom.Id,
                                            State = (int)CurrentState.未出去,
                                            EstimateId = entity.id,
                                            EquipmentCount = item.EquipmentCount,
                                            WarehouseId = borrowInfo.TransferWarehouse,
                                            SupplierId = item.SupplierId,

                                        });
                                    }

                                    transferCom.CommonJpTransferDetailRealities = RealitydetailsList;
                                }
                                if (flowState.Equals("true"))
                                {
                                    _unitOfWork.TransferRepository.Insert(transferCom, false);
                                }



                                bool result = _unitOfWork.TransferApplyRepository.Update(returnInfo, true);
                                if (result)
                                {

                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                }
                                else
                                {
                                    return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                }
                            }

                        }

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }
        /// <summary>
        /// 借用单转归还单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6",
        ///         "applyId":"归还发起人员ID"，
        ///         "applyName":"归还发起人员姓名",
        ///         "userType":"",
        ///         "userInfo":"",
        ///         "dataScope":"",
        ///         "nextStepId":"",
        ///         "currentStepName":"",
        ///         "flowType":"",
        ///         "flowName":"",
        ///         "orgId":"",
        ///         "note":"",
        ///         "flowState":""
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("TansferBorrowOrder")]
        public async Task<HttpResponseMessage> TansferBorrowOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"id is require");
                        }

                        else
                        {
                            var id = (string)(entity.id);
                            string processCurrentId = Guid.NewGuid().ToString();
                            var borrowInfo = _unitOfWork.DbContext.CommonJpTransferApplies.Include(p => p.CommonJpTransferDetailEstimates).Include(p => p.CommonJpTransfers).FirstOrDefault(t => t.Id == id);
                            string orderId = Guid.NewGuid().ToString();
                            var flowState = (string)(entity.flowState).ToLower();
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderId, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                             , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, borrowInfo.Order);

                            //新增数据
                            CommonJpTransferApply order = new CommonJpTransferApply()
                            {

                                Id = orderId,
                                ActionType = 2,//2表示归还
                                BorrowOrderId = id,
                                TransferId = borrowInfo.TargetId,
                                ApplyUser = entity.applyId,
                                ApplyUserName = entity.applyName,
                                CreateUser = entity.applyId,
                                TransferWarehouse = borrowInfo.CommonJpTransfers?.FirstOrDefault().ReceiveWarehouseId,
                                TargetId = borrowInfo.TransferId,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                ProcessCurrentId = processCurrentId,
                                Order = borrowInfo.Order.Replace("JY", "GH"),
                                UpdateTime = DateTime.Now
                            };
                            List<CommonJpTransferDetailEstimate> detailsList = new List<CommonJpTransferDetailEstimate>();
                            foreach (var item in borrowInfo.CommonJpTransferDetailEstimates)
                            {
                                detailsList.Add(new CommonJpTransferDetailEstimate()
                                {
                                    Id = Guid.NewGuid().ToString(),

                                    EquipmentDetailId = item.EquipmentDetailId,
                                    EstimateId = order.Id,
                                    EquipmentCount = item.EquipmentCount,

                                });

                            }
                            order.CommonJpTransferDetailEstimates = detailsList;
                            borrowInfo.CommonJpTransfers.FirstOrDefault().CurrentState = 3;

                            _unitOfWork.TransferApplyRepository.Update(borrowInfo, false);
                            bool result = _unitOfWork.TransferApplyRepository.Insert(order, true);
                            if (result)
                            {

                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }



                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

    }
}