﻿using JmpCommon;
using JmpCommon.Tools;
using JmpModel.Model;
using JmpModel.Model.Enumerates;
using JmpModel.Model.Repository;
using JunmpPoliceStation.App_Start;
using JunmpPoliceStation.Extensions;
using JunmpPoliceStation.Models.Repository;
using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.ChangeTracking.Internal;
using Microsoft.Extensions.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Linq.Expressions;
using System.Net.Http;
using System.Runtime.CompilerServices;
using System.Threading.Tasks;

namespace JunmpPoliceStation.Controllers
{
    /// <summary>
    /// 装备回库
    /// </summary>
    [ApiController]
    [Route("api/[controller]")]
    public class InventoryReturnController : ControllerBase
    {
        private ILogger<InventoryReturnController> _logger;
        UnitOfWork _unitOfWork;
        private static readonly object _lockObj = new object();
        public InventoryReturnController(ILogger<InventoryReturnController> logger, UnitOfWork unitOfWork)
        {
            _logger = logger;
            _unitOfWork = unitOfWork;
        }

        /// <summary>
        /// 获取装备回库申请单
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "page":0,
        ///         "size":10,
        ///         "orderCode":"", //订单号
        ///         "approveType":0,  //0待审核,1已完成,2已驳回,3全部
        ///         "action":0,
        ///         "applyId":"",
        ///         "startTime":"",
        ///         "endTime":"",
        ///         "warehouseId":"" 
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetPagedListOrder")]
        public async Task<HttpResponseMessage> GetPagedListOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        int.TryParse(entity.page, out int page);
                        int.TryParse(entity.size, out int size);
                        string applyId = entity.applyId ?? "";
                        string approvalId = entity.approvalId ?? "";
                        string startTime = entity.startTime;
                        string endTime = entity.endTime;
                        if (size == 0)
                        {
                            size = 10;
                        }
                        if (string.IsNullOrEmpty(applyId) && string.IsNullOrEmpty(approvalId))
                        {
                            return JsonManager.SimpleCustResponse("applyId or approvalId is require");
                        }

                        var param = new string[] {
                       "ProcessCurrent",
                       "ProcessCurrent.CommonJpProcessHistories",
                       "CommonJpInventoryReturnApplyDetails" ,
                       "Warehouse" ,
                       "CommonJpInventoryReturnApplyDetails.Equipment" ,
                       "CommonJpInventoryReturnApplyDetails.Size" ,
                       "CommonJpInventoryReturnApplyDetails.Supplier" ,
                    };

                        string orderCode = entity.orderCode ?? "";
                        string warehouseId = entity.warehouseId;
                        string actions = entity.action;
                        Expression<Func<CommonJpInventoryReturnApply, bool>> expression = t => t.ApplyId == applyId;
                        if (string.IsNullOrEmpty(actions))
                        {
                            return JsonManager.SimpleCustResponse("action is require");

                        }
                        if (!string.IsNullOrEmpty(warehouseId))
                        {
                            expression = expression.And(t => t.WarehouseId.Equals(warehouseId));
                        }
                        if (!string.IsNullOrEmpty(startTime) && !string.IsNullOrEmpty(endTime))
                        {
                            expression = expression.And(t => t.CreateTime >= Convert.ToDateTime(startTime) && t.CreateTime <= Convert.ToDateTime(endTime));
                        }
                        if (!string.IsNullOrEmpty(orderCode))
                        {
                            expression = expression.And(t => t.OrderCode.Contains(orderCode));
                        }

                        expression = expression.And(t => t.ProcessCurrent.FlowType.Equals(actions));

                        if (!string.IsNullOrEmpty(entity.approveType))
                        {
                            string approveType = entity.approveType;
                            if (approveType.Equals("0")) //0待审核,1已完成,2已驳回
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("false") && !string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                            else if (approveType.Equals("1"))
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("true"));
                            }
                            else if (approveType.Equals("2"))
                            {
                                expression = expression.And(t => t.ProcessCurrent.FlowState.Equals("false") && string.IsNullOrEmpty(t.ProcessCurrent.UserInfo));
                            }
                        }
                        var roleInfo = _unitOfWork.RoleRepository.GetList(p => true);

                        var applyList = _unitOfWork.InventoryReturnApplyRepository
                            .GetList(expression, null, false, param)
                            .OrderByDescending(p => p.ProcessCurrent.UpdateTime);
                        var applyValue = new
                        {
                            totalElements = applyList.Count(),
                            content = applyList.Skip(page * size).Take(size).ToList()
                        };

                        var data = applyValue?.content.Select(t => new
                        {
                            id = t.Id,
                            warehouseId = t.WarehouseId,
                            note = t.Note,
                            t.ProcessCurrent.UserInfo,
                            actionResult = t.ProcessCurrent?.CommonJpProcessHistories?.OrderBy(p => p.UpdateTime).FirstOrDefault()?.AuditUserId == applyId ? "0" : "1",
                            UserInfoName = string.IsNullOrEmpty(t.ProcessCurrent.UserInfo) ? "" : roleInfo.FirstOrDefault(p => p.Id.Equals(int.Parse(t.ProcessCurrent.UserInfo)))?.Name,
                            t.ProcessCurrent.UpdateTime,
                            t.ProcessCurrent.OrgId,
                            t.ProcessCurrent.NextStepId,
                            t.ProcessCurrent.CurrentStepName,
                            t.ProcessCurrent.DataScope,
                            t.ProcessCurrent.UserType,
                            t.ProcessCurrent.FlowType,
                            processActionType = t.ProcessCurrent.ActionType,
                            flowState = Convert.ToBoolean(t.ProcessCurrent.FlowState),
                            applyId = t.ApplyId,
                            applyTime = t.ApplyTime,
                            createTime = t.CreateTime,
                            warehouseName = t.Warehouse?.Name,
                            orderCode = t.OrderCode,
                            applyName = t.ApplyName,
                            historyList = t.ProcessCurrent?.CommonJpProcessHistories?.Select(x => new
                            {
                                x.Id,
                                x.OrgId,
                                x.StepName,
                                x.UpdateTime,
                                x.AuditUserId,
                                x.AuditMind,
                                x.AuditUserName
                            }).OrderByDescending(c => c.UpdateTime),
                            detailList = t.CommonJpInventoryReturnApplyDetails.Select(x => new
                            {
                                equipmentId = x.EquipmentId,
                                equipmentName = x.Equipment?.Name,
                                equipmentSizeId = x.SizeId,
                                equipmentSizeName = x.Size?.SizeName,
                                quantity = x.Quantity,
                                supplierId = x.SupplierId,
                                supplierName = x.Supplier?.Name,
                                typeId = x.Equipment?.EquipmentId,
                                id = x.Id,
                                x.Epc
                            }),

                        });


                        var content = new
                        {
                            applyValue?.totalElements,
                            content = data
                        };
                        return JsonManager.ReturnSuccessResponse(content);

                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }

                }
                catch (Exception ex)
                {

                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 获取装备回库订单详细信息
        /// </summary>
        /// <remarks>
        ///  ## 例子
        ///      {
        ///         "id":""
        ///      }
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetDetailById")]
        public async Task<HttpResponseMessage> GetDetailById([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity.id;


                        var param = new string[] {
                       "CommonJpProcessHistories",
                       "CommonJpInventoryReturnApplies",
                       "CommonJpInventoryReturnApplies.Warehouse" ,
                       "CommonJpInventoryReturnApplies.CommonJpInventoryReturnApplyDetails" ,
                       "CommonJpInventoryReturnApplies.CommonJpInventoryReturnApplyDetails.Equipment" ,
                       "CommonJpInventoryReturnApplies.CommonJpInventoryReturnApplyDetails.Size" ,
                       "CommonJpInventoryReturnApplies.CommonJpInventoryReturnApplyDetails.Supplier" ,

                    };
                        Expression<Func<CommonJpProcessCurrent, bool>> expression = p => p.OrderId.Equals(id) || p.CommonJpInventoryReturnApplies.Any(c => c.OrderCode.Equals(id));

                        var processCurrents = _unitOfWork.CommonJpProcessCurrentRepository.GetList(expression, null, false, param).ToList();
                        if (processCurrents.Count > 0)
                        {


                            var data = processCurrents.Select(t => new
                            {
                                type = 12,
                                t.NextStepId,
                                t.FlowType,
                                flowState = Convert.ToBoolean(t.FlowState),
                                t.UserInfo,
                                t.UserType,
                                t.DataScope,
                                processActionType = t.ActionType ?? "",
                                t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.OrgId,
                                t.UpdateTime,
                                t.CurrentStepName,
                                id = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Id,
                                warehouseId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.WarehouseId,
                                applyId = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyId,
                                applyName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyName,
                                applyTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyTime,
                                note = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Note,
                                createTime = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.CreateTime,
                                warehouseName = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.Warehouse?.Name,
                                t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.OrderCode,

                                actionResult = t.CommonJpProcessHistories?
                                    .OrderBy(p => p.UpdateTime)
                                    .FirstOrDefault()?
                                    .AuditUserId.Equals(t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.ApplyId) == true ? "0" : "1",


                                historyList = t.CommonJpProcessHistories?.Select(x => new
                                {
                                    x.Id,
                                    x.OrgId,
                                    x.StepName,
                                    x.UpdateTime,
                                    x.AuditUserId,
                                    AuditMind = x.AuditMind ?? "",
                                    x.AuditUserName
                                }).OrderByDescending(c => c.UpdateTime),
                                detailList = t.CommonJpInventoryReturnApplies?.FirstOrDefault()?.CommonJpInventoryReturnApplyDetails?.Select(x => new
                                {
                                    realityId = x.OrderId,
                                    equipmentId = x.Equipment?.Id,
                                    equipmentName = x.Equipment?.Name,
                                    equipmentSizeId = x.Size?.Id,
                                    equipmentSizeName = x.Size?.SizeName,
                                    quantity = x.Quantity,
                                    supplierId = x.Supplier?.Id,
                                    x.Epc,
                                    supplierName = x.Supplier?.Name,
                                })
                            }).FirstOrDefault();

                            return JsonManager.ReturnSuccessResponse(data);
                        }
                        else
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 新增/更新装备回库订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"", //新增可不填
        ///         "applyId":"",
        ///         "warehouseId":"",
        ///         "orgId":"",
        ///         "orgCode":"",
        ///         "applyName":"",
        ///         "note":"请求理由",//可为空
        ///         "detailList":[
        ///         {
        ///            "id":"",//新增可不填
        ///            "equipmentId":"",
        ///            "equipmentSizeId":"",
        ///            "quantity":"",
        ///            "supplierId":"",
        ///            "epc":""
        ///         }]
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("AddOrUpdateOrder")]
        //[NoSign]
        public async Task<HttpResponseMessage> AddOrUpdateOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        string id = entity?.id ?? "";
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.applyId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.applyName ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"applyName is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgCode ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgCode is require");
                        }
                        else if (string.IsNullOrEmpty(entity.warehouseId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"warehouseId is require");
                        }
                        else if (string.IsNullOrEmpty(entity.orgId ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"orgId is require");
                        }
                        else if (entity.detailList == null || entity.detailList.Count == 0)
                        {
                            return JsonManager.SimpleCustResponse($"detailList is require");
                        }
                        else if (!string.IsNullOrEmpty(id))
                        {
                            bool processResult = _unitOfWork.CheckProcess(id);
                            if (!processResult)
                            {
                                var order = _unitOfWork.DbContext.CommonJpInventoryReturnApplies
                                    .Include(t => t.CommonJpInventoryReturnApplyDetails)
                                    .FirstOrDefault(t => t.Id == id);
                                if (order == null)
                                {
                                    return JsonManager.SimpleCustResponse($"id:{id}数据不存在");
                                }
                                else
                                {
                                    _unitOfWork.ApproveMessage(order.Id);
                                    string flowState = (string)entity.flowState.ToLower();
                                    _unitOfWork.AuditProcess((string)entity.actionType, order.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                     (string)entity.currentStepName, flowState, (string)entity.note, (string)entity.applyId, (string)entity.applyName, (string)entity.orgId, "update");

                                    order.ApplyId = entity.applyId;
                                    order.ApplyTime = DateTime.Now;
                                    order.CreateTime = DateTime.Now;

                                    order.WarehouseId = entity.warehouseId;
                                    order.OrgId = entity.orgId;
                                    order.ApplyName = entity.applyName;
                                    order.Note = entity.note;


                                    List<string> tmpList = JsonManager.GetDetailIds(entity.detailList);
                                    //var tmpDetail = order.CommonJpInventoryReturnApplyDetails.Where(t => !tmpList.Contains(t.Id)).ToList();
                                    //for (int i = tmpDetail.Count - 1; i >= 0; i--)
                                    //{
                                    //    var tmp_dtl = tmpDetail.ElementAt(i);
                                    //    order.CommonJpInventoryReturnApplyDetails.Remove(tmp_dtl);
                                    //}

                                    //移除不在上传数据内数据
                                    order.CommonJpInventoryReturnApplyDetails = order
                                        .CommonJpInventoryReturnApplyDetails.Where(x => tmpList.Contains(x.Id))
                                        .ToList();

                                    foreach (var item in entity.detailList)
                                    {
                                        int.TryParse(item.quantity, out int qty);
                                        if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentId is require");
                                        }
                                        if (string.IsNullOrEmpty(item.epc ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("epc is require");
                                        }
                                        else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("supplierId is require");
                                        }
                                        else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                        {
                                            return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                        }
                                        else if (qty <= 0)
                                        {
                                            return JsonManager.SimpleCustResponse("quantity field error");
                                        }
                                        else
                                        {
                                            //新增明细
                                            if (string.IsNullOrEmpty(item.id ?? ""))
                                            {
                                                order.CommonJpInventoryReturnApplyDetails.Add(new CommonJpInventoryReturnApplyDetail()
                                                {
                                                    Id = Guid.NewGuid().ToString(),
                                                    EquipmentId = item.equipmentId,
                                                    SizeId = item.equipmentSizeId,
                                                    OrderId = order.Id,
                                                    Quantity = qty,
                                                    SupplierId = item.supplierId,
                                                    Epc = item.epc ?? ""

                                                });
                                            }
                                            else
                                            {
                                                var detail = order.CommonJpInventoryReturnApplyDetails.FirstOrDefault(t => t.Id == item.id);
                                                if (detail == null)
                                                {
                                                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                                                }
                                                else
                                                {
                                                    detail.EquipmentId = item.equipmentId;
                                                    detail.SizeId = item.equipmentSizeId;
                                                    detail.OrderId = order.Id;
                                                    detail.Quantity = qty;
                                                    detail.SupplierId = item.supplierId;
                                                    detail.Epc = item.epc ?? "";
                                                    detail.State = 0;
                                                }
                                            }
                                        }
                                    }

                                    bool result = _unitOfWork.InventoryReturnApplyRepository.Update(order, true);
                                    if (result)
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                                    }
                                }
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.ACCOUNT_IS_AUDITED);
                            }
                        }
                        else
                        {
                            string orderID = Guid.NewGuid().ToString();
                            string processCurrentId = Guid.NewGuid().ToString();
                            string flowState = (string)entity.flowState.ToLower();

                            string head_str = "HK";
                            string orderCode = $"{entity.orgCode}{head_str}{DateTime.Now.ToString("yyyyMMddHHmmss")}";
                            bool processResult = _unitOfWork.AddProcess(processCurrentId, orderID, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId, (string)entity.currentStepName
                                , (string)entity.flowType, (string)entity.flowName, (string)entity.flowId, flowState, (string)entity.orgId, (string)entity.note, (string)entity.applyId, (string)entity.applyName, orderCode);




                            //新增数据
                            var order = new CommonJpInventoryReturnApply()
                            {
                                ApplyId = entity.applyId,
                                ApplyTime = DateTime.Now,
                                CreateTime = DateTime.Now,
                                Note = entity.note,
                                WarehouseId = entity.warehouseId,
                                Id = orderID,
                                OrgId = entity.orgId,
                                ApplyName = entity.applyName,
                                ProcessCurrentId = processCurrentId,
                                OrderCode = orderCode
                            };


                            var detailsList = new List<CommonJpInventoryReturnApplyDetail>();
                            foreach (var item in entity.detailList)
                            {
                                int.TryParse(item.quantity, out int qty);
                                if (string.IsNullOrEmpty(item.equipmentId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentId is require");
                                }
                                else if (string.IsNullOrEmpty(item.epc ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("epc is require");
                                }
                                else if (string.IsNullOrEmpty(item.supplierId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("supplierId is require");
                                }
                                else if (string.IsNullOrEmpty(item.equipmentSizeId ?? ""))
                                {
                                    return JsonManager.SimpleCustResponse("equipmentSizeId is require");
                                }
                                else if (qty <= 0)
                                {
                                    return JsonManager.SimpleCustResponse("quantity field error");
                                }
                                else
                                {
                                    detailsList.Add(new CommonJpInventoryReturnApplyDetail()
                                    {
                                        Id = Guid.NewGuid().ToString(),
                                        EquipmentId = item.equipmentId,
                                        SizeId = item.equipmentSizeId,
                                        OrderId = order.Id,
                                        Quantity = qty,
                                        SupplierId = item.supplierId,
                                        Epc = item.epc ?? "",
                                        State = 0
                                    });
                                }
                            }

                            order.CommonJpInventoryReturnApplyDetails = detailsList;

                            if (flowState == "true")
                            {
                                order.CurrentState = flowState == "true" ? 1 : 0;
                                //更新子表状态
                                foreach (var detail in order.CommonJpInventoryReturnApplyDetails)
                                {
                                    detail.State = 1;
                                    //生成流水表
                                    GenerateState(order.OrderCode, detail.Epc, detail.Id, order.WarehouseId, order.OrgId, order.ApplyId);
                                }
                                //反写库存状态
                                UpdateInvState(order.CommonJpInventoryReturnApplyDetails?.Select(x => x.Epc).ToList(), order.OrderCode, order.WarehouseId);

                            }

                            bool result = _unitOfWork.InventoryReturnApplyRepository.Insert(order, true);

                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 删除装备回库订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "id":"",
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("DeleteOrder")]
        public async Task<HttpResponseMessage> DeleteOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else if (string.IsNullOrEmpty(entity.id ?? ""))
                        {
                            return JsonManager.SimpleCustResponse("id is require");
                        }
                        string id = entity.id ?? "";
                        var order = _unitOfWork.DbContext.CommonJpInventoryReturnApplies.FirstOrDefault(t => t.Id == id);
                        if (order == null)
                        {
                            return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                        }
                        else
                        {
                            var detailList = _unitOfWork.InventoryReturnApplyDetailRepository
                                .GetList(x => x.OrderId == order.Id)
                                .ToList();
                            _unitOfWork.InventoryReturnApplyDetailRepository.Delete(detailList, false);

                            bool result = _unitOfWork.InventoryReturnApplyRepository.Delete(order, true);
                            if (result)
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_SUCCESS);
                            }
                            else
                            {
                                return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.REQUEST_DATA_ERROR);
                    }
                }

                catch (Exception ex)
                {
                    //_logger.LogError("Login/SignIn 错误:" + ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 审批装备回库订单
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///         "idList":[{id:"99a776d7-f9ae-40f8-87e2-be4fa5eb42c6"}],
        ///         "orgId":"0002EEA3-CC53-4BD8-A970-B18407AF9CCC",
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("ApproveOrder")]
        public async Task<HttpResponseMessage> ApproveOrder([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {
                        lock (_lockObj)
                        {
                            var entity = JsonManager.GetJsonEntity(jdata);
                            if (entity == null)
                            {
                                return JsonManager.SimpleCustResponse($"model is null");
                            }
                            else if (string.IsNullOrEmpty(entity.id ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"id is require");
                            }
                            else if (string.IsNullOrEmpty(entity?.flowState ?? ""))
                            {
                                return JsonManager.SimpleCustResponse($"flowState is require");
                            }
                            else
                            {

                                string id = entity.id ?? "";
                                if (string.IsNullOrEmpty(id))
                                {
                                    return JsonManager.SimpleCustResponse($"id is require");
                                }
                                var orderInfo = _unitOfWork.DbContext.CommonJpInventoryReturnApplies
                                    .Include(t => t.CommonJpInventoryReturnApplyDetails)
                                    .FirstOrDefault(t => t.Id == id);
                                var flowState = (string)(entity.flowState).ToLower();
                                if (orderInfo == null)
                                {
                                    return JsonManager.SimpleCustResponse("invalid id");
                                }
                                else
                                {
                                    bool processResult = _unitOfWork.CheckProcess(orderInfo.Id);
                                    if (processResult)
                                    {
                                        _unitOfWork.ApproveMessage(orderInfo.Id);
                                        _unitOfWork.AuditProcess((string)entity.actionType, orderInfo.Id, (string)entity.userType, (string)entity.userInfo, (string)entity.dataScope, (string)entity.nextStepId,
                                         (string)entity.currentStepName, flowState, (string)entity.approvalMsg, (string)entity.auditUser, (string)entity.auditUserName, (string)entity.orgId, "approve");
                                        orderInfo.ApprovalTime = DateTime.Now;

                                        if (flowState == "true")
                                        {
                                            orderInfo.CurrentState = flowState == "true" ? 1 : 0;
                                            //更新子表状态
                                            foreach (var detail in orderInfo.CommonJpInventoryReturnApplyDetails)
                                            {
                                                detail.State = 1;
                                                //生成流水表
                                                GenerateState(orderInfo.OrderCode, detail.Epc, detail.Id, orderInfo.WarehouseId, orderInfo.OrgId, orderInfo.ApplyId);
                                            }
                                            //反写库存状态
                                            UpdateInvState(orderInfo.CommonJpInventoryReturnApplyDetails?.Select(x => x.Epc).ToList(), orderInfo.OrderCode, orderInfo.WarehouseId);

                                        }

                                        //更新审批状态
                                        bool result = _unitOfWork.InventoryReturnApplyRepository.Update(orderInfo, true);
                                        if (!result)
                                        {
                                            return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                        }
                                        else
                                        {
                                            //报废成功，重新计算阈值
                                            var sizeList = orderInfo.CommonJpInventoryReturnApplyDetails
                                                .Select(x => x.SizeId)
                                                .ToList();
                                            _unitOfWork.CalcThreshold(sizeList, orderInfo.OrgId, orderInfo.WarehouseId);
                                            return JsonManager.ReturnSuccessResponse(new
                                            {
                                                orderCode = orderInfo.OrderCode
                                            });
                                        }
                                    }
                                    else
                                    {
                                        return JsonManager.SimpleStatusResponse(ResultCode.APPROVE_ERROR);
                                    }
                                }
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleCustResponse($"invalid parameter");
                    }

                }
                catch (Exception ex)
                {

                    _logger.LogError(ex.ToString());
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }

        /// <summary>
        /// 根据EPC获取物资信息
        /// </summary>
        /// <remarks>
        /// ## 例子
        /// 
        ///     {
        ///        "epc":"xxx-xxx-xxx-xxx"
        ///     }
        /// 
        /// </remarks>
        /// <param name="jdata"></param>
        /// <returns></returns>
        [HttpPost("GetWzByEpc")]
        public async Task<HttpResponseMessage> GetWzByEpc([FromBody] JObject jdata)
        {
            return await Task.Run(() =>
            {
                try
                {
                    if (jdata != null)
                    {

                        var entity = JsonManager.GetJsonEntity(jdata);
                        if (entity == null)
                        {
                            return JsonManager.SimpleCustResponse($"model is null");
                        }
                        else if (string.IsNullOrEmpty(entity.epc ?? ""))
                        {
                            return JsonManager.SimpleCustResponse($"epc is require");
                        }
                        else
                        {
                            string epc = entity.epc ?? "";

                            //8:领用 7:单警柜出库中 3:单警柜中
                            var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories
                                .Include(t => t.SupplierCodeNavigation)
                                .Include(t => t.EquipmentCodeNavigation)
                                .Include(t => t.EquipmentCodeNavigation.Equipment)
                                .Include(t => t.EquipmentSizecodeNavigation)
                                .Include(t => t.WarehouseCodeNavigation)
                                .FirstOrDefault(t => t.Epc.Equals(epc)
                                && (t.CurrentState == 8 || t.CurrentState == 7 || t.CurrentState == 3)
                                && (t.LostFlag == false || t.LostFlag == null));
                            if (wz_info == null)
                            {
                                return JsonManager.SimpleCustResponse("未找到物资信息");
                            }
                            else
                            {
                                var data = new
                                {
                                    equipmentId = wz_info.EquipmentCode,
                                    equipmentName = wz_info.EquipmentCodeNavigation?.Name,
                                    typeId = wz_info.EquipmentCodeNavigation?.EquipmentId,
                                    typeName = wz_info.EquipmentCodeNavigation?.Equipment?.Name,
                                    equipmentSizeId = wz_info.EquipmentSizecode,
                                    equipmentSizeName = wz_info.EquipmentSizecodeNavigation?.SizeName,
                                    supplierId = wz_info.SupplierCode,
                                    supplierName = wz_info.SupplierCodeNavigation?.Name,
                                    epc = wz_info.Epc,
                                    warehouseId = wz_info.WarehouseCode,
                                    warehouseName = wz_info.WarehouseCodeNavigation?.Name,
                                    orgId = wz_info.OrgId
                                };
                                return JsonManager.ReturnSuccessResponse(data);
                            }
                        }
                    }
                    else
                    {
                        return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                    }
                }
                catch (Exception ex)
                {
                    return JsonManager.SimpleStatusResponse(ResultCode.OPERATE_FAILED);
                }
            });
        }


        private bool GenerateState(string orderCode, string epc, string detailId, string warehouseId, string orgId, string applyId)
        {
            var invInfo = _unitOfWork.DbContext.CommonJpEquipmentInventories.FirstOrDefault(t => t.Epc.Contains(epc));
            if (invInfo != null)
            {
                CommonJpEquipmentState equState = new CommonJpEquipmentState()
                {
                    OrderCode = orderCode,
                    Id = Guid.NewGuid().ToString(),
                    State = 1,
                    ActionState = 19,   //回库
                    EqiupmentId = invInfo.Id,
                    OutInState = 1,     //1：入库
                    ReturnId = detailId,
                    WarehouseId = warehouseId,
                    CreateTime = DateTime.Now,
                    OrgId = orgId,
                    OutTime = DateTime.Now,
                    PoliceId = _unitOfWork.DbContext.CommonJpUsers.FirstOrDefault(x => x.Id == applyId)?.PoliceId
                };
                _unitOfWork.DbContext.CommonJpEquipmentStates.Add(equState);
                return true;
            }
            else
            {
                return false;
            }
        }

        private void UpdateInvState(List<string> epcList, string orderCode, string warehouseId)
        {
            if (epcList == null || epcList.Count == 0)
            {
                _logger.LogError($"[装备回库]未找到回库单明细，{orderCode}");
            }
            var wz_info = _unitOfWork.DbContext.CommonJpEquipmentInventories.Where(t => epcList.Contains(t.Epc)).ToList();
            if (wz_info.Count > 0)
            {
                wz_info.ForEach(x =>
                {
                    x.CurrentState = 0;
                    x.EquipmentLocation = 0;
                    x.CabinetId = null;
                    x.PoliceCode = null;
                    x.WarehouseCode = warehouseId;
                    _unitOfWork.EquipmentInventoryRepository.Update(x, false);
                });

            }
        }
    }
}
