﻿using LibUsbDotNet;
using LibUsbDotNet.Main;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using System.Threading;

namespace JmpPrintService
{
    public class USBPrint
    {
        //UsbRegDeviceList allDevices = UsbDevice.AllDevices;//获取全部USB设备
        private Dictionary<string, ushort> dic_device = new Dictionary<string, ushort>();
        private UsbDeviceFinder usbFinder;
        private UsbDevice usbDevice;
        private UsbEndpointWriter writer;
        private UsbEndpointReader reader;
        //ErrorCode ecWrite;
        //ErrorCode ecRead;
        public static Queue<string> PrintMsg = new Queue<string>();
        public static int ReadFlag = 0;//读写标志
        public static int PrintFlag = 0;//打印标志
        /// <summary>
        /// 初始化打印程序
        /// </summary>
        /// <returns></returns>
        public bool Init()
        {
            try
            {
                //获取斑马打印机连接
                dic_device = UsbBaseWMI.GetAllUsbDevInfo();
                if (dic_device.Count > 0)
                {

                    UsbRegDeviceList mRegDevices = UsbDevice.AllDevices;
                    usbFinder = new UsbDeviceFinder(dic_device["VID"], dic_device["PID"]);
                    this.usbDevice = UsbDevice.OpenUsbDevice(usbFinder);//打开斑马打印机

                    Guid deviceID = new Guid();
                    UsbDevice.OpenUsbDevice(ref deviceID, out UsbDevice usbDevice);
                    IUsbDevice wholeUsbDevice = this.usbDevice as IUsbDevice;
                    if (!ReferenceEquals(wholeUsbDevice, null))
                    {
                        //这是一个“完整的”USB设备。在使用之前，
                        //必须选择所需的配置和接口。
                        //选择config #1
                        wholeUsbDevice.SetConfiguration(1);

                        // 接口地址重置 #0
                        wholeUsbDevice.ClaimInterface(0);
                    }
                    if (this.usbDevice != null)
                    {
                        writer = this.usbDevice.OpenEndpointWriter(WriteEndpointID.Ep01);
                        reader = this.usbDevice.OpenEndpointReader(ReadEndpointID.Ep02);

                        reader.DataReceivedEnabled = true;
                        reader.DataReceived += OnDataReceived;
                        bool result = this.usbDevice.Open();

                        return result;
                    }
                    else
                    {
                        return false;
                    }
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }

        private void OnDataReceived(object sender, EndpointDataEventArgs e)
        {
            try
            {
                if (ReadFlag.Equals(1))
                {
                    string res_msg = Encoding.Default.GetString(e.Buffer);
                    string de_msg = System.Text.RegularExpressions.Regex.Replace(res_msg, @"[^0-9]+", "");
                    PrintMsg.Enqueue(de_msg);
                }
                //byte[] readBuffer = new byte[1024];
                //int bytesRead;
                //while (ReadFlag.Equals(1))
                //{
                //    ecRead = reader.Read(readBuffer, 5000, out bytesRead);
                //    if (bytesRead > 0)
                //    {
                //        string ReturnMsg = Encoding.Default.GetString(readBuffer);
                //        string result = System.Text.RegularExpressions.Regex.Replace(ReturnMsg, @"[^0-9]+", "");
                //        PrintMsg.Enqueue(result);
                //        readBuffer = new byte[1024];
                //    }
                //    if (ecRead != ErrorCode.None)
                //    {
                //        if (ecRead.Equals(ErrorCode.IoTimedOut))
                //        {
                //            continue;
                //        }
                //        else
                //        {
                //            PrintMsg.Enqueue("logout");
                //            break;
                //        }

                //    }

                //    //WaitHandle.WaitAll(new WaitHandle[] { usbReadTransfer.AsyncWaitHandle }, 200, false);
                //}
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public void SetReadFlag()
        {
            ReadFlag = 1;
        }
        //private List<byte> buffer = new List<byte>(4096);//默认分配1页内存

        ///// <summary>
        /////开始读取打印数据
        ///// </summary>
        //public void StartRead()
        //{
        //    try
        //    {
        //        byte[] readBuffer = new byte[1024];
        //        int bytesRead;
        //        while (ReadFlag.Equals(1))
        //        {
        //            ecRead = reader.Read(readBuffer, 5000, out bytesRead);
        //            if (bytesRead > 0)
        //            {
        //                string ReturnMsg = Encoding.Default.GetString(readBuffer);
        //                string result = System.Text.RegularExpressions.Regex.Replace(ReturnMsg, @"[^0-9]+", "");
        //                PrintMsg.Enqueue(result);
        //                readBuffer = new byte[1024];
        //            }
        //            if (ecRead != ErrorCode.None)
        //            {
        //                if (ecRead.Equals(ErrorCode.IoTimedOut))
        //                {
        //                    continue;
        //                }
        //                else
        //                {
        //                    PrintMsg.Enqueue("logout");
        //                    break;
        //                }

        //            }

        //            //WaitHandle.WaitAll(new WaitHandle[] { usbReadTransfer.AsyncWaitHandle }, 200, false);
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
        //    }
        //    //ecRead = usbReadTransfer.Wait(out transferredIn);
        //}

        /// <summary>
        /// 发送打印机指令
        /// </summary>
        /// <param name="SendText"></param>
        /// <returns></returns>
        public bool SendMsg(string SendText)
        {
            try
            {
                byte[] temp = System.Text.ASCIIEncoding.Default.GetBytes(SendText);
                char[] temp2 = System.Text.Encoding.GetEncoding("GB18030").GetChars(temp);
                Byte[] data = System.Text.Encoding.GetEncoding("GB18030").GetBytes(temp2);
                ErrorCode ec = ErrorCode.None;
                UsbTransfer usbWriteTransfer;

                ec = writer?.SubmitAsyncTransfer(data, 0, data.Length, 100, out usbWriteTransfer) ?? ErrorCode.None;
                Thread.Sleep(2000);
                if (ec != ErrorCode.None)
                {
                    ReadFlag = 0;
                    return false;
                    //throw new Exception("打印机发送指令失败.");
                }
                else
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }
        /// <summary>
        /// 停止打印程序
        /// </summary>
        public void StopPrint()
        {
            ReadFlag = 0;
            Thread.Sleep(500);
            if (usbDevice != null)
            {
                if (usbDevice?.IsOpen ?? false)
                {
                    usbDevice?.Close();
                }
            }
            else
            {
                usbDevice = null;
            }


        }
        public void Send()
        {

            try
            {
                string sSendText = "^XA" +

                                    "^JMA^LL200^PW680^MD10^PR2^PON^LRN^LH0,0" +
                                    "^FO10,30" +
                                    "^A0N,72,72" +
                                    "^FD Hello World!^FS" +
                                    "^XZ";
                byte[] temp = System.Text.ASCIIEncoding.Default.GetBytes(sSendText);
                Char[] temp2 = System.Text.Encoding.GetEncoding("GB18030").GetChars(temp);
                Byte[] data = System.Text.Encoding.GetEncoding("GB18030").GetBytes(temp2);
                ErrorCode ec = ErrorCode.None;
                UsbTransfer usbWriteTransfer;
                ec = writer.SubmitAsyncTransfer(data, 0, data.Length, 100, out usbWriteTransfer);
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }

        //打印机可用状态集合
        //public enum enum_printerS_status
        //{
        //    / <summary>
        //    / 故障
        //    / </summary>
        //    warn = 0,
        //    / <summary>
        //    / 打印中
        //    / </summary>
        //    print,
        //    / <summary>
        //    / 空闲中
        //    / </summary>
        //    ready,
        //    / <summary>
        //    / 其他状态
        //    / </summary>
        //    other
        //}
    }
}
