﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LocalPrint
{
    public class PrintInfo
    {
        /// <summary>
        /// 停止位
        /// </summary>
        private System.IO.Ports.StopBits _stopBits = System.IO.Ports.StopBits.One;

        /// <summary>
        /// 检验位
        /// </summary>
        private System.IO.Ports.Parity _checkBits = System.IO.Ports.Parity.None;

        /// <summary>
        /// 流控制
        /// </summary>
        private System.IO.Ports.Handshake _flowControl = System.IO.Ports.Handshake.None;

        /// <summary>
        /// 波特率
        /// </summary>
        private int _baudRate = 115200;

        /// <summary>
        /// 数据位
        /// </summary>
        private int _dataBits = 8;

        /// <summary>
        /// 串口名称
        /// </summary>
        private string _portName = "COM4" +
            "";

        /// <summary>
        /// 串口类
        /// </summary>
        public System.IO.Ports.SerialPort sSerialPort = new System.IO.Ports.SerialPort();

        /// <summary>
        /// 连接Com口
        /// </summary>
        /// <param name="isSuccess"></param>
        /// <param name="msg"></param>
        public void OpenComm(ref bool isSuccess, ref String msg)
        {
            try
            {
                if (this.sSerialPort.IsOpen)
                {
                    this.sSerialPort.Close();
                }
                //设置参数打开串口信息
                this.sSerialPort.PortName = "COM4";
                //波特率
                this.sSerialPort.BaudRate = this._baudRate;
                //数据位
                this.sSerialPort.DataBits = this._dataBits;
                //停止位
                this.sSerialPort.StopBits = this._stopBits;
                //检验位
                this.sSerialPort.Parity = this._checkBits;
                //流控制
                this.sSerialPort.Handshake = this._flowControl;

                this.sSerialPort.Open();
                if (this.sSerialPort.IsOpen)
                {
                    isSuccess = true;
                    msg = ("串口打开成功!");
                }
                else
                {
                    isSuccess = false;
                }
            }
            catch (Exception ex)
            {
                isSuccess = false;
                msg = ("请确保打印机连接正常.Error:" + ex.Message);
            }
        }

        /// <summary>
        /// 关闭连接
        /// </summary>
        /// <param name="isSuccess"></param>
        /// <param name="msg"></param>
        public void CloseComm(ref bool isSuccess, ref string msg)
        {
            try
            {
                if (this.sSerialPort == null)
                {
                    msg = ("无对应的串口信息!");
                    isSuccess = false;
                }
                if (this.sSerialPort.IsOpen)
                {
                    this.sSerialPort.Close();
                    msg = ("串口关闭成功!");
                    isSuccess = true;
                }
            }
            catch (Exception ex)
            {
                isSuccess = false;
                msg = ("请联系管理员.Error:" + ex.Message);
            }
        }

        /// <summary>
        /// 发送打印指令
        /// </summary>
        /// <param name="sSendText"></param>
        /// <param name="isSuccess"></param>
        /// <param name="msg"></param>
        public void SendPrintCmd(string sSendText, ref bool isSuccess, ref String msg)
        {
            try
            {
                if (this.sSerialPort == null)
                {
                    msg = ("无串口信息!");
                    isSuccess = false;
                    return;
                }
                if (!this.sSerialPort.IsOpen)
                {
                    msg = ("串口没有打开!");
                    isSuccess = false;
                    return;
                }
                byte[] temp = System.Text.ASCIIEncoding.Default.GetBytes(sSendText);
                Char[] temp2 = System.Text.Encoding.GetEncoding("GB18030").GetChars(temp);
                Byte[] data = System.Text.Encoding.GetEncoding("GB18030").GetBytes(temp2);
                this.sSerialPort.Write(data, 0, data.Length);
            }
            catch (Exception ex)
            {
                msg = ("btn_Send_Click.Error:" + ex.Message);
                isSuccess = false;
            }
        }
    }
}
