﻿using LiteDB;
using System.Collections.Generic;
using System.Linq;

namespace JmpPrintService.DBContent
{
    public static class ReadDB
    {
        /// <summary>
        /// 获取数据库路径
        /// </summary>
        /// <returns></returns>
        public static string Path()
        {
            var path = System.IO.Path.GetFullPath(
                System.AppDomain.CurrentDomain.BaseDirectory +
                string.Format("/litedb-{0}.db", "litedb-2f6d864e-7f00-412d-aa5d-58593ad2f15d"));
            return path;
        }
        /// <summary>
        /// 增加
        /// </summary>
        /// <typeparam name="tb_Batch"></typeparam>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static int SaveTPrintInfo<T>(T type, string dbName) where T : new()
        {
            using (var db = new LiteDatabase(Path()))
            {
                var col = db.GetCollection<T>(dbName);
                var value = col.Insert(type);
                return value.AsInt32;
            }
        }
        /// <summary>
        /// 更新信息(泛型通用)
        /// </summary>
        /// <typeparam name="tb_Batch"></typeparam>
        /// <param name="obj"></param>
        /// <returns></returns>
        public static bool UpdateBatch<T>(T type, string dbName) where T : new()
        {
            using (var db = new LiteDatabase(Path()))
            {
                var col = db.GetCollection<T>(dbName);
                var success = col.Update(type);
                return success;
            }
        }


        /// <summary>
        /// 删除信息(泛型通用)
        /// </summary>
        /// <param name="docId"></param>
        /// <returns></returns>
        public static bool DeleteBatch<T>(int docId, string dbName)
        {
            // Open data file (or create, if not exits)
            using (var db = new LiteDatabase(Path()))
            {
                // Get a collectoin (or create, if not exits)
                var col = db.GetCollection<T>(dbName);
                var success = col.Delete(docId);
                return success;
            }
        }

        /// <summary>
        /// 获取全部信息(泛型通用)
        /// </summary>
        /// <returns></returns>
        public static List<T> GetBatch<T>(string dbName)
        {
            using (var db = new LiteDatabase(Path()))
            {
                var col = db.GetCollection<T>(dbName);
                var data = col.FindAll();
                List<T> batchList = data.ToList<T>();
                return batchList;
            }
        }
    }
}
