﻿using JmpZbModel;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JmpPrintService.Basic
{
    public static class PrintCache
    {
        public static string ComPort { get; set; } = "COM1";
        private static object msgObj = new object();
        private static object epcObj = new object();
        //private static Queue<PrintMessage> PrintMsg { get; set; } = new Queue<PrintMessage>();
        private static Queue<string> EpcMsg { get; set; } = new Queue<string>();
        //public static void EnPrintMsg(PrintMessage strMsg)
        //{
        //    lock (msgObj)
        //    {
        //        PrintMsg?.Enqueue(strMsg);
        //    }
        //}
        //public static PrintMessage DePrintMsg()
        //{
        //    lock (msgObj)
        //    {
        //        return PrintMsg?.Dequeue();
        //    }
        //}

        public static void EnTagMsg(string strMsg)
        {
            lock (epcObj)
            {
                EpcMsg?.Enqueue(strMsg);
            }
        }
        public static string DeTagMsg()
        {
            lock (epcObj)
            {
                if (EpcMsg.Count > 0)
                {
                    return EpcMsg?.Dequeue();
                }
                else { return ""; }
            }
        }

        public static void ClearTagMsg()
        {
            lock (epcObj)
            {
                 EpcMsg?.Clear();
            }
        }

        //public static int PrintMsgCount()
        //{
        //    lock (msgObj)
        //    {
        //        return PrintMsg?.Count ?? 0;
        //    }
        //}
        public static int EpcMsgCount()
        {
            lock (epcObj)
            {
                return EpcMsg?.Count ?? 0;
            }
        }

    }
    public class TagInfo
    {
        public string Content { get; set; }
        public MessageType Type { get; set; }
    }
}
