﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using ZXing;
using ZXing.QrCode;

namespace JmpZbService.Basic
{
    public static class CommonHelper
    {
        private static List<string> listNo1 = new List<string>() { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?" };

        public static string PhotoImageInsert(string strText)
        {
            string strInfo = "";
            //设置QR二维码的规格  
            QrCodeEncodingOptions option = new QrCodeEncodingOptions();
            //设置编码格式，否则中文乱码  
            option.CharacterSet = "UTF-8";
            //设置宽和高  
            option.Height = 250;
            option.Width = 250;

            //设置周围空白边距  
            option.Margin = 1;
            BarcodeWriter writer = new BarcodeWriter();
            //二维码  
            writer.Format = BarcodeFormat.QR_CODE;
            writer.Options = option;

            //生成二维码  
            Bitmap image = writer.Write(strText);
            byte[] byte1 = ConvertTo1Bpp1(image, 1);

            string s = "";
            int n = 0;
            //打印机图片点阵宽度
            int d = ((image.Width + 7) / 8) * 8;
            for (int j = 0; j < image.Height; j++)
            {
                for (int i = 0; i < d; i++)
                {
                    if (i >= image.Width)
                    {
                        s += "0";
                    }
                    else
                    {
                        s += byte1[j * image.Width + i].ToString();
                    }
                    if (n == 3)
                    {
                        int xjDenary = Convert.ToInt32(s, 2);
                        strInfo += listNo1[xjDenary];
                        n = 0;
                        s = "";
                    }
                    else
                    {
                        n++;
                    }
                }
            }
            return strInfo;
        }



        public static string Image2String(Bitmap bitmap)
        {
            //生成二维码  
            byte[] byte1 = ConvertTo1Bpp1(bitmap, 1);

            string s = "";
            string strInfo = "";
            int n = 0;
            //打印机图片点阵宽度
            int d = ((bitmap.Width + 7) / 8) * 8;
            for (int j = 0; j < bitmap.Height; j++)
            {
                for (int i = 0; i < d; i++)
                {
                    if (i >= bitmap.Width)
                    {
                        s += "0";
                    }
                    else
                    {
                        s += byte1[j * bitmap.Width + i].ToString();
                    }
                    if (n == 3)
                    {
                        int xjDenary = Convert.ToInt32(s, 2);
                        strInfo += listNo1[xjDenary];
                        n = 0;
                        s = "";
                    }
                    else
                    {
                        n++;
                    }
                }
            }
            return strInfo;
        }

        /// <summary>
        /// 图像二值化1：取图片的平均灰度作为阈值，低于该值的全都为0，高于该值的全都为255
        /// </summary>
        /// <param name="bmp">原图</param>
        /// <param name="nType">放到倍数</param>
        /// <returns></returns>
        private static byte[] ConvertTo1Bpp1(Bitmap bmp, int nType)
        {
            byte[] b = new byte[(bmp.Width * bmp.Height)];

            for (int i = 0; i < bmp.Width; i++)
            {
                for (int j = 0; j < bmp.Height; j++)
                {
                    //获取该点的像素的RGB的颜色
                    Color color = bmp.GetPixel(i, j);
                    //Color newColor = value > average ? Color.FromArgb(0, 0, 0) : Color.FromArgb(255, 255, 255);
                    b[j * bmp.Width + i] = (new byte[] { color.R, color.G, color.B }).Max() > 60 ? (byte)0 : (byte)1;
                    //bmp.SetPixel(i, j, newColor);
                }
            }
            return b;
        }


    }
}
