﻿using JmpPrintService.Model;
using RJCP.IO.Ports;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace JmpPrintService.Basic
{
    public class ComConnect : ConnectBase
    {
        protected SerialPortStream serialPort = null;
        private Action<byte[]> onAnalysisReciveMsg;
        public ComConnect(Action<byte[]> onAnalysisReciveMsg, int baudRate = 115200)
        {
            serialPort = new SerialPortStream(PrintCache.ComPort, baudRate, 8, Parity.None, StopBits.One);
            serialPort.Handshake = Handshake.None;
            serialPort.RtsEnable = true;
            serialPort.DataReceived += new EventHandler<SerialDataReceivedEventArgs>(OnReviceData);
            serialPort.ErrorReceived += OnErrorReceived;
            serialPort.PinChanged += OnPinChanged;
            this.onAnalysisReciveMsg = onAnalysisReciveMsg;
        }

        private void OnPinChanged(object sender, SerialPinChangedEventArgs e)
        {

        }

        private void OnErrorReceived(object sender, SerialErrorReceivedEventArgs e)
        {

        }

        /// <summary>
        ///开始读取打印数据
        /// </summary>
        protected void OnReviceData(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {
                if (!serialPort.IsOpen)
                {
                    return;
                }
                else
                {
                    //Thread.Sleep(500);
                    int src_len = serialPort.BytesToRead;//数据长度
                    byte[] buffer = new byte[src_len];//声明一个临时数组，存储当前来的串口数据
                    serialPort.Read(buffer, 0, src_len);//读取缓冲数据
                    onAnalysisReciveMsg?.BeginInvoke(buffer, default, default);
                    serialPort.Flush();
                }

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }

        }

        /// <summary>
        /// 打开Com口
        /// </summary>
        /// <param name="isSuccess"></param>
        /// <param name="msg"></param>
        public override bool Connection()
        {
            try
            {
                if (serialPort.IsOpen)
                {
                    serialPort.Close();
                }

                //serialPort.ReadTimeout = 2000;
                serialPort.Open();

                if (serialPort.IsOpen)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }

        /// <summary>
        /// 断开串口连接
        /// </summary>
        /// <returns></returns>
        public override bool DisConnection()
        {
            try
            {
                if (serialPort == null)
                {
                    return true;
                }
                if (serialPort.IsOpen)
                {
                    serialPort.Close();
                    return true;
                }

                return false;

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }

        /// <summary>
        /// 发送指令
        /// </summary>
        /// <param name="sSendText"></param>
        /// <returns></returns>
        public override bool SendMsg(string sSendText)
        {
            try
            {
                if (serialPort == null)
                {
                    return false;
                }
                if (!serialPort.IsOpen)
                {
                    return false;
                }

                byte[] tmp1 = System.Text.Encoding.Default.GetBytes(sSendText);
                serialPort.Write(tmp1, 0, tmp1.Length);
                return true;

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
                return false;
            }
        }


    }

}
