﻿using JmpPrintService.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JmpPrintService.Basic
{
    public class CmdAnalysis
    {
        protected PrintState PrintState { get; set; }
        public PrintState GetPrintState()
        {
            return PrintState;
        }
        public void SetPrintState(PrintState state)
        {
            this.PrintState = state;
        }
        public void ToshibaSerialportMsg(byte[] buffers)
        {
            List<byte> bufferList = new List<byte>();
            StringBuilder builderList = new StringBuilder();
            List<string> resultList = new List<string>();
            bufferList.AddRange(buffers);
            #region 数据完整性判断
            //至少要包含头尾 01 02  03 04 0D 0A
            while (bufferList.Count >= 6)
            {
                #region 查找数据头尾
                if (bufferList[0] == 0x01 && bufferList[1] == 0x02)
                {
                    //找到头
                    for (int i = 2; i < bufferList.Count - 3; i++)
                    {
                        if (bufferList[i] == 0x03 && bufferList[i + 1] == 0x04 && bufferList[i + 2] == 0x0D && bufferList[i + 3] == 0x0A)
                        {//找到尾
                            for (int j = 2; j < i; j++)
                            {
                                builderList.Append(bufferList[j].ToString("X2"));
                            }

                            resultList.Add(builderList.ToString());
                            builderList.Clear();
                            bufferList.RemoveRange(0, i + 4);
                        }
                    }
                }
                else
                {
                    bufferList.RemoveAt(0);
                }
                #endregion

            }

            #endregion


            foreach (string item in resultList)
            {
                string str_normal_head = item.ToString().Substring(0, 1);
                string str_tag_head = item.ToString().Substring(0, 2);
                string str_msg_ontent = string.Empty;
                string str_msg_code = string.Empty;
                var sss = item.ToString().Substring(0, 4);
                Log.WorkLog(item, "cmd");
                JmpZbModel.MessageType messageType = JmpZbModel.MessageType.无;
                if (str_normal_head == "3")
                {
                    string str_status_src = item.ToString().Substring(0, 4);
                    var str_status_vle = str_status_src.Substring(1, 1) + str_status_src.Substring(3, 1);
                    switch (str_status_vle)
                    {
                        case "00":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.正常;
                                break;
                            }
                        case "01":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印头未关闭";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "02":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.正常;
                                break;
                            }
                        case "04":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "PAUSE ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "05":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.正常;
                                break;
                            }
                        case "06":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "指令错误";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "07":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "COMMS ERROR";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "11":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印机卡纸";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "12":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "CUTTER ERROR ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "13":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印机缺纸";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "14":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印机无碳带";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "15":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印头未关闭 ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "17":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "HEAD ERROR ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "18":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "EXCESS HEAD TEMP";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "21":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "打印机碳带异常 ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "22":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "REWIND FULL ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "23":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "REWIND FULL ****";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "36":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "40":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.正常;
                                break;
                            }
                        case "41":
                            {
                                //messageType = JmpZbModel.MessageType.通知;
                                //str_msg_ontent = "ON LINE";
                                PrintState = PrintState.正常;
                                break;
                            }
                        case "50":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "FLASH WRITE ERR.";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "51":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "FORMAT ERROR";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "54":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "FLASH CARD FULL";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "60":
                            {

                                PrintState = PrintState.正常;
                                break;
                            }
                        case "61":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "数据写入失败";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "62":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "RFID ERROR";
                                PrintState = PrintState.异常;
                                break;
                            }
                        case "65":
                            {
                                //messageType = JmpZbModel.MessageType.异常;
                                //str_msg_ontent = "RFID CONFIG ERR";
                                PrintState = PrintState.异常;
                                break;
                            }
                    }

                    //PrintCache.EnPrintMsg(new JmpZbModel.PrintMessage()
                    //{
                    //    MessageCode = str_msg_code,
                    //    MessageContent = str_msg_ontent,
                    //    MessageType = messageType
                    //});
                }
                else if (str_tag_head == "46")
                {
                    str_msg_code = item.ToString().Substring(2, 4);
                    switch (str_msg_code)
                    {
                        case "3030":
                            {
                                //str_msg_ontent = "RFID 读取失败";
                                //PrintCache.EnPrintMsg(new JmpZbModel.PrintMessage()
                                //{
                                //    MessageCode = str_msg_code,
                                //    MessageContent = str_msg_ontent,
                                //    MessageType = JmpZbModel.MessageType.异常
                                //});
                                break;
                            }
                        case "3234":
                            {
                                var content = item.Substring(6);
                                PrintCache.EnTagMsg(content);
                                break;
                            }
                    }


                }
                else { Log.WorkLog(item, "else"); }
            }


        }

    }
}
