﻿using GalaSoft.MvvmLight;
using GalaSoft.MvvmLight.Command;
using JmpZbModel;
using JmpZbPrint.Model;
using JmpZbPrint.UsControl;
using MaterialDesignThemes.Wpf;
using NetworkCommsDotNet;
using NetworkCommsDotNet.Connections;
using NetworkCommsDotNet.Connections.TCP;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Threading;
using JmpZbPrint.Common;
using JmpZbPrint.Dialog;
using JmpZbPrint.View;

namespace JmpZbPrint.ViewModel
{
    public class TagBagPrinViewModel : ViewModelBase
    {
        private MainWindow _window;
        public TagBagPrinViewModel(MainWindow window)
        {
            _window = window;

            OnStartPrintItemsCmd = new RelayCommand(OnPrintStart);
            OnStopPrintItemsCmd = new RelayCommand(OnPrintStop);

            OnQueryCommand = new RelayCommand(OnQuery);
            OnPageChangeCmd = new RelayCommand(OnPageChange);
            OnGenTagCmd = new RelayCommand(OnGenTag);
            OnWindowLoadCmd = new RelayCommand(OnWindowLoad);

        }

        #region filed
        private WaitDialog waitDialog = default;
        private bool isStop = false;
        private ObservableCollection<print_info> _printList = new ObservableCollection<print_info>();
        public ObservableCollection<print_info> UiPrintList
        {
            get { return _printList; }
            set
            {
                _printList = value;
                RaisePropertyChanged();
            }
        }

        private string _equName;
        public string EquName
        {
            get { return _equName; }
            set
            {
                _equName = value;
                RaisePropertyChanged();
            }
        }
        private string _vendorName;
        public string VendorName
        {
            get { return _vendorName; }
            set
            {
                _vendorName = value;
                RaisePropertyChanged();
            }
        }
        private int _epcType;
        public int EpcType
        {
            get { return _epcType; }
            set
            {
                _epcType = value;
                RaisePropertyChanged();
            }
        }

        private string _message = "状态：打印机初始化中";
        public string UiMessage
        {
            get { return _message; }
            set
            {
                _message = value;
                RaisePropertyChanged();
            }
        }

        private string _msgccolor = "Green";
        public string MsgColor
        {
            get { return _msgccolor; }
            set
            {
                _msgccolor = value;
                RaisePropertyChanged();
            }
        }

        private bool _bindButton = false;
        public bool BindButton
        {
            get { return _bindButton; }
            set
            {
                _bindButton = value;
                RaisePropertyChanged();
            }
        }
        private int _total = 0;
        public int TotalRecord
        {
            get { return _total; }
            set
            {
                _total = value;
                RaisePropertyChanged();
            }
        }
        private int _page = 0;
        public int PageIndex
        {
            get { return _page; }
            set
            {
                _page = value;
                RaisePropertyChanged();
            }
        }

        private int _pageTotal = 0;
        public int PageTotal
        {
            get { return _pageTotal; }
            set
            {
                _pageTotal = value;
                RaisePropertyChanged();
            }
        }

        private int _pageSize = 50;
        public int PageSize
        {
            get { return _pageSize; }
            set
            {
                _pageSize = value;
                RaisePropertyChanged();
            }
        }
        private bool _startEnable = false;
        public bool StartEnable
        {
            get { return _startEnable; }
            set
            {
                _startEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _stopEnable = false;
        public bool StopEnable
        {
            get { return _stopEnable; }
            set
            {
                _stopEnable = value;
                RaisePropertyChanged();
            }
        }
        private bool _isSelectAll = false;
        public bool IsSelectAll
        {
            get { return _isSelectAll; }
            set
            {
                _isSelectAll = value;
                RaisePropertyChanged();
                SelectAll();
            }
        }
        #endregion

        #region cmd attr
        public RelayCommand OnStartPrintItemsCmd { get; set; }
        public RelayCommand OnStopPrintItemsCmd { get; set; }
        public RelayCommand OnWindowLoadCmd { get; set; }
        public RelayCommand OnQueryCommand { get; set; }
        public RelayCommand OnPageChangeCmd { get; set; }
        public RelayCommand OnGenTagCmd { get; set; }
        public RelayCommand OnWindowClosingCmd { get; set; }

        #endregion

        #region method

        public void OnWindowLoad()
        {
            OnQuery();
            _window.printServerHelper.EnableControlEvent += EnableControl;
            _window.printServerHelper.Init();
        }
        private void OnQuery()
        {
            PageIndex = 1;
            IsSelectAll = false;
            UiPrintList.Clear();
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintBagList(CaChe.UserInfo.baseJpOrganization.id, EquName, out string msg);
                        //TotalRecord = tmp?.total ?? 0;
                        //PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            //if (tmp?.record != null && tmp?.record.Count > 0)
                            if (tmp.Item1 && tmp.Item2.Count > 0)
                            {
                                var list = tmp.Item2;
                                UiPrintList = new ObservableCollection<print_info>(new List<print_info>(
                                    list.Select(x => new print_info()
                                    {
                                        LabelType = "装备包",
                                        epc = x.epc,
                                        id = x.id,
                                        warehouseName = x.warehouseName,
                                        warehouseId = x.warehouseId,
                                        productTime = x.createTime.ToString("yyyy-MM-dd"),
                                        bagName = x.bagName,
                                        number = x.number.ToString(),
                                        oneBoxNum = x.oneBoxNum,
                                        invInfo = x.invInfo
                                    })));
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });

        }
        private void OnPageChange()
        {
            return;
            waitDialog = new WaitDialog();
            waitDialog.SetToolTop("数据加载中...");
            DialogHost.Show(waitDialog, "MainRootDialog",
                (obj, args) =>
                {
                    Task.Run(() =>
                    {
                        var tmp = HttpHelper.GetPrintList(EpcType, LabelType.打印, PageIndex, VendorName, EquName);
                        TotalRecord = tmp?.total ?? 0;
                        PageTotal = TotalRecord == 0 ? 0 : (TotalRecord + PageSize - 1) / PageSize;
                        App.Current.Dispatcher.BeginInvoke(DispatcherPriority.Normal, (Action)delegate ()
                        {
                            UiPrintList?.Clear();
                            if (tmp?.record != null && tmp?.record.Count > 0)
                            {
                                UiPrintList = new ObservableCollection<print_info>(tmp.record);
                            }
                            args.Session.Close();
                        });
                    });
                },
                (obj, args) =>
                {

                });
        }
        private void OnGenTag()
        {
        }
        private void OnPrintStart()
        {
            isStop = false;
            StopEnable = true;
            StartEnable = false;

            var print = UiPrintList.Where(t => t.IsSelected == true).ToList();

            Task.Run(() =>
            {
                foreach (var tsk_item in print)
                {
                    if (isStop)
                    {
                        break;
                    }
                    else
                    {
                        //tmp_id = tsk_item.Id;
                        var res = _window.printServerHelper.SendPrintCmd(new SingleInfo()
                        {
                            Info1 = tsk_item.bagName,
                            //Info2 = tsk_item.sizeName,
                            //Info3 = tsk_item.supplierName,
                            Info4 = tsk_item.oneBoxNum.ToString(),
                            Info5 = tsk_item.number.ToString(),
                            Info6 = tsk_item.productTime,
                            Info9 = tsk_item.epc.Replace(" ", ""),
                            ModelType = "pieceBag"
                        });

                        if (res)
                        {
                            UpdateEpcStateById(tsk_item.id.Replace(" ", ""), true);
                        }
                        //打印机异常，不继续发指令
                        else if (!res) { break; }
                        else { }
                    }
                }
                OnPrintStop();
            });
        }
        public void OnPrintStop()
        {
            StopEnable = false;
            StartEnable = true;
            isStop = true;
        }
        private void UpdateEpcStateById(string id, bool apply = false)
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                var item = UiPrintList.FirstOrDefault(t => t.id.Contains(id));
                if (item != null)
                {
                    item.state = 1;
                    Tuple<bool, string> flagData = new Tuple<bool, string>(true, "");
                    if (apply)
                    {
                        //装备包打印成功
                        var res = HttpHelper.UpdateBagState(id, out string msg);
                        flagData = new Tuple<bool, string>(res, msg);
                    }
                    if (flagData.Item1)
                    {
                        UiPrintList.Remove(item);
                        LiteDbHelper.DeleteByEpc(item.epc);
                        TotalRecord -= 1;

                        if (UiPrintList.Count == 0)
                        {
                            PageIndex = 1;
                            OnPageChange();
                        }
                    }
                    else
                    {
                        //EPC状态更新失败
                        UiMessage = flagData.Item2;
                        MsgColor = "Red";
                    }
                }
            });
        }
        public void EnableControl(bool flag, bool startEnable, bool stopEnable, string msg = "")
        {
            StartEnable = startEnable;
            StopEnable = stopEnable;

            if (!string.IsNullOrEmpty(msg))
            {
                UiMessage = "状态：" + msg;
                MsgColor = flag ? "Green" : "Red";
            }
        }
        public void SelectAll()
        {
            App.Current.Dispatcher.Invoke(() =>
            {
                foreach (var item in UiPrintList)
                {
                    item.IsSelected = _isSelectAll;
                }
                this.RaisePropertyChanged(() => UiPrintList);
            });
        }
        public override void Cleanup()
        {
            base.Cleanup();
            isStop = true;
            _window.printServerHelper.EnableControlEvent -= EnableControl;
            NetworkComms.Shutdown();
        }
        #endregion

    }

}
