﻿using JmpZbPrint.Common;
using System;
using System.Windows;

namespace JmpZbPrint.View
{
    /// <summary>
    /// SettingsWindow.xaml 的交互逻辑
    /// </summary>
    public partial class SettingsWindow : Window
    {
        private Config vm;
        public SettingsWindow(Config config)
        {
            InitializeComponent();
            this.vm = config;
            this.DataContext = vm;

            cbb_autoUpdate.IsEnabled = vm.IsAutoUpdate;
        }

        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void SaveClick(object sender, RoutedEventArgs e)
        {
            if (CaChe.SaveSystemStep(vm))
            {
                MessageBox.Show("配置保存成功！", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
                CaChe.LoadSystemStep();
                DialogResult = true;
            }
        }

        private void CloseClick(object sender, RoutedEventArgs e)
        {
            DialogResult = false;

        }

        private void cb_autoUpdate_Click(object sender, RoutedEventArgs e)
        {
            cbb_autoUpdate.IsEnabled = cb_autoUpdate.IsChecked == true;
        }
    }
}
