﻿using JmpZbPrint.Dialog;
using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.View
{
    /// <summary>
    /// SupplierWin.xaml 的交互逻辑
    /// </summary>
    public partial class SetGenInfo : Window
    {
        public event Action<recode_info> OnRefreshGrid;
        public recode_info record { get; set; }
        public List<Supplier> SupplierList { get; set; } = new List<Supplier>();
        public List<WarehouseInfo> WarehouseList { get; set; } = new List<WarehouseInfo>();
        public SetGenInfo()
        {
            InitializeComponent();
            record = new recode_info();
            WarehouseList = HttpHelper.GetWarehouse();
        }
        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnSelectVendor_Click(object sender, RoutedEventArgs e)
        {
            var win = new SupplierWindow();
            win.ShowDialog();
            if (win.Supplier != null)
            {
                if (!SupplierList.Any(t => t.id == win.Supplier.id))
                {
                    SupplierList.Insert(0, win.Supplier);
                    cboSupplier.ItemsSource = null;
                    cboSupplier.ItemsSource = SupplierList;
                    cboSupplier.DisplayMemberPath = "name";
                    cboSupplier.SelectedValuePath = "id";
                    cboSupplier.SelectedIndex = 0;
                }
            }
        }
        private void OnSelectEqu_Click(object sender, RoutedEventArgs e)
        {
            var equ = new SelectEqu();
            equ.ShowDialog();
            if (equ.EquInfo != null)
            {
                txtEquName.Text = equ.EquInfo.name;
                record = new recode_info();
                record.equCode = equ.EquInfo.code;
                record.equId = equ.EquInfo.id;
                record.equName = equ.EquInfo.name;

                //查询号型
                var equ_attr = HttpHelper.GetEquInfoById(equ.EquInfo.id);
                if (equ_attr != null)
                {
                    SupplierList = equ_attr.suppliers;
                    cboSupplier.ItemsSource = null;
                    cboSupplier.ItemsSource = SupplierList;
                    cboSupplier.DisplayMemberPath = "name";
                    cboSupplier.SelectedValuePath = "id";
                    cboSupplier.SelectedIndex = 0;

                    cboSize.ItemsSource = equ_attr.sizes;
                    cboSize.DisplayMemberPath = "name";
                    cboSize.SelectedValuePath = "id";
                    cboSize.SelectedIndex = 0;
                }

            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            cboWarehouse.ItemsSource = WarehouseList;
            cboWarehouse.DisplayMemberPath = "name";
            cboWarehouse.SelectedValuePath = "id";
            cboWarehouse.SelectedIndex = 0;

            dtProductDate.SelectedDate = DateTime.Now.AddDays(-7);
            dtUseDate.SelectedDate = DateTime.Now;
        }

        private void OnSave_Click(object sender, RoutedEventArgs e)
        {
            if (string.IsNullOrEmpty(record.equId))
            {
                MessageBox.Show("装备未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboSize.SelectedItem == null)
            {
                MessageBox.Show("号型未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboWarehouse.SelectedItem == null)
            {
                MessageBox.Show("入库仓库未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (cboSupplier.SelectedItem == null)
            {
                MessageBox.Show("供应商未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (dtUseDate.SelectedDate == null)
            {
                MessageBox.Show("使用日期未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (dtProductDate.SelectedDate == null)
            {
                MessageBox.Show("生产日期未选择", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtPrice.Text)
                || !decimal.TryParse(txtPrice.Text, out decimal price)
                || price <= 0)
            {
                MessageBox.Show("单价输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtZbq.Text)
               || !int.TryParse(txtZbq.Text, out int warrantyCycle)
               || warrantyCycle < 0)
            {
                MessageBox.Show("质保周期输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtWxzq.Text)
              || !int.TryParse(txtWxzq.Text, out int repairCycle)
              || repairCycle <= 0)
            {
                MessageBox.Show("维保周期输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else if (string.IsNullOrEmpty(txtNum.Text)
           || !int.TryParse(txtNum.Text, out int genNum)
           || genNum <= 0)
            {
                MessageBox.Show("数量输入不正确", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
            }
            else
            {
                var size = cboSize.SelectedItem as EquSizeInfo;
                var supplier = cboSupplier.SelectedItem as Supplier;
                var warehouse = cboWarehouse.SelectedItem as WarehouseInfo;

                record.sizeCode = size.code;
                record.sizeId = size.id;
                record.sizeName = size.name;

                record.suppilerCode = supplier.code;
                record.supplierId = supplier.id;
                record.suppilerName = supplier.name;

                record.warehouseId = warehouse.id;
                record.warehouseName = warehouse.name;

                record.useTime = dtUseDate.SelectedDate;
                record.productTime = dtProductDate.SelectedDate;

                record.repairCycle = repairCycle;
                record.warrantyCycle = warrantyCycle;
                record.price = (float)price;

                record.needNum = genNum;

                record.LabelType = "件标";

                OnRefreshGrid?.Invoke(record);
            }
        }

        private void OnCancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
    }
}
