﻿using GalaSoft.MvvmLight.Messaging;
using JmpZbPrint.PagePartial;
using JmpZbPrint.ViewModel;
//using rfidLink.Extend;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Reflection;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using JmpZbPrint.Common;

namespace JmpZbPrint.View
{
    /// <summary>
    /// MainWindow.xaml 的交互逻辑
    /// </summary>
    public partial class InternalWindow : Window
    {
        private bool isLoad = false;
        private IntPrintWindow printWindow;
        private IntBindWindow bindWindow;
        private IntHistoryWindow historyWindow;

        public IPrintServerHelper printServerHelper;
        public InternalWindow()
        {
            try
            {
                InitializeComponent();
                this.txtTitle.Text = CaChe.SysConfig?.AppTitle ?? "";
                this.Title = CaChe.SysConfig?.AppTitle ?? "";

                switch (CaChe.SysConfig?.PrintType)
                {
                    case 0:
                        {
                            printServerHelper = new ToShiBaPrintServerHelper();
                            break;
                        }
                    case 1:
                        {
                            printServerHelper = new PostekPrintServerHelper();
                            break;
                        }
                    default:
                        {
                            //默认东芝
                            printServerHelper = new ToShiBaPrintServerHelper();
                            break;
                        }
                }
                printWindow = new IntPrintWindow(this);
                bindWindow = new IntBindWindow();
                historyWindow = new IntHistoryWindow();

            }
            catch (Exception ex)
            {
                Log.ErrorLog(ex.ToString(), MethodBase.GetCurrentMethod().Name);
            }
        }


        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private object syncObj = new object();
        private void OnDataGridLoadingRow(object sender, DataGridRowEventArgs e)
        {
            lock (syncObj)
            {
                e.Row.Header = e.Row.GetIndex() + 1;
            }
        }

        private void OnTabSelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            if (isLoad)
            {
                switch (tb_ctrl.SelectedIndex)
                {
                    case 0:
                        {
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is IntBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Visible;
                            pri_history.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 1:
                        {
                            bin_control.Visibility = Visibility.Visible;
                            if (bindWindow.DataContext is IntBindViewModel model)
                            {
                                if (model.taskWsService != null)
                                {
                                    model.taskWsService.Dispose();
                                    model.taskWsService = null;
                                    model.InitWs();
                                }
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            pri_history.Visibility = Visibility.Collapsed;
                            break;
                        }
                    case 2:
                        {
                            bin_control.Visibility = Visibility.Collapsed;
                            if (bindWindow.DataContext is IntBindViewModel model)
                            {
                                model.resetEvent.Set();
                                model.cWsServiceToken?.Cancel();
                                model.wsConn?.Close();
                            }
                            pri_control.Visibility = Visibility.Collapsed;
                            pri_history.Visibility = Visibility.Visible;
                            break;
                        }
                    default:
                        break;
                }

            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            isLoad = true;
            tb_ctrl.SelectedIndex = 0;
            pri_control.Visibility = Visibility.Visible;
            pri_control.Content = printWindow;
            pri_history.Content = historyWindow;
            bin_control.Content = bindWindow;
        }

        private void Window_Closing(object sender, System.ComponentModel.CancelEventArgs e)
        {
            printWindow.Clearup();
            bindWindow.Clearup();
            printServerHelper.Dispose();
            Process.GetCurrentProcess().Kill();
        }
    }
}
