﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Panuon.UI.Silver;
using Panuon.UI.Silver.Core;
using System;
using System.Diagnostics;
using System.IO;
using System.Reflection;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Markup;

namespace JmpZbPrint.View
{
    /// <summary>
    /// AutoClosingMessageBox.xaml 的交互逻辑
    /// </summary>
    public partial class AutoClosingMessageBox : WindowX, IComponentConnector
    {
        private int _count = 0;
        private System.Threading.Timer _timer;
        private Action _callBack;
        public AutoClosingMessageBox(Window window, string content, string title, int count, Action callback)
        {
            InitializeComponent();

            Owner = window;
            Title = "    " + title;
            lb_Message.Content = content;
            _count = count;
            _callBack = callback;
            _timer = new System.Threading.Timer(TimerFunction, null, 0, 1000);

            //居中弹出
            this.Left = System.Windows.SystemParameters.PrimaryScreenWidth / 2 - this.Width / 2;
            this.Top = System.Windows.SystemParameters.PrimaryScreenHeight / 2 - this.Height / 2;
        }
        private void Window_Loaded(object sender, RoutedEventArgs e)
        {

        }

        private void btn_Submit_Click(object sender, RoutedEventArgs e)
        {
            //执行
            _timer.Dispose();
            _callBack.BeginInvoke(null, null);
            this.Close();
        }

        private void btn_Cancel_Click(object sender, RoutedEventArgs e)
        {
            _timer.Dispose();
            this.Close();
        }

        private void TimerFunction(object state)
        {
            this.Dispatcher.Invoke(() => { btn_Submit.Content = $"确定({_count})"; });
            if (_count < 0)
            {
                _timer.Dispose();
                this.Dispatcher.Invoke(() => this.btn_Submit_Click(null, null));
            }
            _count--;
        }
    }
}
