﻿using GalaSoft.MvvmLight.Command;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JmpZbPrint.UsControl
{
    /// <summary>
    /// PageControl.xaml 的交互逻辑
    /// </summary>
    public partial class PageControl : UserControl
    {

        #region 委托事件
        //定义一个事件
        public event RoutedEventHandler OnPageChanged;
        #endregion

        public PageControl()
        {
            InitializeComponent();

        }

        /// <summary>
        /// 总页数
        /// </summary>
        private int pageCount = 0;
        /// <summary>
        /// 当前页
        /// </summary>
        private int pageIndex = 0;

        #region 每页条数

        /// <summary>
        /// 注册当前页
        /// </summary>
        public static readonly DependencyProperty PageSizeProperty = DependencyProperty.Register("PageSize", typeof(string),
        typeof(PageControl), new FrameworkPropertyMetadata("0", FrameworkPropertyMetadataOptions.AffectsMeasure), new ValidateValueCallback(PageIndexValidation));

        /// <summary>
        /// 当前页
        /// </summary>
        public string PageSize
        {
            get { return GetValue(PageSizeProperty).ToString(); }
            set
            {
                SetValue(PageSizeProperty, value);
            }
        }

        #endregion

        #region 当前页

        /// <summary>
        /// 注册当前页
        /// </summary>
        public static readonly DependencyProperty PageIndexProperty = DependencyProperty.Register("PageIndex", typeof(string),
        typeof(PageControl), new FrameworkPropertyMetadata("0", FrameworkPropertyMetadataOptions.AffectsMeasure, new PropertyChangedCallback(OnPageIndexChanged)), new ValidateValueCallback(PageIndexValidation));

        /// <summary>
        /// 验证当前页
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool PageIndexValidation(object value)
        {
            return true;
        }

        /// <summary>
        /// 当前页
        /// </summary>
        public string PageIndex
        {
            get { return GetValue(PageIndexProperty).ToString(); }
            set
            {
                //if (int.Parse(value) <= 0) { value = "1"; }
                SetValue(PageIndexProperty, value);
            }
        }

        #endregion

        #region 总页数
        /// <summary>
        /// 总页数
        /// </summary>
        public static readonly DependencyProperty TotalPageProperty = DependencyProperty.Register("TotalPage", typeof(string), typeof(PageControl), new FrameworkPropertyMetadata("0", FrameworkPropertyMetadataOptions.AffectsMeasure, new PropertyChangedCallback(OnTotalPageChanged)), new ValidateValueCallback(PageCountPageValidation));

        /// <summary>
        /// 总页数进行验证
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool PageCountPageValidation(object value)
        {
            return true;
        }

        /// <summary>
        /// 总页数
        /// </summary>
        public string TotalPage
        {
            get { return GetValue(TotalPageProperty).ToString(); }
            set
            {
                SetValue(TotalPageProperty, value);
            }
        }

        /// <summary>
        /// 总数据条数
        /// </summary>
        public static readonly DependencyProperty TotalRecordProperty = DependencyProperty.Register("TotalRecord", typeof(string), typeof(PageControl), new FrameworkPropertyMetadata("0", FrameworkPropertyMetadataOptions.AffectsMeasure, new PropertyChangedCallback(OnTotalRecodChanged)), new ValidateValueCallback(TotalRecordPageValidation));

        /// <summary>
        /// 总页数进行验证
        /// </summary>
        /// <param name="value"></param>
        /// <returns></returns>
        public static bool TotalRecordPageValidation(object value)
        {
            return true;
        }

        /// <summary>
        /// 总页数
        /// </summary>
        public string TotalRecord
        {
            get { return GetValue(TotalRecordProperty).ToString(); }
            set
            {
                SetValue(TotalRecordProperty, value);

            }
        }

        #endregion

        #region 私有方法
        /// <summary>
        /// 值改变方法将由此方法来引发事件
        /// </summary>
        private void PageChangedTrigger()
        {
            ///引发事件
            OnPageChanged?.Invoke(this, new RoutedEventArgs());
        }
        #endregion

        /// <summary>
        /// 首页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnFirPageClick(object sender, RoutedEventArgs e)
        {
            PageIndex = "1";
            PageChangedTrigger();

        }

        /// <summary>
        /// 前一页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnPrePageClick(object sender, RoutedEventArgs e)
        {
            pageCount = GetIntVal(TotalPage);
            pageIndex = GetIntVal(PageIndex);
            if (pageIndex > 1)
            {
                pageIndex = pageIndex - 1;
                PageIndex = pageIndex.ToString();
            }
            PageChangedTrigger();
        }

        /// <summary>
        /// 后一页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnNexPageClick(object sender, RoutedEventArgs e)
        {
            pageIndex = GetIntVal(PageIndex);
            pageCount = GetIntVal(TotalPage);
            if (pageIndex < pageCount)
            {
                pageIndex = pageIndex + 1;
                PageIndex = pageIndex.ToString();
            }
            PageChangedTrigger();
        }

        /// <summary>
        /// 尾页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnEndPageClick(object sender, RoutedEventArgs e)
        {
            pageIndex = GetIntVal(TotalPage);
            PageIndex = pageIndex.ToString();
            PageChangedTrigger();
        }

        /// <summary>
        /// 刷新当前页
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void btnRefresh_Click(object sender, RoutedEventArgs e)
        {
            PageChangedTrigger();
        }

        /// <summary>
        /// 索引转换int
        /// </summary>
        /// <param name="val"></param>
        /// <returns></returns>
        private int GetIntVal(string val)
        {
            if (!int.TryParse(val, out int temp))
            {
                temp = 1;
            }
            return temp;
        }

        /// <summary>
        /// 画每页显示等数据
        /// </summary>
        private static void DisplayPagingInfo(PageControl datapage)
        {
            if (int.Parse(datapage.PageIndex) == 1)
            {
                datapage.btnUp.IsEnabled = false;
                datapage.btnFirst.IsEnabled = false;

            }
            else
            {
                datapage.btnUp.IsEnabled = true;
                datapage.btnFirst.IsEnabled = true;
            }
            if (int.Parse(datapage.PageIndex) == int.Parse(datapage.TotalPage == "" ? "0" : datapage.TotalPage))
            {
                datapage.btnNext.IsEnabled = false;
                datapage.btnEnd.IsEnabled = false;


            }
            else
            {
                datapage.btnNext.IsEnabled = true;
                datapage.btnEnd.IsEnabled = true;

            }
            datapage.tbTip.Text = $"第{datapage.PageIndex}页，共{datapage.TotalPage}页。共{datapage.TotalRecord}条记录！";

        }

        /// <summary>
        /// 当当前页值改变
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void OnTotalPageChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e)
        {
            DisplayPagingInfo(sender as PageControl);
            //MyButton hsb = (MyButton)sender;
            //  SetValue(PageControl.CurrentPageProperty, "1");
            // SetFunc();
            //Image image = hsb.tehImage;
            //CurrentPage = "1";
            //image.Source = new BitmapImage((Uri)e.NewValue);
        }

        /// <summary>
        /// 当当前页值改变
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void OnTotalRecodChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e)
        {
            DisplayPagingInfo(sender as PageControl);
        }


        /// <summary>
        /// 当当前页值改变
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void OnPageIndexChanged(DependencyObject sender, DependencyPropertyChangedEventArgs e)
        {
            DisplayPagingInfo(sender as PageControl);
            //MyButton hsb = (MyButton)sender;
            //  SetValue(PageControl.CurrentPageProperty, "1");
            // ShowMsg("event");
            //Image image = hsb.tehImage;
            //CurrentPage = "1";
            //image.Source = new BitmapImage((Uri)e.NewValue);
        }

        private void DataPageControl_Loaded(object sender, RoutedEventArgs e)
        {
            if (this.pageCount == 1 && pageIndex == 1)
            {
                btnEnd.IsEnabled = false;
                btnFirst.IsEnabled = false;
                btnNext.IsEnabled = false;
                btnUp.IsEnabled = false;
            }
        }

    }
}
