﻿using JmpZbModel.Model;
using JmpZbPrint.Common;
using JmpZbPrint.Dialog;
using JmpZbPrint.Model;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JmpZbPrint.PagePartial
{
    /// <summary>
    /// ModifyPrint.xaml 的交互逻辑
    /// </summary>
    public partial class SetBasicInfo : Window
    {

        public ObservableCollection<order_info> OrderList
        {
            get;
            set;
        }

        public SetBasicInfo(List<order_info> orders)
        {
            InitializeComponent();
            g_order.Items.Clear();
            int num = 0;
            orders.ForEach(s =>
            {
                num++;
                s.rowNum = num;
                if (s.suppilers != null && s.suppilers.Count == 1)
                {
                    s.supplierId = s.suppilers.FirstOrDefault().id;
                }
            });
            this.OrderList = new ObservableCollection<order_info>(orders);
            g_order.ItemsSource = OrderList;
        }


        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnWindowLoaded(object sender, RoutedEventArgs e)
        {
        }
        private void OnWzSelectionChanged(object sender, SelectionChangedEventArgs e)
        {
        }
        private void OnSaveClick(object sender, RoutedEventArgs e)
        {
            var tmpList = OrderList.ToList();
            var index = 1;
            bool flag = true;
            foreach (var item in tmpList)
            {
                if (string.IsNullOrEmpty(item.supplierId))
                {
                    flag = false;
                    MessageBox.Show($"第{index}行供应商未选择！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.needNum <= 0)
                {
                    flag = false;
                    MessageBox.Show($"第{index}行购入数量填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.useTime == null || item.useTime == default)
                {
                    flag = false;
                    MessageBox.Show($"第{index}行使用日期填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.productTime == null || item.productTime == default)
                {
                    flag = false;
                    MessageBox.Show($"第{index}行生产日期填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.warrantyCycle < 0)
                {
                    flag = false;
                    MessageBox.Show($"第{index}质保周期填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.repairCycle <= 0)
                {
                    flag = false;

                    MessageBox.Show($"第{index}维保周期填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else if (item.price <= 0)
                {
                    flag = false;
                    MessageBox.Show($"第{index}购入单价填写不正确！", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                    break;
                }
                else
                {
                    index++;
                    continue;
                }
            }

            if (flag)
            {
                var grList = tmpList.GroupBy(t => new { t.detailId, t.reNum })
                    .Select(s => new
                    {
                        detailId = s.FirstOrDefault().detailId,
                        equName = s.FirstOrDefault().equName,
                        sizeName = s.FirstOrDefault().sizeName,
                        reNum = s.FirstOrDefault().reNum,
                        needNum = s.Sum(x => x.needNum)

                    }).ToList();
                foreach (var item in grList)
                {
                    if (item.needNum > item.reNum)
                    {
                        flag = false;
                        MessageBox.Show($"装备[{item.equName} - {item.sizeName}]购入总数量超出剩余数量{item.reNum}!", "提示", MessageBoxButton.OK, MessageBoxImage.Warning);
                        break;
                    }
                    else { continue; }
                }

                if (flag)
                {
                    foreach (var s in tmpList)
                    {
                        var supplier = s.suppilers?.FirstOrDefault(t => t.id == s.supplierId);
                        s.supplierCode = supplier?.code ?? "";
                        s.supplierName = supplier?.name ?? "";
                        var request = new request_ext_info()
                        {
                            detailId = s.detailId,
                            equCode = s.equCode,
                            sizeCode = s.sizeCode,
                            supplierCode = s.supplierCode,
                            supplierId = s.supplierId,
                            quantity = s.needNum,
                            price = (float)s.price,
                            productTime = s.productTime,
                            repairCycle = s.repairCycle,
                            useTime = s.useTime,
                            warrantyCycle = s.warrantyCycle,
                            supplierName = s.supplierName,
                            shelfId = s.shelfId,
                            shelfRange = s.shelfRange,
                            shelfRow = s.shelfRow,
                            shelfColumn = s.shelfColumn,

                        };

                        var res = HttpHelper.GenerateExtTagEpc(request, out string msg);
                        if (res)
                        {
                            flag = true;
                            OrderList.Remove(s);
                        }
                        else
                        {
                            flag = false;
                            MessageBox.Show($"[{s.equName}-{s.sizeName}] 生成失败，原因：{msg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                            break;
                        }
                    }
                    if (flag)
                    {
                        MessageBox.Show($"任务生成成功", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
                        this.Close();
                    }
                }
            }

        }
        private void OnCancelClick(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
        private void OnClose(object sender, MouseButtonEventArgs e)
        {
            this.Close();
        }

        private void g_order_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {

        }

        private void OnSpiltItemClick(object sender, RoutedEventArgs e)
        {
            if (g_order.SelectedValue != null)
            {
                var item = g_order.SelectedValue as order_info;
                var index = g_order.SelectedIndex;


                OrderList.Insert(index, new order_info()
                {
                    createTime = item.createTime,
                    detailId = item.detailId,
                    equCode = item.equCode,
                    equId = item.equId,
                    equName = item.equName,
                    supplierId = item.supplierId,
                    genedNum = item.genedNum,
                    IsSelected = item.IsSelected,
                    orderCode = item.orderCode,
                    orderId = item.orderId,
                    price = item.price,
                    productTime = item.productTime,
                    reNum = item.reNum,
                    repairCycle = item.repairCycle,
                    sizeId = item.sizeId,
                    sizeName = item.sizeName,
                    suppilers = item.suppilers,
                    totalNum = item.totalNum,
                    useTime = item.useTime,
                    warrantyCycle = item.warrantyCycle,
                    sizeCode = item.sizeCode,
                    supplierCode = item.supplierCode,
                    needNum = 0,
                    rowNum = 0
                });

            }
        }

        private void OnSelectSupplierClick(object sender, RoutedEventArgs e)
        {
            var win = new SupplierWindow();
            win.ShowDialog();
            if (win.Supplier != null)
            {
                var item = g_order.SelectedValue as order_info;
                if (item.suppilers.Count(t => t.id == win.Supplier.id) == 0)
                {
                    item.suppilers.Add(win.Supplier);
                    item.supplierId = win.Supplier.id;
                }
            }
        }

        private void OnSelectShelfClick(object sender, RoutedEventArgs e)
        {
            var item = g_order.SelectedValue as order_info;
            var win = new ShelfWindow(new WarehouseInfo() { id = item.warehouseId, name = item.warehouseName }, item.equId, item.sizeId);
            win.ShowDialog();
            if (win.Shelf != null)
            {
                item.shelfName = win.Shelf.name;
                item.shelfId = win.Shelf.id;
                item.shelfRange = Convert.ToInt32(win.Shelf.range);
                item.shelfRow = Convert.ToInt32(win.Shelf.row);
                item.shelfColumn = Convert.ToInt32(win.Shelf.column);
            }
            //强制触发刷新
            item.shelfInfo = "";
        }

        private void OnDeleteItemClick(object sender, RoutedEventArgs e)
        {
            if (g_order.SelectedValue != null)
            {
                var item = g_order.SelectedValue as order_info;
                var index = g_order.SelectedIndex;
                OrderList.Remove(item);
            }
        }

    }
}
