﻿using JmpZbModel.Model;
using JmpZbPrint.Common;
using JmpZbPrint.Dialog;
using JmpZbPrint.Model;
using JmpZbPrint.View;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using Newtonsoft.Json;

namespace JmpZbPrint.PagePartial
{
    /// <summary>
    /// IntGenEpcWindow.xaml 的交互逻辑
    /// </summary>
    public partial class IntGenEpcWindow : Window
    {
        public event Action OnRefreshGrid;
        public ObservableCollection<recode_info> OrderList
        {
            get;
            set;
        }

        private int type;
        public IntGenEpcWindow(int type)
        {
            InitializeComponent();
            this.type = type;
            txtTitle.Text = type == 0 ? "生成打印任务" : "生成绑定任务";
            //g_order.Items.Clear();
            g_order.AutoGenerateColumns = false;
            OrderList = new ObservableCollection<recode_info>();
            g_order.ItemsSource = OrderList;

            OnNewBoxBtn.Visibility = type == 0 ? Visibility.Visible : Visibility.Hidden;
        }


        private void Sb_Completed(object sender, EventArgs e)
        {
            this.Close();
        }

        private void OnWindowLoaded(object sender, RoutedEventArgs e)
        {
        }
        private void OnWzSelectionChanged(object sender, SelectionChangedEventArgs e)
        {
        }
        private void OnNewBoxClick(object sender, RoutedEventArgs e)
        {
            var tmp = new SetGenInfoV2("箱标");
            tmp.OnRefreshGrid += RefreshGrid;
            tmp.Show();
        }
        private void OnNewClick(object sender, RoutedEventArgs e)
        {
            var tmp = new SetGenInfoV2("件标");
            tmp.OnRefreshGrid += RefreshGrid;
            tmp.Show();
        }
        private void OnSaveClick(object sender, RoutedEventArgs e)
        {
            var tmpList = OrderList.ToList();
            bool flag = false;
            foreach (var s in tmpList)
            {
                if (s.LabelType == "箱标")
                {
                    List<recode_info> epc_record = new List<recode_info>();
                    for (int i = 0; i < s.needNum; i++)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");
                        //Thread.Sleep(1);
                        ////5842 ：'XB'的16进制
                        //var xbEpc = "5842" + _batch_no + "000";

                        //创建箱标epc
                        var boxRequest = new request_int_info()
                        {
                            labelType = "箱标",
                            equCode = s.equCode,
                            productTime = s.productTime,
                            sizeCode = s.sizeCode,
                            oneBoxNum = s.oneBoxNum,
                            quantity = s.needNum,
                            supplierCode = s.suppilerCode,
                            warrantyCycle = s.warrantyCycle
                        };
                        var boxRes = HttpHelper.GenerateIntTagEpc(boxRequest, out string boxMsg);
                        if (!boxRes.Item1)
                        {
                            flag = false;
                            MessageBox.Show($"[{s.equName}-{s.sizeName}] 箱标生成失败，原因：{boxMsg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                            return;
                        }
                        var xbEpc = boxRes.Item2.First().epc;

                        //箱标内件标生成epc
                        var request = new request_int_info()
                        {
                            labelType = "件标",
                            equCode = s.equCode,
                            productTime = s.productTime,
                            sizeCode = s.sizeCode,
                            quantity = s.oneBoxNum,
                            supplierCode = s.suppilerCode,
                            warrantyCycle = s.warrantyCycle
                        };
                        var res = HttpHelper.GenerateIntTagEpc(request, out string msg);
                        if (!res.Item1)
                        {
                            flag = false;
                            MessageBox.Show($"[{s.equName}-{s.sizeName}] 件标生成失败，原因：{msg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                            return;
                        }
                        epc_record.Add(new recode_info()
                        {
                            LabelType = "箱标",
                            orgId = s.orgId,
                            batchNo = _batch_no,
                            epc = xbEpc,
                            num = i + 1,
                            equCode = s.equCode,
                            equId = s.equId,
                            sizeCode = s.sizeCode,
                            equName = s.equName,
                            isdelete = false,
                            oneBoxNum = s.oneBoxNum,
                            needNum = s.needNum,
                            price = s.price,
                            productTime = s.productTime,
                            repairCycle = s.repairCycle,
                            sizeId = s.sizeId,
                            sizeName = s.sizeName,
                            suppilerCode = s.suppilerCode,
                            supplierId = s.supplierId,
                            suppilerName = s.suppilerName,
                            type = type,
                            useTime = s.useTime,
                            warehouseId = s.warehouseId,
                            warehouseName = s.warehouseName,
                            warrantyCycle = s.warrantyCycle,
                            createTime = DateTime.Now,
                            ShelfId = s.ShelfId,
                            ShelfName = s.ShelfName,
                            ShelfRange = s.ShelfRange,
                            ShelfRow = s.ShelfRow,
                            ShelfColumn = s.ShelfColumn,
                            epcListJson = JsonConvert.SerializeObject(res.Item2.Select(x => x.epc))
                        });
                    }
                    LiteDbHelper.AddRange(epc_record);
                    flag = true;
                    OrderList.Remove(s);
                }
                else
                {
                    var request = new request_int_info()
                    {
                        equCode = s.equCode,
                        productTime = s.productTime,
                        sizeCode = s.sizeCode,
                        quantity = s.needNum,
                        supplierCode = s.suppilerCode,
                        warrantyCycle = s.warrantyCycle
                    };
                    var res = HttpHelper.GenerateIntTagEpc(request, out string msg);
                    if (res.Item1)
                    {
                        var _batch_no = DateTime.Now.ToString("yyyyMMddHHmmssfff");
                        //写入EPC到liteDB
                        List<recode_info> epc_record = new List<recode_info>();
                        res.Item2.ForEach(x =>
                        {
                            s.epc = x.epc;
                            s.num = x.num;
                            epc_record.Add(new recode_info()
                            {
                                LabelType = "件标",
                                orgId = s.orgId,
                                batchNo = _batch_no,
                                epc = x.epc,
                                num = x.num,
                                equCode = s.equCode,
                                equId = s.equId,
                                sizeCode = s.sizeCode,
                                equName = s.equName,
                                isdelete = false,
                                needNum = s.needNum,
                                price = s.price,
                                productTime = s.productTime,
                                repairCycle = s.repairCycle,
                                sizeId = s.sizeId,
                                sizeName = s.sizeName,
                                suppilerCode = s.suppilerCode,
                                supplierId = s.supplierId,
                                suppilerName = s.suppilerName,
                                type = type,
                                useTime = s.useTime,
                                warehouseId = s.warehouseId,
                                warehouseName = s.warehouseName,
                                warrantyCycle = s.warrantyCycle,
                                createTime = DateTime.Now,
                                ShelfId = s.ShelfId,
                                ShelfName = s.ShelfName,
                                ShelfRange = s.ShelfRange,
                                ShelfRow = s.ShelfRow,
                                ShelfColumn = s.ShelfColumn,
                            });
                        });

                        LiteDbHelper.AddRange(epc_record);
                        flag = true;
                        OrderList.Remove(s);
                    }
                    else
                    {
                        flag = false;
                        MessageBox.Show($"[{s.equName}-{s.sizeName}] 生成失败，原因：{msg}", "提示", MessageBoxButton.OK, MessageBoxImage.Error);
                        return;
                    }
                }
            }

            if (flag)
            {
                MessageBox.Show($"任务生成成功", "提示", MessageBoxButton.OK, MessageBoxImage.Information);
                this.Close();
            }

        }
        private void OnCancelClick(object sender, RoutedEventArgs e)
        {
            this.Close();
        }
        private void OnClose(object sender, MouseButtonEventArgs e)
        {
            this.Close();
        }

        private void g_order_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {

        }


        private void OnDeleteItemClick(object sender, RoutedEventArgs e)
        {
            if (g_order.SelectedValue != null)
            {
                var item = g_order.SelectedValue as recode_info;
                var index = g_order.SelectedIndex;
                OrderList.Remove(item);
            }
        }

        private void RefreshGrid(recode_info recode)
        {
            OrderList.Add(new recode_info()
            {
                LabelType = recode.LabelType,
                orgId = CaChe.UserInfo.baseJpOrganization.id,
                suppilerCode = recode.suppilerCode,
                type = recode.type,
                epc = recode.epc,
                equCode = recode.equCode,
                equId = recode.equId,
                equName = recode.equName,
                isdelete = false,
                IsSelected = false,
                needNum = recode.needNum,
                oneBoxNum = recode.oneBoxNum,
                num = recode.num,
                price = recode.price,
                productTime = recode.productTime,
                repairCycle = recode.repairCycle,
                sizeCode = recode.sizeCode,
                sizeId = recode.sizeId,
                sizeName = recode.sizeName,
                supplierId = recode.supplierId,
                suppilerName = recode.suppilerName,
                useTime = recode.useTime,
                warehouseId = recode.warehouseId,
                warehouseName = recode.warehouseName,
                warrantyCycle = recode.warrantyCycle,
                ShelfId = recode.ShelfId,
                ShelfName = recode.ShelfName,
                ShelfRange = recode.ShelfRange,
                ShelfRow = recode.ShelfRow,
                ShelfColumn = recode.ShelfColumn,
            });
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            OnRefreshGrid?.Invoke();
        }
    }
}
