﻿using System;
using System.IO;
using System.Runtime.CompilerServices;
using System.Text;

namespace JmpZbPrint
{
    public class Log
    {
        //private static 
        private static StreamWriter sr;
        private static readonly object syncWorkObj = new object();
        private static readonly object syncErrorObj = new object();
        private static readonly object syncDebugObj = new object();
        private static bool bEnableWorkLog = true;
        private static bool bEnableErrorLog = true;
        private static bool bEnableDebugLog = true;
        public Log()
        {

        }

        /// <summary>
        /// Log 启用
        /// </summary>
        /// <param name="enable"></param>
        public static void EnableWorkLog(bool enable)
        {
            bEnableWorkLog = enable;
        }

        /// <summary>
        /// Log 启用
        /// </summary>
        /// <param name="enable"></param>
        public static void EnableErrorLog(bool enable)
        {
            bEnableErrorLog = enable;
        }

        /// <summary>
        /// Log 启用
        /// </summary>
        /// <param name="enable"></param>
        public static void EnableDebugLog(bool enable)
        {
            bEnableDebugLog = enable;
        }


        /// <summary>
        /// 工作日志
        /// </summary>
        /// <param name="logTxt"></param>
        /// <param name="ModuleName"></param>
        public static void WorkLog(string logTxt, [CallerMemberName] string ModuleName = default)
        {
            lock (syncWorkObj)
            {
                if (bEnableWorkLog)
                {
                    WriteLine(logTxt, ModuleName, "WorkLog/");
                }
            }
        }

        /// <summary>
        /// 异常日志
        /// </summary>
        /// <param name="logTxt"></param>
        /// <param name="ModuleName"></param>
        public static void ErrorLog(string logTxt, [CallerMemberName] string ModuleName = null)
        {
            lock (syncErrorObj)
            {
                if (bEnableErrorLog)
                {
                    WriteLine(logTxt, ModuleName, "ErrorLog/");
                }
            }
        }

        /// <summary>
        /// 异常日志
        /// </summary>
        /// <param name="logTxt"></param>
        /// <param name="ModuleName"></param>
        public static void DebugLog(string logTxt, string ModuleName)
        {
            lock (syncDebugObj)
            {
                if (bEnableDebugLog)
                {
                    WriteLine(logTxt, ModuleName, "DebugLog/");
                }
            }
        }


        /// <summary>
        /// 写日志
        /// </summary>
        /// <param name="logTxt"></param>
        /// <param name="ModuleName"></param>
        /// <param name="pathName"></param>
        private static void WriteLine(string logTxt, string ModuleName, string pathName)
        {
            try
            {
                string logPath = AppDomain.CurrentDomain.SetupInformation.ApplicationBase + pathName
                    + DateTime.Now.ToString("yyyyMMdd") + ".log";
                ClearFile(AppDomain.CurrentDomain.SetupInformation.ApplicationBase + pathName);
                logTxt = string.Format(" {0}|{1}|{2}",
                    DateTime.Now.ToString("yyyy-MM-dd HH:mm"),
                    ModuleName,
                    logTxt);


                sr = new StreamWriter(logPath, true, Encoding.Default);
                sr.WriteLine(logTxt);
                sr.Close();
            }
            catch { }
        }

        /// <summary>
        /// 日志清除文件
        /// </summary>
        /// <param name="FilePath"></param>
        private static void ClearFile(string FilePath)
        {
            if (!Directory.Exists(FilePath))
            {
                Directory.CreateDirectory(FilePath);
            }

            String[] Files = Directory.GetFiles(FilePath);
            if (Files.Length > 30)
            {
                for (int i = 0; i < 1; i++)
                {
                    try
                    {
                        File.Delete(Files[i]);
                    }
                    catch
                    {
                    }
                }
            }
        }
    }

}
